@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OwnerList') </span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">

                    @permission('owner-create')
                    <a href="{{route('owner.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="owner">
                    <thead>
                    <tr>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.FullName')</th>
                        <th>@lang('layout.Email')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.Percentage') %</th>
                        <th>@lang('layout.CreatedAt')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#owner').DataTable({
                ajax: '{{route("owner.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'phone', name: 'percent'},
                    {data: 'percentage', name: 'percentage', orderable: true, searchabele: false},
                    {data: 'created_at', name: 'created_at', searchabele: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'account', orderable: false, searchabele: false},

                ]


            });


        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>


@endpush
