@extends('layouts.app')
@section('style')
<link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop


@section('content')

<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit') </span>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OwnerInformation') </span>
            </div>
        </div>
        <div class="portlet-body form">
            <!-- BEGIN FORM-->
            {!! Form::model($owner,['method' => 'PATCH','route' => ['owner.update',$owner->id],'class'=>'form-horizontal','files'=> true])!!}
            <div class="form-body">
              
                <div class="row">
                    <div class="col-md-6">
                            <label class="control-label">@lang('layout.FullName')</label>
                            {!! Form::text('name', null, array('class' => 'form-control')) !!}
                    </div>
                    <!--/span-->
                    <div class="col-md-3">
                            <label class="control-label">@lang('layout.Code')</label>
                            {!! Form::text('code', null, array('class' => 'form-control')) !!}
                    </div>
                    <div class="col-md-3">
                            <label class="control-label">@lang('layout.Type')</label>
                            {!! Form::select('type[]', $type,$owner->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                    </div>
                    <!--/span-->
                </div>
                <div class="row">
                    <div class="col-md-6">
                            <label class="control-label">@lang('layout.AccountsReceivable')</label>
                                <select name="receivable" id="" class="form-control">
                                    @foreach($receivable AS $key=>$value)
                                    <?php
                                    $selected = '';
                                    if ($key == $owner->receivable_id) {
                                        $selected = 'selected="selected"';
                                    }
                                    ?>
                                    <option <?= $selected ?> value="{{$key}}">{{$value}}</option>

                                    @endforeach
                                </select>
                    </div>
                    <div class="col-md-6">
                            <label class="control-label">@lang('layout.AccountsPayable')</label>
                                <select name="payable" id="" class="form-control">
                                    @foreach($payable AS $key=>$value)
                                    <?php
                                    $selected = '';
                                    if ($key == $owner->payable_id) {
                                        $selected = 'selected="selected"';
                                    }
                                    ?>
                                    <option <?= $selected ?> value="{{$key}}">{{$value}}</option>

                                    @endforeach
                                </select>
                    </div>
                </div>

                <br>
                <!----------------------------------------------------------------------------------
                ------------------------------------------------------------------------------------
                ----------------------Begin Other INformations--------------------------------------
                ------------------------------------------------------------------------------------>
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN TAB PORTLET-->
                        <div class="portlet light bordered" >
                            
                            <div class="portlet-body">
                                <div class="tabbable tabbable-tabdrop">
                                    <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                
                                        <li class="active">
                                            <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                        </li> 
                                        <li class="">
                                            <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.JobTitle')</a>
                                        </li> 
                
                                        
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="tab1">
                                            <div class="row">
                                                <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Address1')</label>
                                                        {!! Form::text('address1', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                </div> 
                                                <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Address2')</label>
                                                        {!! Form::text('address2', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                 </div>
                                                 <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.PostCode')</label>
                                                        {!! Form::number('post_code', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                </div>
                
                                            </div> 
                                            <div class="row">
                                                <div class="col-md-6">
                                                      <label class="control-label">@lang('layout.City')</label>
                                                      {!! Form::text('city', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                              </div>
                      
                                              <div class="col-md-6" id="countries">
                                                      <label class="control-label">@lang('layout.Country')</label>
                                                      <v-select label="name" v-model="selectedCountry" :options="countries">
                                                    </v-select>
                                                    <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                    <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                              </div>
                                          </div>
                                        </div>
                                        <div class="tab-pane" id="tab2">
                                            <div class="row">
                                                <div class="col-md-6" id="countryPhone">
                                                    <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                    <div class="col-md-7">
                                                        {!! Form::text('phone', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountryPhone!=null">
                                                        @{{(selectedCountryPhone==null)?null:selectedCountryPhone.dial_code}}
                                                    </span>
                                                </div>
                        
                                                <div class="col-md-6">
                                                    <div class="form-group ">
                                                        <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                        <div class="col-md-9">
                                                            {!! Form::number('phone2', null, array('tabindex' =>'4','class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                        
                                                <!--/span-->
                                               
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('email', null, array('class' => 'form-control','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="tab5">
                                            <div class="row">
                                                <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.Date')</label>
                                                        <input type="text"  name="reg_date" class="form-control date" value="{{convertDate($owner->reg_date)}}" autocomplete="off">
                                                </div>
                                                <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                        <input type="text"  name="date_of_birth" class="form-control date" value="{{convertDate($owner->date_of_birth)}}" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="tab6">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                    <?php
                                                        $photo = null;
                                                        if($owner && $owner->photo!=null)
                                                        {
                                                            $photo =  $owner->photo;
                                                        }
                                                    ?>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                            </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail"
                                                                    style="max-width: 200px; max-height: 150px;"></div>
                                                                <div>
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <!-- <input type="file" name="photo">  -->
                                                                            {!! Form::file('photo', []) !!}</span>
                                                                    {!! Form::hidden('photo1', (!$owner)?null:$owner->photo) !!}
                                                                    <a href="javascript:;" class="btn default fileinput-exists"
                                                                    data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="tab7">
                                            <div class="row">
                                                <div class="col-md-6" >
                                                    <label class="control-label ">@lang('layout.Percentage')</label>
                                                    {!! Form::number('percentage', null, array('class' => 'form-control')) !!}
                                                </div>
                                                <div class="col-md-6" id="memberClassDiv">
                                                    <label class="control-label ">@lang('layout.Class')</label>
                                                    <select name="class" class="form-control select_style">
                                                        <option value="">کلاس را انتخاب کنید</option>
                                                        @forEach($class as $key => $value)
                                                            <option value="{{$key}}" {{$owner-> class_id == $key ? 'selected' : ''}}>{{$value}}</option>
                                                        @endforeach
                                                    </select>
                                                    {{-- {!! Form::select('class', $class,$owner->class_id, array('class' => 'form-control select_style')) !!} --}}
                                                </div>
                                                </div>
                                                                    
                                                <div class="row" id="genderApp">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Gender')</label>
                                                                <div style="border: 1px dotted ;">
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="gender"  value="male" v-model="type"> @lang('layout.Male') </label>
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="gender" value="female"  v-model="type">
                                                                        @lang('layout.Female') </label>
                                                                </div>
                                                    </div>
                                                    <!--/span-->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Membership')</label>
                                                                <div style="border: 1px dotted ;">
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="free" v-model="members"> @lang('layout.Free') </label>
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="professiona" v-model="members">
                                                                        @lang('layout.Professional') </label>
                                                                </div>
                                                        </div>
                                                    </div>
                                                </div>
                
                                        </div>
                                        <div class="tab-pane" id="tab8">

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                                        <div class="col-md-9">
                                                            {!! Form::select('job_title_id[]', $jobTitle,$owner->memberJobtitle, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'job_title')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                    </div>
                </div>
                
                <!----------------------------------------------------------------------------------
                ------------------------------------------------------------------------------------
                ----------------------End Other INformations--------------------------------------
                ------------------------------------------------------------------------------------>
            </div>
            <div class="form-actions">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-offset-3 col-md-9">
                                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                                <a href="{{route('owner.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>
                </div>
            </div>
            {!! Form::close() !!}
            <!-- END FORM-->
        </div>
    </div>

</div>

@endsection
@push('scripts')
<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>

    Vue.component('v-select', VueSelect.VueSelect);
    var countries = {!!$countries!!};
    var selectedCountry = {!!$selectedCountry!!};
	
     new Vue({
        el:'#countries',
        data:{
            countries:countries,
            selectedCountry:selectedCountry
        }
	});
    new Vue({
        el:"#countryPhone",
        data:{
            selectedCountryPhone:selectedCountry
        }
    })

    var gen = {!! json_encode($owner) !!}
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });

    $('#type').multiselect({
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });

    $(document).ready(function() {
        // $('#reg_date').persianDatepicker({
        //     observer: true,
        //     format: 'YYYY/MM/DD',
        //     altFormat: 'u',
        //     autoClose: true,
        // });

        // $('#date_of_birth').persianDatepicker({
        //     observer: true,
        //     format: 'YYYY/MM/DD',
        //     altFormat: 'u',
        //     autoClose: true,
        // });
    });
</script>
@endpush