@extends('layouts.app')
@section('style')
<link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewOwner') </span>
            </div>
        </div>
        <div class="portlet-body form" id="app" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'owner.store','method'=>'POST', 'class'=>'form-horizontal','files'=> true)) !!}
            {!! csrf_field() !!}
            <div class="form-body">
                <div class="row">
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.FullName')</label>
                        {!! Form::text('name', null, array('class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'),'autocomplete'=>'off')) !!}
                        <span class="required">@{{ errors.first('name') }}</span>
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Code')</label>
                        {!! Form::text('code', $code, array('placeholder' => 'Code','class' => 'form-control','v-validate' =>'"numeric"','data-vv-as' => __('layout.Code'))) !!}
                        <span class="required">@{{ errors.first('code') }}</span>
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Type')</label>
                        <select name="type[]" multiple="multiple" class="list-style form-control" id="type">
                            @foreach($type as $key=>$value)
                            @if($value == __('type.Owner'))
                            <option selected value="{{$key}}">{{$value}}</option>
                            @else
                            <option value="{{$key}}">{{$value}}</option>
                            @endif
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.AccountsReceivable')</label>
                        {{Form::select('receivable',$receivable,Null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.AccountsReceivable')])}}
                        <span class="required">@{{ errors.first('receivable') }}</span>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.AccountsPayable')</label>
                        {{Form::select('payable',$payable,Null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.AccountsPayable')])}}
                        <span class="required">@{{ errors.first('payable') }}</span>
                    </div>
                </div>

                <br>
                <!----------------------------------------------------------------------------------
                ------------------------------------------------------------------------------------
                ----------------------Begin Other INformations--------------------------------------
                ------------------------------------------------------------------------------------>
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN TAB PORTLET-->
                        <div class="portlet light bordered" >
                            
                            <div class="portlet-body">
                                <div class="tabbable tabbable-tabdrop">
                                    <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                
                                        <li class="active">
                                            <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                        </li>
                                        <li class="">
                                            <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                        </li> 
                                        <li class="">
                                            <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.JobTitle')</a>
                                        </li> 
                
                                        
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="tab1">
                                            <div class="row">
                                                <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Address1')</label>
                                                        {!! Form::text('address1', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                </div> 
                                                <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Address2')</label>
                                                        {!! Form::text('address2', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                 </div>
                                                 <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.PostCode')</label>
                                                        {!! Form::number('post_code', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                </div>
                
                                            </div> 
                                            <div class="row">
                                                <div class="col-md-6">
                                                      <label class="control-label">@lang('layout.City')</label>
                                                      {!! Form::text('city', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                              </div>
                      
                                              <div class="col-md-6" id="countries">
                                                      <label class="control-label">@lang('layout.Country')</label>
                                                      <v-select label="name" v-model="selectedCountry" :options="countries">
                                                        </v-select>
                                                        <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                        <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                              </div>
                                          </div>
                                        </div>
                                        <div class="tab-pane" id="tab2">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                    <div class="col-md-7">
                                                        {!! Form::text('phone', null, array('class' => 'form-control','v-validate' =>'"numeric"','data-vv-as' => __('layout.Phone'))) !!}
                                                        <span class="required">@{{ errors.first('phone') }}</span>
                                                    </div>
                                                    <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                                        @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                    </span>
                                                </div>
                        
                                                <div class="col-md-6">
                                                    <div class="form-group ">
                                                        <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                        <div class="col-md-9">
                                                            {!! Form::number('phone2', null, array('tabindex' =>'4','class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                </div>
                        
                                                <!--/span-->
                                               
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('email', null, array('class' => 'form-control','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="tab5">
                                            <div class="row">
                                                <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.Date')</label>
                                                        <input type="text"  name="reg_date" class="form-control date" autocomplete="off">
                                                </div>
                                                <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                        <input type="text"  name="date_of_birth" class="form-control date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="tab6">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                 
                
                                                    <?php
                                                    // $logo = null;
                                                    // if($company && $company->logo!=null)
                                                    // {
                                                    //     $logo =  $company->logo;
                                                    // }
                                                ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                            <img src="#" alt=""/>
                                                        </div>
                                                            <div class="fileinput-preview fileinput-exists thumbnail"
                                                                style="max-width: 200px; max-height: 150px;"></div>
                                                            <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <!-- <input type="file" name="photo">  -->
                                                                        {!! Form::file('photo', []) !!}</span>
                                                                <a href="javascript:;" class="btn default fileinput-exists"
                                                                data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                
                
                                                </div>
                                            </div>
                
                                        </div>
                                        <div class="tab-pane" id="tab7">
                                            <div class="row">
                                                <div class="col-md-6" >
                                                    <label class="control-label ">@lang('layout.Percentage')</label>
                                                    {!! Form::number('percentage', null, array('class' => 'form-control')) !!}
                                                </div>

                                                <div class="col-md-6" id="memberClassDiv">
                                                        <label class="control-label ">@lang('layout.Class')</label>
                                                        {{Form::select('class',$class,Null,['class' => 'form-control','placeholder' => __('layout.SelectClass')])}}
                                                </div>
                                                </div>
                                                                    
                                                <!--/row-->
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Gender')</label>
                                                                <div style="border: 1px dotted ;">
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') </label>
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="gender" value="female" >
                                                                        @lang('layout.Female') </label>
                                                                </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Membership')</label>
                                                                <div style="border: 1px dotted ;">
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                                                    <label class="radio-inline">
                                                                        <input type="radio" name="membership" value="professiona" >
                                                                        @lang('layout.Professional') </label>
                                                        </div>
                                                    </div>
                                                
                                                </div>
                
                                        </div>
                                        <div class="tab-pane" id="tab8">

                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                                        <div class="col-md-9">
                                                            <select role="button"    name="job_title_id[]" multiple="multiple"  class="list-style form-control" id="job_title">
                                                                @foreach($jobTitle as $key=>$value)
                                                                <option value="{{$key}}">{{$value}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                    </div>
                </div>
                
                <!----------------------------------------------------------------------------------
                ------------------------------------------------------------------------------------
                ----------------------End Other INformations--------------------------------------
                ------------------------------------------------------------------------------------>
                
            </div>

            <div class="form-actions">
                <div class="row">
                    <div class="col-md-6">
                        <div class="row">
                            <div class="col-md-offset-3 col-md-9">
                                <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>

                                <a href="{{route('owner.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-6"></div>
                </div>
            </div>
            {!! Form::close() !!}
            <!-- END FORM-->
        </div>
    </div>
</div>
@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
    Vue.component('v-select', VueSelect.VueSelect);
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    var countries = {!!$countries!!};

    new Vue({

        el: "#app",
        data:{
            countries:countries,
            selectedCountry:{
                id:'Afghanistan',
                name:'Afghanistan',
                dial_code:'0093'
            }
        },

        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // console.log(e);
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            }
        },


    });

    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });


</script>
@endpush