@extends('layouts.app')

@section('content')



<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" 
        :value-type="'overtimes'"
        @closed="closeModal">

        <div slot="body">
            <div class="row">
                <div class="form-group">

                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                                  :options="member">
                        </v-select>
                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div>
                      <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectClass') </label>
                            <select name="class_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectClass')</option>
                                @foreach($member_class as  $class)
                                    <option value="{{$class->id}}">{{$class->name}}</option>
                                @endforeach
                            </select>
                        </div>
                </div>


            </div>

            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                               
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date">
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>            
    </report-modal>
</div>

    <!-- END PAGE HEADER-->


    

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OvertimeList')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                     <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @permission('overtime-create')
                        <a href="{{route('overtime.create')}}">
                            <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="overtimes">
                    <thead>
                    <tr>
                       {{-- <th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.Employee_ID')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('menu.OvertimeType')</th>
                        <th>@lang('layout.Quantity')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
 @include('print.modal')
@push('scripts')
<script>
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#overtimes').DataTable( {
            ajax:'{{route("overtime.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?0:7}}", "{{getRowOrder()}}"]],
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            paging:         true,
            serverSide: true,


            columns: [  
               /* { data: 'id',           name: 'overtimes.id'},*/
                { data: 'Employee_ID',  name: 'members.id_card' },
                { data: 'name',         name: 'members.name' },
                { data: 'overtimeType', name: 'overtimeType',orderable:false,searchable:false  },
                { data: 'qty',          name: 'overtimes.qty'},
                { data: 'currency',     name: 'overtimes.currency' },
                { data: 'rate',         name: 'overtimes.rate' },
                { data: 'total',        name: 'total',orderable:false,searchable:false },
                { data: 'Date',         name: 'overtimes.date',searchable:false},
                { data: 'username',     name: 'users.name',orderable:false,searchable:false },
                { data: 'description',  name: 'overtimes.description'},
                { data: 'actions',      name: 'actions',orderable:false,searchable:false },



            ]
        });
    });
      Vue.component('v-select', VueSelect.VueSelect)


      // new for modal


var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember:null,
                member:{!!$member!!},

            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },

                onMemberSearch(search,loading){  
                       loading(true);
                       this.searchMember(search,loading,this);
                },

                searchMember(search,loading,vm){
                       axios.get("{{route('callMethod.search')}}",{
                        params:{
                          method_name:'member',
                          type:'Customer',
                          search:search,
                        }
                       })
                       .then(function (response)
                       {
                         this.memberlist=[];
                         if(response.data.length>0)
                         {
                            vm.memberlist=response.data;
                            console.log('data',vm.memberlist);
                         }
                         loading(false);
                       })
                       .catch(function (error)
                       {
                          console.log(error);
                       })
                },
    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});
      // /new for modal
 


    
</script>
@endpush
