@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditOvertime') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
            
                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($overtime, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['overtime.update',$overtime->id]]) !!}
                <div class="form-body">

                <div class="row">

                    <div class="col-md-3">
                        <div class="form-group">
                           <label class="control-label col-md-3">@lang('layout.SelectMember'):</label>
                              <div class="col-md-9">
                                   <v-select label="name" 
                                      :options="employee"
                                      v-model="selectedMember">
                                </v-select>
                                <input type="hidden" name="emp_id"
                                   :value="!selectedMember?null:selectedMember.id"
                                   required>
                            </div>
                        </div>
                    </div> 
                    <div class="col-md-3">
                 
                        <div class="form-group">
                           <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.Date')])}}
                            </div>
                        </div> 
                    </div>  
                    <div class="col-md-3">
                        <div class="form-group">
                           <label class="control-label col-md-3">@lang('menu.OvertimeType'):</label>
                              <div class="col-md-9">
                                     <select name="overtime_type" class="form-control">
                                    @foreach($overtimeTypes as  $over_type)
                                        <?php
                                        $selected = '';
                                        if ($over_type->name == $overtime->type) {
                                            $selected = 'selected';
                                        }
                                        ?>
                                        <option <?=$selected?> value="{{$over_type->id}}">{{$over_type->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                     <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Total'):</label>
                            <div class="col-md-9">
                                <input type="number" class="form-control" value="0"  :value="qty*amount" readonly>
                            </div>
                        </div>
                    </div>
                   
                </div>
                <div class="row">
                    
                
                    <div class="col-md-3">
                     
                      
                        <div class="form-group">
                            
                            <label class="control-label col-md-3">@lang('layout.Currency')</label>
                            <div class="col-md-9">
                             <v-select label="code" @input="selectedRate"
                              :options="currency"
                              v-model="selected_currency">
                                                                          
                             </v-select>
                            <input type="hidden" name="currency" :value="selected_currency.code">
                            </div>
                        </div>
                    </div>  
                     <div class="col-md-3">
                         <div class="form-group">

                                <label class="control-label col-md-3">@lang('layout.Rate') </label>
                                <div class="input-group col-md-9">
                                    <input v-model="selected_currency.exchange_rate" class="form-control"
                                           type="number" step="any" min="0">
                                    <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                </div>
                        </div>
                        <input type="hidden" name="currency_rate" :value="selected_currency.exchange_rate">
                    </div>  
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9">
                                 {{Form::number('amount',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model' =>'amount'])}}
                            </div>
                        </div>
                    </div>
                     <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Quantity'):</label>
                            <div class="col-md-9">
                                 {{Form::number('qty',null,['class' => 'form-control','step' => 'any','min' =>'0','v-model' =>'qty'])}}
                            </div>
                        </div>
                    </div>
                    </div>

                    <div class="row">
                        
                 
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                 {{Form::textarea('description',null,['class' => 'form-control','rows' => '2','placeholder' => __('layout.Description')])}}
                            </div>
                        </div>
                        
                    </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('overtime.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
    <script>
         Vue.component('v-select', VueSelect.VueSelect);
         var employee ={!! $employee !!};
        new Vue({
            el: '#app',
            data: {
                selectedMember:{!! json_encode($selectedmember) !!},
                employee:employee,
                rate: 0,
                currency:{!! json_encode($currency) !!},
                selected_currency :{!! json_encode(Currency()->getCurrency()) !!},

                amount:{!!$overtime->amount!!},
                qty:{!!$overtime->qty!!}
            },
            created() {
                console.log(this.employee);
                this.checkSelected();
            },
            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },
                },
            methods:{
                checkSelected(){ 
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for(var x in allCarrencies){
                        for(z in allCarrencies[x]){
                            if(allCarrencies[x][z] == "{!! $overtime->currency !!}"){

                                this.selected_currency = allCarrencies[x];
                                this.selected_currency.rate="{!! $overtime->rate !!}";
                                this.selected_currency.exchange_rate="{!! $overtime->rate !!}";
                                
                                break;
                            }
                        }

                    }

                },
     
            }
        });
    </script>
@endpush