@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.CreateNewOvertime')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'overtime.store','method'=>'POST','class'=>'form-horizontal', 'id'=>'overtime_form')) !!}
                {{ csrf_field() }}
                <div class="form-body">

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.EmployeeName'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectEmployee')" label="name"
                                          v-model="selectedEmployee"
                                          :options="{{json_encode($employee)}}"
                                          @input="getSalary"
                                          >
                                </v-select>
                                <input type="hidden" name="employee_id"
                                       v-model.number="(!selectedEmployee)?null:selectedEmployee.id">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                <input type="text" name="date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.OvertimeType'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('menu.OvertimeType')" label="name"
                                          v-model="selectedOvertimeType"
                                          :options="{{json_encode($overtimeTypes)}}">
                                </v-select>
                                <input type="hidden" name="overtime_type"
                                       v-model.number="(!selectedOvertimeType)?null:selectedOvertimeType.id">
                            </div>
                        </div>
                    </div> 
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Currency'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectCurrency')" label="code"
                                          v-model="selectedCurrency"
                                          :options="{{json_encode($currency)}}">
                                </v-select>
                                <input type="hidden" name="currency"
                                       v-model.number="(!selectedCurrency)?null:selectedCurrency.code">
                            </div>
                        </div> 
                    </div>    
                    <div class="col-md-4">
                         <div class="form-group">

                                <label class="control-label col-md-3">@lang('layout.Rate'): </label>
                                <div class="input-group col-md-9">
                                    <input v-model="selectedCurrency.exchange_rate" class="form-control"
                                           type="number" step="any" min="0">
                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                </div>
                        </div>
                        <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                    </div>                    
                    <div class="col-md-4" v-if="this.salaryAmount">
                        <div class="form-group">
                            <label class="control-label col-md-5">@lang('layout.AmountFromBasicSalary'): </label>
                            <div class="col-md-7">
                                <input type="checkbox" style="font-size:12px;height:20px"  v-model="use_basic_saraly">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Quantity'):</label>
                            <div class="col-md-9">
                                <input type="number" name="qty" class="form-control" v-model="qty">
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9" v-if="!use_basic_saraly">
                                {{Form::number('amount',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Amount'),'step' => 'any','min' =>'0','v-model'=>'amount'])}}
                                <span class="required">@{{ errors.first('amount') }}</span>
                            </div>
                            <div class="col-md-9" v-if="use_basic_saraly">
                                <input class="form-control"type="number" step="any" min="0" name="amount" :value="over_amount" readonly>
                                <span class="required">@{{ errors.first('amount') }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Total'):</label>
                            <div class="col-md-9">
                                {{-- <input type="number" class="form-control" value="0"  :value="qty*amount"  readonly> --}}
                                <input type="number" class="form-control" value="0"  :value="netPayable"  readonly>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4" v-if="use_basic_saraly">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.BasicSalary'):</label>
                            <div class="input-group col-md-9">
                                <input type="number" class="form-control" :value="(!salary)?null:salary.amount" readonly>
                                    <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" v-if="use_basic_saraly">
                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.SalaryRate'): </label>
                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                    <div class="input-group col-md-9">
                                        <input v-model="selectedEmployee.rate" class="form-control" 
                                               type="number" min="0" step="any" readonly>
                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                    </div>
                                </div>
                            </div>
                        </span>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                <textarea name="description" class="form-control" placeholder="@lang('layout.Description')"></textarea>
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('overtime.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);
        let home = {!! $homeCurrency !!};
        // var work_time = {!!getCompanyWorkAmount()['hourly']!!};
        let vu = new Vue({
            el: '#app',
            data: {
                selectedCurrency: home,
                selectedOvertimeType : null,
                selectedEmployee     : null,
                qty:null,
                amount:null,
                salary:null,
                salaryAmount:0,
                use_basic_saraly:null,
                work_time:8
            },
            mounted(){
                @if(getCompanyWorkAmount()['hourly'])
                var work_time = {!!getCompanyWorkAmount()['hourly']!!};
                this.work_time = work_time;
                @endif
            },
            computed:{
                netPayable()
                        {
                            var total=0;
                            var qty     = parseFloat((this.qty)?this.qty:0);
                            if(this.selectedEmployee && this.use_basic_saraly) {
                                total=((this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])/(30*this.work_time))*qty;
                            }
                            else
                            {
                                total = this.amount*this.qty
                            }
                             return total;
                        },
                over_amount(){
                    var amount=this.amount;
                    if(this.selectedEmployee && this.use_basic_saraly)
                    {
                        amount = (this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])/(30*this.work_time);
                    }
                    return amount;
                }
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('overtime.store')}}";
                                form_id = 'overtime_form';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                    .then(function (response) {
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.selectedEmployee = null;
                                            vu.selectedOvertimeType = null;
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },

                getSalary(){
                    if(this.selectedEmployee)
                    {   
                        this.getSalaryRecord(this.selectedEmployee.id);
                    
                    } 
                },
                getSalaryRecord(id)
                {
                        $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async:false,
                        data:{
                            method_name:'memberSalary',
                            employee_id:id,
                            },
                        success:function(data){
                            this.salary=data;

                            if(this.salary !=undefined && this.salary !=null)
                            {
                              this.salaryAmount=this.salary.amount;
                              this.selectedEmployee['currency']=this.salary.currency;
                              this.selectedEmployee['sal_id']=this.salary.id;
                              this.selectedEmployee['rate']=this.salary.rate;
                            }
                        }.bind(this),

                        error: function(error){
                            console.log(error)
                        }
                    });
                    
                }
                
            }
        })

    </script>
@endpush 