@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('menu.CompanyOrganization')</h3>
<h4>@lang('layout.ShareholderList')</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <th class="center" >@lang('layout.No')</th>
      <th class="center" >@lang('layout.FullName')</th>
      <th class="center" >@lang('layout.Phone')</th>
      <th class="center" >@lang('layout.Percentage')</th>
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($owner AS $owner_row)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$owner_row->name}}</td>
    <td class="center">{{$owner_row->phone}}</td>
    <td class="center">{{$owner_row->percentage}} %</td>
  </tr>
  @endforeach
</table>

<h4>@lang('layout.SupervisorList')</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <th class="center" >@lang('layout.No')</th>
      <th class="center" >@lang('layout.FullName')</th>
      <th class="center" >@lang('layout.Phone')</th>
      <th class="center" >@lang('layout.JobTitle')</th>
      <th class="center" >@lang('layout.BossName')</th>
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($supervisor AS $sup_row)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$sup_row->name}}</td>
    <td class="center">{{$sup_row->phone}}</td>
    <td class="center">
    @if($sup_row->job_title)
    @foreach($sup_row->job_title AS $job)
    {{$job->name}}&nbsp;&nbsp;
    @endforeach
    @endif
    </td>
    <td class="center">{{$sup_row->bossName}}</td>
  </tr>
  @endforeach
</table>
<h4>@lang('layout.EmployeeList')</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <th class="center" >@lang('layout.No')</th>
      <th class="center" >@lang('layout.FullName')</th>
      <th class="center" >@lang('layout.Phone')</th>
      <th class="center" >@lang('layout.JobTitle')</th>
      <th class="center" >@lang('layout.BossName')</th>
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($employee AS $sup_row)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$sup_row->name}}</td>
    <td class="center">{{$sup_row->phone}}</td>
    <td class="center">
    @if($sup_row->job_title)
    @foreach($sup_row->job_title AS $job)
    {{$job->name}}&nbsp;&nbsp;
    @endforeach
    @endif
    </td>
    <td class="center">{{$sup_row->bossName}}</td>
  </tr>
  @endforeach
</table>
<h4>@lang('layout.Location') ( @lang('layout.MainCompany') )</h4>
@if($company)
<table class="main-table">
  <tr>
    <td><h5>{!!$company->country!!} &nbsp;&nbsp; {!!$company->city!!} &nbsp;&nbsp; {!!$company->street_address!!}</h5></td>
  </tr>
</table>
@endif

<h4>@lang('layout.ProductList')</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <th class="center" >@lang('layout.No')</th>
      <th class="center" >@lang('layout.Product')</th>
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($companyProduct AS $pro_row)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$pro_row->details}}</td>
  </tr>
  @endforeach
</table>

<h4>@lang('layout.Branch')</h4>
<table class="main-table">
  <thead>
    <tr class="bg">
      <th class="center" >@lang('layout.No')</th>
      <th class="center" >@lang('layout.Name')</th>
      <th class="center" >@lang('layout.Country')</th>
      <th class="center" >@lang('layout.City')</th>
      <th class="center" >@lang('layout.Address')</th>
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($companies AS $comp_row)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{!!$comp_row['name']!!}</td>
    <td class="center">{!!$comp_row['country']!!}</td>
    <td class="center">{!!$comp_row['city']!!}</td>
    <td class="center">{!!$comp_row['street_address']!!}</td>
  </tr>
  @endforeach
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection