@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OpeningInventorylist')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">

                    @permission('openingInventory-export')
                    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="openingInventory"/>
                    <button type="submit" id="sample_editable_1_new" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    {{Form::close()}}
                    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                    <input type="hidden" name="type" value="openingInventory"/>
                    <button type="submit" class="btn btn-success"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')
                    </button>
                    {{Form::close()}}
                    @endpermission
                    @permission('inventory-create')
                    <a href="{{route('openingInventory.create',$inventory->id)}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="openingInventory">
                    <thead>
                    <tr>
                        {{--<th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.CostInInventory')</th>
                        <th>@lang('layout.SalePrice')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#openingInventory').DataTable({
                ajax: '{{route("openingInventory.index",["id"=>$inventory->id])}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                   /* {data: 'id', name: 'id'},*/
                    {data: 'cost', name: 'cost'},
                    {data: 'sale_price', name: 'sale_price'},
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description'},
                    {data: 'actions', searchable: false, orderable: false},
                ]
            });
        });
    </script>


@endpush
