@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditInventoryOpening')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">
                <a href="" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                <a href="" class="reload" data-original-title="" title=""> </a>
                <a href="" class="remove" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="inventory_opening">
            <!-- BEGIN FORM-->

            {{Form::model($openingInventory,['route' => ['openingInventory.update',$openingInventory->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
            {{ csrf_field() }}
            <input type="hidden" name="item_id" value="{{$inventory->id}}">
            <div class="form-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="">
                            <label class="control-label"> @lang('layout.ItemName')</label>
                            {{Form::text('name',$inventory->name,['class' => 'form-control','placeholder' => __('layout.EnterItemName'),'readonly'])}}
                            {{--<span class="help-block"> This is inline help </span>--}}
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="">
                            <label class="control-label">@lang('layout.ItemCode'):</label>
                            {{Form::number('number',$inventory->number,['class' => 'form-control','min' =>'0' ,'placeholder' => __('layout.ItemCode'),'readonly'])}}
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="">
                            <label class="control-label">@lang('layout.U_M_Set')</label>
                            <v-select :disabled="true" placeholder="@lang('layout.SelectUnitMeasure') " label="name"
                                      :options="measureList" v-model="measureSelected"></v-select>
                            <input type="hidden" name="um_id" :value="(measureSelected)?measureSelected.id:null">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.Date') </label>
                        <div>
                            <input class="form-control date" name="date" value="{{$openingInventory->date}}"
                                   autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.Vendor')</label>

                        <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                        <input type="hidden" name="vendor" :value="!selected_vendor?null:selected_vendor.id" required>
                    </div>
                    @permission(['cost-create'])
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label"> @lang('layout.Default_Rate')</label>
                            {{Form::number('rate',$openingInventory->sale_price,['class' => 'form-control','step' => 'any','min' =>'0','placeholder' => __('layout.Default_Rate'),'v-validate' =>'"decimal:10"','data-vv-as' => __('layout.Default_Rate')])}}
                            <span class="required">@{{ errors.first('rate') }}</span>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label">@lang('layout.CostInInventory')</label>
                            {{Form::number('cost',$openingInventory->cost,['class' => 'form-control','v-model'=>'cost','tabindex'=>'7','step' => 'any','min' =>'0','v-validate' =>'"required|decimal:10"','data-vv-as' => __('layout.CostInInventory')])}}
                            <span class="required">@{{ errors.first('cost') }}</span>
                        </div>
                    </div>
                    @endpermission
                </div>
                <div class="row">
                    <div class="col-md-2">
                        <label class="control-label">@lang('layout.Contract')</label>
                        <v-select label="company_name" :options="contract" v-model="selected_contract"></v-select>
                        <input type="hidden" name="contract" :value="!selected_contract?null:selected_contract.id" required>
                    </div>
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label">@lang('layout.Description')</label>
                            {{Form::textarea('description',$openingInventory->description,['class' => 'form-control','rows'=>'1'])}}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label">@lang('layout.OnHand')</label>
                            <input type="number" disabled class="form-control" v-model='onHand'> 
                            {{--{{Form::number('quantity',null,['class' => 'form-control','v-model'=>'onHand
                            ','step' => 'any','min' =>'0'])}}--}}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label">@lang('layout.TotalValue')</label>
                            {{Form::number('total',null,['class' => 'form-control','v-model'=>'result','step' => 'any','min' =>'0' ,'disabled'])}}
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label">@lang('layout.OMeasureValue1')</label>
                            {{Form::number('o_measure',$o_measure,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            <input type="hidden" name="old_o_measure" value="{{$o_measure}}">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="">
                            <label class="control-label">@lang('layout.OMeasureValue2')</label>
                            {{Form::number('o_measure2',$o_measure2,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            <input type="hidden" name="old_o_measure2" value="{{$o_measure2}}">
                        </div>
                    </div>
                    <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                </div>
                <div class="row">

                    <div style="height: 200px; overflow:scroll;">

                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center"> @lang('layout.Site') </th>
                                    <th class="text-center"> @lang('layout.OnHand') </th>
                                    <th class="text-center" v-show="showWhat('expire_date')=='yes'" > @lang('layout.ExpireDate') </th>
                                    @if(systemConfig()[27] == 1)
                                    <th class="text-center"> @lang('layout.Density') </th>
                                    @endif
                                    @if(showLocation()=="true")
                                    <th class="text-center"> @lang('layout.Location') </th>
                                    @endif
                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description1') </th>
                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Model') </th>
                                    <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Color') </th>
                                    @if (getCalQuantityOfOtherMeasure() == 'simpleMethod' || getCalQuantityOfOtherMeasure() == 'avgMethod')
                                    <th v-show="showWhat('other_measure')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                                    <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                                    @endif
                                    @if(getShowCBM()=="true")
                                    <th>@lang('layout.CBM') </th>
                                    @endif


                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="site in sites">
                                    <td class="highlight">
                                        <input type="hidden" name="site_id[]" :value="site.id" >
                                        <input type="text" :value="site.name" disabled  class = 'form-control' >
                                    </td>
                                    <td class="highlight">
                                        <input name="quantity[]" type="number" class="form-control" placeholder="@lang('layout.OnHand')" v-model.number="site.qty">
                                        <input name="stock_id[]" type="hidden" :value="site.stock_id">
                                    </td>
                                    <td class="highlight" v-show="showWhat('expire_date')=='yes'">
                                        <input name="expire_date[]" v-model="site.expire_date" type="text" class="form-control date" placeholder="@lang('layout.ExpireDate')">
                                    </td>
                                    @if(systemConfig()[27] == 1)
                                    <td class="highlight">
                                        <input name="density[]" type="number" v-model="site.density" class="form-control" placeholder="@lang('layout.Density')">
                                    </td>
                                    @endif
                                    @if(showLocation()=="true")
                                    <td>
                                        <input name="location[]" type="text" v-model="site.location" class="form-control" placeholder="@lang('layout.Location')">
                                    </td>
                                    @endif
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Description1')" name="inventory_description[]" v-model="site.description" class="form-control">
                                    </td>
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Model')" name="model[]" v-model="site.model" class="form-control">
                                    </td>
                                    <td v-show="showWhat('sale_description')=='yes'">
                                        <input type="text" placeholder="@lang('layout.Color')" name="color[]" v-model="site.color" class="form-control">
                                    </td>
                                    @if (getCalQuantityOfOtherMeasure() == 'simpleMethod' || getCalQuantityOfOtherMeasure() == 'avgMethod')
                                    <td v-show="showWhat('other_measure')=='yes'">
                                        <input name="other_measure_amount1[]" type="number" v-model="site.other_measure" class="form-control" placeholder="@lang('layout.OMeasureValue1')">
                                    </td>
                                    <td v-show="showWhat('other_measure2')=='yes'">
                                        <input name="other_measure_amount2[]" type="number" v-model="site.other_measure2" class="form-control" placeholder="@lang('layout.OMeasureValue2')">
                                    </td>
                                    @endif
                                    @if(getShowCBM()=="true")
                                    <td>
                                        <input name="cbm[]" type="number" v-model.number="site.cbm" class="form-control" placeholder="@lang('layout.CBM')">
                                    </td>
                                    @endif 
                                </tr>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <a href="{{route('openingInventory.index',['id'=>$inventory->id])}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        var selectedVendor = {!! $selectedVendor !!};
        var openingInventory = {!! $openingInventory !!};
        var contract ={!! $contract !!};
        Vue.component('v-select', VueSelect.VueSelect)
        let vu = new Vue({
            el: '#inventory_opening',
            data: {
                vendor: [],
                selected_vendor: null,
                contract: contract,
                selected_contract: null,
                sites:{!! json_encode($site) !!},
                measureList:{!! json_encode($measure) !!},
                measureSelected: null,
                cost: 0
            },
            computed: {
                result: function () {
                    return myRound(this.cost * this.onHand);
                },
                onHand: function () {
                    var total = 0
                    this.sites.forEach(function (site) {
                        total += (site.qty) ? Number.parseFloat(site.qty) : 0;
                    })
                    return total;
                }
            },
            mounted: function () {
                this.selected_vendor = selectedVendor;
                if (openingInventory) {
                    this.cost = Number.parseFloat(openingInventory.cost);
                }
                this.measureSelected = _.find(this.measureList, (o) => o.id == {{$inventory->um_id}});
                if (openingInventory) {
                    if (openingInventory.contract_id) {
                        this.selected_contract = _.find(this.contract, (o) => o.id == openingInventory.contract_id);
                    }
                }

            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.vendor = [];
                            vu.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
            }
        })
    </script>
@endpush
