@extends('layouts.report')

<?php
$reportTitle = __('menu.CashBook');
?>
@section('content')
    @include('layouts.report-header')
    <?php
    $report = customeReport('contract', 'index');
    $count = 0;
    $total_home_currency = 0;
    $currencies = [];
    ?>

    <!-- begin  ClosingBalance -->
    <h2 class="center" style="background-color: lightblue">@lang('layout.ClosingBalance')</h2>
    @foreach($c_data AS $key=>$value)
        <h3 class="center" style="background-color: lightblue">{{$key}}</h3>
        <!-- begin  foreach each account -->
        @foreach($value As $k=>$v)
            <h4 class="center">{{$v['account']->name}}</h4>
            @if($v['details'])
                <!-- begin detail -->
                <table class="main-table">
                    <thead class="bg">

                    </thead>
                    <?php
                    $total = 0;
                    $rate = 1;
                    ?>
                    @foreach($v['details'] as $detail)
                        <tr>
                            <?php

                            $rate = $detail->rate;
                            $total += $detail->amount;

                            ?>

                        </tr>
                @endforeach
                <!-- end detail -->

                    <tr>
                    <!-- <td class="center" >{{$total}}</td> -->
                        <span>{{$total}}</span>
                    </tr>


                </table>

            @endif
        @endforeach
        <!--  end each account -->

    @endforeach
    <!-- end  ClosingBalance -->







    @foreach($data AS $key=>$value)
        <h1 class="center" style="background-color: lightblue">{{$key}}</h1>
        <!-- begin  foreach each account -->
        @foreach($value As $k=>$v)
            <h3 class="center" style="color: gray">{{$v['account']->name}}</h3>
            @if($v['details'])
                <!-- begin detail -->
                <table class="main-table">
                    <thead class="bg">
                    <th>@lang('layout.ID')</th>
                    <th>@lang('layout.Date')</th>
                    <th>@lang('layout.Description')</th>
                    <th>@lang('layout.Currency')</th>
                    <th>@lang('layout.Received')</th>
                    <th>@lang('layout.Paid')</th>
                    <th>@lang('layout.Rate')</th>
                    </thead>
                    <?php
                    $total = 0;
                    $total_r = 0;
                    $total_p = 0;
                    $Balance = 0;
                    $rate = 1;
                    ?>
                    @foreach($v['details'] as $detail)
                        <tr>
                            <?php
                            if ($detail->amount > 0) {
                                $total_r += $detail->amount;
                            }
                            if ($detail->amount < 0) {
                                $total_p += $detail->amount;
                            }
                            $rate = $detail->rate;
                            $total += $detail->amount;
                            $total_home_currency += $detail->amount / $rate;
                            if (array_key_exists($detail->currency, $currencies)) {
                                $currencies[$detail->currency] = $currencies[$detail->currency] + $detail->amount;
                            } else {
                                $currencies[$detail->currency] = $detail->amount;
                            }
                            ?>
                            <td class="center">{{$detail->id}}</td>
                            <td class="center">{{convertDate($detail->date)}}</td>
                            <td class="center">{{$detail->remark}}</td>
                            <td class="center">{{$detail->currency}}</td>
                            <td class="center">
                                @if($detail['amount']>0)
                                    {{round($detail['amount'],2)}}
                                @endif
                            </td>
                            <td class="center">
                                @if($detail['amount']<0)
                                    {{round($detail['amount'],2)}}
                                @endif
                            </td>
                            <td class="center">{{$detail->rate}}</td>
                        </tr>
                @endforeach
                <!-- end detail -->
                    <tr>
                        <td class="center" colspan="4">@lang('layout.ToDay') </td>
                        <td class="center">{{$total_r}}</td>
                        <td class="center">{{$total_p}}</td>
                        <td class="center"></td>

                    </tr>
                    <tr>
                        <td class="center" colspan="3">@lang('layout.Balance')</td>
                        <td class="center" colspan="3">{{$total}}</td>
                        <td class="center">{{round($total/$rate,2)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
                    </tr>


                </table>

            @endif

            @if($v['overAlltotal'])
                <!--  <span><table class="main-table">
        <tr><th>@lang('layout.Total')</th></tr>
        <tr><td class="center">{{$v['overAlltotal']->amount}}  {{getHomeCurrency()[getCurrencyType()]}}</td></tr>
      </table></span> -->
            @endif
        @endforeach
        <!--  end each account -->

    @endforeach
    <table>
        <tr>

        </tr>
    </table>
    <table class="main-table">
        <tr style="background-color: lightblue">
            <td colspan="3">
                <div class="center">@lang('layout.PerCurrency')</div>
            </td>
        </tr>


        <tr>
            <td>
                <div class="center"> @lang('layout.Record')  </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Currency') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.Amount') </div>
            </td>
        </tr>
        <?php
        $count = 0;
        foreach($currencies As $key=>$currency)
        {
        ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
        <?php
        }
        ?>


        <tr>
            <td colspan="2">
                <div class="center">@lang('layout.HomeCurrencyTotal')</div>
            </td>
            <td>
                <div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}</div>
            </td>

        </tr>
    </table>

     <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection