@extends('layouts.app')
@section('style')
<link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
<link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css" />
<link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ url('/assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('content')
<!-- <h3 style="color:red">@lang('layout.SomeOfThisInformationOnlyShowsInThisAccount')</h3> -->
<hr />
{{Form::open(array('route'=>'onlineSYstemConfig.store', 'method'=>'POST','enctype'=>'multipart/form-data'))}}
    <div class="form-body" id="app">
        <div class="row" style="padding: 10px 20px;">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                <div class="row" style="padding: 0px 10px;">
                    <?php
                        $logo = null;
                        $logo2 = null;
                        $company_image = null;
                        if ($company && $company->logo != null) {
                            $logo =  $company->logo;
                        }
                        if ($company && $company->logo2 != null) {
                            $logo2 =  $company->logo2;
                        }
                        if($company && $company->company_image !=null){
                            $company_image = $company->company_image;
                        }
                    ?>
                    <div class="col-md-4">
                        <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                            <div class="fileinput-new thumbnail" style="width: 100%; height: 150px;">
                                <img src="{!!url('/uploads/logo/'.$logo)!!}" alt="" />
                            </div>
                            <!-- <img src="/uploads/logo/{{(!$company)?null:$company->logo}}" alt=""/> -->
                            <!-- <img :src="(!item.item)?null:((!item.item.photo)?null:uploads+'/'+item.item.photo)" alt=""/> -->
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px;"></div>
                            <div>
                                <span class="btn default btn-file">
                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                    <!-- <input type="file" name="photo">  -->
                                    {!! Form::file('photo', []) !!}</span>
                                    {!! Form::hidden('photo1', (!$company)?null:$company->logo) !!}
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                            </div>
                            <span>@lang('layout.LogoSize') 350X50</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                            <div class="fileinput-new thumbnail" style="width: 100%; height: 150px;">
                                <img src="{!!url('/uploads/logo/'.$logo2)!!}" alt="" />
                            </div>
                            <!-- <img src="/uploads/logo/{{(!$company)?null:$company->logo}}" alt=""/> -->
                            <!-- <img :src="(!item.item)?null:((!item.item.photo)?null:uploads+'/'+item.item.photo)" alt=""/> -->
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px;"></div>
                            <div>
                                <span class="btn default btn-file">
                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                    <!-- <input type="file" name="photo">  -->
                                    {!! Form::file('photo_sm', []) !!}</span>
                                {!! Form::hidden('photo_sm1', (!$company)?null:$company->logo2) !!}
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                            </div>
                            <span>@lang('layout.LogoSize') 60X60</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                            <div class="fileinput-new thumbnail" style="width: 100%; height: 150px;">
                                <img src="{!!url('/uploads/logo/'.$company_image)!!}" alt="" /></div>
                            <!-- <img src="/uploads/logo/{{(!$company)?null:$company->logo}}" alt=""/> -->
                            <!-- <img :src="(!item.item)?null:((!item.item.photo)?null:uploads+'/'+item.item.photo)" alt=""/> -->
                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 150px;"></div>
                            <div>
                                <span class="btn default btn-file">
                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                    <!-- <input type="file" name="photo">  -->
                                    {!! Form::file('company_image', []) !!}</span>
                                    {!! Form::hidden('new_image_company1', (!$company)?null:$company->company_image) !!}
                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                            </div>
                            <span>@lang('layout.AboutImageSize') 1128X786</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.Currency')</label>
                        <v-select label="code" :options="currency" v-model="selected_currency"></v-select>
                        <input type="hidden" name="currency" :value="selected_currency.code">
                    </div>
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.Language')</label>
                        <v-select label="name" :options="lang" v-model="selected_lang"></v-select>
                        <input type="hidden" name="lang" :value="selected_lang.id">
                    </div>
                    <div class="col-md-4">
                        {{Form::label('name', __('layout.CompanyName'))}}
                        <textarea id="" class="form-control" name="name">{!! (!$company)?null: $company->company_name!!}</textarea>
                        <input type="hidden" name="company_id" value="{{(!$company)?null: $company->id}}">
                    </div>
                    <div class="col-md-4">
                        {{Form::label('phone', __('layout.Phone'))}}
                        <textarea id="" class="form-control" name="phone">{!! (!$company)?null: $company->phone!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        {{Form::label('email', __('layout.Email'))}}
                        <textarea id="" class="form-control" name="email">{!! (!$company)?null: $company->email!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        {{Form::label('webSite', __('layout.WebSite'))}}
                        <textarea id="" class="form-control" name="webSite">{!! (!$company)?null: $company->website!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        {{Form::label('city', __('layout.City'))}}
                        <textarea id="" class="form-control" name="city">{!! (!$company)?null: $company->city!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        {{Form::label('streetAddress', __('layout.StreetAddress'))}}
                        <textarea id="" class="form-control" name="streetAddress">{!! (!$company)?null: $company->street_address!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        {{Form::label('map', __('layout.Map'))}}
                        <textarea id="" class="form-control" name="map">{!! (!$company)?null: $company->map!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        <label>@lang('layout.CompanyInformation')</label>
                        <textarea name="editor2" class="form-control" id="">{!! (!$company)?null: $company->description!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        <label>@lang('layout.ThemeColor')</label>
                        <select class="form-control" name="color" v-model="(!company)?null:company.color">
                            <option value="">@lang('layout.SelectColor')</option>
                            <option style="background-color: #13263c; color: #ffffff;" value="#13263c">@lang('layout.Default')</option>
                            <option style="background-color: #000000; color: #ffffff;" value="#000000">@lang('layout.Color') 1</option>
                            <option style="background-color: #442484; color: #ffffff;" value="#442484">@lang('layout.Color') 2</option>
                            <option style="background-color: #05614e; color: #ffffff;" value="#05614e">@lang('layout.Color') 3</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="control-label">@lang('layout.Font')</label>
                        <select class="form-control" name="font" v-model="(!company)?null:company.font">
                            <option value="default">@lang('layout.Default')</option>
                            <option value="aril">@lang('layout.Aaril')</option> 
                            <option value="bzar" selected>@lang('layout.BZar')</option>
                            <option value="bnazanin">@lang('layout.BNazanin')</option>
                            <option value="Btitr">@lang('layout.Btitr')</option>
                            <option value="BBaran">@lang('layout.BBaran')</option>
                            <option value="BKoodakO">@lang('layout.Kodak')</option>
                            <option value="BKoodakBd">@lang('layout.KodakBold')</option>
                            <option value="IranNastaliq">@lang('layout.Nastaliq')</option>
                            <option value="XBNiloofarBd">@lang('layout.XBNiloofarBd')</option>
                            <option value="majalla">@lang('layout.Majalla')</option>
                            <option value="majallab">@lang('layout.Majallab')</option>
                            <option value="IRANSansWeb">@lang('layout.SansWeb')</option>
                            <option value="Vazir">@lang('layout.Vazir')</option>
                            <option value="Yekan">@lang('layout.Yekan')</option>
                            <option value="Tanha">@lang('layout.Tanha')</option>
                            <option value="Shabnam">@lang('layout.Shabnam')</option>
                            <option value="ShabnamBold">@lang('layout.ShabnamBold')</option>
                            <option value="ShabnamLight">@lang('layout.ShabnamLight')</option>
                            <option value="Samim">@lang('layout.Samim')</option>
                            <option value="SamimBold">@lang('layout.SamimBold')</option>
                            <option value="Sahel">@lang('layout.Sahel')</option>
                            <option value="SahelBold">@lang('layout.SahelBold')</option>
                            <option value="SahelBlack">@lang('layout.SahelBlack')</option>
                            <option value="Parastoo">@lang('layout.Parastoo')</option>
                            <option value="ParastooBold">@lang('layout.ParastooBold')</option>
                            <option value="TimesNewRoman">@lang('layout.TimesNewRoman')</option>
                            <option value="TimesNewRomanBold">@lang('layout.TimesNewRomanBold')</option>
                        </select>
                    </div>
                    <div class="col-md-4" style="margin-top: 5px;">
                        <table class="table table-striped table-bordered table-advance table-hover">
                            <tbody>
                                <tr>
                                    <td style="text-align: center;">@lang('layout.OnHand')</td>
                                </tr>
                                <tr>
                                    <td style="text-align: center;">
                                        <label class="switch">
                                            <input type="checkbox" name="show_onhand" value="1" <?php if ($company) { if ($company->show_onhand == 1) { echo 'checked'; }} ?> >
                                            <span class="slider round"></span>
                                        </label>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-bottom: 10px;">
                <h3>@lang('layout.SocialMedia')</h3>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                <div class="row" style="padding: 0px 10px;">
                    <div v-for="(social,index) in socials">
                        <div class="col-md-4">
                            {{Form::label('socialName', __('layout.SocialName'))}}
                            <select name="socialName[]" v-model="social.socialName" id="" class="form-control">
                                <option value="Phone">@lang('layout.Phone')</option>
                                <option value="Email">@lang('layout.Email')</option>
                                <option value="FaceBook">@lang('layout.FaceBook')</option>
                                <option value="Whatsapp">@lang('layout.Whatsapp')</option>
                                <option value="WebSite">@lang('layout.WebSite')</option>
                                <option value="YouTube">@lang('layout.YouTube')</option>
                                <option value="Telegram">@lang('layout.Telegram')</option>
                                <option value="Instagram">@lang('layout.Instagram')</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            {{Form::label('socialUrl', __('layout.SocialUrl'))}}
                            <input type="text" name="socialUrl[]" class="form-control" v-model="social.socialUrl" placeholder="@lang('layout.SocialUrl')">
                        </div>
                        <div class="col-md-4" style="display: flex; justify-content: center;align-items: end;height: 4em;">
                            <a href="javascript:;" class="btn btn-circle green" style="display: flex;justify-content: center; align-items: center;padding: 5px 7px;" @click="addrow"><i class="fa fa-plus"></i></a>
                            <a href="javascript:;" class="btn btn-circle red" style="display: flex;justify-content: center; align-items: center;margin-right: 5px;padding: 5px 7px;" @click="removerow(index,1)"><i class="fa fa-minus"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin-bottom: 10px;">
                <h3>@lang('layout.Description')</h3>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px;">
                <div class="row" style="padding: 0px 10px;">
                    <div v-for="(detail,index) in details" :key="index">
                        <table class="table table-bordered table-advance">
                            <tr>
                                <td>
                                    <label>@lang('layout.Title') </label>
                                    <input type="text" :name="'title['+index+']'" class="form-control" v-model="detail.title" placeholder="@lang('layout.Title')">
                                </td>
                                <td :colspan="detail.company_type != 'comment' ? 2 : 1">
                                    <label>@lang('layout.Quantities') </label>
                                    <input type="text" :name="'company_qty['+index+']'" class="form-control" v-model="detail.company_qty" placeholder="@lang('layout.Quantities')">
                                </td>
                                <td v-if="detail.company_type == 'comment'">
                                    <label>@lang('layout.Name') </label>
                                    <input type="text" :name="'company_name['+index+']'" class="form-control" v-model="detail.company_name" placeholder="@lang('layout.Name')">
                                </td>
                                <td rowspan="2" style="vertical-align: middle;">
                                    <a href="javascript:;" class="btn btn-circle green" @click="addrow_detail"><i class="fa fa-plus"></i></a>
                                    <a href="javascript:;" class="btn btn-circle red" @click="removerow_detail(index,1)"><i class="fa fa-minus"></i></a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label class="control-label">@lang('layout.Type') </label>
                                    <select :name="'company_type['+index+']'" v-model="detail.company_type" class="form-control">
                                        <option value="" disabled>@lang('layout.SelectFormat')</option>
                                        <option value="statistic">@lang('layout.Statistic')</option>
                                        <option value="descriptive">@lang('layout.Description')</option>
                                        <option value="comment">@lang('layout.Comments')</option>
                                    </select>
                                </td>
                                <td>
                                    <label>@lang('layout.Description') </label>
                                    <textarea :name="'description['+index+']'" class="form-control">@{{detail.description}}</textarea>
                                </td>
                                <td>
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 120px;">
                                            <img :src="(!detail.image)?null:'{{asset('uploads/online_about/')}}/'+detail.image" alt="" /></div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 120px;"></div>
                                        <div>
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input :name="'image['+index+']'" type="file">
                                            </span>
                                            <input :name="'image1['+index+']'" type="hidden" :value="(!detail)?null:detail.image">
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                        <br>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="border-radius: 8px; margin-bottom: 10px; padding: 15px;">
                <div class="row text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('onlineShop.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
            </div>
        </div>
    </div>

{{Form::close()}}
@endsection
@push('scripts')
<script>
    Vue.component('v-select', VueSelect.VueSelect);
    $(document).ready(function() {
        $('#summernote_1').summernote({
            toolbar: [
                // [groupName, [list of button]]
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['font', ['strikethrough', 'superscript', 'subscript']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']]
            ],
            dialogsFade: true
        });
        $('#company_name_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false
        });
        $('#city_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false
        });
        $('#country_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false
        });
        $('#phone_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false
        });
        $('#email_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false
        });
        $('#webSite_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false,
        });
        $('#streetAddress_editor').summernote({
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']]
            ],
            shortcuts: false,
        });
    });
    var currency = {!! $currency !!};
    var homeCurrency = {!! $homeCurrency !!};
    var info_details = {!! json_encode($info_details) !!};
    var info_social = {!! json_encode($info_social) !!};
    var company = {!! json_encode($company) !!};
    var lang = "{!! $lang !!}";
    new Vue({
        el: '#app',
        data: {
            socials: [],
            details: [],
            currency: currency,
            selected_currency: homeCurrency,
            info_details: info_details,
            info_social: info_social,
            selected_lang: lang,
            company: company,
            lang: [{
                'id': 'en',
                'name': 'English'
            }, {
                'id': 'fa',
                'name': 'فارسی'
            }],
        },
        created() {
        },
        mounted() {
            @if($lang != null)
            this.selected_lang = _.find(this.lang, (o) => o.id == "{{$lang}}");
            @endif
            if (this.info_social) {
                if (this.info_social.length) {
                    var len = this.info_social.length;
                    for (var x = 0; x < len; x++) {
                        this.socials.push({
                            socialName: this.info_social[x].social_name,
                            socialUrl: this.info_social[x].social_url,
                            socialIcon: this.info_social[x].social_icon
                        });
                    }
                }
            }
            this.socials.push({
                socialName: null,
                socialUrl: null,
                socialIcon: null
            });
            if (this.info_details) {
                if (this.info_details.length) {
                    var len = this.info_details.length;
                    for (var x = 0; x < len; x++) {
                        this.details.push({
                            title: this.info_details[x].title,
                            company_qty: this.info_details[x].company_qty,
                            company_type: this.info_details[x].company_type,
                            company_name: this.info_details[x].company_name,
                            description: this.info_details[x].description,
                            image: this.info_details[x].image
                        });
                    }
                }
            }
            this.details.push({
                title: null,
                company_qty: null,
                company_name: null,
                description: null,
                image: null
            });
        },
        methods: {
            addrow() {
                this.socials.push({
                    socialName: null,
                    socialUrl: null
                });
            },
            removerow(index, id) {
                if (this.socials.length > 1)
                    this.socials.splice(index, 1)
            },
            addrow_detail() {
                this.details.push({
                    title: null,
                    company_qty: null,
                    company_name: null,
                    description: null,
                    image: null
                });
            },
            removerow_detail(index, id) {
                if (this.details.length > 1)
                    this.details.splice(index, 1)
            },
        }
    });
</script>
<script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script>
<script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js') }}" type="text/javascript"></script>
<script src="{{ url('/assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js') }}" type="text/javascript"></script>
<script src="{{ url('/assets/global/plugins/bootstrap-markdown/lib/markdown.js') }}" type="text/javascript"></script>
<script src="{{ url('/assets/global/plugins/bootstrap-markdown/js/bootstrap-markdown.js') }}" type="text/javascript"></script>
<script src="{{ url('/assets/global/plugins/bootstrap-summernote/summernote.js') }}" type="text/javascript"></script>
<script src="{{ url('/assets/pages/scripts/components-editors.js') }}" type="text/javascript"></script>
@endpush