@extends('layouts.app')

@section('style')
<link rel="stylesheet" href="{{url('/')}}/assets/pages/css/profile.min.css" type="text/css" media="all" />
<style>
    .bgg{
        background-color: #f1f4f7;
    }
    .tab-pane.active #accordion1 .row .portlet.light.bordered .portlet-title
    {
        /* background-color: #169ef4; */
        /* background-color: #c1e5fb; */
    }
    .side_style
    {
        /* background-color: #ececef; */
    }
</style>
@endsection

@section('content')

<!-- END PAGE HEADER-->
<div id="print-modal">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                v-if="is_show"
                :value-type="'onlineItemList'"
                @closed="closeModal">
        <div slot="body">
            <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Type')</label>
                                <select name="photo" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    <option value="photo">@lang('layout.Photo')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>  
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                    autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                    autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!-- BEGIN TAB PORTLET-->

<!-- END PAGE HEADER-->
<div id="print-modal-user">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                v-if="is_show"
                :value-type="'online_users'"
                @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                    autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                    autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!-- BEGIN TAB PORTLET-->

<!-- END PAGE HEADER-->
<div id="print-modal-order">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                v-if="is_show"
                :value-type="'onlineOrderList'"
                @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                    autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                    autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!-- BEGIN TAB PORTLET-->

<div class="row">

    <div class="portlet light ">
        
        <div class="portlet-title" id="backbtn">
            <div class="page-bar">
                <ul class="page-breadcrumb">
                    <li>
                        <a href="{{url('/')}}">@lang('menu.Dashboard')</a>
                        <i class="fa fa-angle-double-left"></i>
                    </li>
                    <li>
                        <span>@lang('menu.OnlineShop')</span>
                    </li>
                </ul>
            </div>
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('menu.OnlineShop')</span>
            </div>
            
        </div>
        <div class="portlet-body form">
               
                <div class="profile" style="background-color: #eef1f5;"> 
               
                    <div class="tabbable-line tabbable-full-width">
                        <!-- <ul class="nav nav-tabs">
                        <li class="">
                                <a href="#tab_1_1" data-toggle="tab" aria-expanded="false"> Overview </a>
                            </li>
                            <li class="">
                                <a href="#tab_1_3" data-toggle="tab" aria-expanded="false"> Account </a>
                            </li>
                            <li class="active">
                                <a href="#tab_1_6" data-toggle="tab" aria-expanded="true"> Help </a>
                            </li>
                        </ul> -->
                        <?php
                            $logo = null;
                                if( onlineSystemConfig()['logo'] !='')
                                {
                                $logo =  onlineSystemConfig()['logo'];
                                }
                        ?>
                        <div class="tab-content">

                            <div class="tab-pane active" id="tab_1_6">
                                <div class="row">
                                    <div class="col-lg-2 col-md-2 col-sm-12 col-md-12">
                                         <!-- PORTLET MAIN -->
                                        <div class="portlet light profile-sidebar-portlet ">
                                            <!-- SIDEBAR USERPIC -->
                                            <div class="profile-userpic">
                                                <img src="{!!url('/uploads/logo/'.$logo)!!}" class="img-responsive" alt=""> </div>
                                                                
                                            <!-- END SIDEBAR USERPIC -->
                                            <!-- SIDEBAR USER TITLE -->
                                            <div class="profile-usertitle side_style">
                                                <a href="{{route('/')}}" >
                                                    <div class="profile-usertitle-name"> {!!onlineSystemConfig()['name']!!} </div>
                                                </a>
                                                <!-- <div class="profile-usertitle-job"> Developer </div> --> 
                                            </div>
                                            <!-- END SIDEBAR USER TITLE -->
                                            <!-- SIDEBAR BUTTONS -->
                                            <div class="profile-userbuttons side_style" >
                                                <a class="btn btn-circle green btn-sm" href="{{route('onlineComment.index')}}"> <i class="fa fa-comment"></i> @lang('menu.Comment')</a>

                                                <!-- <button type="button" class="btn btn-circle red btn-sm">Message</button> -->
                                            </div>
                                            <!-- END SIDEBAR BUTTONS -->
                                            <!-- SIDEBAR MENU -->
                                            <div class="profile-usermenu side_style" >
                                                <ul class="nav">      
                                                    <li class="active">
                                                        <a href="#tab_3" data-toggle="tab">
                                                        <i class="fa fa-database" style="color: red;font-size: 18px;"></i> @lang('layout.Items') </a>
                                                    </li>
                                                    <li class="">
                                                        <a href="#tab_4" data-toggle="tab">
                                                        <i class="fa fa-user" style="color: red;font-size: 18px;"></i>@lang('menu.Users')</a>
                                                    </li>
                                                    <li class="">
                                                        <a href="#tab_5" data-toggle="tab">
                                                        <i class="fa fa-file-text" style="color: red;font-size: 18px;"></i> @lang('layout.Orders') </a>
                                                    </li>
                                                    <li class="">
                                                        <a href="{{route('onlineSYstemConfig.index')}}" >
                                                        <i class="icon-settings" style="color: red;font-size: 18px;"></i> @lang('menu.Settings') </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <!-- END MENU -->
                                        </div>
                                        <!-- PORTLET MAIN -->
                                        <div class="portlet light">
                                            <!-- STAT -->
                                            <div class="row list-separated profile-stat">
                                                <div class="col-md-12 col-sm-12 col-xs-12">
                                                    <a href="{{route('systemAlerts.onlineOrder')}}">
                                                    <div class="uppercase profile-stat-title"> {{$onlineOrders}} </div>
                                                    <div class="uppercase profile-stat-text"> @lang('layout.OnlineOrders') </div>
                                                    </a>
                                                </div>
                                                <!-- <div class="col-md-4 col-sm-4 col-xs-6">
                                                    <div class="uppercase profile-stat-title"> 51 </div>
                                                    <div class="uppercase profile-stat-text"> Tasks </div>
                                                </div>
                                                <div class="col-md-4 col-sm-4 col-xs-6">
                                                    <div class="uppercase profile-stat-title"> 61 </div>
                                                    <div class="uppercase profile-stat-text"> Uploads </div>
                                                </div> -->
                                            </div>
                                            <!-- END STAT -->
                                            <div>
                                                <h4 class="profile-desc-title">@lang('layout.Description')</h4>
                                                <span class="profile-desc-text"> {!!onlineSystemConfig()['description']!!} </span>
                                                <div class="margin-top-20 profile-desc-link">
                                                    <i class="fa fa-phone"></i>
                                                    <a >{!!onlineSystemConfig()['phone']!!}</a>
                                                </div>
                                                <div class="margin-top-20 profile-desc-link">
                                                    <i class="fa fa-file-text"></i>
                                                    <a >{!!onlineSystemConfig()['email']!!}</a>
                                                </div>
                                                <div class="margin-top-20 profile-desc-link">
                                                    <i class="fa fa-globe"></i>
                                                    <a >{!!onlineSystemConfig()['website']!!}</a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- END PORTLET MAIN -->
                                    </div>
                                    <div class="col-lg-10 col-md-10 col-sm-12 col-md-12">
                                        <div class="tab-content">
                                            <!----------------------------------------------------------------------------
                                            | BEGIN Online Items
                                            |---------------------------------------------------------------------------->
                                            <div id="tab_3" class="tab-pane active">
                                                        <div class=" portlet light bordered " > 
                                                            <div class="portlet-title" id="">
                                                                <div class="caption font-dark">
                                                                    <i class="fa fa-database font-red" style="font-size: 25px"></i>&nbsp;
                                                                    <span class="caption-subject bold uppercase">@lang('layout.Items')</span>
                                                                </div>
                                                                <div class="tools"> </div>
                                                                <div class="pull-right">

                                                                    @permission('onlineShop-export')
                                                                        <span id="anchore-modal">
                                                                            <a href="#" @click.prevent="showModal" class="btn  btn-success">
                                                                                <i class="fa fa-print"></i>
                                                                            </a>
                                                                        </span>
                                                                        @endpermission
                                                                        @permission('onlineShop-list')
                                                                        <a href="{{route('onlineItem.index')}}">
                                                                            <button class="btn btn-success">
                                                                                <i class="fa fa-database"></i> @lang('layout.AllItem')
                                                                            </button>
                                                                        </a>
                                                                        @endpermission 
                                                                        @permission('onlineShop-create')
                                                                        <a href="{{route('onlineItem.create')}}">
                                                                            <button class="btn btn-success">
                                                                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                                                            </button>
                                                                        </a>
                                                                        @endpermission

                                                                </div>
                                                            </div>
                                                            <div class="portlet-body">
                                                                <table class="table table-striped table-bordered table-hover" id="online_items_table">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>@lang('layout.Name')</th>
                                                                        <th>@lang('layout.Description')</th>
                                                                        <th>@lang('layout.Price')</th>
                                                                        <th>@lang('layout.OnHand')</th>
                                                                        <th>@lang('layout.Actions')</th>


                                                                        </tr>
                                                                    </thead>
                                                                </table>
                                                            </div>
                                                        </div>
                                            </div>
                                            <!----------------------------------------------------------------------------
                                            | End Online Items
                                            |---------------------------------------------------------------------------->
                                            <!----------------------------------------------------------------------------
                                            | BEGIN Online Users
                                            |---------------------------------------------------------------------------->
                                            <div id="tab_4" class="tab-pane">
                                                <div id="accordion1" class="panel-group">
                                                        <div class=" portlet light bordered " > 
                                                            <div class="portlet-title" id="noBack">
                                                                <div class="caption font-dark">
                                                                    <i class="fa fa-user font-red" style="font-size: 25px"></i>&nbsp;
                                                                    <span class="caption-subject bold uppercase">@lang('menu.Users')</span>
                                                                </div>

                                                                <div class="tools"> </div>
                                                                <div class="pull-right">
                                                                    

                                                                    @permission('onlineShop-export')
                                                                        <span id="anchore-modal-user">
                                                                            <a href="#" @click.prevent="showModal" class="btn  btn-success">
                                                                                <i class="fa fa-print"></i>
                                                                            </a>
                                                                        </span>
                                                                        @endpermission
                                                                        @permission('onlineShop-create')
                                                                        <!-- <a href="{{route('online.users.create')}}">
                                                                            <button class="btn btn-success">
                                                                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                                                            </button>
                                                                        </a> -->
                                                                        @endpermission


                                                                </div>
                                                            </div>
                                                            <div class="portlet-body">
                                                                <table class="table table-striped table-bordered table-hover" id="online_users_table">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>@lang('layout.Name')</th>
                                                                        <th>@lang('layout.LastName')</th>
                                                                        <th>@lang('layout.Phone')</th>
                                                                        <th>@lang('layout.Email')</th>
                                                                        <th>@lang('layout.Language')</th>
                                                                        <th>@lang('layout.Actions')</th>
                                                                        </tr>
                                                                    </thead>
                                                                </table>
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                            <!----------------------------------------------------------------------------
                                            | End Online Users
                                            |---------------------------------------------------------------------------->
                                            <!----------------------------------------------------------------------------
                                            | BEGIN Online Orders
                                            |---------------------------------------------------------------------------->
                                            <div id="tab_5" class="tab-pane">
                                                <div id="accordion1" class="panel-group">
                                                        <div class=" portlet light bordered " > 
                                                            <div class="portlet-title" id="noBack">
                                                                <div class="caption font-dark">
                                                                    <i class="fa fa-file-text font-red" style="font-size: 25px"></i>&nbsp;
                                                                    <span class="caption-subject bold uppercase">@lang('layout.Orders')</span>
                                                                </div>
                                                                <div class="tools"> </div>
                                                                <div class="pull-right">
                                                                    <span id="anchore-modal-order">
                                                                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                                            <i class="fa fa-print"></i>
                                                                        </a>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="portlet-body">
                                                                <table class="table table-striped table-bordered table-hover" id="online_order_table">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>@lang('layout.Number')</th>
                                                                        <th>@lang('layout.Customer')</th>
                                                                        <th>@lang('layout.Phone')</th>
                                                                        <th>@lang('layout.Currency')</th>
                                                                        <th>@lang('layout.Date')</th>
                                                                        <th>@lang('layout.DeliveryDate')</th>
                                                                        <th>@lang('layout.Amount')</th>
                                                                        <th width="20%">@lang('layout.Description')</th>
                                                                        <th>@lang('layout.Action')</th>
                                                                        </tr>
                                                                    </thead>
                                                                </table>
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                            <!----------------------------------------------------------------------------
                                            | End Online Orders
                                            |---------------------------------------------------------------------------->
                                            <!----------------------------------------------------------------------------
                                            | BEGIN Online Settings
                                            |---------------------------------------------------------------------------->
                                            <div id="tab_6" class="tab-pane">
                                                <div id="accordion1" class="panel-group">
                                                        <div class=" portlet light bordered " > 
                                                            <div class="portlet-title" id="noBack">
                                                                <div class="caption font-dark">
                                                                    <i class="icon-settings font-red" style="font-size: 25px"></i>&nbsp;
                                                                    <span class="caption-subject bold uppercase">@lang('menu.Settings')</span>
                                                                </div>
                                                                <div class="tools"> </div>
                                                                <div class="pull-right">
                                                                    <span id="anchore-modal">
                                                                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                                            <i class="fa fa-print"></i>
                                                                        </a>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                            <div class="portlet-body">
                                                                <table class="table table-striped table-bordered table-hover" id="vehicleLocationsddddd">
                                                                    <thead>
                                                                        <tr>
                                                                        <th>@lang('layout.Name')</th>
                                                                        <th>@lang('layout.Description')</th>
                                                                        <th>@lang('layout.Price')</th>
                                                                        <th>@lang('layout.OnHund')</th>
                                                                        <th>@lang('layout.Actions')</th>


                                                                        </tr>
                                                                    </thead>
                                                                </table>
                                                            </div>
                                                        </div>
                                                </div>
                                            </div>
                                            <!----------------------------------------------------------------------------
                                            | End Online Settings
                                            |---------------------------------------------------------------------------->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end tab-pane-->
                </div>

            <!-- END FORM-->
        </div>
    </div>
</div>



<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@push('scripts')
<script>
    $(document).ready(function() {
        $('#online_items_table').DataTable({
            ajax: {
                ajax: '{{route("onlineShop.index")}}',
                data: {
                    type: 'online_items'
                }
            },
            pageLength: '{{getPageRows()}}',
          
            scrollCollapse: true,
            paging: true,
            serverSide: true,


            columns: [{
                    data: 'name',
                    name: 'online_item.name'
                },
                {
                    data: 'description',
                    name: 'online_item.description'
                },
                {
                    data: 'price',
                    name: 'online_item.price'
                },
                {
                    data: 'onhand',
                    name: 'online_item.onhand'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });        
        
        $('#online_users_table').DataTable({
            ajax: {
                ajax: '{{route("onlineShop.index")}}',
                data: {
                    type: 'online_users'
                }
            },
            pageLength: '{{getPageRows()}}',
          
            scrollCollapse: true,
            paging: true,
            serverSide: true,



            columns: [{
                    data: 'fname',
                    name: 'online_user.fname'
                },
                {
                    data: 'lname',
                    name: 'online_user.lname'
                },
                {
                    data: 'phone',
                    name: 'online_user.phone'
                },
                {
                    data: 'email',
                    name: 'online_user.email'
                },
                {
                    data: 'lang',
                    name: 'online_user.lang'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]
        });        
        
        $('#online_order_table').DataTable({
            ajax: {
                ajax: '{{route("onlineShop.index")}}',
                data: {
                    type: 'online_orders'
                }
            },
            pageLength: '{{getPageRows()}}',
          
            scrollCollapse: true,
            paging: true,
            serverSide: true,



            columns: [
                {data: 'number', name: 'online_order.number'},
                {data: 'fname', name: 'online_user.fname'},
                {data: 'phone', name: 'online_user.phone'},
                {data: 'currency', name: 'currency', orderable: false, searchable: false},
                {data: 'date', name: 'date', orderable: false, searchable: false},
                {data: 'delivery_date', name: 'delivery_date', orderable: false, searchable: false},
                {data: 'price', name: 'price', orderable: false, searchable: false},
                {data: 'description', name: 'online_order.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false}
                
            ]
        });




    });



    Vue.component('v-select', VueSelect.VueSelect)


    // new for modal


    var vm = new Vue({
        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('onlineItem.report') !!}',
            excelRoute: '{!! route('onlineItem.report') !!}',


        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },


        }
    });

    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true;

            }
        }
    });

    var vuser = new Vue({
        el: '#print-modal-user',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}'
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },
        }
    });

    new Vue({
        el: '#anchore-modal-user',
        methods: {
            showModal: function() {
                console.log('trr')
                vuser.$data.is_show = true;

            }
        }
    });

    var vorder = new Vue({
        el: '#print-modal-order',
        data: {
            is_show: false,
            pdfRoute: '{!!route('onlineOrder.report') !!}',
            excelRoute: '{!! route('onlineOrder.report') !!}'
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },
        }
    });

    new Vue({
        el: '#anchore-modal-order',
        methods: {
            showModal: function() {
                console.log('trr')
                vorder.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#anchore-modal1',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.is_show = true;

            }
        }
    });
    // /new for modal

    var vtr = new Vue({
        el: '#sites',
        data: {
            site_id: 0,
        },
        methods: {
            getData() {
                getRecord();
            }
        }
    });

    var driver_v = new Vue({
        el: '#driver_t',
        data: {
            tcompany_id: 0,
        },
        methods: {
            getData() {
                getDriverRecord();
            }
        }
    });
</script>
@endpush