@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OnlinePartEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                {!! Form::model($online_item, ['method' => 'PATCH','route' => ['onlinePart.update',$online_item->item_to_show_id],'class'=>'form-horizont','id'=>'onlinepart-edit-form','files'=> true]) !!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label"> @lang('layout.Part')</label>
                                    <select name="type" v-model="part" class="form-control">
                                        <option value="">@lang('layout.SelectPart')</option>
                                        <option value="RecommendedProduct">@lang('layout.RecommendedProduct')</option>
                                        <option value="NewProduct">@lang('layout.NewProduct')</option>
                                        <option value="OurProduct">@lang('layout.OurProduct')</option>
                                        <option value="IncommmingProduct">@lang('layout.IncommmingProduct')</option>
                                        <option value="Slider">@lang('layout.Slider')</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                <th style="min-width: 180px">@lang('layout.ImageTitle') </th>
                                <th style="min-width: 100px;">@lang('layout.Photo')</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <v-select label="name" v-model="item.inventory" :options="temp_items"
										@search="onItemSearch"></v-select>
                                    <input type="hidden" :name="'id['+index+']'" :value="(!item.inventory)?null:item.inventory.id">
                                </td>
                                <td>
                                    <textarea :name="'description['+index+']'" class="form-control" rows="2">@{{(item.inventory==null)?null:item.inventory.description}}</textarea>
                                </td>
                                <td v-if="part == 'Slider'">
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 180px; height: 120px;">
                                            <img :src="(!item.inventory)?null:((!item.inventory.source)?null:'{{asset('uploads/online_item/')}}/'+item.inventory.source)" alt=""/></div>
                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                            style="max-width: 180px; max-height: 120px;"></div>
                                        <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <input :name="'image['+index+']'" type="file">
                                                    </span>
                                                    <input :name="'image1['+index+']'" type="hidden" :value="(!item.inventory)?null:item.inventory.source" >
                                            <a href="javascript:;" class="btn default fileinput-exists"
                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                        </div>
                                        
                                        <span class="input-group-addon" style="color: #b90000;">
                                        @lang('layout.ImageSize')
                                        </span>
                                    </div>
                                </td>
                                <td v-if="part !== 'Slider'">
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 180px; height: 120px;">
                                            <img :src="(!item.inventory)?null:((!item.inventory.image)?null:'{{asset('uploads/online_item/')}}/'+item.inventory.image)" alt=""/></div>
                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                            style="max-width: 180px; max-height: 120px;"></div>
                                        <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <input :name="'image['+index+']'" type="file">
                                                    </span>
                                                    <input :name="'image1['+index+']'" type="hidden" :value="(!item.inventory)?null:item.inventory.image" >
                                            <a href="javascript:;" class="btn default fileinput-exists"
                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <hr>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="submitForm"
                            class="btn green">@lang('layout.Update')</button>
                    <a href="{{route('onlinePart.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);
        
        var online_item = {!! json_encode($online_item) !!};
        var uploads = "{{asset('uploads/online_item/')}}";

        var v = new Vue({
            el: '#app',
            data: {
                part: online_item.type,
                showModal: false,
                uploads: uploads,
                selectedIndex: 0,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                brandItems: [],
                temp_items: [],
                totalAmountes: [],
                inventories: [],
                selected_index: 0,
                selected_area: null
            },
            computed: {
                setRates(){


                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {
                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }
                    }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    if (this.inventories.length == 0) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function() {
                if (online_item) {
                    // console.log('ssssssss', online_item);
                    this.inventories.push({
                        item: null,
                        inventory: online_item
                    });
                }

            },
            methods:
                {
                    memberClassChange() {
                        this.customer = this.all_customer;
                        if (this.selected_class) {
                            this.customer = this.all_customer.filter((member) => {
                                return this.selected_class.id == member.class_id;
                            });

                        }
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        if (v.inventories[index].item_category != null) {
                        let inventory_category_id = this.inventories[index]['item_category'].id;
                        let inventory_brand_id = (v.inventories[index]['selectedBrand'] != undefined) ? v.inventories[index]['selectedBrand'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                brand_id: inventory_brand_id,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    //ajax call to get items brand
                    onItemSearchBrand(selectedIndex) {
                        v.setIndex(selectedIndex);
                        if (v.inventories[selectedIndex].selectedBrand != null) {
                            let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                            let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                            axios.get("{{route('onlinePartSearch.search')}}", {
                                params: {
                                    method_name: 'itemSearchNameBoot',
                                    brand_id: inventory_brand_id,
                                    inventory_category_id: inventory_category_id
                                }
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }

                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;
                            // console.log(213213,item);
                            var OnHand = ((item.OnHand * item.measure_unit / item.measure.measure_unit));
                            result1 = Number.parseFloat(OnHand).toFixed(precision());
                            this.inventories[index].item.quantity = result1;
                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }


                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('onlinePartSearch.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                keyword: search
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    // end item search
					
                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.selected_index = index;
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("onlinepart-edit-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush