@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'onlineOrderList'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OnlineOrderList')</span>
                </div>
                <div class="tools">

                </div>
                <div class="pull-right">

                    @permission('onlineShop-export')

                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('onlineShop-create')
                    <!-- <a href="{{route('onlinePart.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered " cellspacing="0" id="onlineOrder">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.DeliveryDate')</th>
                        <th>@lang('layout.Amount')</th>
                        <th width="20%">@lang('layout.Description')</th>
                        <th>@lang('layout.Status')</th>
                        <th>@lang('layout.Action')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <div id="factor-obj">
    <!-- @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif -->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
     
        let data_table;
        $(document).ready(function () {

            data_table = $('#onlineOrder').DataTable({
                ajax: '{{route("onlineOrder.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:0}}", "{{getRowOrder()}}"]],
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'name', name: 'name'},
                    {data: 'phone', name: 'phone'},
                    {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'date', name: 'date'},
                    {data: 'delivery_date', name: 'delivery_date'},
                    {data: 'price', name: 'price', orderable: false, searchable: false},
                    {data: 'description', name: 'description'},
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]

            });
        });


        // new vue for modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('onlineOrder.report') !!}',
                excelRoute: '{!! route('onlineOrder.report') !!}',
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        // /new vue for modal
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object')
                    {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });

    </script>


@endpush
