@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OnlineOrderEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                {!! Form::model($online_order, ['method' => 'PATCH','route' => ['onlineOrder.update',$online_order->id],'class'=>'form-horizont','id'=>'onlinepart-edit-form','files'=> true]) !!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 form-group">
                            <label class=" control-label">@lang('layout.User')</label>
                            <div>
                                <h3> {{$online_order->fname}} </h3>
                            </div>
                        </div>
                        <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12 form-group">
                            <label class=" control-label">@lang('layout.Number')</label>
                            <div>
                                <h3> {{$online_order->number}} </h3>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 form-group">
                            <label class=" control-label">@lang('layout.Email')</label>
                            <div>
                                <h3> {{$online_order->email}} </h3>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 form-group">
                            <label class=" control-label">@lang('layout.Date')</label>
                            <div>
                                <h3> {{$online_order->date}} </h3>
                            </div>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 form-group">
                            <label class=" control-label">@lang('layout.Price')</label>
                            <div>
                                <h3> @{{total}} {{$online_order->currency}} </h3>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12 form-group">
                            <label class=" control-label">@lang('layout.DeliveryDate')</label>
                            <div>
                                <input type="text" name="delivery_date" value="{{$online_order->delivery_date}}" autocomplete="off" class="form-control date">
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 form-group">
                            <label class="control-label">@lang('layout.Description')</label>
                            <textarea name="description" class="form-control" rows="2">{{$online_order->description}}</textarea>
                        </div>
                    </div>
                </div>

                <div class="row" v-if="orders.length>0" >
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover" >
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> # </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Photo')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(item,index) in orders">
                                <td>@{{index+1}}</td>
                                <td class="highlight">
                                    <!-- <v-select label="name" v-model="item.item" :options="temp_items" ></v-select>
                                    <input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id"> -->
                                    @{{(item.item==null)?null:item.item.name}}
                                </td>
                                <td>
                                    <div style="width: 70px; height: 60px;" v-if="item.item!=null">
                                        <img :src="uploads+'/'+item.item.image" style="width: 70px; height: 60px;" alt="" />
                                    </div>
                                </td>
                                <td>
                                    @{{(item.item==null)?null:item.item.quantity}}
                                    <!-- <input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')"> -->
                                </td>
                                <td>
                                    @{{((item.item==null)?null:(item.item.price))}} @{{(item.item==null)?null:item.item.currency}}
                                    <!-- <input type="hidden" name="price[]" v-model.number="(item.item==null)?null:item.item.price" > -->
                                </td>
                                <td>
                                    @{{((item.item==null)?null:(item.item.price * item.item.quantity))}} @{{(item.item==null)?null:item.item.currency}}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <br/>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="submitForm"
                            class="btn green">@lang('layout.Update')</button>
                    <a href="{{route('onlineOrder.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);

        var selected_item = {!! json_encode($online_order_list) !!};
        var uploads = "{{asset('uploads/online_item/')}}";
        
        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedIndex: 0,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                brandItems: [],
                temp_items: [],
                selected_item: selected_item,
			    orders:[],
                uploads: uploads,
                selected_index: 0,
                selected_area: null
            },
            computed: {
                // calculate total
                total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.orders.length; i++) {
                        if (this.orders[i].item && this.orders[i].item != null) {
                            if (this.orders[i].item.quantity > 0 && this.orders[i].item.price > 0) {
                                this.currency = this.orders[i].item.currency;
                                sum += this.orders[i].item.quantity * this.orders[i].item.price;
                            }
                        }
                    }
                    return myRound(sum);
                }
            },
            mounted:function(){
            // initialize the selected item
                for(var i=0;i<this.selected_item.length;i++)
                {
                // console.log('ssssssss',this.selected_item[i]);
                this.orders.push({item:this.selected_item[i],item_category:null});
                }
            },
            methods:
                {
                    memberClassChange() {
                        this.customer = this.all_customer;
                        if (this.selected_class) {
                            this.customer = this.all_customer.filter((member) => {
                                return this.selected_class.id == member.class_id;
                            });

                        }
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        if (v.inventories[index].item_category != null) {
                        let inventory_category_id = this.inventories[index]['item_category'].id;
                        let inventory_brand_id = (v.inventories[index]['selectedBrand'] != undefined) ? v.inventories[index]['selectedBrand'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                brand_id: inventory_brand_id,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    //ajax call to get items brand
                    onItemSearchBrand(selectedIndex) {
                        v.setIndex(selectedIndex);
                        if (v.inventories[selectedIndex].selectedBrand != null) {
                            let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                            let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                            axios.get("{{route('onlinePartSearch.search')}}", {
                                params: {
                                    method_name: 'itemSearchNameBoot',
                                    brand_id: inventory_brand_id,
                                    inventory_category_id: inventory_category_id
                                }
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }

                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;
                            // console.log(213213,item);
                            var OnHand = ((item.OnHand * item.measure_unit / item.measure.measure_unit));
                            result1 = Number.parseFloat(OnHand).toFixed(precision());
                            this.inventories[index].item.quantity = result1;
                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }


                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('onlinePartSearch.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                keyword: search
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    // end item search
					
                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.selected_index = index;
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("onlinepart-edit-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush