@extends('layouts.factor-master')
@section('content')

    <?php
    $report = [];
    $_name = true;
    ?>
    <table class="main-table">
        @if($online_order && $online_order !=[])

            <tr>
                <td>
                    <span>@lang('layout.Number')</span>:
                    <span>{{$online_order->number}}</span>
                </td>
                <td>
                    <span>@lang('layout.User')</span>:
                    <span>{{$online_order->fname}}</span>
                </td>
                <td>
                    <span>@lang('layout.Email')</span>:
                    <span>{{$online_order->email}}</span>
                </td>
                <td>
                    <span>@lang('layout.Date')</span>:
                    <span>{{$online_order->date}}</span>
                </td>
            </tr>
            <tr>
                <td>
                    <span>@lang('layout.DeliveryDate')</span>:
                    <span>{{$online_order->delivery_date}}</span>
                </td>
                <td>
                    <span>@lang('layout.Description')</span>:
                    <span>{{$online_order->description}}</span>
                </td>
            </tr>
        @endif
    </table>


    <h3 class="table-caption" style="text-align: center;">@lang('layout.OnlineOrderReport')</h3>
    <table class="main-table">

        <tr class="bg">
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
            <th class="text-center" style="min-width: 80px;"> @lang('layout.Photo')</th>
            <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
            <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
            <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
        </tr>
        <?php
        $count = 0;
        $total = 0;
        ?>
        @foreach($online_order_list AS $record)
            <?php
            $total += $record->price * $record->quantity;
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->name}}</td>
                <td>
                    @if($record->image)
                    <div style="width: 70px; height: 60px;">
                        <img src="{{asset('uploads/online_item/'.'/'.$record->image)}}" style="width: 70px; height: 60px;" alt="" />
                    </div>
                    @endif
                </td>
                <td class="center">{{$record->quantity}}</td>
                <td class="center">{{$record->price}} {{$record->currency}}</td>
                <td class="center">{{$record->price * $record->quantity}} {{$record->currency}}</td>
            </tr>
        @endforeach

        <tr class="bg">
            <td colspan="2" class="center">@lang('layout.Total')</td>
            <td colspan="4" class="center">{{$total}}</td>
        </tr>
      
    </table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection