@extends('layouts.app')

@section('content')
@include('online_message.modal')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'onlineMessageShow'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                <input type="hidden" name="session_id" value="{{$id}}" />
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>

    <div id="loading_app" v-cloak>
    {{Form::open(['route' => 'onlineMessage.store','method' => 'POST','class' => 'inline'])}}


    <input type="hidden" name="session_id" value="{{$id}}" />
    <textarea class="form-control" name="message" v-model="message" style="display: none" > </textarea>

    <button id="loading-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Message')</label>
                            <textarea class="form-control" name="message" v-model="message" > </textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <input type="submit" value="@lang('layout.Submit')" class="btn btn-success" @click="ok" />
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>
        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- 
    <div id="print-modal-message">
        <modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'onlineMessage'" @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Message')</label>
                                <textarea class="form-control" name="message" > </textarea>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </modal>
    </div> -->
    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OnlineMessageShow')</span>
                </div>
                <div class="tools">

                </div>
                <div class="pull-right">
                    <a class="btn btn-success" onclick="getMessageList()" title="@lang('layout.Alerts')" id="alert_count">
                        <span class="badge badge-success" style="top: -8px;">@{{alert}}</span>
                        <i class="icon-bell"></i>
                    </a>
                    @permission('onlineShop-export')
                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('onlineShop-create')
                     <button type="button" id="contract_loading" class="btn btn-success"><i class="fa fa-plus"></i> @lang('layout.AnswerToMessage') </button>
                    @endpermission
                    
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered " cellspacing="0" id="onlineMessage">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.UserSystem')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Time')</th>
                        <th width="30%">@lang('layout.Message')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <div id="factor-obj">
    <!-- @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif -->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>
     

        let data_table;
            function getMessageList() {

            data_table = $('#onlineMessage').DataTable({
                ajax: '{{route("onlineMessage.show",$id)}}',
                pageLength: '{{getPageRows()}}',
                order: [["5", "desc"]],
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'session_id', name: 'messages.session_id'},
                    {data: 'fname', name: 'fname', orderable: false, searchable: false},
                    {data: 'name', name: 'name', orderable: false, searchable: false},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'date', name: 'date', searchable: false},
                    {data: 'time', name: 'time', searchable: false},
                    {data: 'massage', name: 'messages.massage'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]

            });
            // getMessagePerTime();
            v_alert.message_id = v_alert.last_message_id;
            v_alert.alert = '';
            }
            
            function getMessagePerTime() {
                setTimeout((function () {
                    getLastMessage();
                    // console.log(12);
                }), 4e4)
            }
            function getLastMessage() {
                $.ajax({
                    type: 'GET',
                    url: "{{route('onlineMessage.last')}}",
                    data:{id:v_alert.message_id, session_id:'{{$id}}'},
                    success: function (result) {
                        if (result.count > 0) {
                            v_alert.last_message_id = result.id;
                        }
                        v_alert.alert = result.count;
                        // console.log(999,result.count);
                        // location.reload();
                        // return true;
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                    }
                });
                getMessagePerTime();
            }




        $(document).ready(function () {
            getMessagePerTime();
            getMessageList();
        });


        // new vue for modal

        var v_alert = new Vue({
            el: '#alert_count',
            data: {
                alert: '',
                message_id: '{{$message_id}}',
                last_message_id: '{{$message_id}}'
            },
            methods: {
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('onlineMessage.report') !!}',
                excelRoute: '{!! route('onlineMessage.report') !!}',
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        // new vue for modal

        var vmMessage = new Vue({
            el: '#print-modal-message',
            data: {
                is_show: false,
                pdfRoute: '{!!route('onlineMessage.report') !!}',
                excelRoute: '{!! route('onlineMessage.report') !!}',
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#message-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vmMessage.$data.is_show = true;

                }
            }
        });

        new Vue({
        el: '#loading_app',
        data: {
            showModal: false,
            message: null,

        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {


                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {

                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    $('#contract_loading').on('click', function(e) {
        $('#loading-modal').click();
        e.preventDefault();
    });

        // /new vue for modal
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object')
                    {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });

    </script>


@endpush
