@push('scripts')
    <script type="text/javascript">
        Vue.component('modal', {
            props: ['pdfRoute', 'excelRoute', 'valueType'],


            data: function () {
                return {
                    print_type: 'pdf',
                    form_route: ''
                }
            },

            template:
                `
				 <transition name="modal">
        		<div class="modal-mask" >
            	<div class="modal-wrapper" >
                <div class="modal-container">

                    <div class="modal-header">
                        <slot name="header">

                        </slot>
                    </div>

                    <div class="modal-body">

	                <form v-bind:action="form_route" method="POST" class="inline" id="print-from000s">

	                	{!!  csrf_field() !!}
						<slot name="body">


						</slot>
					</form>
            </div>

            <div class="modal-footer">
                <slot name="footer">

                    <button type=button class="modal-default-button btn btn-success" v-on:click="submitForPrint">
					@lang('layout.Submit')
                    </button>
                    <button type=button class="modal-default-button btn btn-danger" v-on:click="closeModal">
					@lang('layout.Cancel')
                    </button>
                </slot>
            </div>
        </div>
    </div>
</div>
</transition>
`,

            methods: {
                closeModal() {
                    console.log("closed modal event triggered");
                    this.$emit('closed');
                },
                submitForPrint() {
                    // code for sumbiting the route
                    this.closeModal();
                    $("#print-from000s").submit();


                },
            }


        });
    </script>
@endpush



@section('styles')
    <style>
        .modal-mask {
            position: fixed;
            z-index: 9998;
            top: 0;
            left: 0;
            width: 100%;
            overflow-y: auto;
            height: 100%;
            background-color: rgba(0, 0, 0, .5);
            display: table;
            transition: opacity .3s ease;
        }

        .modal-wrapper {
            display: table-cell;
            vertical-align: middle;
        }

        .modal-containerd {
            width: 80%;
            max-width: 90%;
            margin: 0px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 2px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
            transition: all .3s ease;
            font-family: Helvetica, Arial, sans-serif;
        }

        .modal-header h3 {
            margin-top: 0;
            color: #42b983;
        }

        .modal-body {
            margin: 20px 0;
        }

        .modal-default-button {
            float: right;
        }

        .modal-enter {
            opacity: 0;
        }

        .modal-leave-active {
            opacity: 0;
        }

        .modal-enter .modal-container,
        .modal-leave-active .modal-container {
            -webkit-transform: scale(1.1);
            transform: scale(1.1);
        }
    </style>
@endsection