@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OnlineMessageEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                {!! Form::model($online_message, ['method' => 'PATCH','route' => ['onlineMessage.update',$online_message->id],'class'=>'form-horizont','id'=>'onlinepart-edit-form','files'=> true]) !!}
                {{ csrf_field() }}
                <input type="hidden" name="session_id" value="{{$online_message->session_id}}" >
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-3 col-md-2 col-sm-12 col-xs-12">
                            <div class="col-md-12 form-group">
                                <label class=" control-label">@lang('layout.User')</label>
                                <div>
                                    <input readonly value="{{$online_message->fname}}" class="form-control">
                                    
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-2 col-sm-12 col-xs-12">
                            <div class="col-md-12 form-group">
                                <label class=" control-label">@lang('layout.Date')</label>
                                <div>
                                    <input readonly value="{{convertDate($online_message->date)}}" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Message')</label>
                                    <textarea name="message" class="form-control" rows="4">{{$online_message->massage}}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="submitForm"
                            class="btn green">@lang('layout.Update')</button>
                    <a href="{{route('onlineComment.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);
        

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedIndex: 0,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                brandItems: [],
                temp_items: [],
                totalAmountes: [],
                inventories: [],
                selected_index: 0,
                selected_area: null
            },
            computed: {
                setRates(){


                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // check data validation
                isError: function () {
                    var isError = false;
                    if (this.inventories.length == 0) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function() {
            },
            methods:
                {
                    memberClassChange() {
                        this.customer = this.all_customer;
                        if (this.selected_class) {
                            this.customer = this.all_customer.filter((member) => {
                                return this.selected_class.id == member.class_id;
                            });

                        }
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.selected_index = index;
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("onlinepart-edit-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush