@extends('layouts.app')
@section('style')
  <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
  <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
<style type="text/css">
.modal-container{
  width: 30%;
}
</style>
@stop
@section('content')

<div class="portlet">
  <div class="portlet-title" id="backbtn">
    <div class="caption"><i
      class=""></i>@lang('layout.OnlineItemShow')
    </div>
    <div class="tools"><a
      href="javascript:;" class="collapse" data-original-title="" title=""> </a>
      <a href="#portlet-config" data-toggle="modal" class="config" data-
      original-title="" title=""> </a>


    </div>
  </div>
  <div class="portlet-body">
    <div class="row">
    <div class="col-md-4">
    <a href="{{asset('uploads/online_item/' . $online_item->image)}}" target='_blank'>
      <img src="{{asset('uploads/online_item/' . $online_item->image)}}" class='img-responsive'>
    </a>
    </div>
    <div class="col-md-8">
    <div class="table-scrollable">
      <table class="table table-striped table-bordered table-advance table-hover">
      <thead>
        <tr>
          <th>#</th>
          <th class="hidden-xs"><i class="fa fa-briefcase"></i> @lang('layout.ItemName')</th>
          <th><i class="fa  fa-bars"></i> @lang('layout.Category')</th>
          <th><i class="fa  fa-bars"></i> @lang('menu.InventoryBrand')</th>
          <th><i class="fa  fa-color"></i> @lang('layout.Color')</th>
        <th class="hidden-xs"><i class="fa  fa"></i> @lang('layout.OnHand')
      </th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="hidden-xs"> {{ $online_item->id}}  </td>
      <td class="hidden-xs"> {{ $online_item->name}}  </td>
      <td class="hidden-xs"> {{ $online_item->category_name}}  </td>
      <td class="hidden-xs"> {{ $online_item->brand_name}}  </td>
      <td class="hidden-xs"> <span style="background-color: {{ $online_item->color}} ; width:10px;height:6px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>  </td>
      <td class="hidden-xs"> {{ $online_item->onhand}}  </td>
    </tr>
  </tbody>
  </table>
      <table class="table table-striped table-bordered table-advance table-hover">
      <thead>
        <tr>
      <th><i class="fa "></i> @lang('layout.Rate') </th>
      <th><i class="fa "></i> @lang('layout.Currency') </th>
      <th><i class="fa fa"></i> @lang('layout.Measure')</th>
      <th> 
        <i class="fa fa-clock-o"></i> @lang('layout.CreatedAt')
      </th>
      <th><i class="fa fa"></i> @lang('layout.Description')
      </th> 
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="hidden-xs"> {{ $online_item->price }}  </td>
      <td class="hidden-xs"> {{ $online_item->currency }}  </td>
      <td class="hidden-xs"> {{ $online_item->um_name }}  </td>
      <td class="hidden-xs"> {{ $online_item->date}}  </td>
      <td class="hidden-xs"> {{ $online_item->description}} </td>
    </tr>
  </tbody>
</table>
</div>
</div>
</div>
</div>
</div>
<div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs">  
    <li class="active">
      <a href="#both" data-toggle="tab" id="tab-both">
       <i class="fa fa-image "></i><b> @lang('layout.ImageList') </b></a>
     </li> 
     <li class="">
      <a href="#add_image" data-toggle="tab" id="tab-add_image">
      <i class="fa fa-plus"></i><b> @lang('layout.AddImage') </b></a>
     </li>
     <!-- <li class="">
      <a href="#qut-out" data-toggle="tab" id="tab-qut-out">
       <i class="fa fa-credit-card-alt"></i><b> @lang('layout.QutOut') </b></a>
     </li> -->

   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
    <div class="tab-pane active" id="both">
     <div class="row">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
          <div class="portlet-title">
            <div class="caption font-dark">
              <i class="icon-settings font-dark"></i>
              <span class="caption-subject bold uppercase">@lang('layout.Photo')</span>
            </div>
             <div class="actions">
          </div>
          </div>

          <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="both_table">
              <thead>
                <tr>
                  <th>@lang('layout.Photo')</th>
                  <th>@lang('layout.Description')</th>
                  <th>@lang('layout.Action')</th>
                </tr>
              </thead>
            </table>
          </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
      </div>
    </div>
  </div> 
  <div class="tab-pane" id="add_image">
   <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light bordered">
        <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.Photo')</span>
          </div>
          <div class="actions">
          </div>
        </div>
        <div class="portlet-body">
                <!-- BEGIN FORM-->
                {!! Form::model($online_item, ['method' => 'PATCH','route' => ['onlineItem.image.store',$online_item->id],'class'=>'form-horizont','id'=>'image-form','files'=> true]) !!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                            <img src="" alt=""/></div>
                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                            style="max-width: 200px; max-height: 150px;"></div>
                                        <div>
                                                <span class="btn default btn-file">
                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <input name="image" type="file">
                                                    </span>
                                            <a href="javascript:;" class="btn default fileinput-exists"
                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <label class="control-label ">@lang('layout.Description') </label>
                            <textarea name="description" class="form-control" rows="3"></textarea>
                            <input name="id" type="hidden" class="form-control" value="{{$online_item->id}}" />
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="submitForm"
                            class="btn green">@lang('layout.Submit')</button>
                  </div>
                  <br/>
                  <br/>
                </div>
                {!! Form::close() !!}
            <!-- END FORM-->
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
</div>
<div class="tab-pane" id="qut-out">
  <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light bordered">
        <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.QutOut')</span>
          </div>
          <div class="actions">

          <!--   <button type="button" onClick="report_by_type_pdf()" id="print_excell_out" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
          
            <button type="button" onClick="report_by_type_pdf()" id="print_pdf_out" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button> -->

            <span id="anchore-modal-out">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
            </span>
    
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-bordered table-hover" id="qut-out-table">
            <thead>
              <tr>  
                 <th>@lang('layout.Type')</th>
                 <th>@lang('layout.Number')</th>
                 <th>@lang('layout.ReferenceNumber')</th>
                 <th>@lang('layout.Customer')</th>
                 <th>@lang('layout.Date')</th>
                 <th>@lang('layout.SiteName')</th>
                 <th>@lang('layout.Quantity')</th>
                 <th>@lang('layout.Measure')</th>
                  <th>@lang('layout.Price')</th>
                 <th>@lang('layout.Total')</th>
                 <th>@lang('layout.Description')</th>

              </tr>
            </thead>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
</div>


</div>
</div>


</div>
@endsection
@include('print.modal')
@push('scripts')
<script>

   Vue.component("v-select", VueSelect.VueSelect);
  var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
      ok: function() {
        this.$emit('ok')
      }
    }
  })
// start app
// start app
var vm=new Vue({
  el: '#app',
  data: {
    showModal: false
  },
  methods:{
    ok:function(){
this.showModal = !this.showModal;
},
close:function(e)
{
  this.showModal = !this.showModal;
},
getModalContent(myData){
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
  $(document).ready(function(){
    var to, from;
    to = $("#range-to-example").persianDatepicker(modelDate());
    from = $("#range-from-example").persianDatepicker(modelDate());
 
    document.getElementById('dynamic_content').innerHTML=myData;
  });
})
}
},
})

$(document).ready(function(){
  $('#tab-qut-in').on('shown.bs.tab', function(event){


    $('#qut-in-table').DataTable({  
      scrollCollapse: true,
      serverSide: true,
      paging: true,
      order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
      retrieve: true,
      ajax:{
        url:'{{route("inventory.show",$online_item->id)}}',
        data:{type:'qut-in'}
      },
      pageLength:'{{getPageRows()}}',
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [
      { data: 'Type',          name: 'Type',searchable:false },
      { data: 'Number',        name: 'Number',searchable:false },
      { data: 'refNo',         name: 'refNo',searchable:false },
      { data: 'Vendor',        name: 'Vendor',searchable:false },
      { data: 'Date',          name: 'Date' ,searchable:false},
      { data: 'SiteName',      name: 'SiteName',searchable:false },
      { data: 'Quantity',      name: 'Quantity',searchable:false },
      { data: 'Measure',       name: 'Measure',searchable:false },
      { data: 'Cost',          name: 'Cost',searchable:false },
      { data: 'total_cost',    name: 'total_cost',searchable:false },
      { data: 'Total',         name: 'Total' ,searchable:false},
      { data: 'Description',   name: 'Description',searchable:false },
      ]
    });  
  });
});



// end qut-in 
// qut-in

$(document).ready(function(){
  $('#tab-qut-out').on('shown.bs.tab', function(event){

    $('#qut-out-table').DataTable({  
      order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
      scrollCollapse: true,
      serverSide: true,
      paging: true,
      retrieve: true,
      ajax:{
        url:'{{route("inventory.show",$online_item->id)}}',
        data:{type:'qut-out'}
      },
      pageLength:'{{getPageRows()}}',
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [
      { data: 'Type',          name: 'Type',searchable:true },
      { data: 'Number',        name: 'Number',searchable:false },
      { data: 'refNo',         name: 'refNo',searchable:false },
      { data: 'Vendor',        name: 'Vendor' ,searchable:false},
      { data: 'Date',          name: 'Date',searchable:false },
      { data: 'SiteName',      name: 'SiteName',searchable:false },
      { data: 'Quantity',      name: 'Quantity' ,searchable:false},
      { data: 'Measure',       name: 'Measure',searchable:false },
      { data: 'sales_price',   name: 'sales_price',searchable:false },
      { data: 'Total',         name: 'Total' ,searchable:false},
      { data: 'Description',   name: 'Description',searchable:false },
      ]

    });  
  });
});

// end qut-in
$(document).ready(function(){
  
    $('#both_table').DataTable({ 
      // order: [["{{orderByColumn()=='number'?1:4}}", "{{getRowOrder()}}"]],
      serverSide: true,
      paging: true,
      ajax:{
        url:'{{route("onlineItem.show",$online_item->id)}}',
        data:{type:'image'}
      },
      pageLength:'{{getPageRows()}}',
      buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
      columns: [
      { data: 'image',         name: 'image', searchable:false,orderable:true },
      { data: 'description',   name: 'description'},
      { data: 'actions',       name: 'actions', searchable:false,orderable:true },
      ]

    });  
});


       var vi = new Vue({
            el: '#add_image',
            methods: {
              // submit the form
              submitForm() {
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("image-form").submit()

                    }
                    else {

                    }
                });

              },
              saveAndNew() {
                var url = "{{route('onlineItem.image.store', ['id' => $online_item->id])}}";
                form_id = 'image-form';
                var data = $('#' + form_id).serialize();
                toggleBlock(true);
                axios.post(url, data)
                .then(function (response) {
                    toggleBlock(0);
                  console.log(123123,response);
                    if (response.data.result == 1) {
                        $('#' + form_id).trigger('reset');
                        //$('#success-sound')[0].play();
                        toastr.success('', response.data.message);
                        location.reload();
                    }
                    else {
                        var message = "{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    }
                })
                .catch(function (error) {
                    toggleBlock(0);
                    console.log(error);
                    var message = "{{__('message.Warning')}}";
                    //$('#error-sound')[0].play();
                    toastr.warning('', message);
                });
            }
          }
        });

</script>
@endpush