@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'onlineItemList'"
                      @closed="closeModal">

            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.Type') @lang('layout.Item')</label>
                                <select name="item_type" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    <option value="item">@lang('layout.Item')</option>
                                    <option value="service">@lang('layout.Service')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>  
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Type')</label>
                                <select name="photo" class="form-control">
                                    <option value="">@lang('layout.SelectType')</option>
                                    <option value="photo">@lang('layout.Photo')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>   
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.OnlineItemList')</span>
                </div>
                <div class="tools">

                </div>
                <div class="pull-right">

                    @permission('onlineShop-export')

                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('onlineShop-create')
                    <a href="{{route('onlineItem.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered " cellspacing="0" id="online_item">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Price')</th>
                        <th>@lang('layout.Color')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Photo')</th>
                        <th style="width: 20%;">@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <div id="factor-obj">
    <!-- @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif -->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
     
        let data_table;
        $(document).ready(function () {

            data_table = $('#online_item').DataTable({
                ajax: '{{route("onlineItem.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'online_item.id'},
                    {data: 'name', name: 'online_item.name'},
                    {data: 'price', name: 'online_item.price'},
                    {data: 'color', name: 'color', orderable: false, searchable: false},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'image', name: 'image', orderable: false, searchable: false},
                    {data: 'description', name: 'online_item.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}

                ]

            });


            $('#btnPrint').click(function () {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

            });


        });


        // new vue for modal

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('onlineItem.report') !!}',
                excelRoute: '{!! route('onlineItem.report') !!}',


            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        // /new vue for modal
        Vue.component('v-select', VueSelect.VueSelect)

        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object')
                    {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });

    </script>


@endpush
