@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('style')
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <style></style>
@stop
@section('content')
    @include("layouts.Cmodal")
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OnlineItemEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($online_item, ['method' => 'PATCH','route' => ['onlineItem.update',$online_item->id],'class'=>'form-horizont','id'=>'inventory-edit-form','files'=> true]) !!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" :options="currency" v-model="selected_currency" disabled ></v-select>
                                    <input type="hidden" name="currency" :value="selected_currency.code">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th style="min-width: 130px">@lang('layout.Category') </th>
                                    <th style="min-width: 80px;">@lang('layout.Brand')</th>
                                    <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                    <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                    <th style="min-width: 100px">@lang('layout.Color') </th>
                                    <th style="min-width: 120px">@lang('layout.Date') </th>
                                    <th style="min-width: 100px;">@lang('layout.Photo')</th>
                                    <th style="min-width: 180px">@lang('layout.Description') </th>
                                    <th style="min-width: 120px">@lang('layout.Measure') </th>
                                    <th style="min-width: 50px">@lang('layout.Cost') </th>
                                    <th style="min-width: 50px">@lang('layout.SalePrice') </th>
                                    <!-- <th></th> -->
                                </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td style="vertical-align: middle;">@{{index+1}}</td>
                                <td style="vertical-align: middle;">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                    <input type="hidden" name="inventory_category_name[]" :value="(!item.item_category)?null:item.item_category.name">
                                </td>
                                <td class="highlight" style="vertical-align: middle;">
                                    <v-select label="name" @keyup.native="onItemSearchBrand(index)" @click.native="onItemSearchBrand(index)" v-model="item.selectedBrand" :options="brandItem" placeholder="@lang('layout.Brand')" ></v-select>
                                    <input type="hidden" :name="'brand_id['+index+']'" :value="(item.selectedBrand==null)?null:item.selectedBrand.id">
                                    <input type="hidden" name="brand_name[]" :value="(item.selectedBrand==null)?null:item.selectedBrand.name">
                                </td>
                                <td class="highlight" style="vertical-align: middle;">
                                    <v-select label="name" v-model="item.inventory" :options="temp_items"
											@keyup.native="onItemload(index)"
											  @click.native="onItemload(index)"
											  @search="onItemSearch"></v-select>
                                    <input type="hidden" name="item_id[]" :value="(!item.item)?null:item.item.item_id">
                                    <input type="hidden" name="item_name[]" :value="(!item.item)?null:item.item.item_name">
                                </td>
                                <td style="vertical-align: middle;">
                                    <input type="number" name="inventory_quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           oninput = "autowidths(event)"
                                           class="form-control input-style input-number chan_length"
                                           placeholder="@lang('layout.Quantity')">
                                </td>

                                <td style="vertical-align: middle;">
                                    <input type="color" name="color[]" v-model="(item.item==null)?null:item.item.color" class="form-control" placeholder="@lang('layout.Color')">
                                </td>
                                <td style="vertical-align: middle;">
									<date_picker name="date[]" v-model="(item.item==null)?null:item.item.date" placeholder="@lang('layout.Date')" ></date_picker>
                                </td>
                                <td style="vertical-align: middle;">
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 100px; height: 90px;">
                                            <img :src="(!item.item)?null:((!item.item.photo)?null:uploads+'/'+item.item.photo)" alt=""/></div>
                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                            style="max-width: 100px; max-height: 90px;"></div>
                                        <div>
                                                <span class="btn default btn-file"> 
                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                    <input name="image[]" type="file">
                                                    </span>
                                                    <input name="image1[]" type="hidden" :value="(!item.item)?null:item.item.photo" >
                                            <a href="javascript:;" class="btn default fileinput-exists"
                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                        </div>
                                    </div>
                                </td>
                                <td style="vertical-align: middle;">
                                    <textarea name="description[]" class="form-control" rows="3">@{{(item.item==null)?null:item.item.description}}</textarea>
                                </td>
                                <td class="highlight" style="vertical-align: middle;">
                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                    </select>

                                    <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                    <input type="hidden" name="inventory_measure_name[]" :value="(item.item==null)?null:item.item.measure.measure_name">
                                </td>
                                <td style="vertical-align: middle;">
                                    <div class="input-group">
                                        <input type="number" placeholder="@lang('layout.Cost')"
                                                v-bind:value="(item.item==null)?null:myRound(item.item.cost*selected_currency.rate)"
                                                oninput = "autowidths(event)"
                                                class="form-control chan_length" disabled="disabled">
                                        <span class="input-group-addon">
                                            @{{selected_currency.symbol}}
                                        </span>
                                    </div>

                                </td>
                                <td style="vertical-align: middle;">
                                    <div class="input-group">
                                        <input type="number" name="inventory_price[]" placeholder="@lang('layout.SalePrice')"
                                               :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)"
                                               oninput = "autowidths(event)"
                                               ref="in" @input="setNewRate('inventory',index)" class="form-control chan_length">
                                        <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>

                                </td>
                                <!-- <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </td> -->
                            </tr>
                            </tbody>
                        </table>
                        <hr>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="submitForm"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('onlineItem.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);

        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectReceive: null,
                    classes: [],
                    selectedClass: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }

                    }).catch(error => console.log(error));
            },
            methods: {
              

                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();

                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        var customer_id = 0;
                        if (response) {
                            customer_id = response.customer_id;
                        }
                        axios.get('{{route("invoice.create")}}').then(response => {

                            v.customer = response.data.customer;
                            document.getElementById("modalForm").reset();
                            v.selected_customer=_.find(v.customer,(v)=>v.id==customer_id);

                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        var currency ={!! $currency !!};
        var inventoryCategory = {!! $inventoryCategory !!};
        let homeCurrency = {!! $home !!};
        var inventoryBrand = {!! $inventoryBrand !!};
        var online_item = {!! json_encode($online_item) !!};
        var uploads = "{{asset('uploads/online_item/')}}";

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                online_item: online_item,
                uploads: uploads,
                currency: currency,
                selected_currency: homeCurrency,
                selectedIndex: 0,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                brandItem: inventoryBrand,
                brandItems: [],
                temp_items: [],
                totalAmountes: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                inventory_category: inventoryCategory,
                selected_index: 0,
                selected_area: null
            },
            computed: {
                setRates(){


                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {
                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }
                    }
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function() {
                // initialize the selected item
                // `item_id`, `name`, `price`, `color`, `collection`, `category_id`, `brand_id`, `um_id`, `currency`, `description`, `image`, `type`, `onhand`
                if (this.online_item) {
                    this.selected_currency = _.find(this.currency, (o) => o.code == this.online_item['currency']);
                    var selectedBrand = _.find(this.brandItem, (o) => o.id == this.online_item['brand_id']);
                    var selectedcategory = _.find(this.inventory_category, (o) => o.id == this.online_item['category_id']);
                    console.log('ssssssss', this.online_item);
                    this.inventories.push({
                        item: this.online_item,
                        item_category: selectedcategory, selectedBrand: selectedBrand, inventory: this.online_item
                    });
                }

            },
            methods:
                {
                    memberClassChange() {
                        this.customer = this.all_customer;
                        if (this.selected_class) {
                            this.customer = this.all_customer.filter((member) => {
                                return this.selected_class.id == member.class_id;
                            });

                        }
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        if (v.inventories[index].item_category != null) {
                        let inventory_category_id = this.inventories[index]['item_category'].id;
                        let inventory_brand_id = (v.inventories[index]['selectedBrand'] != undefined) ? v.inventories[index]['selectedBrand'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                brand_id: inventory_brand_id,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    //ajax call to get items brand
                    onItemSearchBrand(selectedIndex) {
                        v.setIndex(selectedIndex);
                        if (v.inventories[selectedIndex].selectedBrand != null) {
                            let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                            let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchNameBoot',
                                    brand_id: inventory_brand_id,
                                    inventory_category_id: inventory_category_id
                                }
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }

                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;
                            // console.log(213213,item);
                            var OnHand = ((item.OnHand * item.measure_unit / item.measure.measure_unit));
                            result1 = Number.parseFloat(OnHand).toFixed(precision());
                            this.inventories[index].item.quantity = result1;
                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }


                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_brand_id = (v.inventories[v.selected_index]['selectedBrand'] != undefined) ? v.inventories[v.selected_index]['selectedBrand'].id : '';
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                keyword: search,
                                brand_id: inventory_brand_id,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    // end item search
					
                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_brand_id = (v.inventories[index]['selectedBrand'] != undefined) ? v.inventories[index]['selectedBrand'].id : '';
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchAllBoot',
                                    inventory_id: inventory_id,
                                    brand_id: inventory_brand_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = null;
                                        v.uploads = "{{asset('uploads/items/')}}";
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.selected_index = index;
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("inventory-edit-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush