@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')
    <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css"/>
    <style>

    </style>
@stop
@section('content')
    @include("layouts.Cmodal")

    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.OnlineCommentEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->

                {!! Form::model($online_comment, ['method' => 'PATCH','route' => ['onlineComment.update',$online_comment->id],'class'=>'form-horizont','id'=>'onlinepart-edit-form','files'=> true]) !!}
                {{ csrf_field() }}

                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-3 col-md-2 col-sm-12 col-xs-12">
                            <div class="col-md-12 form-group">
                                <label class=" control-label">@lang('layout.User')</label>
                                <div>
                                    <input type="text" name="user_name" value="{{$online_comment->user_name}}" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-2 col-sm-12 col-xs-12">
                            <div class="col-md-12 form-group">
                                <label class=" control-label">@lang('layout.Email')</label>
                                <div>
                                    <input type="email" name="email" value="{{$online_comment->email}}" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control" rows="4">{{$online_comment->description}}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="submitForm"
                            class="btn green">@lang('layout.Update')</button>
                    <a href="{{route('onlineComment.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">

                </cmodal>
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueInputAutowidth);
        

        var v = new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedIndex: 0,
                rate: 0,
                discountFiled: 0,
                discountIsAmount: false,
                brandItems: [],
                temp_items: [],
                totalAmountes: [],
                inventories: [],
                selected_index: 0,
                selected_area: null
            },
            computed: {
                setRates(){


                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // check data validation
                isError: function () {
                    var isError = false;
                    if (this.inventories.length == 0) {
                        isError = true;
                    }
                    return isError;


                },
                // filter the banks according to selected currency
                approperiateBank: function () {
                    var bankCopy = this.banks.slice();
                    var tempBank = bankCopy.filter((account) => {
                        return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                    });
                    if (tempBank.length > 0) {
                        this.selected_banks = tempBank[0];
                    }
                    return tempBank;
                },
            },
            mounted: function() {
            },
            methods:
                {
                    memberClassChange() {
                        this.customer = this.all_customer;
                        if (this.selected_class) {
                            this.customer = this.all_customer.filter((member) => {
                                return this.selected_class.id == member.class_id;
                            });

                        }
                    },

                    setIndex(e) {
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.setIndex(index);
                        if (v.inventories[index].item_category != null) {
                        let inventory_category_id = this.inventories[index]['item_category'].id;
                        let inventory_brand_id = (v.inventories[index]['selectedBrand'] != undefined) ? v.inventories[index]['selectedBrand'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                brand_id: inventory_brand_id,
                                inventory_category_id: inventory_category_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    //ajax call to get items brand
                    onItemSearchBrand(selectedIndex) {
                        v.setIndex(selectedIndex);
                        if (v.inventories[selectedIndex].selectedBrand != null) {
                            let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                            let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                            axios.get("{{route('onlinePartSearch.search')}}", {
                                params: {
                                    method_name: 'itemSearchNameBoot',
                                    brand_id: inventory_brand_id,
                                    inventory_category_id: inventory_category_id
                                }
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }

                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;
                            // console.log(213213,item);
                            var OnHand = ((item.OnHand * item.measure_unit / item.measure.measure_unit));
                            result1 = Number.parseFloat(OnHand).toFixed(precision());
                            this.inventories[index].item.quantity = result1;
                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {

                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }


                    },
                    // begin item search


                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
                        axios.get("{{route('onlinePartSearch.search')}}", {
                            params: {
                                method_name: 'itemSearchNameBoot',
                                keyword: search
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    // end item search
					
                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                        }
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.selected_index = index;
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null, item_category: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("onlinepart-edit-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },
            created: function () {

            }

        });

    </script>


@endpush