@extends('layouts.factor-master')

@section('content')

<?php
$report=customeReportNew('inventory_index');
?>

  <h3 class="table-caption" style="text-align: center;">@lang('layout.OnlineCommentList')</h3>

  <table   class="main-table">
    <tr>
      @if($from_date)
     <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
  
  
<table class="main-table" cellpadding="5px">

  <thead>
    <tr class="bg">
    <th> @lang('layout.Record') </th>
    <th>@lang('layout.Item')</th>
    <th>@lang('layout.User')</th>
    <th>@lang('layout.Email')</th>
    <th>@lang('layout.Category')</th>
    <th>@lang('layout.Status')</th>
    <th>@lang('layout.Description')</th>
  </tr>
  </thead>
  <tbody>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
    <td class="center" width="2%">{{$record->id}}</td>
    <td class="center" width="20%">{{$record->name}}</td>
    <td class="center" width="18%">{{$record->user_name}}</td>
    <td class="center" width="10%">{{$record->email}}</td>
    <td class="center" width="10%">{{$record->category}}</td>
    <td class="center" width="10%">{{$record->status}}</td>
    <td class="center" width="30%">

      @if(isset($report_format))
      {{$record->description}}
      @else
      {!! wordwrap($record->description,40,"<br/>\n",false) !!}
      @endif

    </td>
  </tr>
  
  @endforeach

</tbody>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection