@extends('online.layouts.app_back')

@section('content')

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Subheader-->
	<div class="subheader p-2 subheader-solid" id="kt_subheader">
		<div class="container-fluid d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
			<!--begin::Info-->
			<div class="d-flex align-items-center flex-wrap mr-1">
				<!--begin::Mobile Toggle-->
				<button class="burger-icon burger-icon-left mr-4 d-inline-block d-lg-none" id="kt_subheader_mobile_toggle">
					<span></span>
				</button>
				<!--end::Mobile Toggle-->
				<!--begin::Page Heading-->
				<div class="d-flex align-items-baseline flex-wrap mr-5">
					<!--begin::Page Title-->
					<h5 class="text-dark font-weight-bold my-1 mr-5">@lang('layout.MyProfile')</h5>
					<!--end::Page Title-->
				</div>
				<!--end::Page Heading-->
			</div>
			<!--end::Info-->
		</div>
	</div>
	<!--end::Subheader-->
	<!--begin::Entry-->
	<div class="d-flex flex-column-fluid pt-4">
		<!--begin::Container-->
		<div class="container">
			<!--begin::Profile Overview-->
			<div class="d-flex flex-row">
				<!--begin::Aside-->
				<div class="flex-row-auto offcanvas-mobile w-300px w-xl-350px" id="kt_profile_aside">
					<!--begin::Profile Card-->
					<div class="card card-custom card-stretch">
						<!--begin::Body-->
						<div class="card-body pt-4">
							<!--begin::Toolbar-->
							<!-- <div class="d-flex justify-content-end">
								<div class="dropdown dropdown-inline">
									<a href="#" class="btn btn-clean btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<i class="ki ki-bold-more-hor"></i>
									</a>
									<div class="dropdown-menu dropdown-menu-sm dropdown-menu-right">
										<ul class="navi navi-hover py-5">
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-drop"></i>
													</span>
													<span class="navi-text">New Group</span>
												</a>
											</li>
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-list-3"></i>
													</span>
													<span class="navi-text">Contacts</span>
												</a>
											</li>
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-rocket-1"></i>
													</span>
													<span class="navi-text">Groups</span>
													<span class="navi-link-badge">
														<span class="label label-light-primary label-inline font-weight-bold">new</span>
													</span>
												</a>
											</li>
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-bell-2"></i>
													</span>
													<span class="navi-text">Calls</span>
												</a>
											</li>
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-gear"></i>
													</span>
													<span class="navi-text">Settings</span>
												</a>
											</li>
											<li class="navi-separator my-3"></li>
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-magnifier-tool"></i>
													</span>
													<span class="navi-text">Help</span>
												</a>
											</li>
											<li class="navi-item">
												<a href="#" class="navi-link">
													<span class="navi-icon">
														<i class="flaticon2-bell-2"></i>
													</span>
													<span class="navi-text">Privacy</span>
													<span class="navi-link-badge">
														<span class="label label-light-danger label-rounded font-weight-bold">5</span>
													</span>
												</a>
											</li>
										</ul>
									</div>
								</div>
							</div> -->
							<!--end::Toolbar-->
							<!--begin::User-->
							<div class="d-flex align-items-center">
								<div class="symbol symbol-60 symbol-xxl-100 mr-5 align-self-start align-self-xxl-center">
									@if(session()->get('online_user')['photo'])
									<div class="symbol-label" style="background-image:url('{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}')"></div>
									@else
									<div class="symbol-label" style="background-image:url('{{url('/online/assets/media/avatars/blank.png')}}')"></div>
									@endif
									<i class="symbol-badge bg-success"></i>
								</div>
								<div>
									<a href="#" class="font-weight-bolder font-size-h5 text-dark-75 text-hover-primary">{{session()->get('online_user')['name']}} {{session()->get('online_user')['last_name']}}</a>
									<div class="text-muted">{{session()->get('online_user')['email']}}</div>
									<div class="mt-2">
										<a href="{{route('online.logout')}}" class="btn btn-sm btn-primary font-weight-bold mr-2 py-2 px-3 px-xxl-5 my-1">@lang('layout.Out')</a>
										<!-- <a href="#" class="btn btn-sm btn-success font-weight-bold py-2 px-3 px-xxl-5 my-1">Follow</a> -->
									</div>
								</div>
							</div>
							<!--end::User-->
							<!--begin::Contact-->
							<div class="py-9">
								<!-- <div class="d-flex align-items-center justify-content-between mb-2">
									<span class="font-weight-bold mr-2">Email:</span>
									<a href="#" class="text-muted text-hover-primary">matt@fifestudios.com</a>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-2">
									<span class="font-weight-bold mr-2">Phone:</span>
									<span class="text-muted">44(76)34254578</span>
								</div>
								<div class="d-flex align-items-center justify-content-between">
									<span class="font-weight-bold mr-2">Location:</span>
									<span class="text-muted">Melbourne</span>
								</div> -->
							</div>
							<!--end::Contact-->
							<!--begin::Nav-->
							<div class="navi navi-bold navi-hover navi-active navi-link-rounded">
								<div class="navi-item mb-2">
									<a href="{{route('online.users.show',session()->get('online_user')['id'])}}" class="navi-link py-4 active">
										<span class="navi-icon mr-2">
											<span class="svg-icon">
												<!--begin::Svg Icon | path:/metronic/theme/html/demo1/dist/assets/media/svg/icons/Design/Layers.svg-->
												<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
													<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
														<polygon points="0 0 24 0 24 24 0 24" />
														<path d="M12.9336061,16.072447 L19.36,10.9564761 L19.5181585,10.8312381 C20.1676248,10.3169571 20.2772143,9.3735535 19.7629333,8.72408713 C19.6917232,8.63415859 19.6104327,8.55269514 19.5206557,8.48129411 L12.9336854,3.24257445 C12.3871201,2.80788259 11.6128799,2.80788259 11.0663146,3.24257445 L4.47482784,8.48488609 C3.82645598,9.00054628 3.71887192,9.94418071 4.23453211,10.5925526 C4.30500305,10.6811601 4.38527899,10.7615046 4.47382636,10.8320511 L4.63,10.9564761 L11.0659024,16.0730648 C11.6126744,16.5077525 12.3871218,16.5074963 12.9336061,16.072447 Z" fill="#000000" fill-rule="nonzero" />
														<path d="M11.0563554,18.6706981 L5.33593024,14.122919 C4.94553994,13.8125559 4.37746707,13.8774308 4.06710397,14.2678211 C4.06471678,14.2708238 4.06234874,14.2738418 4.06,14.2768747 L4.06,14.2768747 C3.75257288,14.6738539 3.82516916,15.244888 4.22214834,15.5523151 C4.22358765,15.5534297 4.2250303,15.55454 4.22647627,15.555646 L11.0872776,20.8031356 C11.6250734,21.2144692 12.371757,21.2145375 12.909628,20.8033023 L19.7677785,15.559828 C20.1693192,15.2528257 20.2459576,14.6784381 19.9389553,14.2768974 C19.9376429,14.2751809 19.9363245,14.2734691 19.935,14.2717619 L19.935,14.2717619 C19.6266937,13.8743807 19.0546209,13.8021712 18.6572397,14.1104775 C18.654352,14.112718 18.6514778,14.1149757 18.6486172,14.1172508 L12.9235044,18.6705218 C12.377022,19.1051477 11.6029199,19.1052208 11.0563554,18.6706981 Z" fill="#000000" opacity="0.3" />
													</g>
												</svg>
												<!--end::Svg Icon-->
											</span>
										</span>
										<span class="navi-text font-size-lg">@lang('layout.MyProfile')</span>
									</a>
								</div>
								<div class="navi-item mb-2">
									<a href="{{route('online.personal.information',session()->get('online_user')['id'])}}" class="navi-link py-4">
										<span class="navi-icon mr-2">
											<span class="svg-icon">
												<!--begin::Svg Icon | path:/metronic/theme/html/demo1/dist/assets/media/svg/icons/General/User.svg-->
												<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
													<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
														<polygon points="0 0 24 0 24 24 0 24" />
														<path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
														<path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#000000" fill-rule="nonzero" />
													</g>
												</svg>
												<!--end::Svg Icon-->
											</span>
										</span>
										<span class="navi-text font-size-lg">@lang('layout.PersonalInfo')</span>
									</a>
								</div>
								<!-- <div class="navi-item mb-2">
									<a href="{{route('online.personal.information',session()->get('online_user')['id'])}}" class="navi-link py-4">
										<span class="navi-icon mr-2">
											<span class="svg-icon">
												<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
													<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
														<rect x="0" y="0" width="24" height="24" />
														<path d="M12,4.56204994 L7.76822128,9.6401844 C7.4146572,10.0644613 6.7840925,10.1217854 6.3598156,9.76822128 C5.9355387,9.4146572 5.87821464,8.7840925 6.23177872,8.3598156 L11.2317787,2.3598156 C11.6315738,1.88006147 12.3684262,1.88006147 12.7682213,2.3598156 L17.7682213,8.3598156 C18.1217854,8.7840925 18.0644613,9.4146572 17.6401844,9.76822128 C17.2159075,10.1217854 16.5853428,10.0644613 16.2317787,9.6401844 L12,4.56204994 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
														<path d="M3.5,9 L20.5,9 C21.0522847,9 21.5,9.44771525 21.5,10 C21.5,10.132026 21.4738562,10.2627452 21.4230769,10.3846154 L17.7692308,19.1538462 C17.3034221,20.271787 16.2111026,21 15,21 L9,21 C7.78889745,21 6.6965779,20.271787 6.23076923,19.1538462 L2.57692308,10.3846154 C2.36450587,9.87481408 2.60558331,9.28934029 3.11538462,9.07692308 C3.23725479,9.02614384 3.36797398,9 3.5,9 Z M12,17 C13.1045695,17 14,16.1045695 14,15 C14,13.8954305 13.1045695,13 12,13 C10.8954305,13 10,13.8954305 10,15 C10,16.1045695 10.8954305,17 12,17 Z" fill="#000000" />
													</g>
												</svg>
											</span>
										</span>
										<span class="navi-text font-size-lg">@lang('layout.OrdersList')</span>
									</a>
								</div> -->
							</div>
							<!--end::Nav-->
						</div>
						<!--end::Body-->
					</div>
					<!--end::Profile Card-->
				</div>
				<!--end::Aside-->
				<!--begin::Content-->
				<div class="flex-row-fluid ml-lg-10">
					<!--begin::Row-->
					<div class="row">
						<div class="col-lg-12">
							<!--begin::List Widget 14-->
							<div class="card card-custom card-stretch gutter-b">
								<!--begin::Header-->
								<div class="card-header border-0">
									<h3 class="card-title font-weight-bolder text-dark">@lang('layout.OrdersList')</h3>
								</div>
								<!--end::Header-->
								<!--begin::Body-->
								<div class="card-body pt-2">
									<?php 
									$total = 0;
									$currency = null;
									 ?>
									@if($last_order)
									@foreach($last_order AS $record)
									<?php 
									$total += ($record->price * $record->quantity);
									$currency = $record->currency;
									?>
									<!--begin::Item-->
									<div class="d-flex flex-wrap align-items-center mb-10">
										<!--begin::Symbol-->
										<div class="symbol symbol-60 symbol-2by3 flex-shrink-0 mr-4">
											<div class="symbol-label" style="background-image: url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}')"></div>
										</div>
										<!--end::Symbol-->
										<!--begin::Title-->
										<div class="d-flex flex-column flex-grow-1 my-lg-0 my-2 pr-3">
											<a href="#" class="text-dark-75 font-weight-bolder text-hover-primary font-size-lg">{{$record->name}}</a>
											<span class="text-muted font-weight-bold font-size-sm my-1">{{$record->description}}</span>
											<span class="text-muted font-weight-bold font-size-sm">@lang('layout.Quantity'): 
											<span class="text-primary font-weight-bold">{{$record->quantity}}</span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
											<span class="text-muted font-weight-bold font-size-sm">@lang('layout.Price'): 
											<span class="text-primary font-weight-bold">{{$record->price}}  {{$record->currency}}</span></span>
										</div>
										<!--end::Title-->
										<!--begin::Info-->
										<div class="d-flex align-items-center py-lg-0 py-2">
											<div class="d-flex flex-column text-right">
												<span class="text-dark-75 font-weight-bolder font-size-h4">{{round(($record->price * $record->quantity),2)}}</span>
												<span class="text-muted font-size-sm font-weight-bolder">{{$record->currency}}</span>
											</div>
										</div>
										<!--end::Info-->
									</div>
									<!--end::Item-->
									@endforeach 
									@endif
									<!--begin::Purchase-->
									<div class="offcanvas-footer">
										<div class="d-flex align-items-center justify-content-between m-2">
											<span class="font-weight-bold text-muted font-size-sm mr-2">@lang('layout.Total')</span>
											<span class="font-weight-bolder text-dark-50 text-right"> {{$total}}  {{$currency}} </span>
										</div>
										<div class="text-right mt-10">
											<a href="{{route('online.ItemOrderDetails',$user->id)}}" class="btn btn-primary text-weight-bold">@lang('layout.Submit')</a>
										</div>
									</div>
									<!--end::Purchase-->
								</div>
								<!--end::Body-->
							</div>
							<!--end::List Widget 14-->
						</div>
					</div>
					<!--end::Row-->
					<!--begin::Card-->
					<div class="card card-custom">
						<div class="card-header">
							<div class="card-title">
								<span class="card-icon">
									<i class="flaticon-notepad text-primary"></i>
								</span>
								<h3 class="card-label">@lang('layout.AcceptedOrders')</h3>
							</div>
							<div class="card-toolbar">
								<!--begin::Dropdown-->
								<!--end::Dropdown-->
								<!--begin::Button-->
								<!-- <a href="#" class="btn btn-primary font-weight-bolder">
								<span class="svg-icon svg-icon-md">
									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
										<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
											<rect x="0" y="0" width="24" height="24" />
											<circle fill="#000000" cx="9" cy="15" r="6" />
											<path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
										</g>
									</svg>
								</span>New Record</a> -->
								<div class="btn btn-icon btn-clean btn-lg mr-1 pulse pulse-success">
									<i class="icon-2x text-dark-50 flaticon-alarm"></i>
									<span class="pulse-ring"></span>
								</div>
								<!--end::Button-->
							</div>
						</div>
						<div class="card-body">
							<!--begin: Datatable-->
							<table class="table table-bordered table-hover table-checkable" id="accepted_order_list" style="margin-top: 13px !important">
								<thead>
									<tr>
										<th class="sorting">@lang('layout.Number')</th>
										<th class="sorting ">@lang('layout.Date')</th>
										<th class="sorting">@lang('layout.Currency')</th>
										<th class="sorting_disabled ">@lang('layout.Amount')</th>
										<th class="sorting_disabled ">@lang('layout.DeliveryDate')</th>
										<th class="sorting_disabled ">@lang('layout.Status')</th>
										<th class="sorting_disabled ">@lang('layout.Actions')</th>
									</tr>
								</thead>
							</table>
							<!--end: Datatable-->
						</div>
					</div>
					<!--end::Card-->
					<!--begin::Card-->
					<div class="card card-custom">
						<div class="card-header">
							<div class="card-title">
								<span class="card-icon">
									<i class="flaticon-notepad text-primary"></i>
								</span>
								<h3 class="card-label">@lang('layout.AllOrders')</h3>
							</div>
							<div class="card-toolbar">
								<!--begin::Dropdown-->
								<!--end::Dropdown-->
								<!--begin::Button-->
								<!-- <a href="#" class="btn btn-primary font-weight-bolder">
								<span class="svg-icon svg-icon-md">
									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
										<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
											<rect x="0" y="0" width="24" height="24" />
											<circle fill="#000000" cx="9" cy="15" r="6" />
											<path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
										</g>
									</svg>
								</span>New Record</a> -->
								<!--end::Button-->
							</div>
						</div>
						<div class="card-body">
							<!--begin: Datatable-->
							<table class="table table-bordered table-hover table-checkable" id="order_list" style="margin-top: 13px !important">
								<thead>
									<tr>
										<th class="sorting">@lang('layout.Number')</th>
										<th class="sorting ">@lang('layout.Date')</th>
										<th class="sorting">@lang('layout.Currency')</th>
										<th class="sorting_disabled ">@lang('layout.Amount')</th>
										<th class="sorting_disabled ">@lang('layout.DeliveryDate')</th>
										<th class="sorting_disabled ">@lang('layout.Status')</th>
										<th class="sorting_disabled ">@lang('layout.Actions')</th>
									</tr>
								</thead>
							</table>
							<!--end: Datatable-->
						</div>
					</div>
					<!--end::Card-->
				</div>
				<!--end::Content-->
			</div>
			<!--end::Profile Overview-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Entry-->
</div>
<!--end::Content-->

@endsection

@push('scripts')

<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->

    <script type="text/javascript">

		@if(App::getLocale())
		Vue.use(VeeValidate, {
			locale: '{{App::getLocale()}}',
		});
		@else
		Vue.use(VeeValidate, {
			locale: 'en',
		});
		@endif
		
        let data_table;

     $(document).ready(function() { 
		// $.fn.dataTable.ext.errMode='none';
       	data_table = $('#order_list').DataTable( {
			ajax: {
				url: '{{route("online.users.show",$user->id)}}',
				data: {type: 'all'}
			},
            pageLength:'10',
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
            pagingType:'full_numbers',
			order: [["0", "desc"]],
            responsive:true,
            columns: [
            { data: 'number', name: 'number' },
            { data: 'date', name: 'date'},
            { data: 'currency', name: 'currency'},
            { data: 'amount', name: 'amount',orderable:false,searchable:false },
            { data: 'delivery_date', name: 'delivery_date',orderable:false,searchable:false },
            { data: 'status', name: 'status',orderable:false,searchable:false },
            { data: 'action', name: 'action' ,orderable:false,searchable:false },
  
            ] 
    }); 
    });		

    let data_table1;

     $(document).ready(function() { 
		// $.fn.dataTable.ext.errMode='none';
       	data_table1 = $('#accepted_order_list').DataTable( {
            ajax: {
				url: '{{route("online.users.show",$user->id)}}',
				data: {type: 'accept'}
			},
            pageLength:'10',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            pagingType:'full_numbers',
			order: [["0", "desc"]],
            responsive:true,
            columns: [
            { data: 'number', name: 'number' },
            { data: 'date', name: 'date'},
            { data: 'currency', name: 'currency'},
            { data: 'amount', name: 'amount',orderable:false,searchable:false },
            { data: 'delivery_date', name: 'delivery_date'},
            { data: 'status', name: 'status',orderable:false,searchable:false },
            { data: 'action', name: 'action' ,orderable:false,searchable:false },
  
            ] 
    }); 
    });
		
	</script>
@endpush