@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-right">
                @permission('user-create')
                <a class="btn btn-success" href="{{ route('users.create') }}"> @lang('layout.CreateNewUser') <i
                            class="fa fa-plus-circle"></i></a>
                @endpermission
            </div>
        </div>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.UserList')  </span>
                </div>
                <div class="tools"></div>

            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="usertable">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Email')</th>
                        <th>@lang('layout.ResetPasswordEmail')</th>
                        <th>@lang('layout.Role')</th>
            
                        <th>@lang('layout.UserType')</th>
                        <th>@lang('layout.Language')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            data_table = $('#usertable').DataTable({
                ajax: '{{route("users.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'reset_password_email', name: 'reset_password_email'},
                    {data: 'display_name', name: 'display_name', orderable: false, searchable: false},
                    {data: 'user_type', name: 'user_type', orderable: false, searchable: false},
                    {data: 'lang', name: 'lang', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                   if(typeof data_table =='object')
                   {
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush