<!DOCTYPE html>

<html lang="{{ config('app.locale') }}" dir={{(App::isLocale('en'))?"ltr":"rtl"}} direction="{{(App::isLocale('en'))?'ltr':'rtl'}}" style="direction:{{(App::isLocale('en'))?'ltr':'rtl'}};">

<!-- BEGIN HEAD -->

<head>

    <meta charset="utf-8" />
	<!-- <title>CAS</title> -->
	
	@if(session()->get('online_system_config'))
    <link rel="shortcut icon" href="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" />
    @else
    <link rel="shortcut icon" href="{{url('/online/assets/logo/logo1.png')}}" />
    @endif

    <meta name="description" content="Create by CHACO" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta content="Azizullah Habibi" name="author" />
    <meta id="token" name="csrf-token" content="{{ csrf_token() }}">
    <meta id="token" name="token" value="{{ csrf_token() }}">
    <link rel="shortcut icon" href="{{url('/online/assets/logo/logo.png')}}" />

    <!--begin::Global Stylesheets Bundle(used by all pages)-->
    @if(App::isLocale('en'))
    <link href="{{url('/online/assets/plugins/global/plugins.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/online/assets/css/style.bundle.css')}}" rel="stylesheet" type="text/css" />
    @else
    <link href="{{url('/online/assets/plugins/global/plugins.bundle.rtl.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/online/assets/css/style.bundle.rtl.css')}}" rel="stylesheet" type="text/css" />
    @endif
    <!--end::Global Stylesheets Bundle-->

    <!-- END HEAD -->
</head>

<body id="kt_body" class="bg-white">

    <!--begin::Main-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Authentication - Sign-up -->
			<div class="d-flex flex-column flex-column-fluid bgi-position-y-bottom position-x-center bgi-no-repeat bgi-size-contain bgi-attachment-fixed" style="background-image: url({{url('/online/assets/media/illustrations/progress-hd.png')}})">
				<!--begin::Content-->
				<div class="d-flex flex-center flex-column flex-column-fluid p-10 pb-lg-20">
					<!--begin::Logo-->
					<a href="{{route('/')}}" class="mb-12">
						@if(session()->get('online_system_config'))
						<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo}}" class="h-45px" />
						@else
						<img alt="Logo" src="{{url('/online/assets/logo/logoA1.png')}}" class="h-45px" />
						@endif
                    </a>
					<!--end::Logo-->
					<!--begin::Wrapper-->
					<div class="w-lg-600px bg-white rounded shadow-sm p-10 p-lg-15 mx-auto">
						<!--begin::Form-->
                        {{Form::open(['route' => 'online.users.store','method' => 'POST','class' => 'form w-100','id'=>'kt_sign_up_form'])}}
                        {{ csrf_field() }}
							<!--begin::Heading-->
							<div class="mb-10 text-center">
								<!--begin::Title-->
								<h1 class="text-dark mb-3">@lang('layout.CreatenewAccount')</h1>
								<!--end::Title-->
                                <!--begin::Link-->
                                <div class="text-gray-400 fw-bold fs-4">@lang('layout.AlreadyHaveAnAccount') 
                                <a href="{{route('online.login')}}" class="link-primary fw-bolder">@lang('layout.SignIn')</a></div>
								<!--end::Link-->
							</div>
							<!--end::Heading-->
							<!--begin::Input group-->
							<div class="row fv-row mb-7">
								<!--begin::Col-->
								<div class="col-xl-6">
									<label class="form-label fw-bolder text-dark fs-6">@lang('layout.Name')</label>
                                    <input class="form-control form-control-lg form-control-solid" type="text" placeholder="" name="fname" autocomplete="off" />
                                    @if ($errors->has('fname'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fname') }}</strong>
                                    </span>
                                    @endif
								</div>
								<!--end::Col-->
								<!--begin::Col-->
								<div class="col-xl-6">
									<label class="form-label fw-bolder text-dark fs-6">@lang('layout.LastName')</label>
									<input class="form-control form-control-lg form-control-solid" type="text" placeholder="" name="lname" autocomplete="off" />
								</div>
								<!--end::Col-->
							</div>
							<!--end::Input group-->
							<!--begin::Input group-->
							<div class="fv-row mb-7">
                                <label class="form-label fs-6 fw-bolder text-dark">@lang('layout.Email')</label>
                                <!--end::Label-->
                                <!--begin::Input-->
                                <input id="email" type="email" class="form-control form-control-lg form-control-solid" name="email" value="{{ old('email') }}" required autofocus autocomplete="off">
                                @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                                @endif
							</div>
							<!--end::Input group-->
							<!--begin::Input group-->
							<div class="mb-10 fv-row" data-kt-password-meter="true">
								<!--begin::Wrapper-->
								<div class="mb-1">
									<!--begin::Label-->
									<label class="form-label fw-bolder text-dark fs-6">@lang('layout.Password')</label>
									<!--end::Label-->
									<!--begin::Input wrapper-->
									<div class="position-relative mb-3">
                                        <input type="password" autocomplete="off" class="form-control form-control-lg form-control-solid" name="password" required>
                                        @if ($errors->has('password'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('password') }}</strong>
                                        </span>
                                        @endif

										<span class="btn btn-sm btn-icon position-absolute translate-middle top-50 end-0 me-n2" data-kt-password-meter-control="visibility">
											<i class="fas fa-eye-slash fs-2"></i>
											<i class="fas fa-eye fs-2 d-none"></i>
										</span>
									</div>
									<!--end::Input wrapper-->
									<!--begin::Meter-->
									<div class="d-flex align-items-center mb-3" data-kt-password-meter-control="highlight">
										<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
										<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
										<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px me-2"></div>
										<div class="flex-grow-1 bg-secondary bg-active-success rounded h-5px"></div>
									</div>
									<!--end::Meter-->
								</div>
								<!--end::Wrapper-->
								<!--begin::Hint-->
								<div class="text-muted">Use 8 or more characters with a mix of letters, numbers &amp; symbols.</div>
								<!--end::Hint-->
							</div>
							<!--end::Input group=-->
							<!--begin::Input group-->
							<div class="fv-row mb-5">
								<label class="form-label fw-bolder text-dark fs-6">@lang('layout.ConfirmPassword')</label>
								<input class="form-control form-control-lg form-control-solid" type="password" placeholder="" name="confirm-password" autocomplete="off" />
							</div>
							<!--end::Input group-->
							<!--begin::Input group-->
							<!-- <div class="fv-row mb-10">
								<label class="form-check form-check-custom form-check-solid form-check-inline">
									<input class="form-check-input" type="checkbox" name="toc" value="1" />
									<span class="form-check-label fw-bold text-gray-700 fs-6">I Agree 
									<a href="#" class="ms-1 link-primary">Terms and conditions</a>.</span>
								</label>
							</div> -->
							<!--end::Input group-->
							<!--begin::Actions-->
							<div class="text-center">
                            <input class="btn btn-lg btn-primary " type="submit" value="@lang('layout.Submit')" />
								<!-- <button type="button" id="kt_sign_up_submit" class="btn btn-lg btn-primary">
									<span class="indicator-label">Submit</span>
									<span class="indicator-progress">Please wait... 
									<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
								</button> -->
							</div>
							<!--end::Actions-->
                        {!! Form::close() !!}
						<!--end::Form-->
					</div>
					<!--end::Wrapper-->
				</div>
				<!--end::Content-->
			</div>
			<!--end::Authentication - Sign-up-->
		</div>
		<!--end::Main-->
    <!-- BEGIN COPYRIGHT -->
    <div class="copyright">&copy; Copyright 2021 C.A.S System - by CH.A CO.</div>
    <!-- END COPYRIGHT -->
    <!--[if lt IE 9]-->

    <!--begin::Global Javascript Bundle(used by all pages)-->
    <script src="{{url('/online/assets/plugins/global/plugins.bundle.js')}}" type="text/javascript"></script>
    <script src="{{url('/online/assets/js/scripts.bundle.js')}}" type="text/javascript"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{url('/online/assets/js/custom/authentication/sign-in/general.js')}}" type="text/javascript"></script>
    <!--end::Page Custom Javascript-->

</body>

</html>