<!DOCTYPE html>

<html lang="{{ config('app.locale') }}" dir={{(App::isLocale('en'))?"ltr":"rtl"}} direction="{{(App::isLocale('en'))?'ltr':'rtl'}}" style="direction:{{(App::isLocale('en'))?'ltr':'rtl'}};">

<head>
@yield('styles')

<!-- BEGIN HEAD -->
@include('online.layouts.admin.includes_back')
<!-- END HEAD -->
<style type="text/css">

    .goog-te-banner-frame {display: none !important ;margin-top:-20px;}
	.translated-ltr{margin-top:-40px;}
	.translated-ltr{margin-top:-40px;}
	
	.goog-logo-link {
	   display:none !important;
	} 

	.goog-te-gadget{
	   color: transparent !important;
	}

    .goog-te-gadget{
        height: 0px !important;
        margin-bottom: 30px !important;
	}

	.goog-te-combo{
	   height: 25px !important;
	   width: 75px !important;
	}

</style>
</head>
<!--begin::Body-->
<?php
$aside = false;
?>
<body id="kt_body" class="header-fixed header-mobile-fixed  @if($aside) aside-enabled aside-fixed aside-minimize-hoverable @endif page-loading" >
    
	<!--begin::Main-->
		<!--begin::Header Mobile-->
		<div id="kt_header_mobile" class="header-mobile align-items-center header-mobile-fixed">
			<!--begin::Logo-->
			<a href="{{route('/')}}">
                @if(session()->get('online_system_config'))
                <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="h-30px" />
                @else
				<img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="h-30px" />
                @endif
			</a>
			<!--end::Logo-->
			<!--begin::Toolbar-->
			<div class="d-flex align-items-center">
				<!--begin::Aside Mobile Toggle-->
				@if($aside)
				<button class="btn p-0 burger-icon burger-icon-left" id="kt_aside_mobile_toggle">
					<span></span>
				</button>
				@endif
				<!--end::Aside Mobile Toggle-->
				<!--begin::Header Menu Mobile Toggle-->
				<button class="btn p-0 burger-icon ml-4" id="kt_header_mobile_toggle">
					<span></span>
				</button>
				<!--end::Header Menu Mobile Toggle-->
				<!--begin::Topbar Mobile Toggle-->
				<button class="btn btn-hover-text-primary p-0 ml-2" id="kt_header_mobile_topbar_toggle">
					<span class="svg-icon svg-icon-xl">
						<!--begin::Svg Icon | path:/metronic/theme/html/demo1/dist/online/assets/media/svg/icons/General/User.svg-->
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
							<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
								<polygon points="0 0 24 0 24 24 0 24" />
								<path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
								<path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#000000" fill-rule="nonzero" />
							</g>
						</svg>
						<!--end::Svg Icon-->
					</span>
				</button>
				<!--end::Topbar Mobile Toggle-->
			</div>
			<!--end::Toolbar-->
		</div>
		<!--end::Header Mobile-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Page-->
			<div class="d-flex flex-row flex-column-fluid page">
				<!--begin::Aside-->
				@if($aside)
				@include('online.layouts.admin.sidebar')
				@endif
				<!--end::Aside-->
				<!--begin::Wrapper-->
				<div class="d-flex flex-column flex-row-fluid wrapper" id="kt_wrapper">
					<!--begin::Header-->
					@include('online.layouts.admin.header_back')
					<!--end::Header-->
					<!--begin::Content-->
					@yield('content')
					<!--end::Content-->
					<!--begin::Footer-->
					@include('online.layouts.admin.footer_back')
					<!--end::Footer-->
				</div>
				<!--end::Wrapper-->
			</div>
			<!--end::Page-->
		</div>
		<!--end::Main-->
	
	<!--begin::panel-->
	@include('online.layouts.admin.panel_back')
	<!--end::panel-->
    
	<!--begin::Scrolltop-->
	<div id="kt_scrolltop" class="scrolltop">
		<span class="svg-icon">
			<!--begin::Svg Icon | path:/metronic/theme/html/demo1/dist/online/assets/media/svg/icons/Navigation/Up-2.svg-->
			<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
				<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<polygon points="0 0 24 0 24 24 0 24" />
					<rect fill="#000000" opacity="0.3" x="11" y="10" width="2" height="10" rx="1" />
					<path d="M6.70710678,12.7071068 C6.31658249,13.0976311 5.68341751,13.0976311 5.29289322,12.7071068 C4.90236893,12.3165825 4.90236893,11.6834175 5.29289322,11.2928932 L11.2928932,5.29289322 C11.6714722,4.91431428 12.2810586,4.90106866 12.6757246,5.26284586 L18.6757246,10.7628459 C19.0828436,11.1360383 19.1103465,11.7686056 18.7371541,12.1757246 C18.3639617,12.5828436 17.7313944,12.6103465 17.3242754,12.2371541 L12.0300757,7.38413782 L6.70710678,12.7071068 Z" fill="#000000" fill-rule="nonzero" />
				</g>
			</svg>
			<!--end::Svg Icon-->
		</span>
	</div>
	<!--end::Scrolltop-->
    
    <!--begin::Javascript-->
	
	<!--begin::Global Config(global config for global JS scripts)-->
	<script>var KTAppSettings = { "breakpoints": { "sm": 576, "md": 768, "lg": 992, "xl": 1200, "xxl": 1400 }, "colors": { "theme": { "base": { "white": "#ffffff", "primary": "#3699FF", "secondary": "#E5EAEE", "success": "#1BC5BD", "info": "#8950FC", "warning": "#FFA800", "danger": "#F64E60", "light": "#E4E6EF", "dark": "#181C32" }, "light": { "white": "#ffffff", "primary": "#E1F0FF", "secondary": "#EBEDF3", "success": "#C9F7F5", "info": "#EEE5FF", "warning": "#FFF4DE", "danger": "#FFE2E5", "light": "#F3F6F9", "dark": "#D6D6E0" }, "inverse": { "white": "#ffffff", "primary": "#ffffff", "secondary": "#3F4254", "success": "#ffffff", "info": "#ffffff", "warning": "#ffffff", "danger": "#ffffff", "light": "#464E5F", "dark": "#ffffff" } }, "gray": { "gray-100": "#F3F6F9", "gray-200": "#EBEDF3", "gray-300": "#E4E6EF", "gray-400": "#D1D3E0", "gray-500": "#B5B5C3", "gray-600": "#7E8299", "gray-700": "#5E6278", "gray-800": "#3F4254", "gray-900": "#181C32" } }, "font-family": "Poppins" };</script>
	<!--end::Global Config-->
    
    <!--begin::Global Theme Bundle(used by all pages)-->
	<script src="{{url('/online/assets-v7/plugins/global/plugins.bundle.js')}}"></script>
	<script src="{{url('/online/assets-v7/plugins/custom/prismjs/prismjs.bundle.js')}}"></script>
	<script src="{{url('/online/assets-v7/js/scripts.bundle.js')}}"></script>
	<!--end::Global Theme Bundle-->
	<!-- <script src="{{url('/online/assets/js/scripts.bundle.js')}}" type="text/javascript"></script> -->
	
    <!--begin::Vuejs-->
    <!-- <script src="{{url('/vuejs/vue.min.v2.6.12.js')}}"></script> -->
    <script src="{{url('/vue/select2/vue-select.js')}}"></script>

    
    <script src="{{url('/vuejs/vee-validate.min.v2.1.7.js')}}"></script>

    @if(App::isLocale('en'))
        <script src="{{url('/vuejs/vee_validate_locale/en.js')}}"></script>
    @else
        <script src="{{url('/vuejs/vee_validate_locale/fa.js')}}"></script>
        <!-- <script src="{{url('/vuejs/vee_validate_locale/pa.js')}}"></script> -->
    @endif

    <!--end:: Vuejs -->

    <!--begin::Page Vendors(used by this page)-->
    <script src="{{url('/online/assets-v7/plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->
    <!--begin::Page Scripts(used by this page)-->
    <!-- <script src="{{url('/online/assets-v7/js/pages/crud/datatables/data-sources/javascript.js')}}"></script> -->
    <!--end::Page Scripts-->

    <!--begin::Page Scripts(used by this page)-->
    <script src="{{url('/online/assets-v7/js/pages/features/miscellaneous/sweetalert2.js')}}"></script>

    <script src="{{url('/online/datePicker/persian-date.js')}}"></script>
    <script src="{{url('/online/datePicker/persian-datepicker.js')}}"></script>
    <!--end::Page Scripts-->

    <!--end::Javascript-->


    <script type="text/javascript">

        // chat part

        $(document).ready(function () {
            function e (e) {
                var t = e.querySelector('[data-kt-element="messages"]'),
                    n = e.querySelector('[data-kt-element="input"]');
                if (0 !== n.value.length) {
                    send_message (n,t);
                }
            };

            
            var t = document.querySelector("#kt_drawer_chat_messenger");
            KTUtil.on(t, '[data-kt-element="input"]', "keydown", (function (n) {
                            if (13 == n.keyCode) return e(t), n.preventDefault(), !1
            })), KTUtil.on(t, '[data-kt-element="send"]', "click", (function (n) {
                e(t);
            }))
            // var c = document.querySelector("#kt_chat_modal");
            // setTimeout((function () {
            //     KTLayoutChat.init(c);
            // }), 2000)

        });

        function send_message (n,t){
            // console.log(12,n);
            if (n.value != null) {
                $.ajax({
                    type: 'GET',
                    url: "{{url('sendMessage')}}/",
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    data:{message:n.value},
                    success: function (result) {
                        messageLisVue.getMessageList(result.session_id);
                        n.value = "";
                        // toastr.success('', result.message);
                        // orderLisVue.getOrderList(user_id, session_id);
                        // table.ajax.reload();
                        // console.log(999,result.count);
                        // location.reload();
                        // return true;
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // return false;
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            }
        } 
        // chat part

        var user_id = null;
        var session_id = null;

        @if(session()->has('online_user'))
            user_id = {{session()->get('online_user')['id']}};
        @endif

        @if(session()->has('online_session'))
            session_id = {{session()->get('online_session')}};
        @endif
        
        var uploadUser = "{{url('/uploads/online_users/')}}";
        var blank = "{{url('/online/assets/media/avatars/blank.png')}}";

        // chat refresh

        function getMessageAllList() {
            messageLisVue.getMessageList(session_id);
            v_alert.message_id = messageLisVue.message_id;
        }
        function getMessagePerTime() {
            setTimeout((function () {
                if (v_alert.message_id == 0) {
                    v_alert.message_id = messageLisVue.message_id;
                }
                getLastMessage();
                // console.log(120, v_alert.message_id);
            }), 4e4)
        }
        function getLastMessage() {
            $.ajax({
                type: 'GET',
                url: "{{route('onlineMessage.last')}}",
                data:{id:v_alert.message_id, session_id:session_id},
                success: function (result) {
                    if (result.count > 0) {
                        v_alert.last_message_id = result.id;
                    }
                    v_alert.alert = result.count;
                    // console.log(999,result.count);
                    // location.reload();
                },
                error: function (error) {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                }
            });
            getMessagePerTime();
        }

        $(document).ready(function () {
            getMessagePerTime();
        });


        // new vue for modal

        var v_alert = new Vue({
            el: '#alert_count',
            data: {
                alert: '',
                message_id: 0,
                last_message_id: session_id
            },
            methods: {
            }
        });

        // chat refresh

        // get message list
        var messageLisVue = new Vue({
            el: '#message_list_vue',
            data: {
                items: [],
                user_id: user_id,
                session_id: session_id,
                uploads: uploadUser,
                blank: blank,
                message_id: 0,
                user: "@lang('layout.You')",
                admin: "@lang('layout.UserSystem')",
            },
            computed: {
                // calculate total
                // total: function () {
                //     var sum = 0;
                //     for (var i = 0; i < this.items.length; i++) {
                //         if (this.items[i].quantity > 0 && this.items[i].price > 0) {
                //             this.currency = this.items[i].currency;
                //             sum += this.items[i].quantity * this.items[i].price;
                //         }
                //     }
                //     return myRound(sum);
                // },
                

            },
            mounted: function () {
                this.getMessageList(this.session_id);
            },
            methods:
                {
                    getMessageList(session_id) {
                        // console.log(123, session_id);
                        if (session_id != null) {
                            axios.get("{{route('online.message.list')}}", {
                                params: {
                                    session_id: session_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.message_id > 0) {
                                        messageLisVue.message_id = response.data.message_id;
                                    }
                                    if (response.data.result.length > 0) {
                                        messageLisVue.items = [];
                                        messageLisVue.items = response.data.result;
                                        setTimeout((function () {
                                            var c = document.querySelector("#kt_chat_modal");
                                            KTLayoutChat.init(c);
                                            messageLisVue.getMessagePerTime(session_id);
                                        }), 400)
                                        // console.log(222, messageLisVue.items);
                                    }else{
                                        messageLisVue.items = [];
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    getMessagePerTime(session_id) {
                        setTimeout((function () {
                            messageLisVue.getMessageList(session_id);
                            // console.log(0);
                        }), 4e4)
                    },
                }

        });
        // message list 

        /** date picker for vuejs */
		Vue.component('date_picker', {
			template: '<input class="form-control" autocomplete="off" />',
			mounted: function() {
				$(this.$el).persianDatepicker({
					initialValue: false,
					observer: true,
					format: 'YYYY/MM/DD',
					autoClose: true,
					response:true,
					initialValueType:'{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
					calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
					calendar:{
						persian:{
							locale:'en'
						}
					}
				});
			}
		})

        $.extend(true, $.fn.dataTable.defaults, {
            "language": {
                url: '{{(App::isLocale("fa") || App::isLocale("pa"))?url("/lang/fa/datatables.json"):url("/lang/en/datatables.json")}}'
            },
        });

        function changeLang (lang){
            // console.log(12,lang);
            if (lang != null) {
                $.ajax({
                    type: 'POST',
                    url: "{{url('onlineChangeLang')}}/" + lang,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        // toastr.success('', result.message);
                        // table.ajax.reload();
                        // console.log(13,result);
                        location.reload();
                    },
                    error: function (error) {
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            }
        } 

        
        function putPurchase (id){
            // console.log(12,id);
            if (id != null) {
                $.ajax({
                    type: 'POST',
                    url: "{{url('onlinePutPurchase')}}/" + id,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        toastr.success('', result.message);
                        orderLisVue.getOrderList(user_id, session_id);
                        // table.ajax.reload();
                        console.log(13,result);
                        // location.reload();
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            }
        } 


        var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";

        var searVue = new Vue({
            el: '#search_vue',
            data: {
                search_input: '',
                items: [],
                uploads: uploads,
            },
            methods:
                {
                    getSearch() {
                        // console.log(123,searVue.search_input);
                        if (searVue.search_input != null) {
                            var search = searVue.search_input;
                            axios.get("{{route('search.item')}}", {
                                params: {
                                    search: search
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.result.length > 0) {
                                        searVue.items = [];
                                        searVue.items = response.data.result;
                                        // console.log(222, searVue.items);
                                    }else{
                                        searVue.items = [];
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                },
            created: function () {

            }

        });

        // get order list
        var orderLisVue = new Vue({
            el: '#order_list_vue',
            data: {
                uploads: uploads,
                items: [],
                user_id: user_id,
                session_id: session_id,
                currency: 'USD',
            },
            computed: {

                // calculate total
                total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.items.length; i++) {
                        if (this.items[i].quantity > 0 && this.items[i].price > 0) {
                            this.currency = this.items[i].currency;
                            sum += this.items[i].quantity * this.items[i].price;
                        }
                    }
                    return myRound(sum);
                }

            },
            mounted: function () {

                this.getOrderList(this.user_id, this.session_id);
                
            },
            methods:
                {
                    getOrderList(user_id, session_id) {
                        // console.log(123,user_id ,session_id);
                        if (user_id != null || session_id != null) {
                            axios.get("{{route('online.order.user')}}", {
                                params: {
                                    user_id: user_id,
                                    session_id: session_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.result.length > 0) {
                                        orderLisVue.items = [];
                                        orderLisVue.items = response.data.result;
                                    }else{
                                        orderLisVue.items = [];
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    Order_plus(item_id, type) {
                        // console.log(123,item_id, type);
                        if (item_id != null) {
                            axios.get("{{route('online.order.plusMinus')}}", {
                                params: {
                                    item_id: item_id,
                                    type: type
                                }
                            })
                            .then(function (response) {
                                // console.log(response);
                                if (response) {
                                    orderLisVue.getOrderList(orderLisVue.user_id, orderLisVue.session_id);
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                }

        });
        // order list 

        function deleteItemAjax(element, datatableId = null) {
            var e = $(element);
            var form = e.parent('form').get(0);
            var url = $(form).get(0).action;
            var table = $(datatableId).DataTable();

            Swal.fire({
                title: "@lang('layout.AreYouSure?')",
                // text: "You wont be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "@lang('layout.Delete')",
                cancelButtonText: "@lang('layout.Cancel')",
                reverseButtons: true
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: 'DELETE',
                        url: url,
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        success: function (res) {
                            
                            Swal.fire(
                                "@lang('layout.Deleted')",
                                res.message,
                                "success"
                            )
                            // toastr.success("Are you the six fingered man?");
                            table.ajax.reload();
                        },
                        error: function (error) {
                            Swal.fire(
                                "@lang('message.Warning')",
                                error.responseJSON.message,
                                "error"
                            )
                        }
                    });
                } else if (result.dismiss === "cancel") {
                    Swal.fire(
                        "@lang('layout.Confirm')",
                        "@lang('layout.FileIsSave')",
                        "error"
                    )
                }
            });
        }  

        /** date picker for vuejs */
        // Vue.component('date_picker', {
        //     template: '<input class="form-control" autocomplete="off" />',
        //     mounted: function() {
        //         $(this.$el).persianDatepicker({
        //             initialValue: false,
        //             observer: true,
        //             format: 'YYYY/MM/DD',
        //             autoClose: true,
        //             response: true,
        //             initialValueType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
        //             calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
        //             calendar: {
        //                 persian: {
        //                     locale: 'en'
        //                 }
        //             }
        //         });
        //     }
        // })

        /** date picker for vuejs end */

        var path = window.location.pathname;
        var path1 = "/CAS/public/" + window.location.pathname.split('/CAS/public/')[1];

        path = path.trim();
        path1 = path1.trim();

        if (path.split('/').length > 1 && path != '/') {

            if (path1 == path) {
                path = "/CAS/public/" + path.split('/CAS/public/')[1];
            } else {
                path = "/" + path.split('/')[1];
            }

            var newURL = window.location.protocol + "//" + window.location.host + path;

            $(" #sidebar-menu a[href~='" + newURL + "']").parent().addClass('active')
            $(" #sidebar-menu a[href~='" + newURL + "']").parent().parent().parent().addClass('active open')

            $(" #head-menu a[href~='" + newURL + "']").parent().addClass('active')
            $(" #head-menu a[href~='" + newURL + "']").parent().parent().parent().addClass('active selected')

        } else {

            var url = window.location.protocol + "//" + window.location.host;
            $(" #sidebar-menu a[href='" + url + "']").parent().addClass('active')
        }


        $('.errors-action').each(function() {
            // $('#error-sound')[0].play();
            toastr.error($(this).find('.error-body').html(), $(this).find('.error-title').html());

        });

        $('.success-action').each(function() {

            // $('#success-sound')[0].play();
            toastr.success($(this).find('.success-body').html(), $(this).find('.success-title').html());

        });
        $('.warning-action').each(function() {

            // $('#warning-sound')[0].play();
            toastr.warning($(this).find('.warning-body').html(), $(this).find('.warning-title').html());

        });

        $('.errors-action,.success-action,.warning-action').fadeOut(4000, 'swing', function() {

            $(this).remove();
        });
        @if(App::isLocale('en'))
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "positionClass": "toast-top-right",
            "onclick": null,
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

        @else
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "positionClass": "toast-top-left",
            "onclick": null,
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
        @endif
        // $.extend(true, $.fn.dataTable.defaults, {
        //     "language": {
        //         url: '{{(App::isLocale("fa") || App::isLocale("pa"))?url("/lang/fa/datatables.json"):url("/lang/en/datatables.json")}}'
        //     },
        // });

        $(document).ready(function() {

            // setTimeout(function(){ 
                // $('#load_order').addClass('ps--active-y');
                // $('#load_order').addClass('ps--scorlling-y');
                // $('#load_order').css('height', '500px');
                // $('#load_order').css('overflow' ,'hidden');
                // $('.ps__rail-y').css('height', '300px');
                // offcanvas-wrapper mb-5 scroll-pull scroll ps ps__rtl ps--active-y
                // ps--scorlling-y
                // document.getElementById('kt_quick_cart').location.reload();
                // window.location.reload();
            // },3000);

            // console.log('wobj',window);
            // onChromeCLosed();


            var calendarType='gregorian';
            var initialValueType='gregorian';
            @if(App::isLocale('fa') || App::isLocale('pa'))
            calendarType='persian';
            initialValueType='persian';
            @endif
            // console.log('myloca','{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}');

            date = $(".date").persianDatepicker({
                initialValue: false,
                observer: true,
                // autocomplete: true,
                format: 'YYYY/MM/DD',
                autoClose: true,
                response:true,
                initialValueType:initialValueType,
    
                calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
                calendar:{
                    persian:{
                        locale:'{{(App::isLocale("fa") || App::isLocale("pa"))?"fa":"en"}}'
                    }
                }
            });

        });


        function myRound(amount = null) {
            var result = 0;

            if (amount != null) {
                result = Number.parseFloat(amount).toFixed(2);
            }
            return result;
        }

    </script>
    <!-- END THEME LAYOUT SCRIPTS -->

    <script type="text/javascript">
        function googleTranslateElementInit() {
        var tra = new google.translate.TranslateElement({pageLanguage: '{{App::getLocale()}}'}, 'google_translate_element');
        
        } 
        // console.log(12, '{{App::getLocale()}}');
    </script>

    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

    @stack('scripts')

    
</body>

</html>