<!DOCTYPE html>

<html lang="{{ config('app.locale') }}" dir={{(App::isLocale('en'))?"ltr":"rtl"}} direction="{{(App::isLocale('en'))?'ltr':'rtl'}}" style="direction:{{(App::isLocale('en'))?'ltr':'rtl'}};">

<style type="text/css">

    .goog-te-banner-frame {display: none !important ;margin-top:-20px;}
	.translated-ltr{margin-top:-40px;}
	.translated-ltr{margin-top:-40px;}

	.goog-logo-link {
	   display:none !important;
	} 

	.goog-te-gadget{
	   color: transparent !important;
	}

	.goog-te-gadget{
        height: 0px !important;
        margin-bottom: 30px !important;
	}

	.goog-te-combo{
	   height: 25px !important;
	   width: 75px !important;
	}

</style>

@yield('styles')

<!-- BEGIN HEAD -->
@include('online.layouts.admin.includes')
<!-- END HEAD -->

<!--begin::Body-->
<body id="kt_body" data-bs-spy="scroll" data-bs-target="#kt_landing_menu" data-bs-offset="200" class="bg-white position-relative">
    <!--begin::Main-->
    <div class="d-flex flex-column flex-root">

        <!-- BEGIN HEADER -->
        @include('online.layouts.admin.header')
        <!-- END HEADER -->

        <!-- BEGIN CONTENT -->
        @yield('content')
        <!-- END CONTENT -->

        <!-- BEGIN FOOTER -->
        @include('online.layouts.admin.footer')
        <!-- END FOOTER -->

        <!--begin::Scrolltop-->
			<div id="kt_scrolltop" class="scrolltop" data-kt-scrolltop="true">
				<!--begin::Svg Icon | path: icons/duotone/Navigation/Up-2.svg-->
				<span class="svg-icon">
					<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
						<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
							<polygon points="0 0 24 0 24 24 0 24" />
							<rect fill="#000000" opacity="0.5" x="11" y="10" width="2" height="10" rx="1" />
							<path d="M6.70710678,12.7071068 C6.31658249,13.0976311 5.68341751,13.0976311 5.29289322,12.7071068 C4.90236893,12.3165825 4.90236893,11.6834175 5.29289322,11.2928932 L11.2928932,5.29289322 C11.6714722,4.91431428 12.2810586,4.90106866 12.6757246,5.26284586 L18.6757246,10.7628459 C19.0828436,11.1360383 19.1103465,11.7686056 18.7371541,12.1757246 C18.3639617,12.5828436 17.7313944,12.6103465 17.3242754,12.2371541 L12.0300757,7.38413782 L6.70710678,12.7071068 Z" fill="#000000" fill-rule="nonzero" />
						</g>
					</svg>
				</span>
				<!--end::Svg Icon-->
			</div>
		<!--end::Scrolltop-->

    </div>

    <!--begin::panel-->
	@include('online.layouts.admin.panel')
	<!--end::panel-->
    
    <!--begin::Javascript-->
    <!--begin::Global Javascript Bundle(used by all pages)-->
    <script src="{{url('/online/assets/plugins/global/plugins.bundle.js')}}" type="text/javascript"></script>
    <script src="{{url('/online/assets/js/scripts.bundle.js')}}" type="text/javascript"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Page Vendors Javascript(used by this page)-->
    <script src="{{url('/online/assets/plugins/custom/fslightbox/fslightbox.bundle.js')}}" type="text/javascript"></script>
    <script src="{{url('/online/assets/plugins/custom/typedjs/typedjs.bundle.js')}}" type="text/javascript"></script>
    <!--end::Page Vendors Javascript-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <script src="{{url('/online/assets/js/custom/landing.js')}}" type="text/javascript"></script>
    <!--end::Page Custom Javascript-->
    <!--end::Javascript-->

    <!-- <script src="{{url('/online/assets/js/custom/apps/chat/chat.js')}}"></script> -->

    <script src="{{url('/vuejs/vee-validate.min.v2.1.7.js')}}"></script>
    
    @if(App::isLocale('en'))
        <script src="{{url('/vuejs/vee_validate_locale/en.js')}}"></script>
    @else
        <script src="{{url('/vuejs/vee_validate_locale/fa.js')}}"></script>
        <!-- <script src="{{url('/vuejs/vee_validate_locale/pa.js')}}"></script> -->
    @endif

    <script src="{{url('/vue/select2/vue-select.js')}}"></script>

    <script>
        // chat part
        var KTAppChat = function () {
            var e = function (e) {
                    var t = e.querySelector('[data-kt-element="messages"]'),
                        n = e.querySelector('[data-kt-element="input"]');
                    if (0 !== n.value.length) {
                        send_message (n,t);
                        // var o, a = t.querySelector('[data-kt-element="template-out"]'),
                        //     l = t.querySelector('[data-kt-element="template-in"]');
                        // (o = a.cloneNode(!0)).classList.remove("d-none"), o.querySelector('[data-kt-element="message-text"]').innerText = n.value, n.value = "", t.appendChild(o), t.scrollTop = t.scrollHeight, setTimeout((function () {
                        //     (o = l.cloneNode(!0)).classList.remove("d-none"), o.querySelector('[data-kt-element="message-text"]').innerText = "@lang('message.ThankYouForYourMessageSystemUserAnswerSoon')", t.appendChild(o), t.scrollTop = t.scrollHeight
                        // }), 2e3)
                    }
                };
            return {
                init: function (t) {
                    !
                    function (t) {
                        t && (KTUtil.on(t, '[data-kt-element="input"]', "keydown", (function (n) {
                            if (13 == n.keyCode) return e(t), n.preventDefault(), !1
                        })), KTUtil.on(t, '[data-kt-element="send"]', "click", (function (n) {
                            e(t)
                        })))
                    }(t)
                }
            }
        }();
        KTUtil.onDOMContentLoaded((function () {
            KTAppChat.init(document.querySelector("#kt_drawer_chat_messenger"))
        }));

        function send_message (n,t){
            // console.log(12,id);
            if (n.value != null) {
                $.ajax({
                    type: 'GET',
                    url: "{{url('sendMessage')}}/",
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    data:{message:n.value},
                    success: function (result) {
                        messageLisVue.getMessageList(result.session_id);
                        n.value = "";
                        // toastr.success('', result.message);
                        // orderLisVue.getOrderList(user_id, session_id);
                        // table.ajax.reload();
                        // console.log(999,result.count);
                        // location.reload();
                        // return true;
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // return false;
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            }
        } 
        // chat part


        /** date picker for vuejs */
        // Vue.component('date_picker', {
        //     template: '<input class="form-control" autocomplete="off" />',
        //     mounted: function() {
        //         $(this.$el).persianDatepicker({
        //             initialValue: false,
        //             observer: true,
        //             format: 'YYYY/MM/DD',
        //             autoClose: true,
        //             response: true,
        //             initialValueType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
        //             calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
        //             calendar: {
        //                 persian: {
        //                     locale: 'en'
        //                 }
        //             }
        //         });
        //     }
        // })

        /** date picker for vuejs end */
        var user_id = null;
        var session_id = null;
        
        @if(session()->has('online_user'))
            user_id = {{session()->get('online_user')['id']}};
        @endif

        @if(session()->has('online_session'))
            session_id = {{session()->get('online_session')}};
        @endif

        var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";

        var uploadUser = "{{url('/uploads/online_users/')}}";
        var blank = "{{url('/online/assets/media/avatars/blank.png')}}";



        // chat refresh

        function getMessageAllList() {
            messageLisVue.getMessageList(session_id);
            v_alert.message_id = messageLisVue.message_id;
        }
        function getMessagePerTime() {
            setTimeout((function () {
                if (v_alert.message_id == 0) {
                    v_alert.message_id = messageLisVue.message_id;
                }
                getLastMessage();
                // console.log(120, v_alert.message_id);
            }), 4e4)
        }
        function getLastMessage() {
            $.ajax({
                type: 'GET',
                url: "{{route('onlineMessage.last')}}",
                data:{id:v_alert.message_id, session_id:session_id},
                success: function (result) {
                    if (result.count > 0) {
                        v_alert.last_message_id = result.id;
                    }
                    v_alert.alert = result.count;
                    // console.log(999,result.count);
                    // location.reload();
                },
                error: function (error) {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                }
            });
            getMessagePerTime();
        }

        $(document).ready(function () {
            getMessagePerTime();
        });


        // new vue for modal

        var v_alert = new Vue({
            el: '#alert_count',
            data: {
                alert: '',
                message_id: 0,
                last_message_id: session_id
            },
            methods: {
            }
        });

        // chat refresh

        // get order list
        var orderLisVue = new Vue({
            el: '#order_list_vue',
            data: {
                uploads: uploads,
                items: [],
                user_id: user_id,
                session_id: session_id,
                currency: 'USD',
            },
            computed: {

                // calculate total
                total: function () {
                    var sum = 0;
                    for (var i = 0; i < this.items.length; i++) {
                        if (this.items[i].quantity > 0 && this.items[i].price > 0) {
                            this.currency = this.items[i].currency;
                            sum += this.items[i].quantity * this.items[i].price;
                        }
                    }
                    return myRound(sum);
                },
                

            },
            mounted: function () {

                this.getOrderList(this.user_id, this.session_id);

            },
            methods:
                {
                    getOrderList(user_id, session_id) {
                        // console.log(123,user_id ,session_id);
                        if (user_id != null || session_id != null) {
                            axios.get("{{route('online.order.user')}}", {
                                params: {
                                    user_id: user_id,
                                    session_id: session_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.result.length > 0) {
                                        orderLisVue.items = [];
                                        orderLisVue.items = response.data.result;
                                        // console.log(222, orderLisVue.items);
                                    }else{
                                        orderLisVue.items = [];
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    Order_plus(item_id, type) {
                        // console.log(123,item_id);
                        if (item_id != null) {
                            axios.get("{{route('online.order.plusMinus')}}", {
                                params: {
                                    item_id: item_id,
                                    type: type
                                }
                            })
                            .then(function (response) {
                                if (response) {
                                    orderLisVue.getOrderList(orderLisVue.user_id, orderLisVue.session_id);
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                }

        });
        // order list 

        // get message list
        var messageLisVue = new Vue({
            el: '#message_list_vue',
            data: {
                items: [],
                user_id: user_id,
                session_id: session_id,
                uploads: uploadUser,
                blank: blank,
                message_id: 0,
                user: "@lang('layout.You')",
                admin: "@lang('layout.UserSystem')",
            },
            computed: {
                // calculate total
                // total: function () {
                //     var sum = 0;
                //     for (var i = 0; i < this.items.length; i++) {
                //         if (this.items[i].quantity > 0 && this.items[i].price > 0) {
                //             this.currency = this.items[i].currency;
                //             sum += this.items[i].quantity * this.items[i].price;
                //         }
                //     }
                //     return myRound(sum);
                // },
                

            },
            mounted: function () {
                this.getMessageList(this.session_id);
            },
            methods:
                {
                    getMessageList(session_id) {
                        // console.log(123, session_id);
                        if (session_id != null) {
                            axios.get("{{route('online.message.list')}}", {
                                params: {
                                    session_id: session_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.message_id > 0) {
                                        messageLisVue.message_id = response.data.message_id;
                                    }
                                    if (response.data.result.length > 0) {
                                        messageLisVue.items = [];
                                        messageLisVue.items = response.data.result;
                                        setTimeout((function () {
                                            KTUtil.onDOMContentLoaded((function () {
                                                var t = document.querySelector("#kt_drawer_chat_messenger");
                                                var e = t.querySelector('[data-kt-element="messages"]');
                                                // console.log(111,e,e.scrollHeight);
                                                e.scrollTop = e.scrollHeight
                                            }));
                                            messageLisVue.getMessagePerTime(session_id);
                                        }), 400)
                                        // console.log(222, messageLisVue.items);
                                    }else{
                                        messageLisVue.items = [];
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    getMessagePerTime(session_id) {
                        setTimeout((function () {
                            messageLisVue.getMessageList(session_id);
                            // console.log(0);
                        }), 4e4)
                    },
                }

        });
        // message list 

        var path = window.location.pathname;
        var path1 = "/CAS/public/" + window.location.pathname.split('/CAS/public/')[1];

        path = path.trim();
        path1 = path1.trim();

        if (path.split('/').length > 1 && path != '/') {

            if (path1 == path) {
                path = "/CAS/public/" + path.split('/CAS/public/')[1];
            } else {
                path = "/" + path.split('/')[1];
            }

            var newURL = window.location.protocol + "//" + window.location.host + path;

            $(" #sidebar-menu a[href~='" + newURL + "']").parent().addClass('active')
            $(" #sidebar-menu a[href~='" + newURL + "']").parent().parent().parent().addClass('active open')

            $(" #head-menu a[href~='" + newURL + "']").parent().addClass('active')
            $(" #head-menu a[href~='" + newURL + "']").parent().parent().parent().addClass('active selected')

        } else {

            var url = window.location.protocol + "//" + window.location.host;
            $(" #sidebar-menu a[href='" + url + "']").parent().addClass('active')
        }


        $('.errors-action').each(function() {
            // $('#error-sound')[0].play();
            toastr.error($(this).find('.error-body').html(), $(this).find('.error-title').html());

        });

        $('.success-action').each(function() {

            // $('#success-sound')[0].play();
            toastr.success($(this).find('.success-body').html(), $(this).find('.success-title').html());

        });
        $('.warning-action').each(function() {

            // $('#warning-sound')[0].play();
            toastr.warning($(this).find('.warning-body').html(), $(this).find('.warning-title').html());

        });

        $('.errors-action,.success-action,.warning-action').fadeOut(4000, 'swing', function() {

            $(this).remove();
        });
        @if(App::isLocale('en'))
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "positionClass": "toast-top-right",
            "onclick": null,
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

        @else
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "positionClass": "toast-top-left",
            "onclick": null,
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
        @endif
        // $.extend(true, $.fn.dataTable.defaults, {
        //     "language": {
        //         url: '{{(App::isLocale("fa") || App::isLocale("pa"))?url("/lang/fa/datatables.json"):url("/lang/en/datatables.json")}}'
        //     },
        // });

        $(document).ready(function() {

            // console.log('wobj',window);
            // onChromeCLosed();


            var calendarType = 'gregorian';
            var initialValueType = 'gregorian';
            @if(App::isLocale('fa') || App::isLocale('pa'))
            calendarType = 'persian';
            initialValueType = 'persian';
            @endif
            // console.log('myloca','{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}');

            // date = $(".date").persianDatepicker({
            //     initialValue: false,
            //     observer: true,
            //     // autocomplete: true,
            //     format: 'YYYY/MM/DD',
            //     autoClose: true,
            //     response: true,
            //     initialValueType: initialValueType,

            //     calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
            //     calendar: {
            //         persian: {
            //             locale: 'en'
            //         }
            //     }


            // });


        });



        function myRound(amount = null) {
            var result = 0;

            if (amount != null) {
                result = Number.parseFloat(amount).toFixed(2);
            }
            return result;
        }
    </script>
    <script type="text/javascript">
        function googleTranslateElementInit() {
        var tra = new google.translate.TranslateElement({pageLanguage: '{{App::getLocale()}}'}, 'google_translate_element');
        
        } 
    </script>
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
    <!-- END THEME LAYOUT SCRIPTS -->
    @stack('scripts')

</body>

</html>