<!--begin::Header Section-->
<div class="mb-0" id="home">
    <!--begin::Wrapper-->
    <div class="bgi-no-repeat bgi-size-contain bgi-position-x-center bgi-position-y-bottom landing-dark-bg" style="">
        <!--begin::Header-->
        <div class="landing-header" data-kt-sticky="true" data-kt-sticky-name="landing-header" data-kt-sticky-offset="{default: '200px', lg: '300px'}">
            <!--begin::Container-->
            <div class="container" style="z-index: 100;">
                <!--begin::Wrapper-->
                <div class="d-flex align-items-center justify-content-between">
                    <!--begin::Logo-->
                    <div class="d-flex align-items-center ms-1 ms-lg-3">
                        <!--begin::Mobile menu toggle-->
                        <button class="btn btn-icon btn-active-color-primary me-3 d-flex d-lg-none" id="kt_landing_menu_toggle">
                            <!--begin::Svg Icon | path: icons/duotone/Text/Menu.svg-->
                            <span class="svg-icon svg-icon-2hx">
                                <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <rect x="0" y="0" width="24" height="24" />
                                        <rect fill="#000000" x="4" y="5" width="16" height="3" rx="1.5" />
                                        <path d="M5.5,15 L18.5,15 C19.3284271,15 20,15.6715729 20,16.5 C20,17.3284271 19.3284271,18 18.5,18 L5.5,18 C4.67157288,18 4,17.3284271 4,16.5 C4,15.6715729 4.67157288,15 5.5,15 Z M5.5,10 L18.5,10 C19.3284271,10 20,10.6715729 20,11.5 C20,12.3284271 19.3284271,13 18.5,13 L5.5,13 C4.67157288,13 4,12.3284271 4,11.5 C4,10.6715729 4.67157288,10 5.5,10 Z" fill="#000000" opacity="0.3" />
                                    </g>
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                        </button>
                        <!--end::Mobile menu toggle-->
                        <!--begin::Logo image-->
                        <a href="{{route('/')}}">
						@if(session()->get('online_system_config'))
						<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" />
						<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" />
						<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" />
						@else
						<img alt="Logo" src="{{url('/online/assets/logo/logoA1.png')}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" />
						<img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" />
						<img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" />
						  @endif
                        </a>
                        <!--end::Logo image-->
                    </div>
                    <!--end::Logo-->
                    <!--begin::Language-->
                    <div class="d-flex align-items-center  ms-1 ms-lg-3">
                        <!--begin::Menu wrapper-->
                        <div class="cursor-pointer symbol symbol-30px symbol-md-40px" title="@lang('layout.PageDirection')" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end" data-kt-menu-flip="bottom">
							<!-- <img src="{{url((App::isLocale('en'))?'/assets/global/img/flags/us.png':'/assets/global/img/flags/af.png')}}" class="w-30px h-30px rounded-1 ms-2" alt="Language" /> -->
							<span class="w-30px h-30px rounded-1 ms-2">
								@if(App::isLocale('en'))
								<i class="fa fa-caret-square-right" style="font-size: 25px;"></i>
								@else
								<i class="fa fa-caret-square-left" style="font-size: 25px;"></i>
						  		@endif
							</span>
                        </div>
                        <!--begin::Menu-->
                        <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold py-4 fs-6 w-150px" data-kt-menu="true">
                            <!--begin::Menu item-->
                            <div class="menu-item px-3">
                                <a href="#" onclick="changeLang('en')" class="menu-link d-flex px-5 {{(App::isLocale('en'))?'active':''}} " style="color: black;">
                                    <span class="symbol symbol-20px me-4">
                                        <i class="fa fa-caret-square-right" style="font-size: 25px;"></i>
                                    </span>@lang('layout.LTR')</a>
                            </div>
                            <!--end::Menu item-->
                            <!--begin::Menu item-->
                            <div class="menu-item px-3">
                                <a href="#" onclick="changeLang('fa')" class="menu-link d-flex px-5 {{(App::isLocale('fa'))?'active':''}} " style="color: black;">
                                    <span class="symbol symbol-20px me-4">
                                        <i class="fa fa-caret-square-left" style="font-size: 25px;"></i>
                                    </span>@lang('layout.RTL')</a>
                            </div>
                            <!--end::Menu item-->
                        </div>
                        <!--end::Menu-->
                        <!--end::Menu wrapper-->
					</div>
					
					<div class="d-flex align-items-center  ms-1 ms-lg-3" id="google_translate_element"></div>
					<!--end::Language -->
					
					
					
					<!--begin::Search-->
					<div id="search_vue" class="d-flex align-items-stretch flex-equal ms-1 ms-lg-3">
						<!--begin::Search-->
						<div id="kt_header_search" class="d-flex align-items-stretch" data-kt-search-keypress="true" data-kt-search-min-length="2" data-kt-search-enter="enter" data-kt-search-layout="menu" data-kt-menu-trigger="auto" data-kt-menu-overflow="false" data-kt-menu-permanent="true" data-kt-menu-placement="bottom-end" data-kt-menu-flip="bottom">
							<!--begin::Search toggle-->
							<div class="d-flex align-items-center" data-kt-search-element="toggle" id="kt_header_search_toggle">
								<div class="btn btn-icon btn-active-light-primary">
									<!--begin::Svg Icon | path: icons/duotone/General/Search.svg-->
									<span class="svg-icon svg-icon-1">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24" />
												<path d="M14.2928932,16.7071068 C13.9023689,16.3165825 13.9023689,15.6834175 14.2928932,15.2928932 C14.6834175,14.9023689 15.3165825,14.9023689 15.7071068,15.2928932 L19.7071068,19.2928932 C20.0976311,19.6834175 20.0976311,20.3165825 19.7071068,20.7071068 C19.3165825,21.0976311 18.6834175,21.0976311 18.2928932,20.7071068 L14.2928932,16.7071068 Z" fill="#000000" fill-rule="nonzero" opacity="0.8" />
												<path d="M11,16 C13.7614237,16 16,13.7614237 16,11 C16,8.23857625 13.7614237,6 11,6 C8.23857625,6 6,8.23857625 6,11 C6,13.7614237 8.23857625,16 11,16 Z M11,18 C7.13400675,18 4,14.8659932 4,11 C4,7.13400675 7.13400675,4 11,4 C14.8659932,4 18,7.13400675 18,11 C18,14.8659932 14.8659932,18 11,18 Z" fill="#000000" fill-rule="nonzero" />
											</g>
										</svg>
									</span>
									<!--end::Svg Icon-->
								</div>
							</div>
							<!--end::Search toggle-->
							<!--begin::Menu-->
							<div data-kt-search-element="content" class="menu menu-sub menu-sub-dropdown p-7 w-325px w-md-375px">
								<!--begin::Wrapper-->
								<div data-kt-search-element="wrapper">
									<!--begin::Form-->
									<form data-kt-search-element="form" class="w-100 position-relative mb-3" autocomplete="off">
										<!--begin::Icon-->
										<!--begin::Svg Icon | path: icons/duotone/General/Search.svg-->
										<span class="svg-icon svg-icon-2 svg-icon-lg-1 svg-icon-gray-500 position-absolute top-50 translate-middle-y ms-0">
											<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
												<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
													<rect x="0" y="0" width="24" height="24" />
													<path d="M14.2928932,16.7071068 C13.9023689,16.3165825 13.9023689,15.6834175 14.2928932,15.2928932 C14.6834175,14.9023689 15.3165825,14.9023689 15.7071068,15.2928932 L19.7071068,19.2928932 C20.0976311,19.6834175 20.0976311,20.3165825 19.7071068,20.7071068 C19.3165825,21.0976311 18.6834175,21.0976311 18.2928932,20.7071068 L14.2928932,16.7071068 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
													<path d="M11,16 C13.7614237,16 16,13.7614237 16,11 C16,8.23857625 13.7614237,6 11,6 C8.23857625,6 6,8.23857625 6,11 C6,13.7614237 8.23857625,16 11,16 Z M11,18 C7.13400675,18 4,14.8659932 4,11 C4,7.13400675 7.13400675,4 11,4 C14.8659932,4 18,7.13400675 18,11 C18,14.8659932 14.8659932,18 11,18 Z" fill="#000000" fill-rule="nonzero" />
												</g>
											</svg>
										</span>
										<!--end::Svg Icon-->
										<!--end::Icon-->
										<!--begin::Input-->
										<input type="text" class="form-control form-control-flush ps-10" name="search" v-model="search_input" @input="getSearch()" placeholder="@lang('layout.Search')..." />
										<input type="hidden" data-kt-search-element="input" />
										<!--end::Input-->
										<!--begin::Spinner-->
										<span class="position-absolute top-50 end-0 translate-middle-y lh-0 d-none me-1" data-kt-search-element="spinner">
											<span class="spinner-border h-15px w-15px align-middle text-gray-400"></span>
										</span>
										<!--end::Spinner-->
										<!--begin::Reset-->
										<span class="btn btn-flush btn-active-color-primary position-absolute top-50 end-0 translate-middle-y lh-0 d-none" data-kt-search-element="clear">
											<!--begin::Svg Icon | path: icons/duotone/Navigation/Close.svg-->
											<span class="svg-icon svg-icon-2 svg-icon-lg-1 me-0">
												<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
													<g transform="translate(12.000000, 12.000000) rotate(-45.000000) translate(-12.000000, -12.000000) translate(4.000000, 4.000000)" fill="#000000">
														<rect fill="#000000" x="0" y="7" width="16" height="2" rx="1" />
														<rect fill="#000000" opacity="0.5" transform="translate(8.000000, 8.000000) rotate(-270.000000) translate(-8.000000, -8.000000)" x="0" y="7" width="16" height="2" rx="1" />
													</g>
												</svg>
											</span>
											<!--end::Svg Icon-->
										</span>
										<!--end::Reset-->
										<!--begin::Toolbar-->
										<div class="position-absolute top-50 end-0 translate-middle-y" data-kt-search-element="toolbar">
											<!--begin::Preferences toggle-->
											<div style="display: none;" data-kt-search-element="preferences-show" class="btn btn-icon w-20px btn-sm btn-active-color-primary me-1" data-bs-toggle="tooltip" title="Show search preferences">
												<!--begin::Svg Icon | path: icons/duotone/Code/Settings4.svg-->
												<!-- <span class="svg-icon svg-icon-1">
													<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
														<path d="M18.6225,9.75 L18.75,9.75 C19.9926407,9.75 21,10.7573593 21,12 C21,13.2426407 19.9926407,14.25 18.75,14.25 L18.6854912,14.249994 C18.4911876,14.250769 18.3158978,14.366855 18.2393549,14.5454486 C18.1556809,14.7351461 18.1942911,14.948087 18.3278301,15.0846699 L18.372535,15.129375 C18.7950334,15.5514036 19.03243,16.1240792 19.03243,16.72125 C19.03243,17.3184208 18.7950334,17.8910964 18.373125,18.312535 C17.9510964,18.7350334 17.3784208,18.97243 16.78125,18.97243 C16.1840792,18.97243 15.6114036,18.7350334 15.1896699,18.3128301 L15.1505513,18.2736469 C15.008087,18.1342911 14.7951461,18.0956809 14.6054486,18.1793549 C14.426855,18.2558978 14.310769,18.4311876 14.31,18.6225 L14.31,18.75 C14.31,19.9926407 13.3026407,21 12.06,21 C10.8173593,21 9.81,19.9926407 9.81,18.75 C9.80552409,18.4999185 9.67898539,18.3229986 9.44717599,18.2361469 C9.26485393,18.1556809 9.05191298,18.1942911 8.91533009,18.3278301 L8.870625,18.372535 C8.44859642,18.7950334 7.87592081,19.03243 7.27875,19.03243 C6.68157919,19.03243 6.10890358,18.7950334 5.68746499,18.373125 C5.26496665,17.9510964 5.02757002,17.3784208 5.02757002,16.78125 C5.02757002,16.1840792 5.26496665,15.6114036 5.68716991,15.1896699 L5.72635306,15.1505513 C5.86570889,15.008087 5.90431906,14.7951461 5.82064513,14.6054486 C5.74410223,14.426855 5.56881236,14.310769 5.3775,14.31 L5.25,14.31 C4.00735931,14.31 3,13.3026407 3,12.06 C3,10.8173593 4.00735931,9.81 5.25,9.81 C5.50008154,9.80552409 5.67700139,9.67898539 5.76385306,9.44717599 C5.84431906,9.26485393 5.80570889,9.05191298 5.67216991,8.91533009 L5.62746499,8.870625 C5.20496665,8.44859642 4.96757002,7.87592081 4.96757002,7.27875 C4.96757002,6.68157919 5.20496665,6.10890358 5.626875,5.68746499 C6.04890358,5.26496665 6.62157919,5.02757002 7.21875,5.02757002 C7.81592081,5.02757002 8.38859642,5.26496665 8.81033009,5.68716991 L8.84944872,5.72635306 C8.99191298,5.86570889 9.20485393,5.90431906 9.38717599,5.82385306 L9.49484664,5.80114977 C9.65041313,5.71688974 9.7492905,5.55401473 9.75,5.3775 L9.75,5.25 C9.75,4.00735931 10.7573593,3 12,3 C13.2426407,3 14.25,4.00735931 14.25,5.25 L14.249994,5.31450877 C14.250769,5.50881236 14.366855,5.68410223 14.552824,5.76385306 C14.7351461,5.84431906 14.948087,5.80570889 15.0846699,5.67216991 L15.129375,5.62746499 C15.5514036,5.20496665 16.1240792,4.96757002 16.72125,4.96757002 C17.3184208,4.96757002 17.8910964,5.20496665 18.312535,5.626875 C18.7350334,6.04890358 18.97243,6.62157919 18.97243,7.21875 C18.97243,7.81592081 18.7350334,8.38859642 18.3128301,8.81033009 L18.2736469,8.84944872 C18.1342911,8.99191298 18.0956809,9.20485393 18.1761469,9.38717599 L18.1988502,9.49484664 C18.2831103,9.65041313 18.4459853,9.7492905 18.6225,9.75 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
														<path d="M12,15 C13.6568542,15 15,13.6568542 15,12 C15,10.3431458 13.6568542,9 12,9 C10.3431458,9 9,10.3431458 9,12 C9,13.6568542 10.3431458,15 12,15 Z" fill="#000000" />
													</svg>
												</span> -->
												<!--end::Svg Icon-->
											</div>
											<!--end::Preferences toggle-->
											<!--begin::Advanced search toggle-->
											<div data-kt-search-element="advanced-options-form-show" class="btn btn-icon w-20px btn-sm btn-active-color-primary" data-bs-toggle="tooltip" title="Show more search options">
												<!--begin::Svg Icon | path: icons/duotone/Navigation/Angle-down.svg-->
												<span class="svg-icon svg-icon-2">
													<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
														<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
															<polygon points="0 0 24 0 24 24 0 24" />
															<path d="M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z" fill="#000000" fill-rule="nonzero" transform="translate(12.000003, 11.999999) rotate(-180.000000) translate(-12.000003, -11.999999)" />
														</g>
													</svg>
												</span>
												<!--end::Svg Icon-->
											</div>
											<!--end::Advanced search toggle-->
										</div>
										<!--end::Toolbar-->
									</form>
									<!--end::Form-->
									<!--begin::Separator-->
									<div class="separator border-gray-200 mb-6"></div>
									<!--end::Separator-->
									<!--begin::Recently viewed-->
									<div data-kt-search-element="results" class="d-none">
										<!--begin::Items-->
										<div class="scroll-y mh-200px mh-lg-325px">
											<!--begin::Category title-->
											<h3 class="fs-5 text-muted m-0 pb-5" data-kt-search-element="category-title">Users</h3>
											<!--end::Category title-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<img src="{{url('/online/assets/media/avatars/150-1.jpg')}}" alt="" />
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Karina Clark</span>
													<span class="fs-7 fw-bold text-muted">Marketing Manager</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<img src="{{url('/online/assets/media/avatars/150-3.jpg')}}" alt="" />
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Olivia Bold</span>
													<span class="fs-7 fw-bold text-muted">Software Engineer</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<img src="{{url('/online/assets/media/avatars/150-8.jpg')}}" alt="" />
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Ana Clark</span>
													<span class="fs-7 fw-bold text-muted">UI/UX Designer</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<img src="online/assets/media/avatars/150-11.jpg" alt="" />
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Nick Pitola</span>
													<span class="fs-7 fw-bold text-muted">Art Director</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<img src="online/assets/media/avatars/150-12.jpg" alt="" />
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Edward Kulnic</span>
													<span class="fs-7 fw-bold text-muted">System Administrator</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Category title-->
											<h3 class="fs-5 text-muted m-0 pt-5 pb-5" data-kt-search-element="category-title">Customers</h3>
											<!--end::Category title-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<img class="w-20px h-20px" src="online/assets/media/svg/brand-logos/volicity-9.svg" alt="" />
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Company Rbranding</span>
													<span class="fs-7 fw-bold text-muted">UI Design</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<img class="w-20px h-20px" src="online/assets/media/svg/brand-logos/tvit.svg" alt="" />
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Company Re-branding</span>
													<span class="fs-7 fw-bold text-muted">Web Development</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<img class="w-20px h-20px" src="online/assets/media/svg/misc/infography.svg" alt="" />
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Business Analytics App</span>
													<span class="fs-7 fw-bold text-muted">Administration</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<img class="w-20px h-20px" src="online/assets/media/svg/brand-logos/leaf.svg" alt="" />
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">EcoLeaf App Launch</span>
													<span class="fs-7 fw-bold text-muted">Marketing</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<img class="w-20px h-20px" src="online/assets/media/svg/brand-logos/tower.svg" alt="" />
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">Tower Group Website</span>
													<span class="fs-7 fw-bold text-muted">Google Adwords</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Category title-->
											<h3 class="fs-5 text-muted m-0 pt-5 pb-5" data-kt-search-element="category-title">Projects</h3>
											<!--end::Category title-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<!--begin::Svg Icon | path: icons/duotone/Communication/Clipboard-list.svg-->
														<span class="svg-icon svg-icon-2 svg-icon-primary">
															<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
																<path d="M8,3 L8,3.5 C8,4.32842712 8.67157288,5 9.5,5 L14.5,5 C15.3284271,5 16,4.32842712 16,3.5 L16,3 L18,3 C19.1045695,3 20,3.8954305 20,5 L20,21 C20,22.1045695 19.1045695,23 18,23 L6,23 C4.8954305,23 4,22.1045695 4,21 L4,5 C4,3.8954305 4.8954305,3 6,3 L8,3 Z" fill="#000000" opacity="0.3" />
																<path d="M11,2 C11,1.44771525 11.4477153,1 12,1 C12.5522847,1 13,1.44771525 13,2 L14.5,2 C14.7761424,2 15,2.22385763 15,2.5 L15,3.5 C15,3.77614237 14.7761424,4 14.5,4 L9.5,4 C9.22385763,4 9,3.77614237 9,3.5 L9,2.5 C9,2.22385763 9.22385763,2 9.5,2 L11,2 Z" fill="#000000" />
																<rect fill="#000000" opacity="0.3" x="10" y="9" width="7" height="2" rx="1" />
																<rect fill="#000000" opacity="0.3" x="7" y="9" width="2" height="2" rx="1" />
																<rect fill="#000000" opacity="0.3" x="7" y="13" width="2" height="2" rx="1" />
																<rect fill="#000000" opacity="0.3" x="10" y="13" width="7" height="2" rx="1" />
																<rect fill="#000000" opacity="0.3" x="7" y="17" width="2" height="2" rx="1" />
																<rect fill="#000000" opacity="0.3" x="10" y="17" width="7" height="2" rx="1" />
															</svg>
														</span>
														<!--end::Svg Icon-->
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column">
													<span class="fs-6 fw-bold">Si-Fi Project by AU Themes</span>
													<span class="fs-7 fw-bold text-muted">#45670</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<!--begin::Svg Icon | path: icons/duotone/Media/Equalizer.svg-->
														<span class="svg-icon svg-icon-2 svg-icon-primary">
															<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
																<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
																	<rect x="0" y="0" width="24" height="24" />
																	<rect fill="#000000" opacity="0.3" x="13" y="4" width="3" height="16" rx="1.5" />
																	<rect fill="#000000" x="8" y="9" width="3" height="11" rx="1.5" />
																	<rect fill="#000000" x="18" y="11" width="3" height="9" rx="1.5" />
																	<rect fill="#000000" x="3" y="13" width="3" height="7" rx="1.5" />
																</g>
															</svg>
														</span>
														<!--end::Svg Icon-->
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column">
													<span class="fs-6 fw-bold">Shopix Mobile App Planning</span>
													<span class="fs-7 fw-bold text-muted">#45690</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<!--begin::Svg Icon | path: icons/duotone/Communication/Group-chat.svg-->
														<span class="svg-icon svg-icon-2 svg-icon-primary">
															<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
																<path d="M16,15.6315789 L16,12 C16,10.3431458 14.6568542,9 13,9 L6.16183229,9 L6.16183229,5.52631579 C6.16183229,4.13107011 7.29290239,3 8.68814808,3 L20.4776218,3 C21.8728674,3 23.0039375,4.13107011 23.0039375,5.52631579 L23.0039375,13.1052632 L23.0206157,17.786793 C23.0215995,18.0629336 22.7985408,18.2875874 22.5224001,18.2885711 C22.3891754,18.2890457 22.2612702,18.2363324 22.1670655,18.1421277 L19.6565168,15.6315789 L16,15.6315789 Z" fill="#000000" />
																<path d="M1.98505595,18 L1.98505595,13 C1.98505595,11.8954305 2.88048645,11 3.98505595,11 L11.9850559,11 C13.0896254,11 13.9850559,11.8954305 13.9850559,13 L13.9850559,18 C13.9850559,19.1045695 13.0896254,20 11.9850559,20 L4.10078614,20 L2.85693427,21.1905292 C2.65744295,21.3814685 2.34093638,21.3745358 2.14999706,21.1750444 C2.06092565,21.0819836 2.01120804,20.958136 2.01120804,20.8293182 L2.01120804,18.32426 C1.99400175,18.2187196 1.98505595,18.1104045 1.98505595,18 Z M6.5,14 C6.22385763,14 6,14.2238576 6,14.5 C6,14.7761424 6.22385763,15 6.5,15 L11.5,15 C11.7761424,15 12,14.7761424 12,14.5 C12,14.2238576 11.7761424,14 11.5,14 L6.5,14 Z M9.5,16 C9.22385763,16 9,16.2238576 9,16.5 C9,16.7761424 9.22385763,17 9.5,17 L11.5,17 C11.7761424,17 12,16.7761424 12,16.5 C12,16.2238576 11.7761424,16 11.5,16 L9.5,16 Z" fill="#000000" opacity="0.3" />
															</svg>
														</span>
														<!--end::Svg Icon-->
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column">
													<span class="fs-6 fw-bold">Finance Monitoring SAAS Discussion</span>
													<span class="fs-7 fw-bold text-muted">#21090</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
											<!--begin::Item-->
											<a href="#" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<span class="symbol-label bg-light">
														<!--begin::Svg Icon | path: icons/duotone/General/User.svg-->
														<span class="svg-icon svg-icon-2 svg-icon-primary">
															<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
																<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
																	<polygon points="0 0 24 0 24 24 0 24" />
																	<path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
																	<path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#000000" fill-rule="nonzero" />
																</g>
															</svg>
														</span>
														<!--end::Svg Icon-->
													</span>
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column">
													<span class="fs-6 fw-bold">Dashboard Analitics Launch</span>
													<span class="fs-7 fw-bold text-muted">#34560</span>
												</div>
												<!--end::Title-->
											</a>
											<!--end::Item-->
										</div>
										<!--end::Items-->
									</div>
									<!--end::Recently viewed-->
									<!--begin::Recently viewed-->
									<div class="mb-4" data-kt-search-element="main">
										<!--begin::Heading-->
										<div class="d-flex flex-stack fw-bold mb-4">
											<!--begin::Label-->
											<span class="text-muted fs-6 me-2">@lang('layout.SearchResult')</span>
											<!--end::Label-->
										</div>
										<!--end::Heading-->
										<!--begin::Items-->
										<div class="scroll-y mh-200px mh-lg-325px">
											<!--begin::Item-->
											<span  v-for="(row,index) in items">
											<a :href="'{{url('item_details')}}/' + row.id" class="d-flex text-dark text-hover-primary align-items-center mb-5">
												<!--begin::Symbol-->
												<div class="symbol symbol-40px me-4">
													<img :src="uploads+'/'+row.image" alt="" />
												</div>
												<!--end::Symbol-->
												<!--begin::Title-->
												<div class="d-flex flex-column justify-content-start fw-bold">
													<span class="fs-6 fw-bold">@{{(!row)?null:row.name}}</span>
													<span class="fs-7 fw-bold text-muted"></span>
												</div>
												<!--end::Title-->
											</a>
											</span>
											<!--end::Item-->
										</div>
										<!--end::Items-->
									</div>
									<!--end::Recently viewed-->
									<!--begin::Empty-->
									<div data-kt-search-element="empty" class="text-center d-none">
										<!--begin::Icon-->
										<div class="pt-10 pb-10">
											<!--begin::Svg Icon | path: icons/duotone/Interface/File-Search.svg-->
											<span class="svg-icon svg-icon-4x opacity-50">
												<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
													<path opacity="0.25" d="M3 4C3 2.34315 4.34315 1 6 1H15.7574C16.553 1 17.3161 1.31607 17.8787 1.87868L20.1213 4.12132C20.6839 4.68393 21 5.44699 21 6.24264V20C21 21.6569 19.6569 23 18 23H6C4.34315 23 3 21.6569 3 20V4Z" fill="#12131A" />
													<path d="M15 1.89181C15 1.39927 15.3993 1 15.8918 1V1C16.6014 1 17.2819 1.28187 17.7836 1.78361L20.2164 4.21639C20.7181 4.71813 21 5.39863 21 6.10819V6.10819C21 6.60073 20.6007 7 20.1082 7H16C15.4477 7 15 6.55228 15 6V1.89181Z" fill="#12131A" />
													<path fill-rule="evenodd" clip-rule="evenodd" d="M13.032 15.4462C12.4365 15.7981 11.7418 16 11 16C8.79086 16 7 14.2091 7 12C7 9.79086 8.79086 8 11 8C13.2091 8 15 9.79086 15 12C15 12.7418 14.7981 13.4365 14.4462 14.032L16.7072 16.293C17.0977 16.6835 17.0977 17.3167 16.7072 17.7072C16.3167 18.0977 15.6835 18.0977 15.293 17.7072L13.032 15.4462ZM13 12C13 13.1046 12.1046 14 11 14C9.89543 14 9 13.1046 9 12C9 10.8954 9.89543 10 11 10C12.1046 10 13 10.8954 13 12Z" fill="#12131A" />
												</svg>
											</span>
											<!--end::Svg Icon-->
										</div>
										<!--end::Icon-->
										<!--begin::Message-->
										<div class="pb-15 fw-bold">
											<h3 class="text-gray-600 fs-5 mb-2">No result found</h3>
											<div class="text-muted fs-7">Please try again with a different query</div>
										</div>
										<!--end::Message-->
									</div>
									<!--end::Empty-->
								</div>
								<!--end::Wrapper-->
								<!--begin::Preferences-->
								<form action="{{route('online.ItemDetailsAll')}}" method="GET" data-kt-search-element="advanced-options-form" class="pt-1 d-none">
									<!--begin::Heading-->
									<h3 class="fw-bold text-dark mb-7">@lang('layout.AdvancedSearch')</h3>
									<!--end::Heading-->
									<!--begin::Input group-->
									<div class="mb-5">
										<input type="text" class="form-control form-control-sm form-control-solid" name="search" placeholder="@lang('layout.Search')..." />
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="mb-5">
										<!--begin::Radio group-->
										<div class="nav-group nav-group-fluid">
											<!--begin::Option-->
											@if($color)
											@foreach($color AS $record4)
											<label>
												<input type="radio" class="btn-check" name="color" value="{{$record4->color}}" />
												<span class="btn btn-sm btn-active btn-active-primary px-4" ><span style="background-color: {{$record4->color}};width:8px;height:6px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span>
											</label>
											@endforeach 
											@endif
											<!--end::Option-->
										</div>
										<!--end::Radio group-->
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="mb-5">
										<select name="brand" data-control="select2" data-placeholder="@lang('layout.Brand')" class="form-select form-select-sm form-select-solid">
											<option value=""></option>
											@if($inventoryBrandAll)
											@foreach($inventoryBrandAll AS $recordB)
											<option value="{{$recordB->id}}">{{$recordB->name}}</option>
											@endforeach 
											@endif
										</select>
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="mb-5">
										<select name="category" data-control="select2" data-placeholder="@lang('layout.Category')" class="form-select form-select-sm form-select-solid">
											<option value=""></option>
											@if($inventoryCategoryAll)
											@foreach($inventoryCategoryAll AS $recordC)
											<option value="{{$recordC->id}}">{{$recordC->name}}</option>
											@endforeach 
											@endif
										</select>
									</div>
									<!--end::Input group-->
									<!--begin::Actions-->
									<div class="d-flex justify-content-end">
										<button type="reset" class="btn btn-sm btn-white fw-bolder btn-active-light-primary me-2" data-kt-search-element="advanced-options-form-cancel">@lang('layout.Cancel')</button>
										<button type="submit" class="btn btn-sm fw-bolder btn-primary" data-kt-search-element="advanced-options-form-search">@lang('layout.Search')</button>
									</div>
									<!--end::Actions-->
								</form>
								<!--end::Preferences-->
								<!--begin::Preferences-->
								<form data-kt-search-element="preferences" class="pt-1 d-none">
									<!--begin::Heading-->
									<h3 class="fw-bold text-dark mb-7">Search Preferences</h3>
									<!--end::Heading-->
									<!--begin::Input group-->
									<div class="pb-4 border-bottom">
										<label class="form-check form-switch form-switch-sm form-check-custom form-check-solid flex-stack">
											<span class="form-check-label text-gray-700 fs-6 fw-bold ms-0 me-2">Projects</span>
											<input class="form-check-input" type="checkbox" value="1" checked="checked" />
										</label>
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="py-4 border-bottom">
										<label class="form-check form-switch form-switch-sm form-check-custom form-check-solid flex-stack">
											<span class="form-check-label text-gray-700 fs-6 fw-bold ms-0 me-2">Targets</span>
											<input class="form-check-input" type="checkbox" value="1" checked="checked" />
										</label>
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="py-4 border-bottom">
										<label class="form-check form-switch form-switch-sm form-check-custom form-check-solid flex-stack">
											<span class="form-check-label text-gray-700 fs-6 fw-bold ms-0 me-2">Affiliate Programs</span>
											<input class="form-check-input" type="checkbox" value="1" />
										</label>
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="py-4 border-bottom">
										<label class="form-check form-switch form-switch-sm form-check-custom form-check-solid flex-stack">
											<span class="form-check-label text-gray-700 fs-6 fw-bold ms-0 me-2">Referrals</span>
											<input class="form-check-input" type="checkbox" value="1" checked="checked" />
										</label>
									</div>
									<!--end::Input group-->
									<!--begin::Input group-->
									<div class="py-4 border-bottom">
										<label class="form-check form-switch form-switch-sm form-check-custom form-check-solid flex-stack">
											<span class="form-check-label text-gray-700 fs-6 fw-bold ms-0 me-2">Users</span>
											<input class="form-check-input" type="checkbox" value="1" />
										</label>
									</div>
									<!--end::Input group-->
									<!--begin::Actions-->
									<div class="d-flex justify-content-end pt-7">
										<button type="reset" class="btn btn-sm btn-white fw-bolder btn-active-light-primary me-2" data-kt-search-element="preferences-dismiss">Cancel</button>
										<button type="submit" class="btn btn-sm fw-bolder btn-primary">Save Changes</button>
									</div>
									<!--end::Actions-->
								</form>
								<!--end::Preferences-->
							</div>
							<!--end::Menu-->
						</div>
						<!--end::Search-->
					</div>
					<!--end::Search-->
					
					
                    <!--begin::Menu wrapper-->
                    <div class="d-lg-block" id="kt_header_nav_wrapper">
                        <div class="d-lg-block p-5 p-lg-0" data-kt-drawer="true" data-kt-drawer-name="landing-menu" data-kt-drawer-activate="{default: true, lg: false}" data-kt-drawer-overlay="true" data-kt-drawer-width="200px" data-kt-drawer-direction="start" data-kt-drawer-toggle="#kt_landing_menu_toggle" data-kt-place="true" data-kt-place-mode="prepend" data-kt-place-parent="{default: '#kt_body', lg: '#kt_header_nav_wrapper'}">
                            <!--begin::Menu-->
                            <div class="menu menu-column flex-nowrap menu-rounded menu-lg-row menu-title-gray-500 menu-state-title-primary nav nav-flush fs-5 fw-bold" id="kt_landing_menu">
                                <!--begin::Menu item-->
                                <div class="menu-item">
                                    <!--begin::Menu link-->
                                    <a class="menu-link nav-link active " href="#kt_body" data-kt-scroll-toggle="true" data-kt-drawer-dismiss="true">@lang('menu.Home')</a>
                                    <!--end::Menu link-->
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item">
                                    <!--begin::Menu link-->
                                    <a class="menu-link nav-link " href="#team" data-kt-scroll-toggle="true" data-kt-drawer-dismiss="true">@lang('menu.NewProduct')</a>
                                    <!--end::Menu link-->
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item">
                                    <!--begin::Menu link-->
                                    <a class="menu-link nav-link " href="#portfolio" data-kt-scroll-toggle="true" data-kt-drawer-dismiss="true">@lang('menu.OurProduct')</a>
                                    <!--end::Menu link-->
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item">
                                    <!--begin::Menu link-->
                                    <a class="menu-link nav-link " href="#pricing" data-kt-scroll-toggle="true" data-kt-drawer-dismiss="true">@lang('menu.IncommmingProduct')</a>
                                    <!--end::Menu link-->
                                </div>
                                <!--end::Menu item-->
                                <!--begin::Menu item-->
                                <div class="menu-item">
                                    <!--begin::Menu link-->
                                    <a class="menu-link nav-link " href="{{route('online.about')}}" data-kt-scroll-toggle="true" data-kt-drawer-dismiss="true">@lang('menu.AboutUs')</a>
                                    <!--end::Menu link-->
                                </div>
                                <!--end::Menu item-->
                            </div>
                            <!--end::Menu-->
                        </div>
                    </div>
                    <!--end::Menu wrapper-->
                    <!--begin::Toolbar-->
                    <div class="flex-equal text-end ms-1">
                        @if(!session()->has('online_user'))
                        <a href="{{route('online.login')}}"  class="btn btn-success btn-sm" style="padding: 5px 6px 8px 6px;" >@lang('layout.SignIn')</a>
                        @endif
                    </div>
                    <!--end::Toolbar-->
                    <!--begin::User-->
                    @if(session()->has('online_user'))
                    <div class="d-flex align-items-center ms-1 ms-lg-3 " id="kt_header_user_menu_toggle">
                        <!--begin::Menu wrapper-->
                        <div class="cursor-pointer symbol symbol-30px symbol-md-40px" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end" data-kt-menu-flip="bottom">
							@if(session()->get('online_user')['photo'])
							<img src="{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}" alt="{{session()->get('online_user')['name']}}" />
							@else
							<img src="{{url('/online/assets/media/avatars/blank.png')}}" alt="{{session()->get('online_user')['name']}}" />
							@endif
                        </div>
                        <!--begin::Menu-->
                        <div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold py-4 fs-6 w-275px" data-kt-menu="true">
                            <!--begin::Menu item-->
                            <div class="menu-item px-3">
                                <div class="menu-content d-flex align-items-center px-3">
                                    <!--begin::Avatar-->
                                    <div class="symbol symbol-50px me-5">
										@if(session()->get('online_user')['photo'])
                                        <img alt="{{session()->get('online_user')['name']}}" src="{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}" />
										@else
                                        <img alt="{{session()->get('online_user')['name']}}" src="{{url('/online/assets/media/avatars/blank.png')}}" />
										@endif
                                    </div>
                                    <!--end::Avatar-->
                                    <!--begin::Username-->
                                    <div class="d-flex flex-column">
                                        <div class="fw-bolder d-flex align-items-center fs-5">{{session()->get('online_user')['name']}}
                                        <span class="badge badge-light-success fw-bolder fs-8 px-2 py-1 ms-2">{{session()->get('online_user')['last_name']}}</span></div>
                                    </div>
                                    <!--end::Username-->
                                </div>
                            </div>
                            <!--end::Menu item-->
                            <!--begin::Menu separator-->
                            <div class="separator my-2"></div>
                            <!--end::Menu separator-->
                            <!--begin::Menu item-->
                            <div class="menu-item px-5">
                                <a href="{{route('online.users.show',session()->get('online_user')['id'])}}" class="menu-link px-5">@lang('layout.MyProfile')</a>
                            </div>
                            <!--end::Menu item-->
                            <!--begin::Menu item-->
                            <!-- <div class="menu-item px-5">
                                <a href="pages/projects/list.html" class="menu-link px-5">
                                    <span class="menu-text">@lang('layout.MyOrders')</span>
                                    <span class="menu-badge">
                                        <span class="badge badge-light-danger badge-circle fw-bolder fs-7">3</span>
                                    </span>
                                </a>
                            </div> -->
                            <!--end::Menu item-->
                            <!--begin::Menu separator-->
                            <div class="separator my-2"></div>
                            <!--end::Menu separator-->
                            <!--begin::Menu item-->
                            <div class="menu-item px-5">
                                <a href="{{route('online.logout')}}" class="btn btn-sm btn-light-primary font-weight-bolder  py-2 px-5"> @lang('layout.LogOut') </a>
                            </div>
                            <!--end::Menu item-->
                        </div>
                        <!--end::Menu-->
                        <!--end::Menu wrapper-->
                    </div>
                    @endif
                    <!--end::User -->
					
					<!--begin::Cart-->
					<div class="d-flex align-items-center ms-1 ms-lg-3">
						<!--begin::Menu- wrapper-->
						<div class="btn btn-icon btn-active-light-primary position-relative w-40px h-40px w-md-40px h-md-40px pulse pulse-success" data-kt-menu-trigger="click" data-kt-menu-attach="parent" data-kt-menu-placement="bottom-end" data-kt-menu-flip="bottom">
							<!--begin::Svg Icon | path: icons/duotone/Code/Compiling.svg-->
							<span class="svg-icon svg-icon-1">
								<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
									<path d="M12,4.56204994 L7.76822128,9.6401844 C7.4146572,10.0644613 6.7840925,10.1217854 6.3598156,9.76822128 C5.9355387,9.4146572 5.87821464,8.7840925 6.23177872,8.3598156 L11.2317787,2.3598156 C11.6315738,1.88006147 12.3684262,1.88006147 12.7682213,2.3598156 L17.7682213,8.3598156 C18.1217854,8.7840925 18.0644613,9.4146572 17.6401844,9.76822128 C17.2159075,10.1217854 16.5853428,10.0644613 16.2317787,9.6401844 L12,4.56204994 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
									<path d="M3.5,9 L20.5,9 C21.0522847,9 21.5,9.44771525 21.5,10 C21.5,10.132026 21.4738562,10.2627452 21.4230769,10.3846154 L17.7692308,19.1538462 C17.3034221,20.271787 16.2111026,21 15,21 L9,21 C7.78889745,21 6.6965779,20.271787 6.23076923,19.1538462 L2.57692308,10.3846154 C2.36450587,9.87481408 2.60558331,9.28934029 3.11538462,9.07692308 C3.23725479,9.02614384 3.36797398,9 3.5,9 Z M12,17 C13.1045695,17 14,16.1045695 14,15 C14,13.8954305 13.1045695,13 12,13 C10.8954305,13 10,13.8954305 10,15 C10,16.1045695 10.8954305,17 12,17 Z" fill="#000000" />
								</svg>
							</span>
							<!--end::Svg Icon-->
							<span class="pulse-ring"></span>
						</div>
						<!--begin::Menu-->
						<div class="menu menu-sub menu-sub-dropdown menu-column w-350px w-lg-375px" data-kt-menu="true" id="order_list_vue">
							<!--begin::Heading-->
							<div class="d-flex flex-column bgi-no-repeat rounded-top" style="background-image:url('{{url('/online/assets/media/misc/pattern-1.jpg')}}')">
								<!--begin::Title-->
								<h3 class="text-white fw-bold px-9 mt-10 mb-6">@lang('layout.OrdersList')
								<span class="fs-8 opacity-75 ps-3"> </span></h3>
								<!--end::Title-->
							</div>
							<!--end::Heading-->
							<!--begin::Tab panel-->
							<div class="fade show active" >
								<!--begin::Items-->
								<div class="scroll-y mh-325px my-5 px-8">
									<!--begin::Item-->
									<div v-if="items" class="d-flex flex-stack py-4"  v-for="(row,index) in items">
										<!--begin::Section-->
										<div class="d-flex align-items-center">
											<!--begin::Symbol-->
											<div class="symbol symbol-35px me-4">
												<span class="symbol-label bg-light-primary">
												<a :href="uploads+'/'+row.image" target="_blank" class="symbol symbol-70 flex-shrink-0">
													<img :src="uploads+'/'+row.image" title="" alt="" />
												</a>
												</span>
											</div>
											<!--end::Symbol-->
											<!--begin::Title-->
											<div class="mb-0 me-4">
												<a :href="'{{url('item_details')}}/'+row.id" class="fs-6 text-gray-800 text-hover-primary fw-bolder">@{{(!row)?null:row.name}}</a>
												<div class="">
												<!--begin::Label-->
												<span class="font-weight-bold me-1 text-dark-75 font-size-lg"> @{{(!row)?null:row.price}} @{{(!row)?null:row.currency}} </span>
												<span class="text-muted me-1">@lang('layout.For')</span>
												<span class="font-weight-bold me-2 text-dark-75 font-size-lg">@{{(!row)?null:row.quantity}}</span>
												<a @click="Order_plus(row.id, 'minus')" class="btn btn-icon btn-light-success btn-sm me-2">
													<i class="fa fa-minus"></i>
												</a>
												<a @click="Order_plus(row.id, 'plus')" class="btn btn-sm btn-light-success btn-icon me-2">
													<i class="fa fa-plus btn-sm"></i>
												</a>
												<a @click="Order_plus(row.id, 'delete')" class="btn btn-sm btn-light-danger btn-icon">
													<i class="fa fa-times btn-sm"></i>
												</a>
												<!--end::Label-->
												</div>
											</div>
											<!--end::Title-->
										</div>
										<!--end::Section-->
									</div>
									<!--end::Item-->
								</div>
								<!--end::Items-->
								<!--begin::View more-->
								<div class="py-3 text-center border-top">
									<div class="d-flex align-items-center justify-content-between m-4">
										<span class="font-weight-bold text-muted font-size-sm m-4">@lang('layout.Total')</span>
										<span class="font-weight-bolder text-dark-50 text-right"> @{{total}}  @{{currency}} </span>
									</div>
									<div class="text-right">
										@if(session()->has('online_user'))
										<a href="{{route('online.ItemOrderDetails',session()->get('online_user')['id'])}}" class="btn btn-primary text-weight-bold">@lang('layout.Submit')</a>
										@else
										<a href="{{route('online.login')}}"  class="btn btn-success">@lang('layout.SignIn')</a>
										@endif
									</div>
								</div>
								<!--end::View more-->
							</div>
							<!--end::Tab panel-->
						</div>
						<!--end::Menu-->
						<!--end::Menu wrapper-->
					</div>
					<!--end::Cart-->

					<!--begin::Chat-->
					<div class="d-flex align-items-center ms-1 ms-lg-3">
						<!--begin::Menu wrapper-->
						<div class="btn btn-icon btn-active-light-primary position-relative w-30px h-30px w-md-40px h-md-40px" onclick="getMessageAllList()" id="kt_drawer_chat_toggle">
							<!--begin::Svg Icon | path: icons/duotone/Communication/Group-chat.svg-->
							<span class="svg-icon svg-icon-1">
								<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
									<path d="M16,15.6315789 L16,12 C16,10.3431458 14.6568542,9 13,9 L6.16183229,9 L6.16183229,5.52631579 C6.16183229,4.13107011 7.29290239,3 8.68814808,3 L20.4776218,3 C21.8728674,3 23.0039375,4.13107011 23.0039375,5.52631579 L23.0039375,13.1052632 L23.0206157,17.786793 C23.0215995,18.0629336 22.7985408,18.2875874 22.5224001,18.2885711 C22.3891754,18.2890457 22.2612702,18.2363324 22.1670655,18.1421277 L19.6565168,15.6315789 L16,15.6315789 Z" fill="#000000" />
									<path d="M1.98505595,18 L1.98505595,13 C1.98505595,11.8954305 2.88048645,11 3.98505595,11 L11.9850559,11 C13.0896254,11 13.9850559,11.8954305 13.9850559,13 L13.9850559,18 C13.9850559,19.1045695 13.0896254,20 11.9850559,20 L4.10078614,20 L2.85693427,21.1905292 C2.65744295,21.3814685 2.34093638,21.3745358 2.14999706,21.1750444 C2.06092565,21.0819836 2.01120804,20.958136 2.01120804,20.8293182 L2.01120804,18.32426 C1.99400175,18.2187196 1.98505595,18.1104045 1.98505595,18 Z M6.5,14 C6.22385763,14 6,14.2238576 6,14.5 C6,14.7761424 6.22385763,15 6.5,15 L11.5,15 C11.7761424,15 12,14.7761424 12,14.5 C12,14.2238576 11.7761424,14 11.5,14 L6.5,14 Z M9.5,16 C9.22385763,16 9,16.2238576 9,16.5 C9,16.7761424 9.22385763,17 9.5,17 L11.5,17 C11.7761424,17 12,16.7761424 12,16.5 C12,16.2238576 11.7761424,16 11.5,16 L9.5,16 Z" fill="#000000" opacity="0.3" />
								</svg>
							</span>
							<!--end::Svg Icon-->
							<i id="alert_count">
							<span v-if="alert > 0" class="bullet bullet-dot bg-success h-6px w-6px position-absolute translate-middle top-0 start-50 animation-blink"></span>
							</i>
						</div>
						<!--end::Menu wrapper-->
					</div>
					<!--end::Chat-->

					
								
                </div>
                <!--end::Wrapper-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::Header-->
        
    </div>
    <!--end::Wrapper-->
    
</div>
<!--end::Header Section-->