@extends('online.layouts.app_back')
@section('styles')
 @if(App::isLocale('en'))
	<!--begin::Page Custom Styles(used by this page)-->
	<link href="{{url('/online/assets-v7/css/pages/wizard/wizard-4.css')}}" rel="stylesheet" type="text/css" />
	<!--end::Page Custom Styles-->
    @else
	<!--begin::Page Custom Styles(used by this page)-->
	<link href="{{url('/online/assets-v7/css/pages/wizard/wizard-4.rtl.css')}}" rel="stylesheet" type="text/css" />
	<!--end::Page Custom Styles-->
    @endif
@endsection

@section('content')

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Entry-->
	<div class="d-flex flex-column-fluid">
		<!--begin::Container-->
		<div class="container">
			<!--begin::Page Layout-->
			<div class="d-flex flex-row">
				<!--begin::Layout-->
				<div class="flex-row-fluid ml-lg-12">
					<!--begin::Card-->
					<div class="card card-custom gutter-b">
						<div class="card-body p-0" id="print_id">
							<!-- begin: Invoice-->
							<!-- begin: Invoice header-->
							<div class="row justify-content-center py-8 px-8 py-md-27 px-md-0">
								<div class="col-md-10">
									<div class="d-flex justify-content-between pb-10 pb-md-20 flex-column flex-md-row">
										<h1 class="display-4 font-weight-boldest mb-10">@lang('layout.OrderDetail')</h1>
										<div class="d-flex flex-column align-items-md-end px-0">
											<!--begin::Logo-->
											<a href="#" class="mb-5">
												<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.$online_system_config->logo}}" alt="" />
											</a>
											<!--end::Logo-->
											<span class="d-flex flex-column align-items-md-end opacity-70">
												<span>{{$online_system_config->company_name}}</span>
												<span>{{$online_system_config->phone}}</span>
											</span>
										</div>
									</div>
									<div class="border-bottom w-100"></div>
									<div class="d-flex justify-content-between pt-6">
										<div class="d-flex flex-column flex-root">
											<span class="font-weight-bolder mb-2">@lang('layout.Date')</span>
											<span class="opacity-70">{{$online_order->date}}</span>
										</div>
										<div class="d-flex flex-column flex-root">
											<span class="font-weight-bolder mb-2">@lang('layout.OrderNumber')</span>
											<span class="opacity-70">{{$online_order->number}}</span>
										</div>
										<div class="d-flex flex-column flex-root">
											<span class="font-weight-bolder mb-2">@lang('layout.Customer')</span>
											<span class="opacity-70">{{$online_order->fname}}
											<br />{{$online_order->email}}</span>
										</div>
									</div>
								</div>
							</div>
							<!-- end: Invoice header-->
							<!-- begin: Invoice body-->
							<div class="row justify-content-center py-4 px-4 py-md-6 px-md-0">
								<div class="col-md-10">
									<div class="table-responsive">
										<table class="table">
											<thead>
												<tr>
													<th class="pl-0 font-weight-bold text-muted text-uppercase">@lang('layout.Items')</th>
													<th class="text-right font-weight-bold text-muted text-uppercase">@lang('layout.Quantity')</th>
													<th class="text-right font-weight-bold text-muted text-uppercase">@lang('layout.UnitPrice')</th>
													<th class="text-right pr-0 font-weight-bold text-muted text-uppercase">@lang('layout.Amount')</th>
												</tr>
											</thead>
											<tbody>
												<?php $total_amount = 0; ?>
												@if($online_order_list)
												@foreach($online_order_list AS $record)
												<?php $total_amount += ($record->cost * $record->quantity); ?>
												<tr class="font-weight-boldest">
													<td class="border-0 pl-0 pt-7 d-flex align-items-center">
													<!--begin::Symbol-->
													<div class="symbol symbol-40 flex-shrink-0 mr-4 bg-light">
														<div class="symbol-label" style="background-image: url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}')"></div>
													</div>
													<!--end::Symbol-->
													{{$record->name}}
													</td>
													<td class="text-right pt-7 align-middle">{{$record->quantity}}</td>
													<td class="text-right pt-7 align-middle">{{round($record->cost,2)}} {{$record->currency}}</td>
													<td class="text-primary pr-0 pt-7 text-right align-middle">{{round(($record->cost * $record->quantity),2)}} {{$record->currency}}</td>
												</tr>
												@endforeach
												@endif
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<!-- end: Invoice body-->
							<!-- begin: Invoice footer-->
							<div class="row justify-content-center bg-gray-100 py-8 px-8 py-md-10 px-md-0 mx-0">
								<div class="col-md-10">
									<div class="table-responsive">
										<table class="table">
											<thead>
												<tr>
													<!-- <th class="font-weight-bold text-muted text-uppercase">PAYMENT TYPE</th>
													<th class="font-weight-bold text-muted text-uppercase">PAYMENT STATUS</th> -->
													<th class="font-weight-bold text-muted text-uppercase">@lang('layout.DeliveryDate')</th>
													<th class="font-weight-bold text-muted text-uppercase text-right">@lang('layout.TotalAmount')</th>
												</tr>
											</thead>
											<tbody>
												<tr class="font-weight-bolder">
													<!-- <td>Credit Card</td>
													<td>Success</td> -->
													<td>{{$online_order->delivery_date}}</td>
													<td class="text-primary font-size-h3 font-weight-boldest text-right">{{ round($total_amount,2) }} {{$online_order->currency}}</td>
												</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
							<!-- end: Invoice footer-->
							<!-- begin: Invoice action-->
							<div class="row justify-content-center py-8 px-8 py-md-10 px-md-0">
								<div class="col-md-10">
									<div class="d-flex justify-content-between">
										<!-- <button type="button" class="btn btn-light-primary font-weight-bold" onclick="window.print();">Download Order Details</button> -->
										<button type="button" class="btn btn-primary font-weight-bold" onclick="window.print();">@lang('layout.Print') @lang('layout.OrderDetail')</button>
									</div>
								</div>
							</div>
							<!-- end: Invoice action-->
							<!-- end: Invoice-->
						</div>
					</div>
					<!--end::Card-->
				</div>
				<!--end::Layout-->
			</div>
			<!--end::Page Layout-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Entry-->
</div>
<!--end::Content-->

@endsection

@push('scripts')
<!--begin::Page Scripts(used by this page)-->
	<!-- <script src="{{url('/online/assets-v7/js/pages/custom/ecommerce/checkout.js')}}"></script> -->
<!--end::Page Scripts-->
@endpush