@extends('online.layouts.app_back')
@section('styles')

@endsection

@section('content')
<?php
if (isset($_GET['search'])) {
	Session()->put('on_search', $_GET['search']);
}
if (isset($_GET['color'])) {
	Session()->put('on_color', $_GET['color']);
}
if (isset($_GET['brand'])) {
	Session()->put('on_brand', $_GET['brand']);
}
if (isset($_GET['category'])) {
	Session()->put('on_category', $_GET['category']);
}
if (isset($_GET['selectCategory'])) {
	Session()->put('on_selectCategory', $_GET['selectCategory']);
}
if (isset($_GET['selectBrand'])) {
	Session()->put('on_selectBrand', $_GET['selectBrand']);
}

?>
<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Subheader-->
	<div class="subheader p-2 subheader-solid" id="kt_subheader">
		<div class="container-fluid d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
			<!--begin::Info-->
			<div class="d-flex align-items-center flex-wrap mr-1">
				<!--begin::Mobile Toggle-->
				<button class="burger-icon burger-icon-left mr-4 d-inline-block d-lg-none" id="kt_subheader_mobile_toggle">
					<span></span>
				</button>
				<!--end::Mobile Toggle-->
				<!--begin::Page Heading-->
				<div class="d-flex align-items-baseline flex-wrap mr-5">
					<!--begin::Page Title-->
					<h5 class="text-dark font-weight-bold my-1 mr-5">@lang('layout.Products')</h5>
					<!--end::Page Title-->
				</div>
				<!--end::Page Heading-->
			</div>
			<!--end::Info-->
		</div>
	</div>
	<!--end::Subheader-->
	<!--begin::Entry-->
	<div class="d-flex flex-column-fluid pt-4">
		<!--begin::Container-->
		<div class="container">
			<div class="row">
				<div class="col-lg-12 col-xxl-12 col-md-12 col-12" style="padding-left: 2px; padding-right: 2px;">
					<div class="card  mb-2" id="top_adver">
						@if( onlineSystemConfig()['advertisment'] == 1)
						<a :href="link" target="_blank" >
							<img :alt="title" :title="title" :src="image" width="100%" heght="200px" />
						</a>
						@endif
					</div>
					<!--begin::Page Layout-->
					<div class="d-flex flex-row">
						<!--begin::Aside-->
						<div class="flex-column offcanvas-mobile w-300px w-xl-325px" id="kt_profile_aside">
							<!--begin::Forms Widget 15-->
							<div class="card card-custom gutter-b">
								<!--begin::Body-->
								<div class="card-body">
									<!--begin::Form-->
									{{Form::open(['route' => 'online.ItemDetailsAll','method' => 'GET'])}}
									<!--begin::Categories-->
									<div class="form-group mb-11">
										<label class="font-size-h3 font-weight-bolder text-dark mb-7">@lang('layout.Categories')</label>
										<!--begin::Checkbox list-->
										<div class="checkbox-list">
											@if($inventoryCategory)
											@foreach($inventoryCategory AS $key => $record3)
											<label class="checkbox checkbox-lg mb-7">
												<input type="checkbox" name="selectCategory[]" value="{{$record3->id}}" />
												<span></span>
												<div class="font-size-lg text-dark-75 font-weight-bold">{{$record3->name}}</div>
												<div class="ml-auto text-muted font-weight-bold">{{$record3->total}}</div>
											</label>
											@endforeach
											@endif
										</div>
										<!--end::Checkbox list-->
									</div>
									<!--end::Categories-->
									<!--begin::Categories-->
									<div class="form-group mb-11">
										<label class="font-size-h3 font-weight-bolder text-dark mb-7">@lang('layout.Brand')</label>
										<!--begin::Checkbox list-->
										<div class="checkbox-list">
											@if($inventoryBrand)
											@foreach($inventoryBrand AS $key => $recordB)
											<label class="checkbox checkbox-lg mb-7">
												<input type="checkbox" name="selectBrand[]" value="{{$recordB->id}}" />
												<span></span>
												<div class="font-size-lg text-dark-75 font-weight-bold">{{$recordB->name}}</div>
												<div class="ml-auto text-muted font-weight-bold">{{$recordB->total}}</div>
											</label>
											@endforeach
											@endif
										</div>
										<!--end::Checkbox list-->
									</div>
									<!--end::Categories-->
									<!--begin::Prices-->
									<div class="form-group mb-7">
										<!-- <label class="font-size-h3 font-weight-bolder text-dark mb-7">Price</label> -->
										<!--begin::Radio list-->
										<!-- <div class="radio-list">
										<label class="radio radio-lg mb-7">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">All</div>
											<div class="ml-auto text-muted font-weight-bold">2047</div>
										</label>
										<label class="radio radio-lg mb-7">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">0$ - 99$</div>
											<div class="ml-auto text-muted font-weight-bold">1403</div>
										</label>
										<label class="radio radio-lg mb-7">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">100$ - 999$</div>
											<div class="ml-auto text-muted font-weight-bold">570</div>
										</label>
										<label class="radio radio-lg">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">1000$ &amp; Above</div>
											<div class="ml-auto text-muted font-weight-bold">38</div>
										</label>
									</div> -->
										<!--end::Radio list-->
									</div>
									<!--end::Prices-->
									<!--begin::Price Slider-->
									<!-- <div class="form-group mb-13">
									<div class="text-muted font-weight-bolder font-size-lg mb-5">Pricing Slider</div>
									<div id="kt_price_slider" class="nouislider nouislider-light nouislider-handle-primary nouislider-bg-light-primary nouislider-shadowless nouislider-borderless"></div>
								</div> -->
									<!--end::Price Slider-->
									<!--begin::Color-->
									<div class="form-group">
										<label class="font-size-h3 font-weight-bolder text-dark mb-7">@lang('layout.Color')</label>
										<div class="radio-inline mb-11">
											@if($color)
											@foreach($color AS $record4)
											<label class="radio radio-accent mr-0">
												<input type="radio" name="color" value="{{$record4->color}}" />
												<span style="background-color: {{$record4->color}} !important;"></span>
											</label>
											@endforeach
											@endif
										</div>
									</div>
									<input type="hidden" name="search_form" value="on" />
									<!--end::Color-->
									<button type="submit" class="btn btn-primary font-weight-bolder mr-2 px-8">@lang('layout.Search')</button>
									<button type="reset" class="btn btn-clear font-weight-bolder text-muted px-8">@lang('layout.Reset')</button>
									{!! Form::close() !!}
									<!--end::Form-->
								</div>
								<!--end::Body-->
							</div>
							<!--end::Forms Widget 15-->
							<div class="offcanvas-mobile" style="" id="left_adver_lg">
								@if( onlineSystemConfig()['advertisment'] == 1)
								<a :href="link" target="_blank" >
									<img :alt="title" :title="title" :src="image" width="100%" />
								</a>
								@endif
							</div>
						</div>
						<!--end::Aside-->
						<!--begin::Layout-->
						<div class="flex-row-fluid ml-lg-8">
							<!--begin::Section-->
							<div class="card card-custom">

								<!--begin::Content-->
								<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
									<!--begin::Subheader-->
									<div class="subheader py-2 py-lg-4 subheader-solid" id="">
										<div class="container-fluid d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
											<!--begin::Details-->
											<div class="d-flex align-items-center flex-wrap mr-2">
												<!--begin::Title-->
												<h3 class="text-dark font-weight-bold mt-2 mb-2 mr-5">@lang('layout.Products')</h3>
												<!--end::Title-->
												<!--begin::Separator-->
												<div class="subheader-separator subheader-separator-ver mt-2 mb-2 mr-5 bg-gray-200"></div>
												<!--end::Separator-->
												<!--begin::Search Form-->
												<!-- <div class="d-flex align-items-center" id="kt_subheader_search"> -->
												<!-- <span class="text-dark-50 font-weight-bold" id="kt_subheader_total">54 Total</span> -->
												<!-- <form class="ml-5">
												<div class="input-group input-group-sm input-group-solid" style="max-width: 175px">
													<input type="text" class="form-control" id="kt_subheader_search_form" placeholder="Search..." />
													<div class="input-group-append">
														<span class="input-group-text">
															<span class="svg-icon">
																<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
																	<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
																		<rect x="0" y="0" width="24" height="24" />
																		<path d="M14.2928932,16.7071068 C13.9023689,16.3165825 13.9023689,15.6834175 14.2928932,15.2928932 C14.6834175,14.9023689 15.3165825,14.9023689 15.7071068,15.2928932 L19.7071068,19.2928932 C20.0976311,19.6834175 20.0976311,20.3165825 19.7071068,20.7071068 C19.3165825,21.0976311 18.6834175,21.0976311 18.2928932,20.7071068 L14.2928932,16.7071068 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
																		<path d="M11,16 C13.7614237,16 16,13.7614237 16,11 C16,8.23857625 13.7614237,6 11,6 C8.23857625,6 6,8.23857625 6,11 C6,13.7614237 8.23857625,16 11,16 Z M11,18 C7.13400675,18 4,14.8659932 4,11 C4,7.13400675 7.13400675,4 11,4 C14.8659932,4 18,7.13400675 18,11 C18,14.8659932 14.8659932,18 11,18 Z" fill="#000000" fill-rule="nonzero" />
																	</g>
																</svg>
															</span>
														</span>
													</div>
												</div>
											</form> -->
												<!-- </div> -->
												<!--end::Search Form-->

											</div>
											<!--end::Details-->
										</div>
									</div>
									<!--end::Subheader-->
									<!--begin::Entry-->
									<div class="d-flex flex-column-fluid">
										<!--begin::Container-->
										<div class="container">
											<!--begin::Row-->
											<div class="row">
												<!--begin::Col-->
												@if($allProduct)
												@foreach($allProduct AS $record)
												<div class="col-xl-4 col-lg-6 col-md-6 col-sm-6">
													<!--begin::Card-->
													<div class="card card-custom gutter-b card-stretch">
														<!--begin::Body-->
														<div class="card-body pt-4">
															<!--begin::Image-->
															<div class="overlay">
																<div class="overlay-wrapper rounded bg-light text-center">
																	<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" alt="" class="mw-100 w-200px" />
																</div>
																<div class="overlay-layer">
																	<a href="{{route('online.ItemDetails',$record->id)}}" class="btn font-weight-bolder btn-sm btn-primary mr-2">@lang('layout.QuickView')</a>
																	<a onclick="putPurchase({{$record->id}})" class="btn font-weight-bolder btn-sm btn-light-primary">@lang('layout.Purchase')</a>
																</div>
															</div>
															<!--end::Image-->
															<!--begin::User-->
															<div class="d-flex align-items-center mb-7">
																<!--begin::Title-->
																<div class="d-flex flex-column">
																	<a href="{{route('online.ItemDetails',$record->id)}}" class="text-dark font-weight-bold text-hover-primary font-size-h4 mb-0">{{$record->name}}</a>
																	<span class="text-muted font-weight-bold">
																		<?php
																		$des = wordwrap(substr($record->description, 0, 120), 60, "<br/>\n", false);
																		echo $des;
																		?>
																	</span>
																</div>
																<!--end::Title-->
															</div>
															<!--end::User-->
															<!--begin::Info-->
															<div class="mb-7">
																<div class="d-flex justify-content-between align-items-center">
																	<span class="text-dark-75 font-weight-bolder mr-2">@lang('layout.Price'):</span>
																	<a href="#" class="text-muted text-hover-primary">{{$record->price}} {{$record->currency}}</a>
																</div>
																@if(session()->get('online_system_config'))
																@if(session()->get('online_system_config')->show_onhand === 0)
																<div class="d-flex justify-content-between align-items-cente my-1">
																	<span class="text-dark-75 font-weight-bolder mr-2">@lang('layout.InStock'):</span>
																	<a href="#" class="text-muted text-hover-primary">{{round($record->onhand,2)}}</a>
																</div>
																@endif
																@endif
																<div class="d-flex justify-content-between align-items-center">
																	<span class="text-dark-75 font-weight-bolder mr-2">@lang('layout.Date'):</span>
																	<span class="text-muted font-weight-bold">{{($record->collection)?onlineConvertDate(date_format(date_create($record->collection), 'Y/m/d')):''}}</span>
																</div>
															</div>
															<!--end::Info-->
															<a href="{{route('online.ItemDetails',$record->id)}}" class="btn btn-block btn-sm btn-light-success font-weight-bolder text-uppercase py-4">@lang('layout.SeeMore')</a>
														</div>
														<!--end::Body-->
													</div>
													<!--end:: Card-->
												</div>
												@endforeach
												@endif
												<!--end::Col-->
											</div>
											<!--end::Row-->
											<!--begin::Pagination-->
											<div class="card card-custom">
												<div class="card-body py-7">
													<!--begin::Pagination-->
													<div class="d-flex justify-content-between align-items-center flex-wrap">
														@if ($allProduct->hasPages())
														<div class="d-flex flex-wrap mr-3">

															@if (!$allProduct->onFirstPage())
															<a href="{{ $allProduct->url($allProduct->onFirstPage()) }}" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
																<i class="ki ki-bold-double-arrow-back icon-xs"></i>
															</a>
															@endif

															@if ($allProduct->onFirstPage())
															<a href="#" class="btn disabled btn-icon btn-sm btn-light-primary mr-2 my-1">
																<i class="ki ki-bold-arrow-back icon-xs"></i>
															</a>
															@else
															<a href="{{ $allProduct->previousPageUrl() }}" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
																<i class="ki ki-bold-arrow-back icon-xs"></i>
															</a>
															@endif

															@for ($i= 1; $i <= $allProduct->lastPage(); $i++)
																@if ($i == $allProduct->currentPage())
																<a href="{{ $allProduct->url($i) }}" class="btn btn-icon btn-sm border-0 btn-hover-primary active mr-2 my-1">{{ $i }}</a>
																@else
																<a href="{{ $allProduct->url($i) }}" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">{{ $i }}</a>
																@endif
																@endfor

																@if ($allProduct->hasMorePages())
																<a href="{{ $allProduct->nextPageUrl() }}" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
																	<i class="ki ki-bold-arrow-next icon-xs"></i>
																</a>
																@else
																<a href="#" class=" disabled btn btn-icon btn-sm btn-light-primary mr-2 my-1">
																	<i class="ki ki-bold-arrow-next icon-xs"></i>
																</a>
																@endif

																@if ($allProduct->lastPage())
																<a href="{{ $allProduct->url($allProduct->lastPage()) }}" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
																	<i class="ki ki-bold-double-arrow-next icon-xs"></i>
																</a>
																@endif
														</div>
														@endif
														<!-- <div class="d-flex flex-wrap mr-3">
													<a href="#" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
														<i class="ki ki-bold-double-arrow-back icon-xs"></i>
													</a>
													<a href="#" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
														<i class="ki ki-bold-arrow-back icon-xs"></i>
													</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">...</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">23</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary active mr-2 my-1">24</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">25</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">26</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">27</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">28</a>
													<a href="#" class="btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">...</a>
													<a href="#" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
														<i class="ki ki-bold-arrow-next icon-xs"></i>
													</a>
													<a href="#" class="btn btn-icon btn-sm btn-light-primary mr-2 my-1">
														<i class="ki ki-bold-double-arrow-next icon-xs"></i>
													</a>
												</div> -->
														<!-- <div class="d-flex align-items-center"> 
												
													<select class="form-control form-control-sm text-primary font-weight-bold mr-4 border-0 bg-light-primary" style="width: 75px;">
														<option value="{{ $allProduct->perPage() }}" selected >{{ $allProduct->perPage() }}</option>
														<option value="20">20</option>
														<option value="30">30</option>
														<option value="50">50</option>
														<option value="100">100</option>
													</select>
													<span class="text-muted">Displaying {{ $allProduct->count() }} of {{ $allProduct->total() }} records</span>
												</div> -->

														<?php //dd($allProduct); 
														?>

													</div>
													<!--end:: Pagination-->
												</div>
											</div>
											<!--end::Pagination-->
										</div>
										<!--end::Container-->
									</div>
									<!--end::Entry-->
								</div>
								<!--end::Content-->
							</div>
							<!--end::Section-->
						</div>
						<!--end::Layout-->
					</div>
				</div>
				<!--end::Page Layout-->
				<div class="d-xxl-none d-lg-none col-sm-12 col-12"  style="padding-left: 2px; padding-right: 2px;" id="left_adver_sm">
					@if( onlineSystemConfig()['advertisment'] == 1)
					<a :href="link" target="_blank" >
						<img :alt="title" :title="title" :src="image" width="100%" />
					</a>
					@endif
				</div>
				
			</div>
		</div>
		<!--end::Container-->
	</div>
	<!--end::Entry-->
</div>
<!--end::Content-->


@endsection

@push('scripts')
<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->

<?php

    $company_number =  null;
    $site_link =  null;

    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>

<script type="text/javascript">

	var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";
	
	function getAdvertisment(com_num, type, loc) {
        // console.log(12,uploads_adve);
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
				data:{session_id:session_id,url:url},
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'left') {
                                left_adver_lg.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_lg.link = result.link;
                                left_adver_lg.title = result.title;

                                left_adver_sm.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_sm.link = result.link;
                                left_adver_sm.title = result.title;
                            }
                        }
                    }
                    // console.log(130,result);
                },
                error: function(error) {
                    console.log(140,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        }
    }

    // $(document).ready(function () {
    //     getAdvertisment(1, 'top');
    // });

	var uploads_adve = '{{$site_link}}';
    
    var top_adver = new Vue({
        el: '#top_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 3, 'top'); 
            }
        },
        methods: {
        }
    });    

    var left_adver_lg = new Vue({
        el: '#left_adver_lg',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 3, 'left'); 
            }
        },
        methods: {
        }
    });

    var left_adver_sm = new Vue({
        el: '#left_adver_sm',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 3, 'left'); 
            }
        },
        methods: {
        }
    });

</script>

@endpush