@extends('online.layouts.app_back')
@section('styles')

@endsection

@section('content')
<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Subheader-->
	<div class="subheader p-2 subheader-solid" id="kt_subheader">
		<div class="container-fluid d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
			<!--begin::Info-->
			<div class="d-flex align-items-center flex-wrap mr-1">
				<!--begin::Mobile Toggle-->
				<button class="burger-icon burger-icon-left mr-4 d-inline-block d-lg-none" id="kt_subheader_mobile_toggle">
					<span></span>
				</button>
				<!--end::Mobile Toggle-->
				<!--begin::Page Heading-->
				<div class="d-flex align-items-baseline flex-wrap mr-5">
					<!--begin::Page Title-->
					<h5 class="text-dark font-weight-bold my-1 mr-5">@lang('layout.Products')</h5>
					<!--end::Page Title-->
				</div>
				<!--end::Page Heading-->
			</div>
			<!--end::Info-->
		</div>
	</div>
	<!--end::Subheader-->
	<!--begin::Entry-->
	<div class="d-flex flex-column-fluid pt-4">
		<!--begin::Container-->
		<div class="container">
			<div class="row">
				<div class="col-lg-12 col-xxl-12 col-md-12 col-12" style="padding-left: 2px; padding-right: 2px;">
					<div class="card  mb-2" id="top_adver">
						@if( onlineSystemConfig()['advertisment'] == 1)
						<a :href="link" target="_blank" >
							<img :alt="title" :title="title" :src="image" width="100%" heght="200px" />
						</a>
						@endif
					</div>
					<!--begin::Page Layout-->
					<div class="d-flex flex-row">
						<!--begin::Aside-->
						<div class="flex-column offcanvas-mobile w-300px w-xl-325px" id="kt_profile_aside">
							<!--begin::Forms Widget 15-->
							<div class="card card-custom gutter-b">
								<!--begin::Body-->
								<div class="card-body">
									<!--begin::Form-->
									{{Form::open(['route' => 'online.ItemDetailsAll','method' => 'GET'])}}
									<!--begin::Categories-->
									<div class="form-group mb-11">
										<label class="font-size-h3 font-weight-bolder text-dark mb-7">@lang('layout.Categories')</label>
										<!--begin::Checkbox list-->
										<div class="checkbox-list">
											@if($inventoryCategory)
											@foreach($inventoryCategory AS $key => $record3)
											<label class="checkbox checkbox-lg mb-7">
												<input type="checkbox" name="selectCategory[]" value="{{$record3->id}}" />
												<span></span>
												<div class="font-size-lg text-dark-75 font-weight-bold">{{$record3->name}}</div>
												<div class="ml-auto text-muted font-weight-bold">{{$record3->total}}</div>
											</label>
											@endforeach
											@endif
										</div>
										<!--end::Checkbox list-->
									</div>
									<!--end::Categories-->
									<!--begin::Categories-->
									<div class="form-group mb-11">
										<label class="font-size-h3 font-weight-bolder text-dark mb-7">@lang('layout.Brand')</label>
										<!--begin::Checkbox list-->
										<div class="checkbox-list">
											@if($inventoryBrand)
											@foreach($inventoryBrand AS $key => $recordB)
											<label class="checkbox checkbox-lg mb-7">
												<input type="checkbox" name="selectBrand[]" value="{{$recordB->id}}" />
												<span></span>
												<div class="font-size-lg text-dark-75 font-weight-bold">{{$recordB->name}}</div>
												<div class="ml-auto text-muted font-weight-bold">{{$recordB->total}}</div>
											</label>
											@endforeach
											@endif
										</div>
										<!--end::Checkbox list-->
									</div>
									<!--end::Categories-->
									<!--begin::Prices-->
									<div class="form-group mb-7">
										<!-- <label class="font-size-h3 font-weight-bolder text-dark mb-7">Price</label> -->
										<!--begin::Radio list-->
										<!-- <div class="radio-list">
										<label class="radio radio-lg mb-7">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">All</div>
											<div class="ml-auto text-muted font-weight-bold">2047</div>
										</label>
										<label class="radio radio-lg mb-7">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">0$ - 99$</div>
											<div class="ml-auto text-muted font-weight-bold">1403</div>
										</label>
										<label class="radio radio-lg mb-7">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">100$ - 999$</div>
											<div class="ml-auto text-muted font-weight-bold">570</div>
										</label>
										<label class="radio radio-lg">
											<input type="radio" name="price" />
											<span></span>
											<div class="font-size-lg text-dark-75 font-weight-bold">1000$ &amp; Above</div>
											<div class="ml-auto text-muted font-weight-bold">38</div>
										</label>
									</div> -->
										<!--end::Radio list-->
									</div>
									<!--end::Prices-->
									<!--begin::Price Slider-->
									<!-- <div class="form-group mb-13">
									<div class="text-muted font-weight-bolder font-size-lg mb-5">Pricing Slider</div>
									<div id="kt_price_slider" class="nouislider nouislider-light nouislider-handle-primary nouislider-bg-light-primary nouislider-shadowless nouislider-borderless"></div>
								</div> -->
									<!--end::Price Slider-->
									<!--begin::Color-->
									<div class="form-group">
										<label class="font-size-h3 font-weight-bolder text-dark mb-7">@lang('layout.Color')</label>
										<div class="radio-inline mb-11">
											@if($color)
											@foreach($color AS $record4)
											<label class="radio radio-accent mr-0">
												<input type="radio" name="color" value="{{$record4->color}}" />
												<span style="background-color: {{$record4->color}} !important;"></span>
											</label>
											@endforeach
											@endif
										</div>
									</div>
									<input type="hidden" name="search_form" value="on" />
									<!--end::Color-->
									<button type="submit" class="btn btn-primary font-weight-bolder mr-2 px-8">@lang('layout.Search')</button>
									<button type="reset" class="btn btn-clear font-weight-bolder text-muted px-8">@lang('layout.Reset')</button>
									{!! Form::close() !!}
									<!--end::Form-->
								</div>
								<!--end::Body-->
							</div>
							<!--end::Forms Widget 15-->
							<div class="offcanvas-mobile" style="" id="left_adver_lg">
								@if( onlineSystemConfig()['advertisment'] == 1)
								<a :href="link" target="_blank" >
									<img :alt="title" :title="title" :src="image" width="100%" />
								</a>
								@endif
							</div>
						</div>
						<!--end::Aside-->
						<!--begin::Layout-->
						<div class="flex-row-fluid ml-lg-8">
							<!--begin::Section-->
							<!--begin::Engage Widget 13-->
							<!--begin::Card-->
							<div class="card card-custom gutter-b">
								<!--begin::Card Body-->
								<div id="image_v" class="card-body d-flex rounded bg-danger p-12 flex-column flex-md-row flex-lg-row flex-xxl-row">
									<!--begin::Image-->
									<div class="bgi-no-repeat bgi-position-center bgi-size-cover" >
									<img alt="Pic" class="h-300px h-md-auto h-lg-auto h-xxl-auto mw-100 w-md-550px w-lg-550px w-xxl-550px  w-100" :src="uploads+'/'+item_image" />
								</div>
									<!--end::Image-->

									<!--begin::Card-->
									<div class="card card-custom w-100 w-md-300px w-lg-300px w-xxl-300px ml-auto">
										<!--begin::Card Body-->
										<div class="card-body px-12 py-10">
											<h3 class="font-weight-bolder font-size-h2 mb-1">
												<a href="#" class="text-dark-75">{{$item->name}}</a>
											</h3>
											<div class="text-primary font-size-h4 mb-9">{{$item->price}} {{$item->currency}}</div>
											<div class="font-size-sm mb-8">{{$item->description}}</div>
											<!--begin::Info-->
											<div class="d-flex mb-3">
												<span class="text-dark-50 flex-root font-weight-bold">@lang('layout.Brand')</span>
												<span class="text-dark flex-root font-weight-bold">{{$item->brand_name}}</span>
											</div>
											<div class="d-flex mb-3">
												<span class="text-dark-50 flex-root font-weight-bold">@lang('layout.Category')</span>
												<span class="text-dark flex-root font-weight-bold">{{$item->category_name}}</span>
											</div>
											<div class="d-flex mb-3">
												<span class="text-dark-50 flex-root font-weight-bold">@lang('layout.Color')</span>
												<span class="text-dark flex-root font-weight-bold"><span style="background-color:{{$item->color}}; width:10px; height:6px; ">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></span>
											</div>
											<div class="d-flex mb-3">
												<span class="text-dark-50 flex-root font-weight-bold">@lang('layout.Date')</span>
												<span class="text-dark flex-root font-weight-bold">{{$item->collection}}</span>
											</div>
											@if(session()->get('online_system_config'))
											@if(session()->get('online_system_config')->show_onhand === 0)
											<div class="d-flex">
												<span class="text-dark-50 flex-root font-weight-bold">@lang('layout.InStock')</span>
												<span class="text-dark flex-root font-weight-bold">{{round($item->onhand,2)}}</span>
											</div>
											@endif
											@endif
											<div><a onclick="putPurchase({{$item->id}})" class="btn text-primary font-size-h2 ">@lang('layout.Purchase')</a></div>
											<!--end::Info-->

											<!--begin::Item-->
											<div class="d-flex flex-column flex-lg-fill float-left mb-3 mt-7">
												<div class="symbol-group symbol-hover">
													@if($image)
													@foreach($image AS $record1)
													<div class="symbol symbol-40 symbol-circle" data-toggle="tooltip" title="{{substr($record1->description,0,120)}}">
														<img alt="Pic" @click="changeImg('{{$record1->source}}')" src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record1->source}}" />
													</div>
													@endforeach
													@endif
													<!-- <div class="symbol symbol-30 symbol-circle symbol-light">
											<span class="symbol-label font-weight-bold">5+</span>
										</div> -->
												</div>
											</div>
											<!--end::Item-->

										</div>
										<!--end::Card Body-->
									</div>
									<!--end::Card-->
								</div>
								<!--end::Card Body-->
							</div>
							<!--end::Card-->
							<!--end::Engage Widget 13-->
							<!--end::Section-->
							<!--begin::Section-->
							<div class="card card-custom">
								<div class="card-body">
									<!--begin::Heading-->
									<div class="d-flex justify-content-between align-items-center mb-7">
										<h2 class="font-weight-bolder text-dark font-size-h3 mb-0">@lang('layout.RelatedProducts')</h2>
										<a href="{{route('online.ItemDetailsAll',$item->category_id)}}" class="btn btn-light-primary btn-sm font-weight-bolder">@lang('layout.ViewAll')</a>
									</div>
									<!--end::Heading-->

									<!--begin::Products-->
									<div class="row">
										<!--begin::Product-->
										@if($allProduct)
										@foreach($allProduct AS $record)
										<div class="col-sm-6 col-md-4 col-lg-4 col-xl-3">
											<!--begin::Card-->
											<div class="card card-custom card-shadowless">
												<div class="card-body p-0">
													<!--begin::Image-->
													<div class="overlay">
														<div class="overlay-wrapper rounded bg-light text-center">
															<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" alt="" class="mw-100 w-200px" />
														</div>
														<div class="overlay-layer">
															<a href="{{route('online.ItemDetails',$record->id)}}" class="btn font-weight-bolder btn-sm btn-primary mr-2">@lang('layout.QuickView')</a>
															<a onclick="putPurchase({{$record->id}})" class="btn font-weight-bolder btn-sm btn-light-primary">@lang('layout.Purchase')</a>
														</div>
													</div>
													<!--end::Image-->
													<!--begin::Details-->
													<div class="text-center mt-5 mb-md-0 mb-lg-5 mb-md-0 mb-lg-5 mb-lg-0 mb-5 d-flex flex-column">
														<a href="{{route('online.ItemDetails',$record->id)}}" class="font-size-h5 font-weight-bolder text-dark-75 text-hover-primary mb-1">{{$record->name}}</a>
														<span class="font-size-lg"><?php
																					$des = wordwrap(substr($record->description, 0, 120), 60, "<br/>\n", false);
																					echo $des;
																					?>
														</span>
													</div>
													<!--end::Details-->
												</div>
											</div>
											<!--end::Card-->
										</div>
										@endforeach
										@endif
										<!--end::Product-->
									</div>
									<!--end::Products-->
								</div>
							</div>
							<!--end::Section-->

							<!--begin::Highlight-->
							<div id="contact_form">
								<div id="" class="d-flex flex-stack flex-wrap flex-md-nowrap card-rounded shadow mt-8 p-6" style="background: linear-gradient(90deg, #20AA3E 0%, #03A588 100%);">
									<!--begin::Content-->
									<div class="col-lg-12 col-xs-12 col-md-12 col-sm-12">
										<!--begin::Col-->
										<div class="col-md-12 pe-lg-12">
											<!--begin::Form-->
											{{Form::open(['route' => 'comment.store','method' => 'POST','class' => 'form mb-15','id'=>'comment-form'])}}
											{{ csrf_field() }}
											<input type="hidden" value="{{$item->id}}" name="item_id">
											<input type="hidden" value="item" name="category">
											<h1 class="fw-bolder text-dark mb-9">@lang('layout.SendMessage')</h1>
											<!--begin::Input group-->
											<div class="row mb-5">
												<!--begin::Col-->
												<div class="col-md-6 fv-row">
													<!--begin::Label-->
													<label class="fs-5 fw-bold mb-2">@lang('layout.Name')</label>
													<!--end::Label-->
													<!--begin::Input-->

													<input type="text" class="form-control form-control-solid" placeholder="@lang('layout.Name')" name="name" v-validate="'required'" data-vv-as="@lang('layout.Name')" />
													<span class="required">@{{ errors.first('name') }}</span>
													<!--end::Input-->
												</div>
												<!--end::Col-->
												<!--begin::Col-->
												<div class="col-md-6 fv-row">
													<!--end::Label-->
													<label class="fs-5 fw-bold mb-2">@lang('layout.Email')</label>
													<!--end::Label-->
													<!--end::Input-->
													<input type="email" class="form-control form-control-solid" placeholder="@lang('layout.Email')" name="email" v-validate="'required'" data-vv-as="@lang('layout.Email')" />
													<span class="required">@{{ errors.first('email') }}</span>
													<!--end::Input-->
												</div>
												<!--end::Col-->
											</div>
											<!--end::Input group-->
											<!--begin::Input group-->
											<div class="d-flex flex-column mb-10 fv-row">
												<label class="fs-2 fw-bold mb-2">@lang('layout.Message')</label>
												<textarea class="form-control form-control-solid" rows="2" name="message" v-validate="'required'" data-vv-as="@lang('layout.Message')" placeholder="@lang('layout.Message')"></textarea>
												<span class="required">@{{ errors.first('message') }}</span>
											</div>
											<!--end::Input group-->
											<!--begin::Submit-->
											<button type="button" class="btn btn-lg btn-outline border-2 btn-outline-white flex-shrink-0" @click="saveAndNew($event)">
												<!--begin::Indicator-->
												<span class="indicator-label">@lang('layout.SendMessage')</span>
												<!--end::Indicator-->
											</button>
											<!--end::Submit-->
											{!! Form::close() !!}
											<!--end::Form-->
										</div>
										<!--end::Col-->
									</div>
									<!--end::Content-->
								</div>
								<!--end::Highlight-->

								<div class="card card-custom">
									<!--begin::Row-->
									<h3 class="fs-2hx text-dark ml-10 mr-10 mt-7 " id="comments" data-kt-scroll-offset="{default: 125, lg: 150}">@lang('menu.Comment')</h3>
									<div class="row card-body g-lg-10 mb-10 mb-lg-20">
										<!--begin::Col-->
										<div class="col-lg-4" v-for="(item,index) in coment">
											<!--begin::Testimonial-->
											<div class="d-flex flex-column justify-content-between h-lg-100 px-10 px-lg-0 pe-lg-10 mb-15 mb-lg-0">
												<!--begin::Wrapper-->
												<div class="mb-7">
													<!--begin::Rating-->
													<div class="rating mb-6">
														<!-- <div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div> -->
													</div>
													<!--end::Rating-->
													<!--begin::Title-->
													<!-- <div class="fs-2 fw-bolder text-dark mb-3">This is by far the cleanest template
												<br />and the most well structured</div> -->
													<!--end::Title-->
													<!--begin::Feedback-->
													<div class="text-gray-500 fw-bold fs-4">
														<a href="#" class="text-dark fw-bolder text-hover-primary fs-6">@{{item.description}}</div>
													<!--end::Feedback-->
												</div>
												<!--end::Wrapper-->
												<!--begin::Author-->
												<div class="d-flex align-items-center">
													<!--begin::Avatar-->
													<div class="symbol symbol-circle symbol-50px me-5 pl-3 pr-3">
														<img src="{{url('online/assets/media/avatars/blank.png')}}" class="" alt="" />
													</div>
													<!--end::Avatar-->
													<!--begin::Name-->
													<div class="flex-grow-1">
														<a href="#" class="text-dark fw-bolder text-hover-primary fs-6">@{{item.user_name}}</a>
														<span class="text-muted d-block fw-bold"></span>
													</div>
													<!--end::Name-->
												</div>
												<!--end::Author-->
											</div>
											<!--end::Testimonial-->
										</div>
										<!--end::Col-->
									</div>
									<!--end::Row-->
								</div>
							</div>

						</div>
						<!--end::Layout-->

					</div>
				</div>
				<!--end::Page Layout-->
				<div class="d-lg-none d-xxl-none col-12"  style="padding-left: 2px; padding-right: 2px;" id="left_adver_sm">
					@if( onlineSystemConfig()['advertisment'] == 1)
					<a :href="link" target="_blank" >
						<img :alt="title" :title="title" :src="image" width="100%" />
					</a>
					@endif
				</div>
			</div>
		</div>
		<!--end::Container-->
	</div>
	<!--end::Entry-->
</div>
<!--end::Content-->


@endsection

@push('scripts')
<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->

<?php

    $company_number =  null;
    $site_link =  null;

    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>

<script type="text/javascript">
	@if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

	var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";

	var item_id = {{$item->id}};
	var item_image = "{{$item->image}}";
	var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";

	function getAdvertisment(com_num, type, loc) {
        // console.log(12,uploads_adve);
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
				data:{session_id:session_id,url:url},
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'left') {
								left_adver_lg.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_lg.link = result.link;
                                left_adver_lg.title = result.title;

                                left_adver_sm.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_sm.link = result.link;
                                left_adver_sm.title = result.title;
                            }
                        }
                    }
                    // console.log(130,result);
                },
                error: function(error) {
                    console.log(140,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        }
    }

    // $(document).ready(function () {
    //     getAdvertisment(1, 'top');
    // });

	var uploads_adve = '{{$site_link}}';
    
    var top_adver = new Vue({
        el: '#top_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 2, 'top'); 
            }
        },
        methods: {
        }
    });    

    var left_adver_lg = new Vue({
        el: '#left_adver_lg',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 2, 'left'); 
            }
        },
        methods: {
        }
    });

    var left_adver_sm = new Vue({
        el: '#left_adver_sm',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 2, 'left'); 
            }
        },
        methods: {
        }
    });

	var v = new Vue({
		el: '#contact_form',
		data: {
			part: '',
			coment: [],
		},
		computed: {
			setRates() {}
		},
		mounted: function() {
			this.getComent();
		},
		methods: {
			getComent() {
				// console.log(222222221);
				axios.get("{{route('comment.home')}}", {
						params: {
							category: 'item',
							item_id: item_id
						}
					})
					.then(function(response) {
						if (response.data.length > 0) {
							v.coment = [];
							v.coment = response.data;
						}
						// console.log(222, response.data);
					})
					.catch(function(error) {
						console.log(error);
					});
			},
			saveAndNew() {
				this.$validator.validate()
					.then(valid => {
						if (valid) {
							console.log('sss11', valid);
							var url = "{{route('comment.store')}}";
							form_id = 'comment-form';
							var data = $('#' + form_id).serialize();
							// toggleBlock(true);
							axios.post(url, data)
								.then(function(response) {
									// toggleBlock(0);
									console.log('sss11', response.data);
									if (response.data.result == 1) {
										$('#' + form_id).trigger('reset');
										//$('#success-sound')[0].play();
										toastr.success('', response.data.message);

									} else {
										var message = "{{__('message.Warning')}}";
										//$('#error-sound')[0].play();
										toastr.warning('', message);
									}
								})
								.catch(function(error) {
									// toggleBlock(0);
									console.log(error);
									var message = "{{__('message.Warning')}}";
									//$('#error-sound')[0].play();
									toastr.warning('', message);
								});

						}
					})
			},
		},
		created: function() {

		}

	});


	var vim = new Vue({
		el: '#image_v',
		data: {
			item_image: item_image,
			uploads: uploads
		},
		methods: {
			changeImg(image) {
				vim.item_image = image;
			},
		},

	});
</script>
@endpush