@extends('online.layouts.app_back')

@section('content')

<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	
	<!--begin::Entry-->
	<div class="d-flex flex-column-fluid">
		<!--begin::Container-->
		<div class="container">
			<!--begin::Profile Personal Information-->
			<div class="d-flex flex-row">
				<!--begin::Content-->
				<div class="flex-row-fluid ml-lg-12">
					<!--begin::Card-->
					<div class="card card-custom card-stretch" id="app" v-cloak>
						<!--begin::Header-->
						<div class="card-header py-3">
							<div class="card-title align-items-start flex-column">
								<h3 class="card-label font-weight-bolder text-dark">@lang('layout.EditOrders')</h3>
								<span class="text-muted font-weight-bold font-size-md mt-1">@lang('layout.Update') @lang('layout.Order') - {{$online_order->number}} : {{$online_order->fname}} </span>
							</div>
						</div>
						<!--end::Header-->
						<!--begin::Form-->
						{!! Form::model($online_order, ['method' => 'PATCH','route' => ['online.ItemOrder.update',$online_order->id],'class'=>'form','id'=>'personal-form','files'=> true]) !!}
						{{ csrf_field() }}
							<!--begin::Body-->
							<div class="card-body">
								<div class="row">
									<div class="col-md-8">
										<div class="form-group row">
											<label class="col-xl-3 col-lg-3 col-form-label">@lang('layout.Date')</label>
											<div class="col-lg-9 col-xl-6">
												<input class="form-control form-control-lg form-control-solid date" type="text" name="date" value="{{$online_order->date}}" autocomplete="off" />
											</div>
										</div>
										<div class="form-group row">
											<label class="col-xl-3 col-lg-3 col-form-label">@lang('layout.DeliveryDate')</label>
											<div class="col-lg-9 col-xl-6">
												<input class="form-control form-control-lg form-control-solid date" type="text" name="delivery_date" value="{{$online_order->delivery_date}}" autocomplete="off" />
											</div>
										</div>
										<div class="form-group row">
											<label class="col-xl-3 col-lg-3 col-form-label">@lang('layout.Description')</label>
											<div class="col-lg-9 col-xl-6">
												<textarea class="form-control form-control-lg form-control-solid" name="description" >{{$online_order->description}}</textarea>
											</div>
										</div>
									</div>
									
									<div class="col-md-4">
										<center>
										@lang('layout.Total') : @{{total}} {{$online_order->currency}}
										</center>
									</div>
								</div>

								<div class="row" v-if="orders.length>0" style="overflow-x: scroll;">
									<table id="table_content" class="table  table-head-bg ">
										<thead>
											<tr>
												<th class="text-center" style="min-width: 8px;"> # </th>
												<th class="text-center" style="min-width: 120px;">@lang('layout.Category') </th>
												<th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
												<th class="text-center" style="min-width: 80px;"> @lang('layout.Photo')</th>
												<th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
												<th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
												<th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
												<th style="min-width: 20px;"></th>
											</tr>
										</thead>
										<tbody>
											<tr v-for="(item,index) in orders">
												<td>@{{index+1}}</td>
												<td>
													<v-select label="name" v-model="item.item_category" :options="inventory_category" @Click.native="addNew('order',index)" @input="itemCategoryChange(index)"></v-select>
													<input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
												</td>
												<td class="highlight">
													<v-select label="name" v-model="item.item" :options="temp_items" @Click.native="addNew('order',index)" @search="onItemSearch"></v-select>
													<input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">
												</td>
												<td>
													<div class="symbol symbol-40px me-4" v-if="item.item!=null">
														<img :src="uploads+'/'+item.item.image" alt="" />
													</div>
												</td>
												<td>
													<input type="number" name="quantity[]" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
												</td>
												<td>
													@{{((item.item==null)?null:(item.item.price))}} @{{(item.item==null)?null:item.item.currency}}
													<input type="hidden" name="price[]" v-model.number="(item.item==null)?null:item.item.price" >
												</td>
												<td>
													@{{((item.item==null)?null:(item.item.price * item.item.quantity))}} @{{(item.item==null)?null:item.item.currency}}
												</td>
												<td>
													<span v-if="orders.length>1" v-on:click="deleteItem('order',index)"><i class="paddint-both la la-trash"></i></span>
												</td>
											</tr>
										</tbody>
									</table>
								</div>
							</div>
							<div class="card-header py-3">
								<div class="card-toolbar">
									<span class="btn btn-info mr-2" @Click="addNew('order',1000)" ><i class="p-0 la la-plus"></i></span>
									<button type="submit" class="btn btn-success mr-2">@lang('layout.Update')</button>
									<a href="{{route('online.users.show',$online_order->id)}}" class="btn btn-secondary">@lang('layout.Cancel')</a>
								</div>
							</div>
							<!--end::Body-->
						<!--end::Form-->
						{!! Form::close() !!}
					</div>
				</div>
				<!--end::Content-->
			</div>
			<!--end::Profile Personal Information-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Entry-->
</div>
<!--end::Content-->

@endsection

@push('scripts')

<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->

    <script type="text/javascript">

		@if(App::getLocale())
		Vue.use(VeeValidate, {
			locale: '{{App::getLocale()}}',
		});
		@else
		Vue.use(VeeValidate, {
			locale: 'en',
		});
		@endif
		
		var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";

        Vue.component('v-select', VueSelect.VueSelect);

		var selected_item = {!! json_encode($online_order_list) !!};
		var inventoryCategory = {!! $inventoryCategory !!};
		
		var v = new Vue({
        el: '#app',
        data: {
            index: 0,
            disabled: false,
			temp_items:[],
            selected_item: selected_item,
            inventory_category: inventoryCategory,
			orders:[],
			uploads:uploads,
        },
		computed: {

			// calculate total
			total: function () {
				var sum = 0;
				for (var i = 0; i < this.orders.length; i++) {
					if (this.orders[i].item && this.orders[i].item != null) {
						if (this.orders[i].item.quantity > 0 && this.orders[i].item.price > 0) {
							this.currency = this.orders[i].item.currency;
							sum += this.orders[i].item.quantity * this.orders[i].item.price;
						}
					}
				}
				return myRound(sum);
			},


		},
		mounted:function(){
          // initialize the selected item
			for(var i=0;i<this.selected_item.length;i++)
			{
			// console.log('ssssssss',this.selected_item[i]);
			this.orders.push({item:this.selected_item[i],item_category:null});
			}
			for(var m=4;m>this.selected_item.length;m--)
			{
				this.orders.push({item:null,item_category:null});
			}
        },
        methods: {
			handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        document.getElementById("personal-form").submit()
                    }
                });
            },
            
			onItemSearch(search){
				let inventory_category_id = (v.orders[this.index]['item_category'] !=undefined)?v.orders[this.index]['item_category'].id:'';
				// console.log(123,search)
				axios.get("{{route('search.item')}}",{
					params:{
						inventory_category_id: inventory_category_id,
						search: search
					}
				})
				.then(function (response)
				{
					v.temp_items=[];
					if(response.data.result.length>0)
					{
						v.temp_items = response.data.result;
					}
				})
				.catch(function (error)
				{
					console.log(error);
				});
			},

			itemCategoryChange(index){
				if(this.orders[index]['item_category'] !=null)
				{
				let inventory_category_id = (v.orders[index]['item_category'] !=undefined)?v.orders[index]['item_category'].id:'';
				
				axios.get("{{route('search.item')}}",{
					params:{
					inventory_category_id: inventory_category_id
					}
				})
				.then(function(response){
					v.temp_items = [];
					if(response.data.result.length >0)
					{
						v.temp_items = response.data.result;
					}
				})
				.catch(function(error){
					console.log(error);
				});
				}

			},

			// generic function for adding item to list
			addNew(type=null,index)
			{
				this.index = index;
				if(type !=null)
				{
					if(type=='order')
					{
						if(this.orders[index+1]==undefined)
						{
						this.temp_items=[];
						this.orders.push({item:null});
						}
					}
					
					
				}
				
			},

			// in here you can check and decide to allow duplicate bank for payment or not
			
			
			// delete item from list
			deleteItem(type=null,index)
			{
				if(type !=null)
				{
					// console.log(type);
					if(type=='order')
					{
						this.orders.splice(index, 1);
					}
					
				}
				
			},
			
        },

    });

	</script>
@endpush