@extends('online.layouts.app')
@section('style')

@endsection

@section('content')

<!--begin::How It Works Section-->
<div class="mb-n10 mb-lg-n20">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Product slider-->
        <div class="tns tns-default  z-index-2" style="direction: ltr;">
            <!--begin::Slider-->
            <div data-tns="true" data-tns-loop="true" data-tns-swipe-angle="false" data-tns-speed="2000" data-tns-autoplay="true" data-tns-autoplay-timeout="8000" data-tns-controls="true" data-tns-nav="false" data-tns-items="1" data-tns-center="false" data-tns-dots="false" data-tns-prev-button="#kt_team_slider_prev1" data-tns-next-button="#kt_team_slider_next1">
                <!--begin::Item-->
                @if($slider)
                @foreach($slider AS $record)
                <div class="text-center px-5 pt-5 pt-lg-10 px-lg-10">
                    <a href="{{route('online.ItemDetails',$record->online_item_id)}}">
                        <img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->source}}" class="card-rounded shadow mw-100" title="{{substr($record->description,0,120)}}" />
                    </a>
                </div>
                @endforeach
                @endif
                <!--end::Item-->
            </div>
            <!--end::Slider-->
            <!--begin::Slider button-->
            <button class="btn btn-icon btn-active-color-primary" id="kt_team_slider_prev1">
                <!--begin::Svg Icon | path: icons/duotone/Navigation/Angle-left.svg-->
                <span class="svg-icon svg-icon-3x">
                    <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <polygon points="0 0 24 0 24 24 0 24" />
                            <path d="M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z" fill="#000000" fill-rule="nonzero" transform="translate(12.000003, 11.999999) scale(-1, 1) rotate(-270.000000) translate(-12.000003, -11.999999)" />
                        </g>
                    </svg>
                </span>
                <!--end::Svg Icon-->
            </button>
            <!--end::Slider button-->
            <!--begin::Slider button-->
            <button class="btn btn-icon btn-active-color-primary" id="kt_team_slider_next1">
                <!--begin::Svg Icon | path: icons/duotone/Navigation/Angle-right.svg-->
                <span class="svg-icon svg-icon-3x">
                    <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <polygon points="0 0 24 0 24 24 0 24" />
                            <path d="M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z" fill="#000000" fill-rule="nonzero" transform="translate(12.000003, 11.999999) rotate(-270.000000) translate(-12.000003, -11.999999)" />
                        </g>
                    </svg>
                </span>
                <!--end::Svg Icon-->
            </button>
            <!--end::Slider button-->
        </div>
        <!--end::Product slider-->
    </div>
    <!--end::Container-->
</div>
<!--end::How It Works Section-->
<!--begin::Statistics Section-->
<div class="mt-sm-n10">
    <!--begin::Curve top-->
    <div class="landing-curve landing-dark-color">
        <svg viewBox="15 -1 1470 48" fill="none">
            <path d="M1 48C4.93573 47.6644 8.85984 47.3311 12.7725 47H1489.16C1493.1 47.3311 1497.04 47.6644 1501 48V47H1489.16C914.668 -1.34764 587.282 -1.61174 12.7725 47H1V48Z" fill="currentColor"></path>
        </svg>
    </div>
    <!--end::Curve top-->
    <!--begin::Wrapper-->
    <div class="pb-15 pt-18 landing-dark-bg">
        <!--begin::Container-->
        <div class="container">

            <div class="row">
                <!-- <div class="col-lg-10 col-xxl-10 col-md-10"> -->
                <div class="row" id="top_adver">
                    @if( onlineSystemConfig()['advertisment'] == 1)
                    <a :href="link" target="_blank" v-if="image">
                        <img :alt="title" :title="title" :src="image" width="100%" heght="200px" />
                    </a>
                    @endif
                </div>

                <!--begin::Heading-->
                <div class="text-center mt-15 mb-5" data-kt-scroll-offset="{default: 100, lg: 150}">
                    <!--begin::Title-->
                    <h3 class="fs-2hx text-white fw-bolder mb-5">@lang('menu.RecommendedProduct')</h3>
                    <!--end::Title-->
                    <!--begin::Description-->
                    <!-- div class="fs-5 text-gray-700 fw-bold">Save thousands to millions of bucks by using single tool
                    <br />for different amazing and great useful admin</div -->
                    <!--end::Description-->
                </div>
                <!--end::Heading-->
                <!--begin::Row-->
                <div class="row w-100 gy-10 mb-md-20">
                    <!--begin::Col-->
                    @if($RecommendedProduct)
                    @foreach($RecommendedProduct AS $record2)
                    <div class="col-md-4 px-5">
                        <!--begin::Story-->
                        <div class="text-center mb-10 mb-md-0">
                           
                            <!--begin::Illustration-->
                            <img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record2->image}}" class="" width="100%" alt="" />
                            <!--end::Illustration-->
                            <!--begin::Heading-->
                            <div class="d-flex flex-center mb-5">
                                <!--begin::Badge-->
                                <!-- <span class="badge badge-circle badge-light-success fw-bolder p-8 me-3 fs-6">2000</span> -->
                                <!--end::Badge-->
                                <!--begin::Title-->
                                <a href="{{route('online.ItemDetails',$record2->id)}}">
                                    <div class="fs-5 fs-lg-3 fw-bolder text-light">{{$record2->name}}</div>
                                </a>
                                <!--end::Title-->
                            </div>
                            <!--end::Heading-->
                            <!--begin::Description-->
                            <div class="fw-bold fs-6 fs-lg-4 text-muted">{{substr($record2->description,0,120)}}</div>
                            <!--end::Description-->
                        </div>
                        <!--end::Story-->
                    </div>
                    @endforeach
                    @endif
                    <!--end::Col-->
                </div>
                <!--end::Row-->
                <!-- </div> -->
                <!-- <div class="col-lg-2 col-xxl-2 col-md-2">
					<a href="{{route('/')}}">
						<img alt="it is Logo" title="it is Logo" src="{{url('/uploads/4.gif')}}" width="100%" />
					</a>
				</div> -->
            </div>
        </div>
        <!--end::Container-->
    </div>
    <!--end::Wrapper-->
    <!--begin::Curve bottom-->
    <div class="landing-curve landing-dark-color">
        <svg viewBox="15 12 1470 48" fill="none">
            <path d="M0 11C3.93573 11.3356 7.85984 11.6689 11.7725 12H1488.16C1492.1 11.6689 1496.04 11.3356 1500 11V12H1488.16C913.668 60.3476 586.282 60.6117 11.7725 12H0V11Z" fill="currentColor"></path>
        </svg>
    </div>
    <!--end::Curve bottom-->
</div>
<!--end::Statistics Section-->
<!--begin::Team Section-->
<div class="py-10 py-lg-20">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Heading-->
        <div class="text-center mb-12">
            <!--begin::Title-->
            <h3 class="fs-2hx text-dark mb-5" id="team" data-kt-scroll-offset="{default: 100, lg: 150}">@lang('menu.NewProduct')</h3>
            <!--end::Title-->
            <!--begin::Sub-title-->
            <!-- <div class="fs-5 text-muted fw-bold">It’s no doubt that when a development takes longer to complete, additional costs to
                <br />integrate and test each extra feature creeps up and haunts most of us.</div> -->
            <!--end::Sub-title=-->
        </div>
        <!--end::Heading-->
        <!--begin::Slider-->
        <div class="tns tns-default" style="direction: ltr;">
            <!--begin::Wrapper-->
            <div data-tns="true" data-tns-loop="true" data-tns-swipe-angle="false" data-tns-speed="2000" data-tns-autoplay="true" data-tns-autoplay-timeout="18000" data-tns-controls="true" data-tns-nav="false" data-tns-items="1" data-tns-center="false" data-tns-dots="false" data-tns-prev-button="#kt_team_slider_prev" data-tns-next-button="#kt_team_slider_next" data-tns-responsive="{1400: {items: 4}, 1100: {items: 3}, 800: {items: 2}}">
                <!--begin::Item-->
                @if($NewProduct)
                @foreach($NewProduct AS $record1)
                <div class="text-center">
                    <!--begin::Photo-->
                    <div class="octagon mx-auto mb-5 d-flex w-200px h-200px bgi-no-repeat bgi-size-contain bgi-position-center" style="background-image:url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record1->image}}')"></div>
                    <!--end::Photo-->
                    <!--begin::Person-->
                    <div class="mb-0">
                        <!--begin::Name-->
                        <a href="{{route('online.ItemDetails',$record1->id)}}" class="text-dark fw-bolder text-hover-primary fs-3">{{$record1->name}}</a>
                        <!--end::Name-->
                        <!--begin::Position-->
                        <div class="text-muted fs-6 fw-bold mt-1">{{substr($record1->description,0,120)}}</div>
                        <!--begin::Position-->
                    </div>
                    <!--end::Person-->
                </div>
                @endforeach
                @endif
                <!--end::Item-->
            </div>
            <!--end::Wrapper-->
            <!--begin::Button-->
            <button class="btn btn-icon btn-active-color-primary" id="kt_team_slider_prev">
                <!--begin::Svg Icon | path: icons/duotone/Navigation/Angle-left.svg-->
                <span class="svg-icon svg-icon-3x">
                    <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <polygon points="0 0 24 0 24 24 0 24" />
                            <path d="M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z" fill="#000000" fill-rule="nonzero" transform="translate(12.000003, 11.999999) scale(-1, 1) rotate(-270.000000) translate(-12.000003, -11.999999)" />
                        </g>
                    </svg>
                </span>
                <!--end::Svg Icon-->
            </button>
            <!--end::Button-->
            <!--begin::Button-->
            <button class="btn btn-icon btn-active-color-primary" id="kt_team_slider_next">
                <!--begin::Svg Icon | path: icons/duotone/Navigation/Angle-right.svg-->
                <span class="svg-icon svg-icon-3x">
                    <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <polygon points="0 0 24 0 24 24 0 24" />
                            <path d="M6.70710678,15.7071068 C6.31658249,16.0976311 5.68341751,16.0976311 5.29289322,15.7071068 C4.90236893,15.3165825 4.90236893,14.6834175 5.29289322,14.2928932 L11.2928932,8.29289322 C11.6714722,7.91431428 12.2810586,7.90106866 12.6757246,8.26284586 L18.6757246,13.7628459 C19.0828436,14.1360383 19.1103465,14.7686056 18.7371541,15.1757246 C18.3639617,15.5828436 17.7313944,15.6103465 17.3242754,15.2371541 L12.0300757,10.3841378 L6.70710678,15.7071068 Z" fill="#000000" fill-rule="nonzero" transform="translate(12.000003, 11.999999) rotate(-270.000000) translate(-12.000003, -11.999999)" />
                        </g>
                    </svg>
                </span>
                <!--end::Svg Icon-->
            </button>
            <!--end::Button-->
        </div>
        <!--end::Slider-->
    </div>
    <!--end::Container-->
</div>
<!--end::Team Section-->
<!--begin::Projects Section-->
<div class="mb-lg-n15 position-relative z-index-2">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Card-->
        <div class="card" style="filter: drop-shadow(0px 0px 40px rgba(68, 81, 96, 0.08))">
            <!--begin::Card body-->
            <div class="card-body p-lg-20">
                <!--begin::Heading-->
                <div class="text-center mb-5 mb-lg-10">
                    <!--begin::Title-->
                    <h3 class="fs-2hx text-dark mb-5" id="portfolio" data-kt-scroll-offset="{default: 100, lg: 150}">@lang('menu.OurProduct')</h3>
                    <!--end::Title-->
                </div>
                <!--end::Heading-->
                <!--begin::Tabs wrapper-->
                <div class="d-flex flex-center mb-5 mb-lg-15">
                    <!--begin::Tabs-->
                    <ul class="nav border-transparent flex-center fs-5 fw-bold">
                        @if($inventoryCategory)
                        <?php $cat_co = 0; ?>
                        @foreach($inventoryCategory AS $recordc)
                        <li class="nav-item">
                            <a class="nav-link text-gray-500 text-active-primary px-3 px-lg-6 <?php if ($cat_co == 0) {
                                                                                                    echo 'active';
                                                                                                } ?>" href="#" data-bs-toggle="tab" data-bs-target="#kt-List-{{$cat_co}}">{{$recordc->name}}</a>
                        </li>
                        <?php $cat_co++; ?>
                        @endforeach
                        @endif
                    </ul>
                    <!--end::Tabs-->
                </div>
                <!--end::Tabs wrapper-->
                <!--begin::Tabs content-->
                <div class="tab-content">
                    <!--begin::Tab pane-->
                    @if($inventoryCategory)
                    <?php $cat_it = 0; ?>
                    @foreach($inventoryCategory AS $recordt)
                    <div class="tab-pane fade show  <?php if ($cat_it == 0) {
                                                        echo 'active';
                                                    } ?>" id="kt-List-{{$cat_it}}">
                        <!--begin::Row-->
                        <div class="row g-10">
                            <!--begin::Col-->
                            @if(array_key_exists(0, $recordt->item))
                            <div class="col-lg-6">
                                <!--begin::Item-->
                                <a class="d-block card-rounded overlay h-lg-100" data-fslightbox="lightbox-projects" href="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[0]->image}}">
                                    <!--begin::Image-->
                                    <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded h-lg-100 min-h-250px" style="background-image:url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[0]->image}}')"></div>
                                    <!--end::Image-->
                                    <!--begin::Action-->
                                    <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                        <i class="fa fa-eye fs-3x text-white"></i>
                                    </div>
                                    <!--end::Action-->
                                </a>
                                <!--begin::Title-->
                                <a href="{{route('online.ItemDetails',$recordt->item[0]->id)}}">
                                    <div class="fs-5 fs-lg-3 fw-bolder text-center">{{$recordt->item[0]->name}}</div>
                                </a>
                                <!--end::Title-->
                                <!--end::Item-->
                            </div>
                            @endif
                            <!--end::Col-->
                            <!--begin::Col-->
                            <div class="col-lg-6">
                                <!--begin::Row-->
                                <div class="row g-10 mb-10">
                                    <!--begin::Col-->
                                    @if(array_key_exists(1, $recordt->item))
                                    <div class="col-lg-6">
                                        <!--begin::Item-->
                                        <a class="d-block card-rounded overlay" data-fslightbox="lightbox-projects" href="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[1]->image}}">
                                            <!--begin::Image-->
                                            <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded h-250px" style="background-image:url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[1]->image}}')"></div>
                                            <!--end::Image-->
                                            <!--begin::Action-->
                                            <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                                <i class="fa fa-eye fs-3x text-white"></i>
                                            </div>
                                            <!--end::Action-->
                                        </a>
                                        <!--begin::Title-->
                                        <a href="{{route('online.ItemDetails',$recordt->item[1]->id)}}">
                                            <div class="fs-5 fs-lg-3 fw-bolder text-center">{{$recordt->item[1]->name}}</div>
                                        </a>
                                        <!--end::Title-->
                                        <!--end::Item-->
                                    </div>
                                    @endif
                                    <!--end::Col-->
                                    <!--begin::Col-->
                                    @if(array_key_exists(2, $recordt->item))
                                    <div class="col-lg-6">
                                        <!--begin::Item-->
                                        <a class="d-block card-rounded overlay" data-fslightbox="lightbox-projects" href="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[2]->image}}">
                                            <!--begin::Image-->
                                            <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded h-250px" style="background-image:url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[2]->image}}')"></div>
                                            <!--end::Image-->
                                            <!--begin::Action-->
                                            <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                                <i class="fa fa-eye fs-3x text-white"></i>
                                            </div>
                                            <!--end::Action-->
                                        </a>
                                        <!--begin::Title-->
                                        <a href="{{route('online.ItemDetails',$recordt->item[2]->id)}}">
                                            <div class="fs-5 fs-lg-3 fw-bolder text-center">{{$recordt->item[2]->name}}</div>
                                        </a>
                                        <!--end::Title-->
                                        <!--end::Item-->
                                    </div>
                                    @endif
                                    <!--end::Col-->
                                </div>
                                <!--end::Row-->
                                <!--begin::Item-->
                                @if(array_key_exists(3, $recordt->item))
                                <a class="d-block card-rounded overlay" data-fslightbox="lightbox-projects" href="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[3]->image}}">
                                    <!--begin::Image-->
                                    <div class="overlay-wrapper bgi-no-repeat bgi-position-center bgi-size-cover card-rounded h-250px" style="background-image:url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordt->item[3]->image}}')"></div>
                                    <!--end::Image-->
                                    <!--begin::Action-->
                                    <div class="overlay-layer card-rounded bg-dark bg-opacity-25">
                                        <i class="fa fa-eye fs-3x text-white"></i>
                                    </div>
                                    <!--end::Action-->
                                </a>
                                <!--begin::Title-->
                                <a href="{{route('online.ItemDetails',$recordt->item[3]->id)}}">
                                    <div class="fs-5 fs-lg-3 fw-bolder text-center">{{$recordt->item[3]->name}}</div>
                                </a>
                                <!--end::Title-->
                                @endif
                                <!--end::Item-->
                            </div>
                            <!--end::Col-->
                        </div>
                        <!--end::Row-->
                    </div>
                    <?php $cat_it++; ?>
                    @endforeach
                    @endif
                    <!--end::Tab pane-->
                </div>
                <!--end::Tabs content-->
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Container-->
</div>
<!--end::Projects Section-->
<!--begin::Pricing Section-->
<div class="mt-sm-n20">
    <!--begin::Curve top-->
    <div class="landing-curve landing-dark-color">
        <svg viewBox="15 -1 1470 48" fill="none">
            <path d="M1 48C4.93573 47.6644 8.85984 47.3311 12.7725 47H1489.16C1493.1 47.3311 1497.04 47.6644 1501 48V47H1489.16C914.668 -1.34764 587.282 -1.61174 12.7725 47H1V48Z" fill="currentColor"></path>
        </svg>
    </div>
    <!--end::Curve top-->
    <!--begin::Wrapper-->
    <div class="py-20 landing-dark-bg">
        <!--begin::Container-->
        <div class="container">
            <div class="row">
                <!--begin::Plans-->
                <div class="d-flex flex-column container pt-lg-20">
                    <!--begin::Heading-->
                    <div class="mb-13 text-center">
                        <h1 class="fs-2hx fw-bolder text-white mb-5" id="pricing" data-kt-scroll-offset="{default: 100, lg: 150}">@lang('menu.IncommmingProduct')</h1>
                        <!-- <div class="text-gray-600 fw-bold fs-5">Save thousands to millions of bucks by using single tool for different
                        <br />amazing and outstanding cool and great useful admin</div> -->
                    </div>
                    <!--end::Heading-->
                    <!--begin::Pricing-->
                    <div class="text-center" id="">
                        <!--begin::Row-->
                        <div class="row g-10">
                            @if($IncommmingProduct)
                            @foreach($IncommmingProduct AS $recordI)
                            <!--begin::Col-->
                            <div class="col-xl-4">
                                <div class="d-flex h-100 align-items-center">
                                    <!--begin::Option-->
                                    <div class="w-100 h-400px d-flex flex-column flex-center rounded-3 bg-white py-15 px-10" style="background-image:url('{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordI->image}}')">
                                        <!--begin::Heading-->
                                        <div class="mb-7 text-center">
                                            <!--begin::Title-->
                                            <h1 class="text-dark mb-5 fw-boldest">{{$recordI->name}}</h1>
                                            <!--end::Title-->
                                            <!--begin::Description-->
                                            <div class=" fw-bold mb-5">{{substr($recordI->description,0,120)}}</div>
                                            <!--end::Description-->
                                        </div>
                                        <!--end::Heading-->
                                        <!--begin::Select-->
                                        <a href="{{route('online.ItemDetails',$recordI->id)}}">@lang('layout.More')..</a>
                                        <!--end::Select-->
                                    </div>
                                    <!--end::Option-->
                                </div>
                            </div>
                            <!--end::Col-->
                            @endforeach
                            @endif
                        </div>
                        <!--end::Row-->
                    </div>
                    <!--end::Pricing-->
                </div>
                <!--end::Plans-->
                <div class="row" id="down_adver">
                    @if( onlineSystemConfig()['advertisment'] == 1)
                    <a :href="link" target="_blank" v-if="image">
                        <img :alt="title" :title="title" :src="image" class="py-10 px-4" width="100%" heght="200px" />
                    </a>
                    @endif
                </div>
            </div>
        </div>
        <!--end::Container-->
    </div>
    <!--end::Wrapper-->
    <!--begin::Curve bottom-->
    <div class="landing-curve landing-dark-color">
        <svg viewBox="15 12 1470 48" fill="none">
            <path d="M0 11C3.93573 11.3356 7.85984 11.6689 11.7725 12H1488.16C1492.1 11.6689 1496.04 11.3356 1500 11V12H1488.16C913.668 60.3476 586.282 60.6117 11.7725 12H0V11Z" fill="currentColor"></path>
        </svg>
    </div>
    <!--end::Curve bottom-->
</div>
<!--end::Pricing Section-->
<!--begin::Testimonials Section-->
<div id="contact_form" class="mt-20 mb-n20 position-relative z-index-2">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Heading-->
        <div class="text-center mb-17">
            <!--begin::Title-->
            <h3 class="fs-2hx text-dark mb-5" id="comments" data-kt-scroll-offset="{default: 125, lg: 150}">@lang('menu.Comment')</h3>
            <!--end::Title-->
            <!--begin::Description-->
            <!-- <div class="fs-5 text-muted fw-bold">Save thousands to millions of bucks by using single tool
                <br />for different amazing and great useful admin</div> -->
            <!--end::Description-->
        </div>
        <!--end::Heading-->
        <!--begin::Row-->
        <div class="row g-lg-10 mb-10 mb-lg-20">
            <!--begin::Col-->
            <div class="col-lg-4" v-for="(item,index) in coment">
                <!--begin::Testimonial-->
                <div class="d-flex flex-column justify-content-between h-lg-100 px-10 px-lg-0 pe-lg-10 mb-15 mb-lg-0">
                    <!--begin::Wrapper-->
                    <div class="mb-7">
                        <!--begin::Rating-->
                        <div class="rating mb-6">
                            <!-- <div class="rating-label me-2 checked">
                                <i class="bi bi-star-fill fs-5"></i>
                            </div>
                            <div class="rating-label me-2 checked">
                                <i class="bi bi-star-fill fs-5"></i>
                            </div>
                            <div class="rating-label me-2 checked">
                                <i class="bi bi-star-fill fs-5"></i>
                            </div>
                            <div class="rating-label me-2 checked">
                                <i class="bi bi-star-fill fs-5"></i>
                            </div>
                            <div class="rating-label me-2 checked">
                                <i class="bi bi-star-fill fs-5"></i>
                            </div> -->
                        </div>
                        <!--end::Rating-->
                        <!--begin::Title-->
                        <!-- <div class="fs-2 fw-bolder text-dark mb-3">This is by far the cleanest template
                            <br />and the most well structured</div> -->
                        <!--end::Title-->
                        <!--begin::Feedback-->
                        <div class="text-gray-500 fw-bold fs-4">
                            <a href="#" class="text-dark fw-bolder text-hover-primary fs-6">@{{item.description}}</div>
                        <!--end::Feedback-->
                    </div>
                    <!--end::Wrapper-->
                    <!--begin::Author-->
                    <div class="d-flex align-items-center">
                        <!--begin::Avatar-->
                        <div class="symbol symbol-circle symbol-50px me-5">
                            <img src="{{url('online/assets/media/avatars/blank.png')}}" class="" alt="" />
                        </div>
                        <!--end::Avatar-->
                        <!--begin::Name-->
                        <div class="flex-grow-1">
                            <a href="#" class="text-dark fw-bolder text-hover-primary fs-6">@{{item.user_name}}</a>
                            <span class="text-muted d-block fw-bold"></span>
                        </div>
                        <!--end::Name-->
                    </div>
                    <!--end::Author-->
                </div>
                <!--end::Testimonial-->
            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
        <!--begin::Highlight-->
        <div class="d-flex flex-stack flex-wrap flex-md-nowrap card-rounded shadow p-8 p-lg-12 mb-n5 mb-lg-n13" style="background: linear-gradient(90deg, #20AA3E 0%, #03A588 100%);">
            <!--begin::Content-->
            <div class="col-lg-12 col-xs-12 col-md-12 col-sm-12">

                <!--begin::Col-->
                <div class="col-md-12 pe-lg-12">
                    <!--begin::Form-->
                    {{Form::open(['route' => 'comment.store','method' => 'POST','class' => 'form mb-15','id'=>'comment-form'])}}
                    {{ csrf_field() }}
                    <input type="hidden" value="home" name="category">
                    <h1 class="fw-bolder text-dark mb-9">@lang('layout.SendMessage')</h1>
                    <!--begin::Input group-->
                    <div class="row mb-5">
                        <!--begin::Col-->
                        <div class="col-md-6 fv-row">
                            <!--begin::Label-->
                            <label class="fs-5 fw-bold mb-2">@lang('layout.Name')</label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <input type="text" class="form-control form-control-solid" placeholder="@lang('layout.Name')" name="name" v-validate="'required'" data-vv-as="@lang('layout.Name')" />
                            <span class="required">@{{ errors.first('name') }}</span>
                            <!--end::Input-->
                        </div>
                        <!--end::Col-->
                        <!--begin::Col-->
                        <div class="col-md-6 fv-row">
                            <!--end::Label-->
                            <label class="fs-5 fw-bold mb-2">@lang('layout.Email')</label>
                            <!--end::Label-->
                            <!--end::Input-->
                            <input type="email" class="form-control form-control-solid" placeholder="@lang('layout.Email')" name="email" v-validate="'required'" data-vv-as="@lang('layout.Email')" />
                            <span class="required">@{{ errors.first('email') }}</span>
                            <!--end::Input-->
                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Input group-->
                    <!--begin::Input group-->
                    <div class="d-flex flex-column mb-10 fv-row">
                        <label class="fs-2 fw-bold mb-2">@lang('layout.Message')</label>
                        <textarea class="form-control form-control-solid" rows="2" name="message" v-validate="'required'" data-vv-as="@lang('layout.Message')" placeholder="@lang('layout.Message')"></textarea>
                        <span class="required">@{{ errors.first('message') }}</span>
                    </div>
                    <!--end::Input group-->
                    <!--begin::Submit-->
                    <button type="button" class="btn btn-lg btn-outline border-2 btn-outline-white flex-shrink-0" @click="saveAndNew($event)">
                        <!--begin::Indicator-->
                        <span class="indicator-label">@lang('layout.SendMessage')</span>
                        <span class="indicator-progress">Please wait...
                            <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                        <!--end::Indicator-->
                    </button>
                    <!--end::Submit-->
                    {!! Form::close() !!}
                    <!--end::Form-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Highlight-->
    </div>
    <!--end::Container-->
</div>
<!--end::Testimonials Section-->

@endsection

@push('scripts')

<?php

    $company_number =  null;
    $site_link =  null;

    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>

<script type="text/javascript">

    
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";

    function changeLang(lang) {
        // console.log(12,lang);
        if (lang != null) {
            $.ajax({
                type: 'POST',
                url: "{{url('onlineChangeLang')}}/" + lang,
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                success: function(result) {
                    // toastr.success('', result.message);
                    // table.ajax.reload();
                    // console.log(13,result);
                    location.reload();
                },
                error: function(error) {
                    // console.log(14,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        }
    }    
    
    function getAdvertisment(com_num, type, loc) {
        // console.log(12,session_id,url);
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
                data:{session_id:session_id,url:url},
                // session_id url
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'down') {
                                down_adver.image = uploads_adve+'/uploads/'+result.image;
                                down_adver.link = result.link;
                                down_adver.title = result.title;
                            }
                        }
                    }
                    // console.log(130,result);
                },
                error: function(error) {
                    console.log(140,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        }
    }

    // $(document).ready(function () {
    //     getAdvertisment(1, 'top');
    // });

    var uploads_adve = '{{$site_link}}';
    
    var top_adver = new Vue({
        el: '#top_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 1, 'top'); 
            }
        },
        methods: {
        }
    });    

    var down_adver = new Vue({
        el: '#down_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 1, 'down'); 
            }
        },
        methods: {
        }
    });

    var v = new Vue({
        el: '#contact_form',
        data: {
            part: '',
            coment: [],
        },
        computed: {
            setRates() {}
        },
        mounted: function() {
            this.getComent();
        },
        methods: {
            getComent() {
                // console.log(222222221);
                axios.get("{{route('comment.home')}}", {
                        params: {
                            category: 'home'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.coment = [];
                            v.coment = response.data;
                        }
                        // console.log(222, response.data);
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            console.log('sss11', valid);
                            var url = "{{route('comment.store')}}";
                            form_id = 'comment-form';
                            var data = $('#' + form_id).serialize();
                            // toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    // toggleBlock(0);
                                    console.log('sss11', response.data);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);

                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    // toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },
        created: function() {

        }

    });


    var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";

    var searVue = new Vue({
        el: '#search_vue',
        data: {
            search_input: '',
            items: [],
            uploads: uploads,
        },
        methods: {
            getSearch() {
                // console.log(123,searVue.search_input);
                if (searVue.search_input != null) {
                    var search = searVue.search_input;
                    axios.get("{{route('search.item')}}", {
                            params: {
                                search: search
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                if (response.data.result.length > 0) {
                                    searVue.items = [];
                                    searVue.items = response.data.result;
                                    // console.log(222, searVue.items);
                                } else {
                                    searVue.items = [];
                                }
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },
        },
        created: function() {

        }

    });
</script>

@endpush