<!DOCTYPE html>

<html lang="{{ config('app.locale') }}" dir={{(App::isLocale('en'))?"ltr":"rtl"}} direction="{{(App::isLocale('en'))?'ltr':'rtl'}}" style="direction:{{(App::isLocale('en'))?'ltr':'rtl'}};">

<!-- BEGIN HEAD -->

<head>

    <meta charset="utf-8" />
    <!-- <title>CAS</title> -->

    @if(session()->get('online_system_config'))
    <link rel="shortcut icon" href="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" />
    @else
    <link rel="shortcut icon" href="{{url('/online/assets/logo/logo1.png')}}" />
    @endif

    <meta name="description" content="Create by CHACO" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta content="Azizullah Habibi" name="author" />
    <meta id="token" name="csrf-token" content="{{ csrf_token() }}">
    <meta id="token" name="token" value="{{ csrf_token() }}">

    <!--begin::Global Stylesheets Bundle(used by all pages)-->
    @if(App::isLocale('en'))
    <link href="{{url('/online/assets/plugins/global/plugins.bundle.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/online/assets/css/style.bundle.css')}}" rel="stylesheet" type="text/css" />
    @else
    <link href="{{url('/online/assets/plugins/global/plugins.bundle.rtl.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/online/assets/css/style.bundle.rtl.css')}}" rel="stylesheet" type="text/css" />
    @endif
    <!--end::Global Stylesheets Bundle-->

    <!-- END HEAD -->
</head>
<body id="kt_body" class="bg-white">
    <!--begin::Main-->
    <div class="d-flex flex-column flex-root">
        <!--begin::Authentication - Sign-in -->
        <div class="d-flex flex-column flex-column-fluid bgi-position-y-bottom position-x-center bgi-no-repeat bgi-size-contain bgi-attachment-fixed" style="background-image: url({{url('/online/assets/media/illustrations/progress-hd.png')}})">
            <!--begin::Content-->
            <div class="d-flex flex-center flex-column flex-column-fluid p-10 pb-lg-20">
                <!--begin::Logo-->
                <a href="{{route('/')}}" class="mb-12">
                    @if(session()->get('online_system_config'))
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo}}" class="h-45px" />
                    @else
                    <img alt="Logo" src="{{url('/online/assets/logo/logoA1.png')}}" class="h-45px" />
                    @endif
                </a>
                <!--end::Logo-->
                <!--begin::Wrapper-->
                <div class="w-lg-500px bg-white rounded shadow-sm p-10 p-lg-15 mx-auto">
                    @if (Session('warning'))
                    <div class="m-heading-1 border-yellow m-bordered warning-action">
                        <div class="warning-body">
                            <p style="font-weight: bold; font-size:20px;color:red">@lang('message.Warning')</p>
                            <p style="font-weight: bold; font-size:16px;">{{ Session('warning') }}</p>
                        </div>
                    </div>
                    @endif
                    <!--begin::Form-->
                    <form class="form w-100" novalidate="novalidate" id="kt_sign_in_form" method="POST" action="{{ url('/user/login') }}">
                        {{ csrf_field() }}
                        <!--begin::Heading-->
                        <div class="text-center mb-10">
                            <!--begin::Title-->
                            <h1 class="text-dark mb-3">@lang('layout.LoginToYourAccount')</h1>
                            <!--end::Title-->
                            <!--begin::Link-->
                            <div class="text-gray-400 fw-bold fs-3">
								<a href="{{route('online.users.create')}}" class="link-primary fw-bolder">@lang('layout.CreatenewAccount')</a></div>
                            <!--end::Link-->
                        </div>
                        <!--begin::Heading-->
                        <!--begin::Input group-->
                        <div class="fv-row mb-10">
                            <!--begin::Label-->
                            <label class="form-label fs-6 fw-bolder text-dark">@lang('layout.Email')</label>
                            <!--end::Label-->
                            <!--begin::Input-->
                            <input id="email" type="email" class="form-control placeholder-no-fix" name="email" value="{{ old('email') }}" required autofocus class="form-control form-control-lg form-control-solid" autocomplete="off">
                            @if ($errors->has('email'))
                            <span class="help-block">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                            @endif
                            <!--end::Input-->
                        </div>
                        <!--end::Input group-->
                        <!--begin::Input group-->
                        <div class="fv-row mb-10">
                            <!--begin::Wrapper-->
                            <div class="d-flex flex-stack mb-2">
                                <!--begin::Label-->
                                <label class="form-label fw-bolder text-dark fs-6 mb-0">@lang('layout.Password')</label>
                                <!--end::Label-->
                                <!--begin::Link-->
                                <a href="{{ route('online.reset') }}" class="link-primary fs-6 fw-bolder">@lang('layout.ToResetYourPassword')</a>
                                <!--end::Link-->
                            </div>
                            <!--end::Wrapper-->
                            <!--begin::Input-->
                            <input id="password" type="password" autocomplete="off" class="form-control form-control-lg form-control-solid" name="password" required>
                            @if ($errors->has('password'))
                            <span class="help-block">
                                <strong>{{ $errors->first('password') }}</strong>
                            </span>
                            @endif
                            <!--end::Input-->
                        </div>
                        <!--end::Input group-->
                        <!--begin::Actions-->
                        <div class="text-center">
                            <!--begin::Submit button-->
                            <input class="btn btn-lg btn-primary w-100 mb-5" type="submit" value="@lang('layout.SignIn')" />
                            <!-- <button type="submit" id="kt_sign_in_submit" class="btn btn-lg btn-primary w-100 mb-5">
                                <span class="indicator-label">Continue</span>
                                <span class="indicator-progress">Please wait... <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                            </button> -->
                            <!--end::Submit button-->
                            <!--begin::Separator-->
                            <!-- <div class="text-center text-muted text-uppercase fw-bolder mb-5">or</div> -->
                            <!--end::Separator-->
                            <!--begin::Google link-->
                            <!-- <a href="#" class="btn btn-flex flex-center btn-light btn-lg w-100 mb-5">
								<img alt="Logo" src="../../../online/assets/media/svg/brand-logos/google-icon.svg" class="h-20px me-3" />Continue with Google</a> -->
                            <!--end::Google link-->
                            <!--begin::Google link-->
                            <!-- <a href="#" class="btn btn-flex flex-center btn-light btn-lg w-100 mb-5">
								<img alt="Logo" src="../../../online/assets/media/svg/brand-logos/facebook-4.svg" class="h-20px me-3" />Continue with Facebook</a> -->
                            <!--end::Google link-->
                            <!--begin::Google link-->
                            <!-- <a href="#" class="btn btn-flex flex-center btn-light btn-lg w-100">
								<img alt="Logo" src="../../../online/assets/media/svg/brand-logos/apple-black.svg" class="h-20px me-3" />Continue with Apple</a> -->
                            <!--end::Google link-->
                        </div>
                        <!--end::Actions-->
                        </form>
                        <!--end::Form-->
                </div>
                <!--end::Wrapper-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Authentication - Sign-in-->
    </div>
    <!--end::Main-->
    <!-- BEGIN COPYRIGHT -->
    <div class="copyright">&copy; Copyright 2021 C.A.S System - by CH.A CO.</div>
    <!-- END COPYRIGHT -->
    <!--[if lt IE 9]-->

    <!--begin::Global Javascript Bundle(used by all pages)-->
    <script src="{{url('/online/assets/plugins/global/plugins.bundle.js')}}" type="text/javascript"></script>
    <script src="{{url('/online/assets/js/scripts.bundle.js')}}" type="text/javascript"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Page Custom Javascript(used by this page)-->
    <!-- <script src="{{url('/online/assets/js/custom/authentication/sign-in/general.js')}}" type="text/javascript"></script> -->
    <!--end::Page Custom Javascript-->



</body>

</html>