@extends('online.layouts.app_back')
@section('styles')

@endsection

@section('content')
<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Entry-->
	<div class="d-flex flex-column-fluid pt-4">

		<!--begin::Container-->
		<div class="container">
			<!--begin::Page Layout-->
			<div class="row">
				<!--begin::Layout-->
				<div class="{{ ( onlineSystemConfig()['advertisment'] == 1)?'col-lg-12 col-xxl-12 col-md-12':'' }} " style="padding-left: 2px; padding-right: 2px;">
					<div class="card  mb-2" id="top_adver">
						@if( onlineSystemConfig()['advertisment'] == 1)
						<a :href="link" target="_blank" >
							<img :alt="title" :title="title" :src="image" width="100%" heght="200px" />
						</a>
						@endif
					</div>
					<!--begin::Section-->
					<div class="card card-custom">
						<!--begin::Content-->
						<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
							<!--begin::Subheader-->
							<div class="subheader py-2 py-lg-4 subheader-solid" id="">
								<div class="container-fluid d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
									<!--begin::Details-->
									<div class="d-flex align-items-center flex-wrap mr-2">
										<!--begin::Title-->
										<h3 class="text-dark font-weight-bold mt-2 mb-2 mr-5">@lang('menu.AboutUs')</h3>
										<!--end::Title-->
										<!--begin::Separator-->
										<div class="subheader-separator subheader-separator-ver mt-2 mb-2 mr-5 bg-gray-200"></div>
										<!--end::Separator-->
										<h2 class="text-dark font-weight-bold mt-2 mb-2 ml-5">
											@if($company)
											--- {{$company->company_name}} ---
											@endif
										</h2>

									</div>
									<!--end::Details-->
								</div>
							</div>
							<!--end::Subheader-->
							<!--begin::Entry-->
							<div class="d-flex flex-column-fluid py-5" style="border-top: 1px solid #a1a4b9;">
								<!--begin::Container-->
								<div class="container">
									<!--begin::Row-->
									<div class="row">
										<!--begin::Col-->
										@if($info_details)
										@foreach($info_details AS $record)

										<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
											<!--begin::Title-->
											<h2 class="fw-bolder text-dark mb-8">{{$record->title}}</h2>
											<!--end::Title-->
											<!--begin::Text-->
											<div class="fs-4 fw-bold text-gray-700 mb-13">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; {{$record->description}}</div>
											<!--end::Text-->
											<!--begin::Image-->
											<img class="w-100 card-rounded mt-2 mb-8 " src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_about/'.$record->image}}" alt="" />
											<!--end::Image-->
										</div>

										@endforeach
										@endif
										<!--end::Col-->
									</div>
									<!--end::Row-->
									<hr />
									<!--begin::Row-->
									<div class="row">
										<!--begin::Title-->
										<h3 class="text-dark font-weight-bold mt-2 mb-2 mr-5">@lang('layout.Contacts') | </h3>
										<br />
										<br />
										<br />
										<!--end::Title-->
										<!--begin::Col-->
										@if($info_social)
										@foreach($info_social AS $record1)

										<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
											<!--begin::Title-->
											<h2 class="fw-bolder text-dark mb-8"> <i class="fa {{$record1->social_icon}} "></i> {{ __('layout.'.$record1->social_name)}}: {{$record1->social_url}} </h2>
											<!--end::Title-->
										</div>
										@endforeach
										@endif
										<!--end::Col-->
									</div>
									<!--end::Row-->
								</div>
								<!--end::Container-->
							</div>
							<!--end::Entry-->

							<div id="contact_form">
								<div id="" class="d-flex flex-stack flex-wrap flex-md-nowrap card-rounded shadow mt-8 p-6" style="background: linear-gradient(90deg, #20AA3E 0%, #03A588 100%);">
									<!--begin::Content-->
									<div class="col-lg-12 col-xs-12 col-md-12 col-sm-12">
										<!--begin::Col-->
										<div class="col-md-12 pe-lg-12">
											<!--begin::Form-->
											{{Form::open(['route' => 'comment.store','method' => 'POST','class' => 'form mb-15','id'=>'comment-form'])}}
											{{ csrf_field() }}
											<input type="hidden" value="home" name="category">
											<h1 class="fw-bolder text-dark mb-9">@lang('layout.SendMessage')</h1>
											<!--begin::Input group-->
											<div class="row mb-5">
												<!--begin::Col-->
												<div class="col-md-6 fv-row">
													<!--begin::Label-->
													<label class="fs-5 fw-bold mb-2">@lang('layout.Name')</label>
													<!--end::Label-->
													<!--begin::Input-->

													<input type="text" class="form-control form-control-solid" placeholder="@lang('layout.Name')" name="name" v-validate="'required'" data-vv-as="@lang('layout.Name')" />
													<span class="required">@{{ errors.first('name') }}</span>
													<!--end::Input-->
												</div>
												<!--end::Col-->
												<!--begin::Col-->
												<div class="col-md-6 fv-row">
													<!--end::Label-->
													<label class="fs-5 fw-bold mb-2">@lang('layout.Email')</label>
													<!--end::Label-->
													<!--end::Input-->
													<input type="email" class="form-control form-control-solid" placeholder="@lang('layout.Email')" name="email" v-validate="'required'" data-vv-as="@lang('layout.Email')" />
													<span class="required">@{{ errors.first('email') }}</span>
													<!--end::Input-->
												</div>
												<!--end::Col-->
											</div>
											<!--end::Input group-->
											<!--begin::Input group-->
											<div class="d-flex flex-column mb-10 fv-row">
												<label class="fs-2 fw-bold mb-2">@lang('layout.Message')</label>
												<textarea class="form-control form-control-solid" rows="2" name="message" v-validate="'required'" data-vv-as="@lang('layout.Message')" placeholder="@lang('layout.Message')"></textarea>
												<span class="required">@{{ errors.first('message') }}</span>
											</div>
											<!--end::Input group-->
											<!--begin::Submit-->
											<button type="button" class="btn btn-lg btn-outline border-2 btn-outline-white flex-shrink-0" @click="saveAndNew($event)">
												<!--begin::Indicator-->
												<span class="indicator-label">@lang('layout.SendMessage')</span>
												<!--end::Indicator-->
											</button>
											<!--end::Submit-->
											{!! Form::close() !!}
											<!--end::Form-->
										</div>
										<!--end::Col-->
									</div>
									<!--end::Content-->
								</div>
								<!--end::Highlight-->

								<div class="card card-custom">
									<!--begin::Row-->
									<h3 class="fs-2hx text-dark ml-10 mr-10 mt-7 " id="comments" data-kt-scroll-offset="{default: 125, lg: 150}">@lang('menu.Comment')</h3>
									<div class="row card-body g-lg-10 mb-10 mb-lg-20">
										<!--begin::Col-->
										<div class="col-lg-4 mb-10" v-for="(item,index) in coment">
											<!--begin::Testimonial-->
											<div class="d-flex flex-column justify-content-between h-lg-100 px-10 px-lg-0 pe-lg-10 mb-15 mb-lg-0">
												<!--begin::Wrapper-->
												<div class="mb-7">
													<!--begin::Rating-->
													<div class="rating mb-6">
														<!-- <div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div>
												<div class="rating-label me-2 checked">
													<i class="bi bi-star-fill fs-5"></i>
												</div> -->
													</div>
													<!--end::Rating-->
													<!--begin::Title-->
													<!-- <div class="fs-2 fw-bolder text-dark mb-3">This is by far the cleanest template
												<br />and the most well structured</div> -->
													<!--end::Title-->
													<!--begin::Feedback-->
													<div class="text-gray-500 fw-bold fs-4">
														<a href="#" class="text-dark fw-bolder text-hover-primary fs-6">@{{item.description}}</div>
													<!--end::Feedback-->
												</div>
												<!--end::Wrapper-->
												<!--begin::Author-->
												<div class="d-flex align-items-center">
													<!--begin::Avatar-->
													<div class="symbol symbol-circle symbol-50px me-5 pl-3 pr-3">
														<img src="{{url('online/assets/media/avatars/blank.png')}}" class="" alt="" />
													</div>
													<!--end::Avatar-->
													<!--begin::Name-->
													<div class="flex-grow-1">
														<a href="#" class="text-dark fw-bolder text-hover-primary fs-6">@{{item.user_name}}</a>
														<span class="text-muted d-block fw-bold"></span>
													</div>
													<!--end::Name-->
												</div>
												<!--end::Author-->
											</div>
											<!--end::Testimonial-->
										</div>
										<!--end::Col-->
									</div>
									<!--end::Row-->
								</div>
							</div>

						</div>
						<!--end::Content-->
					</div>
					<!--end::Section-->
				</div>
				<!--end::Layout-->
				<div class="" style="padding-left: 2px; padding-right: 2px;" id="left_adver" >
					@if( onlineSystemConfig()['advertisment'] == 1)
					<!-- <a :href="link" target="_blank" >
						<img :alt="title" :title="title" :src="image" width="100%" />
					</a> -->
					@endif
				</div>
			</div>
			<!--end::Page Layout-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Entry-->
</div>
<!--end::Content-->
@endsection

@push('scripts')
<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->

<?php

    $company_number =  null;
    $site_link =  null;

    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>

<script type="text/javascript">
	@if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

	var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";

	function getAdvertisment(com_num, type, loc) {
        // console.log(12,uploads_adve);
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
				data:{session_id:session_id,url:url},
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'left') {
                                left_adver.image = uploads_adve+'/uploads/'+result.image;
                                left_adver.link = result.link;
                                left_adver.title = result.title;
                            }
                        }
                    }
                    // console.log(130,result);
                },
                error: function(error) {
                    console.log(140,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        }
    }

    // $(document).ready(function () {
    //     getAdvertisment(1, 'top');
    // });

	var uploads_adve = '{{$site_link}}';
    
    var top_adver = new Vue({
        el: '#top_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 4, 'top'); 
            }
        },
        methods: {
        }
    });    

    var left_adver = new Vue({
        el: '#left_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 4, 'left'); 
            }
        },
        methods: {
        }
    });

	var v = new Vue({
		el: '#contact_form',
		data: {
			part: '',
			coment: [],
		},
		computed: {
			setRates() {}
		},
		mounted: function() {
			this.getComent();
		},
		methods: {
			getComent() {
				// console.log(222222221);
				axios.get("{{route('comment.home')}}", {
						params: {
							category: 'home'
						}
					})
					.then(function(response) {
						if (response.data.length > 0) {
							v.coment = [];
							v.coment = response.data;
						}
						// console.log(222, response.data);
					})
					.catch(function(error) {
						console.log(error);
					});
			},
			saveAndNew() {
				this.$validator.validate()
					.then(valid => {
						if (valid) {
							console.log('sss11', valid);
							var url = "{{route('comment.store')}}";
							form_id = 'comment-form';
							var data = $('#' + form_id).serialize();
							// toggleBlock(true);
							axios.post(url, data)
								.then(function(response) {
									// toggleBlock(0);
									console.log('sss11', response.data);
									if (response.data.result == 1) {
										$('#' + form_id).trigger('reset');
										//$('#success-sound')[0].play();
										toastr.success('', response.data.message);

									} else {
										var message = "{{__('message.Warning')}}";
										//$('#error-sound')[0].play();
										toastr.warning('', message);
									}
								})
								.catch(function(error) {
									// toggleBlock(0);
									console.log(error);
									var message = "{{__('message.Warning')}}";
									//$('#error-sound')[0].play();
									toastr.warning('', message);
								});

						}
					})
			},
		},
		created: function() {

		}

	});
</script>

@endpush