@extends('online.masters.app')
@section('style')
<style>
	body {
		font-family: Arial, sans-serif;
		direction: rtl;
	}
	table {
		width: 100%;
		border-collapse: collapse;
		margin: 20px 0;
	}
	th, td {
		border: 1px solid #ddd;
		padding: 8px;
		text-align: right;
	}
	th {
		background-color: #f2f2f2;
	}
</style>
@endsection
@section('content')
    <!-- Page content -->
    <main class="content-wrapper">
		<div class="container py-5 mt-n2 mt-sm-0">
		  <div class="row pt-md-2 pt-lg-3 pb-sm-2 pb-md-3 pb-lg-4 pb-xl-5">
			<aside class="col-lg-3">
			  <div class="offcanvas-lg offcanvas-start pe-lg-0 pe-xl-4" id="accountSidebar">
				<div class="offcanvas-header d-lg-block py-3 p-lg-0">
				  <div class="d-flex align-items-center">
					<div class="d-flex justify-content-center align-items-center flex-shrink-0 text-primary bg-primary-subtle lh-1 rounded-circle mb-0" style="width: 3rem; height: 3rem">
						@if(session()->get('online_user')['photo'])
						<img src="{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}" loading="lazy" style="width: 100%; border-radius: 50%;" alt="" />
						@else
						<img src="{{url('/online/assets/media/avatars/blank.png')}}" style="width: 100%; border-radius: 50%;" loading="lazy" alt="" />
						@endif
					</div>
					<div class="min-w-0 ps-3">
					  <h5 class="h6 mb-1">{{session()->get('online_user')['name']}} {{session()->get('online_user')['last_name']}}</h5>
					  <div class="nav flex-nowrap text-nowrap min-w-0">
						<a class="nav-link animate-underline text-body p-0" href="#bonusesModal" data-bs-toggle="modal">
							<span class="animate-target me-1">{{session()->get('online_user')['email']}}</span>
						</a>
					  </div>
					</div>
				  </div>
				  <button type="button" class="btn-close d-lg-none" data-bs-dismiss="offcanvas" data-bs-target="#accountSidebar" aria-label="Close"></button>
				</div>
				<div class="offcanvas-body d-block pt-2 pt-lg-4 pb-lg-0">
				  <nav class="list-group list-group-borderless">
					<a class="list-group-item list-group-item-action d-flex align-items-center active" href="{{route('online.users.show',session()->get('online_user')['id'])}}">
					  <i class="ci-credit-card fs-base opacity-75 me-2"></i>
					  @lang('layout.MyProfile')
					</a>
					<a class="list-group-item list-group-item-action d-flex align-items-center" href="{{route('online.personal.information',session()->get('online_user')['id'])}}">
						<i class="ci-user fs-base opacity-75 me-2"></i>
						@lang('layout.PersonalInfo')
					</a>
					<a class="list-group-item list-group-item-action d-flex align-items-center" href="{{route('online.logout')}}">
						<i class="ci-log-out fs-base opacity-75 me-2"></i>
						@lang('layout.Logout')
					</a>
				  </nav>
				</div>
			  </div>
			</aside>
			<div class="col-lg-9">
			  <div class="ps-lg-3 ps-xl-0">
				@if(count($last_order)>0)
				<div class="row align-items-center p-3 pb-md-4 mb-md-1 mb-lg-2 border" style="border-radius: 7px;">
					<div class="col-md-12 col-xl-12 mb-3 mb-md-0">
						<h3 class="h4 me-3 mb-0 text-center mb-5">@lang('layout.Cart')</h3>
					</div>
					<table class="table position-relative z-2 mb-4">
						<thead>
							<tr>
								<th scope="col" class="ps-0" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">#</span></th>
								<th scope="col" class="ps-0" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Items')</span></th>
								<th scope="col" class="text-body  d-none d-xl-table-cell" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Quantity')</span></th>
								<th scope="col" class="text-body  d-none d-md-table-cell" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.UnitPrice')</span></th>
								<th scope="col" class="text-body  d-none d-md-table-cell" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Amount')</span></th>
							</tr>
						</thead>
						<tbody class="align-middle">
							<?php 
								$total = 0;
								$currency = null;
								$count = 0;
							?>
							
							@foreach($last_order AS $record)
							<?php 
								$total += ($record->price * $record->quantity);
								$currency = $record->currency;
							?>
						<!-- Item -->
						<tr>
							<td class="h6 d-xl-table-cell" style="padding: 0px !important; margin: 0px !important;">{{++$count}}</td>
							<td style="padding: 0px !important; margin: 0px !important;">
								<div class="d-flex align-items-center">
								<a class="position-relative flex-shrink-0">
									@if($record->image)
									<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" id="imageElement{{$record->id}}" width="50" loading="lazy" alt="Thumbnail" onclick="openFullscreen('imageElement{{$record->id}}')" style="cursor: zoom-in">
									@else
									<img src="{{asset('uploads/online_item/product.png')}}" id="imageElement{{$record->id}}" width="50" loading="lazy" alt="Thumbnail" onclick="openFullscreen('imageElement{{$record->id}}')" style="cursor: zoom-in">
									@endif
								</a>
								<div class="ps-2 ps-xl-3">
									<h5 class="lh-sm mb-2">
									<a class="hover-effect-underline fs-sm fw-medium">{{$record->name}}</a>
									</h5>
								</div>
								</div>
							</td>
							<td class="h6 d-none d-xl-table-cell" style="padding: 0px !important; margin: 0px !important;">{{$record->quantity}}</td>
							<td class="d-none d-md-table-cell" style="padding: 0px !important; margin: 0px !important;">{{$record->price}}  {{$record->currency}}</td>
							<td class="h6 py-3 d-none d-md-table-cell" style="padding: 0px !important; margin: 0px !important;">{{round(($record->price * $record->quantity),2)}} {{$record->currency}}</td>
						</tr>
						@endforeach
						
						</tbody>
					</table>
				  	<div class="offcanvas-footer">
						<div class="d-flex align-items-center justify-content-between m-2">
							<span class="text-muted font-size-sm mr-2" style="font-weight: bold;">@lang('layout.Total')</span>
							<span class="text-right" style="margin-left: 8em;text-decoration: underline; text-underline-position: below;font-weight: bold;"> {{$total}}  {{$currency}} </span>
						</div>
						<div class="text-right mt-1 text-center">
							<a href="{{route('online.ItemOrderDetails',$user->id)}}" class="btn btn-primary btn-sm text-weight-bold">@lang('layout.Submit')</a>
						</div>
					</div>
				</div>
				@endif
				<div class="row align-items-center p-3 pb-md-4 mb-md-1 mb-lg-2 border" style="border-radius: 7px;">
					<div class="col-md-12 col-xl-12 mb-3 mb-md-0">
						<h3 class="h4 me-3 mb-0 text-center mb-3">@lang('layout.AcceptedOrders')</h3>
					</div>
					<table class="table table-hover table-checkable" id="accepted_order_list" style="margin-top: 13px !important">
						<thead>
							<tr>
								<th class="sorting">@lang('layout.Number')</th>
								<th class="sorting text-center">@lang('layout.Date')</th>
								<th class="sorting text-center">@lang('layout.Currency')</th>
								<th class="sorting text-center">@lang('layout.Amount')</th>
								<th class="sorting_disabled text-center">@lang('layout.DeliveryDate')</th>
								<th class="sorting_disabled text-center">@lang('layout.Status')</th>
								<th class="sorting_disabled text-center">@lang('layout.Actions')</th>
							</tr>
						</thead>
					</table>
				</div>
				<div class="row align-items-center p-3 pb-md-4 mb-md-1 mb-lg-2 border" style="border-radius: 7px;">
					<div class="col-md-12 col-xl-12 mb-3 mb-md-0">
						<h3 class="h4 me-3 mb-0 text-center mb-3">@lang('layout.AllOrders')</h3>
					</div>
					<table class="table table-hover table-checkable" id="order_list">
						<thead>
							<tr>
								<th class="sorting">@lang('layout.Number')</th>
								<th class="sorting">@lang('layout.Date')</th>
								<th class="sorting">@lang('layout.Currency')</th>
								<th class="sorting">@lang('layout.Amount')</th>
								<th class="sorting_disabled ">@lang('layout.DeliveryDate')</th>
								<th class="sorting_disabled ">@lang('layout.Status')</th>
								<th class="sorting_disabled ">@lang('layout.Actions')</th>
							</tr>
						</thead>
					</table>
				</div>
			  </div>
			</div>
		  </div>
		</div>
	</main>
@endsection
@push('scripts')
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<script>
    $(document).ready(function() {
        $('#order_list').DataTable({
			ajax: {
				url: '{{route("online.users.show",$user->id)}}',
				data: {type: 'all'}
			},
			pageLength:'10',
            scrollCollapse: true,
            serverSide: true,
            paging:         true,
            pagingType:'full_numbers',
			order: [["0", "desc"]],
            responsive:true,
            columns: [
				{ data: 'number', name: 'number' },
				{ data: 'date', name: 'date'},
				{ data: 'currency', name: 'currency'},
				{ data: 'amount', name: 'amount'},
				{ data: 'delivery_date', name: 'delivery_date' },
				{ data: 'status', name: 'status'},
				{ data: 'action', name: 'action' ,orderable:false,searchable:false },
            ]
        });
    });
    $(document).ready(function() {
        $('#accepted_order_list').DataTable({
			ajax: {
				url: '{{route("online.users.show",$user->id)}}',
				data: {type: 'accept'}
			},
			pageLength:'10',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            pagingType:'full_numbers',
			order: [["0", "desc"]],
            responsive:true,
            columns: [
            { data: 'number', name: 'number'},
            { data: 'date', name: 'date'},
            { data: 'currency', name: 'currency'},
            { data: 'amount', name: 'amount'},
            { data: 'delivery_date', name: 'delivery_date'},
            { data: 'status', name: 'status' },
            { data: 'action', name: 'action' },
            ]
        });
    });
	function openFullscreen(imageId){
		var imageElement = document.getElementById(imageId);
		if(imageElement.requestFullscreen){
			imageElement.requestFullscreen();
		}
		else if(imageElement.mozRequestFullScreen){
			imageElement.mozRequestFullScreen();
		}
		else if(imageElement.webkitRequestFullscreen){
			imageElement.webkitRequestFullscreen();
		}
		else if(imageElement.msRequestFullscreen){
			imageElement.msRequestFullscreen();
		}
	}
</script>
@endpush