@extends('online.masters.app')
{{-- @section('style') --}}
<style>
	.image-input {
  position: relative;
  display: inline-block;
  border-radius: 0.42rem;
  background-repeat: no-repeat;
  background-size: cover;
}
.image-input .image-input-wrapper {
  width: 120px;
  height: 120px;
  border-radius: 0.42rem;
  background-repeat: no-repeat;
  background-size: cover;
}
.image-input [data-action=change] {
  cursor: pointer;
  position: absolute;
  right: -10px;
  top: -10px;
}
.image-input [data-action=change] input {
  width: 0 !important;
  height: 0 !important;
  overflow: hidden;
  opacity: 0;
}
.image-input [data-action=cancel],
.image-input [data-action=remove] {
  position: absolute;
  right: -10px;
  bottom: -5px;
}
.image-input [data-action=cancel] {
  display: none;
}
.image-input.image-input-changed [data-action=cancel] {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
}
.image-input.image-input-changed [data-action=remove] {
  display: none;
}
.image-input.image-input-empty [data-action=remove],
.image-input.image-input-empty [data-action=cancel] {
  display: none;
}
.image-input.image-input-circle {
  border-radius: 50%;
}
.image-input.image-input-circle .image-input-wrapper {
  border-radius: 50%;
}
.image-input.image-input-circle [data-action=change] {
  right: 5px;
  top: 5px;
}
.image-input.image-input-circle [data-action=cancel],
.image-input.image-input-circle [data-action=remove] {
  right: 5px;
  bottom: 5px;
}
.image-input.image-input-outline .image-input-wrapper {
  border: 3px solid #ffffff;
  -webkit-box-shadow: 0 0.5rem 1.5rem 0.5rem rgba(0, 0, 0, 0.075);
  box-shadow: 0 0.5rem 1.5rem 0.5rem rgba(0, 0, 0, 0.075);
}

</style>
{{-- @endsection --}}
@section('content')
<!-- Page content -->
<main class="content-wrapper">
	<div class="container py-5 mt-n2 mt-sm-0">
	  <div class="row pt-md-2 pt-lg-3 pb-sm-2 pb-md-3 pb-lg-4 pb-xl-5">
		<!-- Sidebar navigation that turns into offcanvas on screens < 992px wide (lg breakpoint) -->
		<aside class="col-lg-3">
		  <div class="offcanvas-lg offcanvas-start pe-lg-0 pe-xl-4" id="accountSidebar">
			<!-- Header -->
			<div class="offcanvas-header d-lg-block py-3 p-lg-0">
			  <div class="d-flex align-items-center">
				<div class="d-flex justify-content-center align-items-center flex-shrink-0 text-primary bg-primary-subtle lh-1 rounded-circle mb-0" style="width: 3rem; height: 3rem">
					@if(session()->get('online_user')['photo'])
					{{-- <div class="symbol-label" style="background-image:url('{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}')"></div> --}}
					<img src="{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}" style="width: 100%; border-radius: 50%;" alt="" />
					@else
					{{-- <div class="symbol-label" style="background-image:url('{{url('/online/assets/media/avatars/blank.png')}}')"></div> --}}
					<img src="{{url('/online/assets/media/avatars/blank.png')}}" style="width: 100%; border-radius: 50%;" alt="" />
					@endif
					{{-- <i class="ci-spotify"></i> --}}
				</div>
				<div class="min-w-0 ps-3">
				  <h5 class="h6 mb-1">{{session()->get('online_user')['name']}} {{session()->get('online_user')['last_name']}}</h5>
				  <div class="nav flex-nowrap text-nowrap min-w-0">
					<a class="nav-link animate-underline text-body p-0" href="#bonusesModal" data-bs-toggle="modal">
						<span class="animate-target me-1">{{session()->get('online_user')['email']}}</span>
					</a>
				  </div>
				</div>
			  </div>
			  <button type="button" class="btn-close d-lg-none" data-bs-dismiss="offcanvas" data-bs-target="#accountSidebar" aria-label="Close"></button>
			</div>
			<!-- Body (Navigation) -->
			<div class="offcanvas-body d-block pt-2 pt-lg-4 pb-lg-0">
			  <nav class="list-group list-group-borderless">
				<a class="list-group-item list-group-item-action d-flex align-items-center" href="{{route('online.users.show',session()->get('online_user')['id'])}}">
				  <i class="ci-credit-card fs-base opacity-75 me-2"></i>
				  @lang('layout.MyProfile')
				</a>
				<a class="list-group-item list-group-item-action d-flex align-items-center active" href="{{route('online.personal.information',session()->get('online_user')['id'])}}">
					<i class="ci-user fs-base opacity-75 me-2"></i>
					@lang('layout.PersonalInfo')
				</a>
				<a class="list-group-item list-group-item-action d-flex align-items-center" href="{{route('online.logout')}}">
					<i class="ci-log-out fs-base opacity-75 me-2"></i>
					@lang('layout.Logout')
				</a>
			  </nav>
			</div>
		  </div>
		</aside>
		<!-- Orders content -->
		<div class="col-lg-9">
			<div class="bg-body rounded-5 py-sm-4 px-sm-5 border">
                <!-- Customers form -->
                <div class="tab-pane fade show active" id="customers" role="tabpanel">
					<h4 class="text-center mb-4">@lang('layout.PersonalInfo')</h4>
					{!! Form::model($user, ['method' => 'PATCH','route' => ['online.users.update',$user->id],'class'=>'form needs-validation','id'=>'personal-form','files'=> true,'novalidate'=>'']) !!}
					{{-- <form class="needs-validation" novalidate=""> --}}
						<div class="row g-3">
							<div class="col-md-6 position-relative">
								<label for="fn" class="form-label">@lang('layout.Name')</label>
								<input type="text" class="form-control form-control-lg" type="text" name="fname" value="{{$user->fname}}" required>
							</div>
							<div class="col-md-6 position-relative">
								<label for="ln" class="form-label">@lang('layout.LastName')</label>
								<input type="text" class="form-control form-control-lg" name="lname" value="{{$user->lname}}">
							</div>
							<div class="col-md-6 position-relative">
								<label for="ln" class="form-label">@lang('layout.Phone')</label>
								<input type="text" class="form-control form-control-lg" name="phone" value="{{$user->phone}}" data-input-format="{&quot;numericOnly&quot;: true, &quot;delimiters&quot;: [&quot;+1 &quot;, &quot; &quot;, &quot; &quot;], &quot;blocks&quot;: [0, 3, 3, 2]}" placeholder="+93 ___ ___ __">
							</div>
							<div class="col-md-6 position-relative">
								<label for="email" class="form-label">@lang('layout.Email')</label>
								<input type="text" class="form-control form-control-lg" name="email" value="{{$user->email}}" placeholder="@lang('layout.Email')">
							</div>
							<div class="col-md-6">
								<label for="phone" class="form-label">@lang('layout.CurrentPassword')</label>
								<input class="form-control form-control-lg" type="password" name="current_password" value="" placeholder="@lang('layout.CurrentPassword')">
								<a href="{{ route('online.reset') }}" class="text-sm font-weight-bold">@lang('layout.ForgotYourPassword')</a>
							</div>
							<div class="col-md-6 position-relative">
								<label class="form-label">@lang('layout.NewPassword')</label>
								<input class="form-control form-control-lg" type="password" name="new_password" value="" placeholder="@lang('layout.NewPassword')">
							</div>
							<div class="col-md-6 position-relative">
								<label class="form-label">@lang('layout.ConfirmPassword')</label>
								<input class="form-control form-control-lg" type="password" name="confirm_password" value="" placeholder="@lang('layout.ConfirmPassword')">
							</div>
							<div class="col-md-6 position-relative">
								<label class="col-xl-3 col-lg-3 col-form-label">@lang('layout.Photo')</label>
								<div class="col-lg-12 col-xl-12">
									<div class="image-input image-input-outline" id="kt_profile_avatar" style="background-image: url({{url('/online/assets/media/avatars/blank.png')}})">
										<div class="image-input-wrapper" style="background-image: url('{{url('/uploads/online_users/'.$user->photo)}}')"></div>
										<label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
											<i class="ci-edit-3 icon-sm text-muted" style="background: transparent;padding:10px;border-radius: 50%;border: 1px solid black;"></i>
											<input type="file" name="image" accept=".png, .jpg, .jpeg" />
											<input type="hidden" name="profile_avatar_remove" />
										</label>
										<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="Cancel avatar">
											<i class="ci-x icon-xs text-muted"></i>
										</span>
										<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="remove" data-toggle="tooltip" title="Remove avatar">
											<i class="ci-close" style="background: transparent;padding:10px;border-radius: 50%;border: 1px solid black;"></i>
										</span>
									</div>
									<input name="image1" type="hidden" value="{{$user->photo}}" >
									<span class="form-text text-muted">@lang('layout.AllowedFileTypes'): png, jpg, jpeg.</span>
								</div>
							</div>
							<div class="col-12 text-center pt-2 pb-3">
								<button type="submit" class="btn btn-dark">@lang('layout.Update')</button>
								<a href="{{route('online.users.show',session()->get('online_user')['id'])}}" class="btn btn-secondary">@lang('layout.Cancel')</a>
							</div>
						</div>
					{{-- </form> --}}
					{!! Form::close() !!}
                </div>
              </div>
		</div>
	  </div>
	</div>
</main>
@endsection
@push('scripts')
<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->
    <script type="text/javascript">
		@if(App::getLocale())
		Vue.use(VeeValidate, {
			locale: '{{App::getLocale()}}',
		});
		@else
		Vue.use(VeeValidate, {
			locale: 'en',
		});
		@endif
		var a = '';
        // Vue.component('v-select', VueSelect.VueSelect);
		var v = new Vue({
        el: '#app',
        data: {
            disabled: false
        },
        methods: {
			handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        document.getElementById("personal-form").submit()
                    }
                });
            },
        },

    });
	</script>
@endpush