@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop


@section('content')


    <div class="row">
        <div class="portlet light bordered sale">
            <!-- BEGIN TAB PORTLET-->
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditUser')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div  class="portlet-body">
                        {!! Form::model($user, ['method' => 'PATCH','route' => ['users.update', $user->id]]) !!}
                        <div class="row"  id="app">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Name'):</label>
                                    {!! Form::text('name', null, array('placeholder' => __('layout.Name'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Email'):</label>
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ResetPasswordEmail'):</label>
                                    {!! Form::text('reset_password_email', null, array('placeholder' => __('layout.ResetPasswordEmail'),'class' => 'form-control','v-validate' =>'"email"','data-vv-as' => __('layout.ResetPasswordEmail'))) !!}
                                    <span class="required">@{{ errors.first('reset_password_email') }}</span>
                                </div>
                            </div> 
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Language'):</label>
                                    {!! Form::select('lang', ['en' => 'English', 'fa' => 'Persian','pa' =>'Pashto'],null,array('class' => 'form-control'))!!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Password'):</label>
                                    {!! Form::password('password', array('placeholder' =>__('layout.Password'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ConfirmPassword'):</label>
                                    {!! Form::password('confirm-password', array('placeholder' => __('layout.ConfirmPassword'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Role'):</label>
                                    {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'role')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('menu.Backups'):</label>
                                    {!! Form::select('backup', ['yes' => __('layout.yes'), 'no' => __('layout.Not')],null,array('class' => 'form-control'))!!}
                                    <span class="required"></span>

                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.UserType'):</label>
                                    {!! Form::select('user_type', ['admin' => __('layout.Admin'),'user' => __('layout.User')],null,array('class' => 'form-control'))!!}
                                    <span class="required"></span>

                                </div>
                            </div>


                            <h3>@lang('layout.AccessTime')</h3>
                            <div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.On'): 
                                            <input type="checkbox" class="form-control" name="time" v-model="time" >
                                             </label>

                                    </div>
                                </div>
                                <div v-if="time">
                                    <div class="col-md-3">


                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Start'):</label>
                                            <div class="input-group">
                                                <input type="time" class="form-control" name="start_time" value="{{$user->start_time}}">
                                                <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">


                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.End'):</label>

                                            <div class="input-group">
                                                <input type="time" class="form-control" name="end_time" value="{{$user->end_time}}">
                                                <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                <a href="{{route('users.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            </div>
                        </div>
                        {!! Form::close() !!}
                </div>

            </div>
    </div>
@endsection

@push('scripts')

    @push('scripts')

    <script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
        <script>
            
            @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
            Vue.use(VeeValidate, {
                locale: 'en',
            });
            @endif

            var checked  = {!! $checked !!};
            new Vue({

                el: "#app",
                data: {
                    time: checked,
                }


            });
            

            $('#role').multiselect({
                placeholder: "@lang('layout.SelectRole')"
            });
          

        </script>
        
    @endpush