<!DOCTYPE html><html lang="en" data-bs-theme="light" data-pwa="true">
<head>
    <meta charset="utf-8">
    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO Meta Tags -->
    <title>{{onlineSystemConfig()['name']}}</title>
    <meta name="description" content="Cartzilla - Multipurpose Bootstrap E-Commerce HTML Template">
    <meta name="keywords" content="online shop, e-commerce, online store, market, multipurpose, product landing, cart, checkout, ui kit, light and dark mode, bootstrap, html5, css3, javascript, gallery, slider, mobile, pwa">
    <meta name="author" content="Createx Studio">
	  {{-- sidebar top icon start  --}}
	  @if(session()->get('online_system_config'))
    	<link rel="shortcut icon" href="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" />
    @else
    	<link rel="shortcut icon" href="{{url('/online/assets/logo/logo1.png')}}" />
    @endif
	  {{-- sidebar top icon end --}}
    <!-- Webmanifest + Favicon / App icons -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <link rel="manifest" href="manifest.json">
    <!-- Theme switcher (color modes) -->
    <script src="{{asset('online/onlineAssets/js/theme-switcher.js')}}"></script>
    <link rel="preload" href="{{asset('online/onlineAssets/fonts/inter-variable-latin.woff2')}}" as="font" type="font/woff2" crossorigin="">
    <link rel="preload" href="{{asset('online/onlineAssets/icons/cartzilla-icons.woff2')}}" as="font" type="font/woff2" crossorigin="">
    <link rel="stylesheet" href="{{asset('online/onlineAssets/icons/cartzilla-icons.min.css')}}">
    <link rel="preload" href="{{asset('online/onlineAssets/css/theme.min.css')}}" as="style">
    <link rel="preload" href="{{asset('online/onlineAssets/css/theme.rtl.min.css')}}" as="style">
    <link rel="stylesheet" href="{{asset('online/onlineAssets/css/theme.min.css')}}" id="theme-styles">
    <script src="{{asset('online/onlineAssets/js/customizer.min.js')}}"></script>
  </head>
  <!-- Body -->
  <body>
    <!-- Customizer offcanvas -->
    <div class="offcanvas offcanvas-end" id="customizer" tabindex="-1">
      <div class="offcanvas-header border-bottom">
        <h4 class="h5 offcanvas-title">@lang('layout.CustomizeTheme')</h4>
        <button class="btn-close" type="button" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body">
        <!-- Customizer settings -->
        <div class="customizer-collapse collapse show" id="customizerSettings">
          <!-- Colors -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center mb-3">
              <i class="ci-paint text-body-tertiary fs-5 me-2"></i>
              <h5 class="fs-lg mb-0">@lang('layout.Colors')</h5>
            </div>
            <div class="row row-cols-2 g-3" id="theme-colors">
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Primary</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-primary" data-color-labels="[&quot;theme-primary&quot;, &quot;primary&quot;, &quot;primary-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#f55266">
                  <label for="primary" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #f55266"></label>
                  <input type="color" class="visually-hidden" id="primary" value="#f55266">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Success</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-success" data-color-labels="[&quot;theme-success&quot;, &quot;success&quot;, &quot;success-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#33b36b">
                  <label for="success" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #33b36b"></label>
                  <input type="color" class="visually-hidden" id="success" value="#33b36b">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Warning</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-warning" data-color-labels="[&quot;theme-warning&quot;, &quot;warning&quot;, &quot;warning-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#fc9231">
                  <label for="warning" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #fc9231"></label>
                  <input type="color" class="visually-hidden" id="warning" value="#fc9231">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Danger</h6>
                <div class="color-swatch d-flex border rounded gap-2 p-2" id="theme-danger" data-color-labels="[&quot;theme-danger&quot;, &quot;danger&quot;, &quot;danger-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#f03d3d">
                  <label for="danger" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #f03d3d"></label>
                  <input type="color" class="visually-hidden" id="danger" value="#f03d3d">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Info</h6>
                <div class="color-swatch d-flex border rounded gap-2 p-2" id="theme-info" data-color-labels="[&quot;theme-info&quot;, &quot;info&quot;, &quot;info-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#2f6ed5">
                  <label for="info" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #2f6ed5"></label>
                  <input type="color" class="visually-hidden" id="info" value="#2f6ed5">
                </div>
              </div>
            </div>
          </div>
          <!-- Direction -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
              <i class="ci-sort text-body-tertiary fs-lg me-2" style="transform: rotate(90deg)"></i>
              <h5 class="fs-lg mb-0">@lang('layout.PageDirection')</h5>
            </div>
            <div class="d-flex align-items-center justify-content-between border rounded p-3">
              <div class="me-3">
                <h6 class="mb-1">@lang('layout.RTL') || @lang('layout.LTR')</h6>
                <p class="fs-sm mb-0">@lang('layout.ChangeTextDirection')</p>
              </div>
              <div class="form-check form-switch m-0">
                <input type="checkbox" class="form-check-input" role="switch" id="rtl-switch">
              </div>
            </div>
          </div>
          <!-- Border width -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
              <i class="ci-menu text-body-tertiary fs-lg me-2"></i>
              <h5 class="fs-lg mb-0">@lang('layout.BorderWidth') , {px}</h5>
            </div>
            <div class="slider-input d-flex align-items-center gap-3 border rounded p-3" id="border-input">
              <input type="range" class="form-range" min="0" max="10" step="1" value="1">
              <input type="number" class="form-control" id="border-width" min="0" max="10" value="1" style="max-width: 5.5rem">
            </div>
          </div>
          <!-- Rounding -->
          <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
            <i class="ci-maximize text-body-tertiary fs-lg me-2"></i>
            <h5 class="fs-lg mb-0">@lang('layout.RoundingCards'), {rem}</h5>
          </div>
          <div class="slider-input d-flex align-items-center gap-3 border rounded p-3">
            <input type="range" class="form-range" min="0" max="5" step=".05" value="0.5">
            <input type="number" class="form-control" id="border-radius" min="0" max="5" step=".05" value="0.5" style="max-width: 5.5rem">
          </div>
        </div>
        <!-- Customizer code -->
        <div class="customizer-collapse collapse" id="customizerCode">
          <div class="nav mb-3">
            <a class="nav-link animate-underline fs-base p-0" href="{{route('/')}}" data-bs-toggle="collapse" aria-expanded="true" aria-controls="customizerSettings customizerCode">
              <i class="ci-chevron-left fs-lg ms-n1 me-1"></i>
              <span class="animate-target">@lang('layout.BackToSettings')</span>
            </a>
          </div>
          <div class="position-relative bg-body-tertiary rounded overflow-hidden pt-3">
            <div class="position-absolute top-0 start-0 w-100 p-3">
              <button type="button" class="btn btn-sm btn-outline-dark w-100" data-copy-text-from="#generated-styles" data-done-label="Code copied">
                <i class="ci-copy fs-sm me-1"></i>
                @lang('layout.CopyCode')
              </button>
            </div>
            <pre class="text-wrap bg-transparent border-0 fs-xs text-body-emphasis p-4 pt-5" id="generated-styles"></pre>
          </div>
        </div>
      </div>
      <!-- Offcanvas footer (Action buttons) -->
      <div class="offcanvas-header border-top gap-3 d-none" id="customizer-btns">
        <button type="button" class="btn btn-lg btn-secondary w-100 fs-sm" id="customizer-reset">
          <i class="ci-trash fs-lg me-2 ms-n1"></i>
          @lang('layout.Reset')
        </button>
        <button class="btn btn-lg btn-primary hiding-collapse-toggle w-100 fs-sm collapsed" type="button" data-bs-toggle="collapse" data-bs-target=".customizer-collapse" aria-expanded="false" aria-controls="customizerSettings customizerCode">
          <i class="ci-code fs-lg me-2 ms-n1"></i>
          @lang('layout.ShowCode')
        </button>
      </div>
    </div>
    <!-- Page content -->
    <main class="content-wrapper w-100 px-3 ps-lg-5 pe-lg-4 mx-auto" style="max-width: 1920px">
      <div class="d-lg-flex">
        <!-- Login form + Footer -->
        <div class="d-flex flex-column min-vh-100 w-100 py-4 mx-auto me-lg-5" style="max-width: 416px">
          <!-- Logo -->
          <header class="navbar px-0 mt-n2 mt-sm-0">
            <a href="{{route('/')}}" class="navbar-brand pt-0 text-center" style="width: 50%;margin: auto auto">
                @if(session()->get('online_system_config'))
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" />
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" />
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" />
                @else
                    <img alt="Logo" src="{{url('/online/assets/logo/logoA1.png')}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" />
                    <img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" />
                    <img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" />
                @endif
            </a>
          </header>
          @if (count($errors) > 0)
          <div class="alert alert-danger alert-dismissible fade show" role="alert" id="myAlert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <p class="error-title"><span>Whoops!</span> There are some problems with inputs</p>
            <ul class="error-body">
              @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
          @endif
          <h1 class="h2 mt-2 text-center">@lang('layout.CreatenewAccount')</h1>
          <div class="nav fs-sm d-flex justify-content-center">
            @lang('layout.AlreadyHaveAnAccount') 
            <a class="nav-link text-decoration-underline p-0 ms-2 fw-bold" href="{{route('online.login')}}">@lang('layout.SignIn')</a>
          </div>
          <!-- Form -->
          {{Form::open(['route' => 'online.users.store','method' => 'POST','class' => 'needs-validation','id'=>'kt_sign_up_form','novalidate' => ''])}}
          {{ csrf_field() }}
                <div class="position-relative mb-4">
                  <label for="name" class="form-label">@lang('layout.Name')</label>
                  <input type="text" class="form-control form-control-lg" required="" placeholder="" name="fname" autocomplete="off">
                  <div class="invalid-tooltip bg-transparent py-0">@lang('layout.EnterAValidName')!</div>
                </div>
                <div class="position-relative mb-4">
                  <label for="lastname" class="form-label">@lang('layout.LastName')</label>
                  <input type="text" class="form-control form-control-lg" required="" placeholder="" name="lname" autocomplete="off" >
                  <div class="invalid-tooltip bg-transparent py-0">@lang('layout.EnterAValidLastname')!</div>
                </div>
                <div class="position-relative mb-4">
                  <label for="register-email" class="form-label">@lang('layout.Email')</label>
                  <input type="email" id="email" class="form-control form-control-lg" required="" name="email" value="{{ old('email') }}" required autofocus autocomplete="off">
                  <div class="invalid-tooltip bg-transparent py-0">@lang('layout.EnterAValidEmailAddress')!</div>
                </div>
                <div class="mb-4">
                  <label for="register-password" class="form-label">@lang('layout.Password')</label>
                  <div class="password-toggle">
                    <input type="password" class="form-control form-control-lg" id="register-password" minlength="8" placeholder="@lang('layout.Minimum8Characters')" required="" autocomplete="off"
            name="password" required>
                    <div class="invalid-tooltip bg-transparent py-0">@lang('layout.PasswordDoesNotMeetTheRequiredCriteria')!</div>
                    <label class="password-toggle-button fs-lg" aria-label="Show/hide password">
                      <input type="checkbox" class="btn-check">
                    </label>
                  </div>
                </div>
                <div class="mb-4">
                  <label for="register-password" class="form-label">@lang('layout.ConfirmPassword')</label>
                  <div class="password-toggle">
                    <input type="password" class="form-control form-control-lg" id="register-password" minlength="8" placeholder="@lang('layout.Minimum8Characters')" required="" name="confirm-password" autocomplete="off">
                    <div class="invalid-tooltip bg-transparent py-0">@lang('layout.ConfirmPasswordDoesNotMatchWithPassword')!</div>
                    <label class="password-toggle-button fs-lg" aria-label="Show/hide password">
                      <input type="checkbox" class="btn-check">
                    </label>
                  </div>
                </div>
                <button type="submit" class="btn btn-lg btn-primary w-100">
            @lang('layout.Submit')
                  <i class="ci-chevron-right fs-lg ms-1 me-n1"></i>
                </button>
          {!! Form::close() !!}
          <!-- Footer -->
          <footer class="mt-auto">
            <p class="fs-xs mb-0 text-center">
              © <span id="currentDate"></span> @lang('layout.AllRightsReserved') <i class="ci-heart-filled text-danger align-middle"></i> <span class="animate-underline"><a class="animate-target text-muted text-decoration-none" href="#" target="_self" rel="noreferrer">CHACO</a></span>
            </p>
          </footer>
        </div>
        <!-- Benefits section that turns into offcanvas on screens < 992px wide (lg breakpoint) -->
        <div class="offcanvas-lg offcanvas-end w-100 py-lg-4 ms-auto" id="benefits" style="max-width: 1034px;">
          <div class="offcanvas-header justify-content-end position-relative z-2 p-3">
            <button type="button" class="btn btn-icon btn-outline-dark text-dark border-dark bg-transparent rounded-circle d-none-dark" data-bs-dismiss="offcanvas" data-bs-target="#benefits" aria-label="Close">
              <i class="ci-close fs-lg"></i>
            </button>
            <button type="button" class="btn btn-icon btn-outline-dark text-light border-light bg-transparent rounded-circle d-none d-inline-flex-dark" data-bs-dismiss="offcanvas" data-bs-target="#benefits" aria-label="Close">
              <i class="ci-close fs-lg"></i>
            </button>
          </div>
          <div class="position-absolute top-0 start-0 w-100 h-100 d-lg-none">
            <span class="position-absolute top-0 start-0 w-100 h-100 d-none-dark" style="background: linear-gradient(-90deg, #accbee 0%, #e7f0fd 100%)"></span>
            <span class="position-absolute top-0 start-0 w-100 h-100 d-none d-block-dark" style="background: linear-gradient(-90deg, #1b273a 0%, #1f2632 100%)"></span>
          </div>
          <div class="offcanvas-body position-relative z-2 d-lg-flex flex-column align-items-center justify-content-center h-100 pt-2 px-3 p-lg-0 rounded-5" style="background-image: url('{{asset('online/onlineAssets/img/2020.jpg')}}'); background-size: cover;">
            <div class="position-absolute top-0 start-0 w-100 h-100 d-none d-lg-block">
              {{-- <span class="position-absolute top-0 start-0 w-100 h-100 rounded-5 d-none-dark" style="background: linear-gradient(-90deg, #accbee 0%, #e7f0fd 100%)"></span>
              <span class="position-absolute top-0 start-0 w-100 h-100 rounded-5 d-none d-block-dark" style="background: linear-gradient(-90deg, #1b273a 0%, #1f2632 100%)"></span> --}}
            </div>
            <div class="position-relative z-2 w-100 text-center px-md-2 p-lg-5">
              <h2 class="h4 pb-3">{{onlineSystemConfig()['name']}}</h2>
              <div class="mx-auto" style="max-width: 790px">
                <div class="row row-cols-1 row-cols-sm-2 g-3 g-md-4 g-lg-3 g-xl-4">
                  <div class="col">
                    <div class="card h-100">
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white bg-opacity-25 border border-white border-opacity-50 rounded-4 d-none-dark"></span>
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white border rounded-4 d-none d-block-dark" style="--cz-bg-opacity: .05"></span>
                      <div class="card-body position-relative z-2">
                        <div class="d-inline-flex position-relative text-info p-3 border rounded-circle">
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-white rounded-pill d-none-dark"></span>
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-body-secondary rounded-pill d-none d-block-dark"></span>
                          <i class="ci-mail position-relative z-2 fs-4 m-1 text-muted"></i>
                        </div>
                        <h3 class="h6 pt-2 my-2">@lang('layout.SubscribeToYourFavoriteProducts')</h3>
                      </div>
                    </div>
                  </div>
                  <div class="col">
                    <div class="card h-100">
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white bg-opacity-25 border border-white border-opacity-50 rounded-4 d-none-dark"></span>
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white border rounded-4 d-none d-block-dark" style="--cz-bg-opacity: .05"></span>
                      <div class="card-body position-relative z-2">
                        <div class="d-inline-flex position-relative text-info p-3 border rounded-circle">
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-white rounded-pill d-none-dark"></span>
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-body-secondary rounded-pill d-none d-block-dark"></span>
                          <i class="ci-settings position-relative z-2 fs-4 m-1 text-muted"></i>
                        </div>
                        <h3 class="h6 pt-2 my-2">@lang('layout.ViewAndManageYourOrdersAndWishlist')</h3>
                      </div>
                    </div>
                  </div>
                  <div class="col">
                    <div class="card h-100">
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white bg-opacity-25 border border-white border-opacity-50 rounded-4 d-none-dark"></span>
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white border rounded-4 d-none d-block-dark" style="--cz-bg-opacity: .05"></span>
                      <div class="card-body position-relative z-2">
                        <div class="d-inline-flex position-relative text-info p-3 border rounded-circle">
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-white rounded-pill d-none-dark"></span>
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-body-secondary rounded-pill d-none d-block-dark"></span>
                          <i class="ci-heart position-relative z-2 fs-4 m-1 text-muted"></i>
                        </div>
                        <h3 class="h6 pt-2 my-2">@lang('layout.CreateWishlists')</h3>
                      </div>
                    </div>
                  </div>
                  <div class="col">
                    <div class="card h-100">
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white bg-opacity-25 border border-white border-opacity-50 rounded-4 d-none-dark"></span>
                      <span class="position-absolute top-0 start-0 w-100 h-100 bg-white border rounded-4 d-none d-block-dark" style="--cz-bg-opacity: .05"></span>
                      <div class="card-body position-relative z-2">
                        <div class="d-inline-flex position-relative text-info p-3 border rounded-circle">
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-white rounded-pill d-none-dark"></span>
                          <span class="position-absolute top-0 start-0 w-100 h-100 bg-body-secondary rounded-pill d-none d-block-dark"></span>
                          <i class="ci-pie-chart position-relative z-2 fs-4 m-1 text-muted"></i>
                        </div>
                        <h3 class="h6 pt-2 my-2">@lang('layout.PayForPurchasesAfterOrder')</h3>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </main>
    <div class="floating-buttons position-fixed top-50 end-0 z-sticky me-3 me-xl-4 pb-4">
      <a class="btn btn-sm btn-outline-secondary text-uppercase bg-body rounded-pill shadow animate-rotate ms-2 me-n5" href="#customizer" style="font-size: .625rem; letter-spacing: .05rem;" data-bs-toggle="offcanvas" role="button" aria-controls="customizer">
        @lang('layout.Customize')<i class="ci-settings fs-base ms-1 me-n2 animate-target"></i>
      </a>
    </div>
    <script src="{{asset('online/onlineAssets/js/theme.min.js')}}"></script>
	<script>
		setTimeout(function() {
			var alert = document.getElementById('myAlert');
			if(alert){
				var bsAlert = new bootstrap.Alert(alert);
				bsAlert.close();
			}
		}, 9000);
	</script>
</body>
</html>