<!DOCTYPE html><html lang="en" data-bs-theme="light" data-pwa="true">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
{{-- head include start here  --}}
@yield('styles')
<style> 
  .chat-input{
    display: flex;
    position: absolute;
    bottom: 0;
    right: 0;
    left: 0;
    align-items: center;
    min-height: 60px;
    max-height: 60px;
    border: none;
    border-radius: 16px 16px 0px 0px;
    color: white;
    background: rgb(117, 117, 117);
    box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
    backdrop-filter: blur(7.4px);
    -webkit-backdrop-filter: blur(7.4px);
  }
  #message-input{
    flex-grow: 1;
    padding: 10px;
    margin-left: 20px;
    margin-right: 5px;
    border: none;
    color: inherit;
    overflow-wrap: break-word;
    background-color: transparent;
    resize: none;
    outline: none;
    overflow: hidden;
  }
  #message-input:focus, #message-input:active{
    border: none;
    outline: none;
  }
  #message-input::placeholder{
    color: rgba(255, 255, 255, 0.8);
  }
  #send-button{
    padding: 5px 15px;
    background-color: transparent;
    border: none;
    color: white;
  }
  #send-button i{
    cursor: pointer;
    transition: color 0.3s ease;
  }
  #send-button i:hover{
    transform: scale(1.1);
    transition: 1s;
  }
  .scrollbar::-webkit-scrollbar{
    width: 7px;
    background-color: #fff;
  }
  .scrollbar::-webkit-scrollbar-thumb{
    background-color: #333;
    border-radius: 10px;
  }
  .scrollbar::-webkit-scrollbar-thumb:hover{
    background-color: #555;
  }
  #adminClass{
    display: flex;
    flex-direction: row-reverse;
  }
  iframe{
    border-radius: 8px;
    width: 100%; 
    height: 100%;
  }
</style>
@include('online.masters.admin.includes')
{{-- head include end here  --}}
  <!-- Body -->
  <body>
    <!-- Customizer offcanvas -->
    <div class="offcanvas offcanvas-end" id="customizer" tabindex="-1">
      <div class="offcanvas-header border-bottom">
        <h4 class="h5 offcanvas-title">@lang('layout.CustomizeTheme')</h4>
        <button class="btn-close" type="button" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body">
        <!-- Customizer settings -->
        <div class="customizer-collapse collapse show" id="customizerSettings">
          <!-- Colors -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center mb-3">
              <i class="ci-paint text-body-tertiary fs-5 me-2"></i>
              <h5 class="fs-lg mb-0">@lang('layout.Colors')</h5>
            </div>
            <div class="row row-cols-2 g-3" id="theme-colors">
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Primary</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-primary" data-color-labels="[&quot;theme-primary&quot;, &quot;primary&quot;, &quot;primary-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#f55266">
                  <label for="primary" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #f55266"></label>
                  <input type="color" class="visually-hidden" id="primary" value="#f55266">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Success</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-success" data-color-labels="[&quot;theme-success&quot;, &quot;success&quot;, &quot;success-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#33b36b">
                  <label for="success" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #33b36b"></label>
                  <input type="color" class="visually-hidden" id="success" value="#33b36b">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Warning</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-warning" data-color-labels="[&quot;theme-warning&quot;, &quot;warning&quot;, &quot;warning-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#fc9231">
                  <label for="warning" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #fc9231"></label>
                  <input type="color" class="visually-hidden" id="warning" value="#fc9231">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Danger</h6>
                <div class="color-swatch d-flex border rounded gap-2 p-2" id="theme-danger" data-color-labels="[&quot;theme-danger&quot;, &quot;danger&quot;, &quot;danger-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#f03d3d">
                  <label for="danger" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #f03d3d"></label>
                  <input type="color" class="visually-hidden" id="danger" value="#f03d3d">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Info</h6>
                <div class="color-swatch d-flex border rounded gap-2 p-2" id="theme-info" data-color-labels="[&quot;theme-info&quot;, &quot;info&quot;, &quot;info-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#2f6ed5">
                  <label for="info" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #2f6ed5"></label>
                  <input type="color" class="visually-hidden" id="info" value="#2f6ed5">
                </div>
              </div>
            </div>
          </div>
          <!-- Direction -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
              <i class="ci-sort text-body-tertiary fs-lg me-2" style="transform: rotate(90deg)"></i>
              <h5 class="fs-lg mb-0">@lang('layout.PageDirection')</h5>
            </div>
            <div class="d-flex align-items-center justify-content-between border rounded p-3">
              <div class="me-3">
                <h6 class="mb-1">@lang('layout.RTL')||@lang('layout.LTR')</h6>
                <p class="fs-sm mb-0">@lang('layout.ChangeTextDirection')</p>
              </div>
              <div class="form-check form-switch m-0">
                <input type="checkbox" class="form-check-input" role="switch" id="rtl-switch">
              </div>
            </div>
          </div>
          <!-- Border width -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
              <i class="ci-menu text-body-tertiary fs-lg me-2"></i>
              <h5 class="fs-lg mb-0">@lang('layout.BorderWidth') , {px}</h5>
            </div>
            <div class="slider-input d-flex align-items-center gap-3 border rounded p-3" id="border-input">
              <input type="range" class="form-range" min="0" max="10" step="1" value="1">
              <input type="number" class="form-control" id="border-width" min="0" max="10" value="1" style="max-width: 5.5rem">
            </div>
          </div>
          <!-- Rounding -->
          <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
            <i class="ci-maximize text-body-tertiary fs-lg me-2"></i>
            <h5 class="fs-lg mb-0">@lang('layout.RoundingCards'), {rem}</h5>
          </div>
          <div class="slider-input d-flex align-items-center gap-3 border rounded p-3">
            <input type="range" class="form-range" min="0" max="5" step=".05" value="0.5">
            <input type="number" class="form-control" id="border-radius" min="0" max="5" step=".05" value="0.5" style="max-width: 5.5rem">
          </div>
        </div>

        <!-- Customizer code -->
        <div class="customizer-collapse collapse" id="customizerCode">
          <div class="nav mb-3">
            <a class="nav-link animate-underline fs-base p-0" href="{{route('/')}}" data-bs-toggle="collapse" aria-expanded="true" aria-controls="customizerSettings customizerCode">
              <i class="ci-chevron-left fs-lg ms-n1 me-1"></i>
              <span class="animate-target">@lang('layout.BackToSettings')</span>
            </a>
          </div>
          <div class="position-relative bg-body-tertiary rounded overflow-hidden pt-3">
            <div class="position-absolute top-0 start-0 w-100 p-3">
              <button type="button" class="btn btn-sm btn-outline-dark w-100" data-copy-text-from="#generated-styles" data-done-label="Code copied">
                <i class="ci-copy fs-sm me-1"></i>
                @lang('layout.CopyCode')
              </button>
            </div>
            <pre class="text-wrap bg-transparent border-0 fs-xs text-body-emphasis p-4 pt-5" id="generated-styles"></pre>
          </div>
        </div>
      </div>
      <!-- Offcanvas footer (Action buttons) -->
      <div class="offcanvas-header border-top gap-3 d-none" id="customizer-btns">
        <button type="button" class="btn btn-lg btn-secondary w-100 fs-sm" id="customizer-reset">
          <i class="ci-trash fs-lg me-2 ms-n1"></i>
          @lang('layout.Reset')
        </button>
        <button class="btn btn-lg btn-primary hiding-collapse-toggle w-100 fs-sm collapsed" type="button" data-bs-toggle="collapse" data-bs-target=".customizer-collapse" aria-expanded="false" aria-controls="customizerSettings customizerCode">
          <i class="ci-code fs-lg me-2 ms-n1"></i>
          @lang('layout.ShowCode')
        </button>
      </div>
    </div>
    <!-- chat part offcanvas -->
    <div class="offcanvas offcanvas-end" id="chatpart" tabindex="-1" aria-labelledby="chatpart" style="width: 500px; overflow-y: auto;">
      <div>
        <!-- Header -->
        <div class="offcanvas-header flex-column align-items-start py-3 pt-lg-4">
          <div class="d-flex align-items-center justify-content-between w-100 mb-3 mb-lg-4">
            <h4 class="offcanvas-title" id="chatpart">@lang('layout.ChitChat')</h4>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
          </div>
        </div>
        <!-- Items -->
          <div id="kt_drawer_chat"  class="bg-white" data-kt-drawer="true" data-kt-drawer-name="chat" data-kt-drawer-activate="true" data-kt-drawer-overlay="true" data-kt-drawer-width="{default:'100%', 'md': '100%'}" data-kt-drawer-direction="end" data-kt-drawer-toggle="#kt_drawer_chat_toggle" data-kt-drawer-close="#kt_drawer_chat_close" style="overflow-x: hidden">
            <div class="w-100 p-2" id="kt_drawer_chat_messenger" >
              <div class="card-body p-3 rounded scrollbar" id="kt_drawer_chat_messenger_body" style="height: 83vh;overflow-y: auto; overflow-x: hidden;">
                <div class="scroll-y me-n5 pe-5" data-kt-element="messages" data-kt-scroll="true" data-kt-scroll-activate="true" data-kt-scroll-height="auto"  data-kt-scroll-dependencies="#kt_drawer_chat_messenger_header, #kt_drawer_chat_messenger_footer" data-kt-scroll-wrappers="#kt_drawer_chat_messenger_body" data-kt-scroll-offset="0px">
                  <div id="message_list_vue">
                  <div v-for="(row,index) in items" >
                    <div :class="'mb-10 justify-content-'+row.type">
                      <div :class="' align-items-'+row.type">

                        <div class="d-flex" id="userClass" v-if="row.type == 'end'">
                          <div style="width: 20%;display: flex; justify-content: center; align-items: center;">  
                            <div class="symbol symbol-35px symbol-circle" style="display: inline;width: 50%;">
                              <img :src="uploads+'/'+row.photo" v-if="row.photo" style="width: 100%;" alt="" />
                              <img :src="blank" v-if="!row.photo" style="width: 100%; border-radius: 50%;" alt="" />
                            </div>
                            <div class="" style="display: inline;width: 50%;">
                              <a href="#" class="text-hover-primary text-dark" id="endClass" v-if="row.type == 'end'">@{{(!row.fname)?user:row.fname}}</a>
                              <a href="#" class="startClass text-hover-primary" id="startClass" v-if="row.type == 'start'">@{{admin}}</a>
                            </div>
                          </div>
                          <div :class="'rounded bg-light-info p-2 text-dark fw-bold mw-lg-400px text-'+row.type" style="width: 70%;display: flex; flex-direction: column;" data-kt-element="message-text">
                            <span style="color: #fff;padding: 10px; background-color: #1f252bbd; border-radius: 10px 10px 0px 10px; margin: 0.15rem 0; max-width: 80%; word-wrap: break-word;text-align: justify; text-align-last: center;">@{{(!row)?null:row.massage}}</span>
                            <span class="text-muted mb-1 text-start">@{{(!row)?null:row.date}}</span></div>
                        </div>

                        <div class="d-flex" id="adminClass" v-if="row.type == 'start'">
                          <div style="width: 50%;display: flex; justify-content: center; align-items: center;">  
                            <div class="" style="display: inline;width: 50%;">
                              <a href="#" class="text-hover-primary text-dark" id="endClass" v-if="row.type == 'end'">@{{(!row.fname)?user:row.fname}}</a>
                              <a href="#" class="startClass text-hover-primary" id="startClass" v-if="row.type == 'start'">@{{admin}}</a>
                            </div>
                            <div class="symbol symbol-35px symbol-circle" style="display: inline;width: 50%;">
                              <img :src="uploads+'/'+row.photo" v-if="row.photo" style="width: 100%;" alt="" />
                              <img :src="blank" v-if="!row.photo" style="width: 50%; border-radius: 50%;" alt="" />
                            </div>
                            
                          </div>
                          <div :class="'rounded bg-light-info p-2 text-dark fw-bold mw-lg-400px text-'+row.type" style="width: 70%;display: flex; flex-direction: column;justify-content: start;align-items: flex-end" data-kt-element="message-text">
                            <span style="color: #fff;padding: 10px; background-color: #007bffbd; border-radius: 10px 10px 10px 0px; margin: 0.15rem 0; max-width: 80%; word-wrap: break-word;text-align: justify; text-align-last: center;">@{{(!row)?null:row.massage}}</span>
                            <span class="text-muted mb-1 text-end">@{{(!row)?null:row.date}}</span></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  </div>
                  <div class="d-flex justify-content-end mb-10 d-none heal" data-kt-element="template-out">
                    <div class="d-flex flex-column align-items-end">
                      <div class="d-flex align-items-center mb-2">
                        <div class="me-3">
                          <span class="text-muted fs-7 mb-1">@lang('layout.JustNow')</span>
                          <a href="#" class="fs-5 fw-bolder text-gray-900 text-hover-primary ms-1">
                          @if(session()->has('online_user'))
                          {{session()->get('online_user')['name']}}
                          @else
                          @lang('layout.You')
                          @endif
                          </a>
                        </div>
                        <div class="symbol symbol-35px symbol-circle">
                          @if(session()->has('online_user'))
                          @if(session()->get('online_user')['photo'])
                          <img src="{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}" alt="{{session()->get('online_user')['name']}}" />
                          @else
                          <img src="{{url('/online/assets/media/avatars/blank.png')}}" alt="{{session()->get('online_user')['name']}}" />
                          @endif
                          @else
                          <img src="{{url('/online/assets/media/avatars/blank.png')}}" alt="" />
                          @endif
                        </div>
                      </div>
                      <div class="p-5 rounded bg-light-primary text-dark fw-bold mw-lg-400px text-end" data-kt-element="message-text"></div>
                    </div>
                  </div>
                  <div class="d-flex justify-content-start mb-10 d-none" data-kt-element="template-in">
                    <div class="d-flex flex-column align-items-start">
                      <div class="d-flex align-items-center mb-2">
                        <div class="symbol symbol-35px symbol-circle">
                          <img src="{{url('/online/assets/media/avatars/blank.png')}}" alt="" />
                        </div>
                        <div class="ms-3">
                          <a href="#" class="fs-5 fw-bolder text-gray-900 text-hover-primary me-1">@lang('layout.UserSystem')</a>
                          <span class="text-muted fs-7 mb-1">@lang('layout.JustNow')</span>
                        </div>
                      </div>
                      <div class="p-5 rounded bg-light-info text-dark fw-bold mw-lg-400px text-start" data-kt-element="message-text">@lang('message.ThankYouForYourMessageSystemUserAnswerSoon')</div>
                    </div>
                  </div>
                </div>
              </div>
                <div class="chat-input mt-5">
                  <textarea class="form-control form-control-flush mb-3" id="message-input" rows="1" data-kt-element="input" placeholder="@lang('layout.Message')"></textarea>
                  <button id="send-button" class="btn btn-primary" type="button" data-kt-element="send"><i class="ci-send"></i></button>
                </div>
              {{-- </div> --}}
            </div>
          </div>
      </div>
    </div>
    <!-- Shopping Cart offcanvas -->
    <div class="offcanvas offcanvas-end pb-sm-2 px-sm-2" id="shoppingCart" tabindex="-1" aria-labelledby="shoppingCartLabel" style="width: 500px; overflow-y: auto;">
      <div id="order_list_vue">
        <!-- Header -->
        <div class="offcanvas-header flex-column align-items-start py-3 pt-lg-4">
          <div class="d-flex align-items-center justify-content-between w-100 mb-3 mb-lg-4">
            <h4 class="offcanvas-title" id="shoppingCartLabel">@lang('layout.Cart')</h4>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
          </div>
        </div>
        <!-- Items -->
        <div class="offcanvas-body d-flex flex-column gap-2">
          <!-- Item -->
          <div class="d-flex align-items-center border-bottom" v-if="items" v-for="(row,index) in items">
            <a class="position-relative flex-shrink-0" :href="uploads+'/'+row.image">
              {{-- <span class="badge text-bg-danger position-absolute top-0 start-0 z-2 mt-0 ms-0">-$2.79</span> --}}
              <img :src="uploads+'/'+row.image" width="110" alt="Thumbnail">
            </a>
            <div class="w-100">
              <div class="d-flex justify-content-between">
                <h5 class="fs-sm fw-medium lh-base mb-2">
                  <a :href="'{{url('item_details')}}/'+row.id" class="fs-6 text-gray-800 text-hover-primary fw-bolder">@{{(!row)?null:row.name}}</a>
                </h5>
                <div class="h6 pb-1 mb-2">
                  <span class="font-weight-bold me-2 text-dark-75 font-size-lg">@{{(!row)?null:row.quantity}}</span>
                </div>
                <div class="h6 pb-1 mb-2">
                  <span class="font-weight-bold me-1 text-dark-75 font-size-lg"> @{{(!row)?null:row.price}} @{{(!row)?null:row.currency}} </span>
                </div>
                <div class="h6 pb-1 mb-2">
                  <span class="font-weight-bold me-1 text-dark-75 font-size-lg"> @{{row.price * row.quantity}} @{{(!row)?null:row.currency}} </span>
                </div>

              </div>
              <div>
                <div class="d-flex align-items-center justify-content-between">
                  <div class="count-input">
                    <button type="button" @click="Order_plus(row.id, 'minus')" class="btn btn-icon btn-sm" aria-label="Decrement quantity">
                      <i class="ci-minus"></i>
                    </button>
                    <input type="number" class="form-control form-control-sm" :value="(!row)?null:row.quantity" readonly="">
                    <button type="button" @click="Order_plus(row.id, 'plus')" class="btn btn-icon btn-sm" data-increment="" aria-label="Increment quantity">
                      <i class="ci-plus"></i>
                    </button>
                  </div>
                  <button type="button" @click="Order_plus(row.id, 'delete')" class="btn-close fs-sm" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-sm" data-bs-title="Remove" aria-label="Remove from cart"></button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- Footer -->
        <div class="offcanvas-header flex-column align-items-start">
          <div class="d-flex align-items-center justify-content-between w-100 mb-3 mb-md-4">
            <span class="text-light-emphasis">@lang('layout.Total')</span>
            <span class="h6 mb-0">@{{total}}  @{{currency}}</span>
          </div>
          <div class="d-flex w-100 gap-3">
            @if(session()->has('online_user'))
            <a class="btn btn-lg btn-secondary w-100"  href="{{route('online.ItemOrderDetails',session()->get('online_user')['id'])}}">@lang('layout.Submit')</a>
            @else
            <a class="btn btn-lg btn-primary w-100" style="border-radius: 7px;" href="{{route('online.login')}}">@lang('layout.SignIn')</a>
            @endif
          </div>
        </div>
      </div>
    </div>
    <!-- Wish List offcanvas -->
    <div class="offcanvas offcanvas-end pb-sm-2 px-sm-2" id="WishList" tabindex="-1" aria-labelledby="shoppingCartLabel" style="width: 500px; overflow-y: auto;">
      <div id="wish_list_vue">
        <!-- Header -->
        <div class="offcanvas-header flex-column align-items-start py-3 pt-lg-4">
          <div class="d-flex align-items-center justify-content-between w-100 mb-3 mb-lg-4">
            <h4 class="offcanvas-title" id="wishListLabel">@lang('layout.WishList')</h4>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
          </div>
        </div>
        <!-- Items -->
        <div class="offcanvas-body d-flex flex-column gap-2">
          <!-- Item -->
          <div class="d-flex align-items-center border-bottom" v-if="items1" v-for="(row,index) in items1">
            <a class="position-relative flex-shrink-0" :href="uploads+'/'+row.image">
              {{-- <span class="badge text-bg-danger position-absolute top-0 start-0 z-2 mt-0 ms-0">-$2.79</span> --}}
              <img :src="uploads+'/'+row.image" width="110" alt="Thumbnail">
            </a>
            <div class="w-100">
              <div class="d-flex justify-content-between align-items-center">
                <div>
                  <h5 class="fs-sm fw-medium lh-base" style="padding: 0px !important; margin: 0px !important;">
                    <a :href="'{{url('item_details')}}/'+row.id" class="fs-6 text-gray-800 text-hover-primary fw-bolder">@{{(!row)?null:row.name}}</a>
                  </h5>
                </div>
                <div>
                  <span class="font-weight-bold me-1 text-dark-75 font-size-lg"> @{{(!row)?null:row.price}} @{{(!row)?null:row.currency}} </span>
                </div>
                <div class="d-flex justify-content-between" style="width: 25%;">
                  <div>
                    <button type="button" class="product-card-button btn btn-icon btn-sm btn-danger ms-auto" @click="putPurchase(row.id)" title="@lang('layout.AddToCart')" data-increment="" aria-label="Increment quantity">
                      <span data-count-input-value=""></span>
                      <i class="ci-shopping-cart fs-sm"></i>
                    </button>
                  </div>
                  <div class="d-flex align-items-center justify-content-between">
                    <button type="button" @click="Order_plus(row.item_id, 'delete')" class="btn-close" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-sm" data-bs-title="Remove" aria-label="Remove from cart" title="@lang('layout.RemoveRow')"></button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Delivey options offcanvas -->
    <div class="offcanvas offcanvas-end pb-sm-2 px-sm-2" id="userLogedin" tabindex="-1" aria-labelledby="deliveryOptionsLabel" style="width: 500px">
      <!-- Header with nav tabs -->
      <div class="offcanvas-header flex-column align-items-start py-3 pt-lg-4">
        <div class="d-flex align-items-center justify-content-between w-100 pb-xl-1 mb-4">
          <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div>
          <div class="menu-content d-flex align-items-center px-3">
            <!--begin::Avatar-->
            <div class="">
              @if(session()->get('online_user'))
                @if(session()->get('online_user')['photo'])
                  <img alt="{{session()->get('online_user')['name']}}" src="{{url('/uploads/online_users/'.session()->get('online_user')['photo'])}}" style="width: 30%; border-radius: 50%;" />
                @else
                  <img alt="{{session()->get('online_user')['name']}}" src="{{url('/online/assets/blank.png')}}" style="width: 30%; border-radius: 50%;" />
                @endif
              @endif
            </div>
            <!--end::Avatar-->
            <!--begin::Username-->
            <div class="d-flex flex-column justify-content-end">
                <div class="fw-bolder d-flex align-items-center fs-5">
                  @if(session()->get('online_user'))
                  {{session()->get('online_user')['name']}} {{session()->get('online_user')['last_name']}}
                  @endif
                </div>
            </div>
            <!--end::Username-->
          </div>     
          <div class="d-flex justify-content-between mt-5">
            <div class="menu-item">
              @if(session()->get('online_user'))
              <a href="{{route('online.users.show',session()->get('online_user')['id'])}}" class="btn btn-sm btn-primary fs-6 fw-bold" style="border-radius: 7px;">@lang('layout.MyProfile')</a>
              @endif
            </div> 
            <div class="menu-item">
              <a href="{{route('online.logout')}}" class="btn btn-sm btn-danger border fs-6 fw-bold" style="border-radius: 7px;"><i class="ci-log-out fs-base opacity-75 me-2"></i> @lang('layout.LogOut') </a>
            </div>  
          </div>
        </div>
      </div>
    </div>
    @include('online.masters.admin.header')
    <main class="content-wrapper">
      @yield('content')
    </main>
    {{-- footer include start here --}}
    @include('online.masters.admin.footer')
    {{-- footer include end here --}}
    <script src="{{asset('online/onlineAssets/js/customizer.min.js')}}"></script>
    <script src="{{url('assets/app/js/app.js')}}"></script>
    <script src="{{url('/online/onlineAssets/datatable/jquery-3.6.0.min.js')}}"></script>
    <link rel="stylesheet" href="{{url('/online/onlineAssets/datatable/jquery.dataTables.min.css')}}">
    {{-- <script src="{{url('/online/onlineAssets/datatable/jquery.dataTables.min.js')}}"></script> --}}
    <script src="{{url('/online/onlineAssets/datatable/datatables.js')}}"></script>
    <script src="{{url('/online/datePicker/persian-date.js')}}"></script>
    <script src="{{url('/online/datePicker/persian-datepicker.js')}}"></script>
    {{-- <script src="{{url('/online/assets-v7/js/pages/features/miscellaneous/sweetalert2.js')}}"></script> --}}
    <script src="{{url('/vue/sweetalert2.all.min.js')}}"></script>
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/online/assets/js/scripts.bundle.js')}}" type="text/javascript"></script>
    <script>
      document.addEventListener("DOMContentLoaded", function(){
        const currentDate = new Date();
        // const options = {year:'numeric', month: 'long', day: 'numeric'};
        const options = {year:'numeric'};
        const formattedDate = currentDate.toLocaleDateString('fa-IR', options);

        document.getElementById('currentDate').textContent = formattedDate;
      });
    </script>
    <!-- Vendor scripts -->
    <script src="{{asset('online/onlineAssets/vendor/swiper/swiper-bundle.min.js')}}"></script>
    <script src="{{asset('online/onlineAssets/vendor/simplebar/simplebar.min.js')}}"></script>
    <script src="{{asset('online/onlineAssets/vendor/choices.js/choices.min.js')}}"></script>
    <script src="{{asset('online/onlineAssets/vendor/glightbox/glightbox.min.js')}}"></script>
    <script src="{{asset('online/onlineAssets/hooper/hooper.js')}}"></script>
    {{-- <script src="{{asset('online/onlineAssets/vendor/list.js/list.min.js')}}"></script> --}}
    <!-- Bootstrap + Theme scripts -->
    <script src="{{asset('online/onlineAssets/js/theme.min.js')}}"></script>
    <script src="{{url('/vue/select2/vue-select.js')}}"></script>
    <script>
$(document).ready(function() {
// console.log('wobj',window);
// onChromeCLosed();
var calendarType = 'gregorian';
var initialValueType = 'gregorian';
@if(App::isLocale('fa') || App::isLocale('pa'))
calendarType = 'persian';
initialValueType = 'persian';
@endif
// console.log('myloca','{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}');
date = $(".date").persianDatepicker({
    initialValue: false,
    observer: true,
    // autocomplete: true,
    format: 'YYYY/MM/DD',
    autoClose: true,
    response: true,
    initialValueType: initialValueType,
    calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
    calendar: {
        persian: {
            locale: 'en'
        }
    }
});
});
      /** date picker for vuejs */
      // Vue.component('date_picker', {
      //     template: '<input class="form-control" autocomplete="off" />',
      //     mounted: function() {
      //         $(this.$el).persianDatepicker({
      //             initialValue: false,
      //             observer: true,
      //             format: 'YYYY/MM/DD',
      //             autoClose: true,
      //             response: true,
      //             initialValueType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
      //             calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
      //             calendar: {
      //                 persian: {
      //                     locale: 'en'
      //                 }
      //             }
      //         });
      //     }
      // })
      /** date picker for vuejs end */
      $.extend(true, $.fn.dataTable.defaults, {
        "language": {
            url: '{{(App::isLocale("fa") || App::isLocale("pa"))?url("/lang/fa/datatables.json"):url("/lang/en/datatables.json")}}'
        },
      });
      var user_id = null;
      var session_id = null;
      @if(session()->has('online_user'))
          user_id = {{session()->get('online_user')['id']}};
      @endif
      @if(session()->has('online_session'))
          session_id = {{session()->get('online_session')}};
      @endif
      var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";
      var uploadUser = "{{url('/uploads/online_users/')}}";
      var blank = "{{url('/online/assets/media/avatars/blank.png')}}";
      // setTimeout((function () {
      //   orderLisCountVue.getOrderList(user_id, session_id);
      // }), 2000);
      // get order list
      var orderLisVue = new Vue({
          el: '#order_list_vue',
          data: {
              uploads: uploads,
              items: [],
              user_id: user_id,
              session_id: session_id,
              currency: 'USD'
          },
          computed: {
              // calculate total
              total: function () {
                  var sum = 0;
                  for (var i = 0; i < this.items.length; i++) {
                      if (this.items[i].quantity > 0 && this.items[i].price > 0) {
                          this.currency = this.items[i].currency;
                          sum += this.items[i].quantity * this.items[i].price;
                      }
                  }
                  return myRound(sum);
              },
          },
          mounted: function () {
              this.getOrderList(this.user_id, this.session_id);
          },
          methods:
              {
                  getOrderList(user_id, session_id) {
                      // console.log(123,user_id ,session_id);
                      if (user_id != null || session_id != null) {
                          axios.get("{{route('online.order.user')}}", {
                              params: {
                                  user_id: user_id,
                                  session_id: session_id
                              }
                          })
                          .then(function (response) {
                              if (response.data) {
                                  if (response.data.result.length > 0) {
                                      orderLisVue.items = [];
                                      orderLisVue.items = response.data.result;
                                  }else{
                                      orderLisVue.items = [];
                                  }
                              }
                          })
                          .catch(function (error) {
                              console.log(error);
                          });
                      }
                  },
                  Order_plus(item_id, type) {
                      // console.log(123,item_id);
                      if (item_id != null) {
                          axios.get("{{route('online.order.plusMinus')}}", {
                              params: {
                                  item_id: item_id,
                                  type: type
                              }
                          })
                          .then(function (response) {
                              if (response) {
                                  orderLisVue.getOrderList(orderLisVue.user_id, orderLisVue.session_id);
                              }
                          })
                          .catch(function (error) {
                              console.log(error);
                          });
                      }
                  },
              }
      }); 
      // get wish list
      var wishLisVue = new Vue({
          el: '#wish_list_vue',
          data: {
              uploads: uploads,
              items1: [],
              user_id: user_id,
              session_id: session_id,
              currency: 'USD'
          },
          computed: {
              // calculate total
              total: function () {
                  var sum = 0;
                  for (var i = 0; i < this.items1.length; i++) {
                      if (this.items1[i].quantity > 0 && this.items1[i].price > 0) {
                          this.currency = this.items1[i].currency;
                          sum += this.items1[i].quantity * this.items1[i].price;
                      }
                  }
                  return myRound(sum);
              },
          },
          mounted: function () {
              this.getWishList(this.user_id, this.session_id);
          },
          methods:
              {
                  getWishList(user_id, session_id) {
                      // console.log(123,user_id ,session_id);
                      if (user_id != null || session_id != null) {
                          axios.get("{{route('online.wishlist.user')}}", {
                              params: {
                                  user_id: user_id,
                                  session_id: session_id
                              }
                          })
                          .then(function (response) {
                              if (response.data) {
                                  if (response.data.result.length > 0) {
                                      wishLisVue.items1 = [];
                                      wishLisVue.items1 = response.data.result;
                                  }else{
                                      wishLisVue.items1 = [];
                                  }
                              }
                          })
                          .catch(function (error) {
                              console.log(error);
                          });
                      }
                  },
                  Order_plus(item_id, type) {
                      // console.log(123,item_id);
                      if (item_id != null) {
                          axios.get("{{route('online.wishlist.plusMinus')}}", {
                              params: {
                                  item_id: item_id,
                                  type: type
                              }
                          })
                          .then(function (response) {
                              if (response) {
                                  wishLisVue.getWishList(wishLisVue.user_id, wishLisVue.session_id);
                              }
                          })
                          .catch(function (error) {
                              console.log(error);
                          });
                      }
                  },
                  putPurchase(id){
                    if (id != null) {
                      $.ajax({
                        type: 'POST',
                        url: "{{url('onlinePutPurchase')}}/" + id,
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        success: function (result) {
                          toastr.success('', result.message);
                          // wishLisVue.getWishList(user_id, session_id);
                          orderLisVue.getOrderList(user_id, session_id);
                          // table.ajax.reload();
                          console.log(13,result);
                          // location.reload();
                        },
                        error: function (error) {
                          var message = "{{__('message.Warning')}}";
                          toastr.warning('', message);
                          // console.log(14,error);
                          // swal("{{__('message.Warning')}}", error.responseJSON.message);
                        }
                      });
                    }
                  },
                  putWishList(id){
                    
                    if (id != null) {
                      $.ajax({
                        type: 'POST',
                        url: "{{url('onlinePutWishList')}}/" + id,
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        success: function (result) {
                          toastr.success('', result.message);
                          wishLisVue.getWishList(user_id, session_id);
                          // table.ajax.reload();
                          console.log(13,result);
                          // location.reload();
                        },
                        error: function (error) {
                          var message = "{{__('message.Warning')}}";
                          toastr.warning('', message);
                          // console.log(14,error);
                          // swal("{{__('message.Warning')}}", error.responseJSON.message);
                        }
                      });
                    }
                  }
              }
      }); 
      var orderLisCountVue = new Vue({
          el: '#order_list_count_vue',
          data: {
              user_id: user_id,
              session_id: session_id,
              count_order_items:null
          },
          mounted: function () {
            var app = this
            setInterval(() => {
              app.getOrderList(this.user_id, this.session_id);
            }, 1000);
          },
          methods:{
            getOrderList(user_id, session_id) {
                if (user_id != null || session_id != null) {
                    axios.get("{{route('online.order.user')}}", {
                        params: {
                            user_id: user_id,
                            session_id: session_id
                        }
                    })
                    .then(function (response) {
                        if (response.data) {
                            // if (response.data.result.length > 0) {
                                orderLisCountVue.count_order_items = response.data.result.length
                                // console.log('kaka',orderLisCountVue.count_order_items)
                            // }
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    });
                }
            }
          }
      });
      var wishLisCountVue = new Vue({
          el: '#wish_list_count_vue',
          data: {
              user_id: user_id,
              session_id: session_id,
              count_order_items1:null
          },
          mounted: function () {
            var app = this
            setInterval(() => {
              app.getWishList(this.user_id, this.session_id);
            }, 1000);
          },
          methods:{
            getWishList(user_id, session_id) {
                if (user_id != null || session_id != null) {
                    axios.get("{{route('online.wishlist.user')}}", {
                        params: {
                            user_id: user_id,
                            session_id: session_id
                        }
                    })
                    .then(function (response) {
                        if (response.data) {
                            // if (response.data.result.length > 0) {
                              wishLisCountVue.count_order_items1 = response.data.result.length
                                // console.log('kaka',orderLisCountVue.count_order_items)
                            // }
                        }
                    })
                    .catch(function (error) {
                        console.log(error);
                    });
                }
            }
          }
      });
      var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";
      var searVue = new Vue({
          el: '#search_vue',
          data: {
              search_input: '',
              items: [],
              uploads: uploads
          },
          methods: {
              getSearch() {
                  // console.log(123,searVue.search_input.length);
                  if (searVue.search_input != null ) {
                      var search = searVue.search_input;
                      axios.get("{{route('search.item')}}", {
                              params: {
                                  search: search
                              }
                          })
                          .then(function(response) {
                              if (response.data) {
                                  if (response.data.result.length > 0) {
                                      searVue.items = [];
                                      searVue.items = response.data.result;
                                      console.log(222, searVue.search_input);
                                  } else {
                                      searVue.items = [];
                                  }
                              }
                          })
                          .catch(function(error) {
                              console.log(error);
                          });
                  }
              },
          },
          created: function() {
          }
      });
      // order list 
      function myRound(amount = null) {
        var result = 0;
        if (amount != null) {
            result = Number.parseFloat(amount).toFixed(2);
        }
        return result;
      }
      function changeLang(lang) {
        if (lang != null) {
            $.ajax({
                type: 'POST',
                url: "{{url('onlineChangeLang')}}/" + lang,
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                success: function(result) {
                    // toastr.success('', result.message);
                    // table.ajax.reload();
                    // console.log(13,result);
                    location.reload();
                },
                error: function(error) {
                    // console.log(14,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);
                }
            });
        }
      } 
      function putPurchase (id){
        // console.log(12,id);
        if (id != null) {
          $.ajax({
            type: 'POST',
            url: "{{url('onlinePutPurchase')}}/" + id,
            headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
            success: function (result) {
              toastr.success('', result.message);
              orderLisVue.getOrderList(user_id, session_id);
              // table.ajax.reload();
              console.log(13,result);
              // location.reload();
            },
            error: function (error) {
              var message = "{{__('message.Warning')}}";
              toastr.warning('', message);
              // console.log(14,error);
              // swal("{{__('message.Warning')}}", error.responseJSON.message);
            }
          });
        }
      } 
      function putWishList (button, id, isWished){
        // console.log(12,id);
        const icon = button.querySelector('i');

        if(isWished){
          icon.classList.remove('ci-heart-filled');
          icon.classList.add('ci-heart');
          icon.style.color = '';
          isWished = false;
        }
        else
        {
          icon.classList.remove('ci-heart');
          icon.classList.add('ci-heart-filled');
          icon.style.color = 'red';
          isWished = true;
        }
        // alert('Item ID : ' + id + 'Wish Status: ' + !isWished);
        if (id != null) {
          $.ajax({
            type: 'POST',
            url: "{{url('onlinePutWishList')}}/" + id,
            headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
            success: function (result) {
              toastr.success('', result.message);
              wishLisVue.getWishList(user_id, session_id);
              // table.ajax.reload();
              console.log(13,result);
              // location.reload();
            },
            error: function (error) {
              var message = "{{__('message.Warning')}}";
              toastr.warning('', message);
              // console.log(14,error);
              // swal("{{__('message.Warning')}}", error.responseJSON.message);
            }
          });
        }

      } 
      function deleteItemAjax(element, datatableId = null) {
                 
                 var e = $(element);
                 var form = e.parent('form').get(0);
                 var url = $(form).get(0).action;
                 var table = $(datatableId).DataTable();
 
                 swal({
                     title: "@lang('layout.AreYouSure?')",
                     icon: "warning",
                     buttons: ["@lang('layout.Cancel')", "@lang('layout.Delete')"],
                     dangerMode: true,
                 }).then((willDelete) => {
                     if (willDelete) {
                         $.ajax({
                             type: 'DELETE',
                             url: url,
                             headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                             success: function (result) {
                                 // swal("{{__('message.DSuccess')}}",result.message);
 
                                 toastr.success('', result.message);
                                 table.ajax.reload();
                             },
                             error: function (error) {
                                 // swal({
                                 //     icon: 'error',
                                 //     title: "@lang('message.Warning')",
                                 //     text: "lalalaaa",
                                 //     footer:"kakkaka"
                                 // })
                                 swal("{{__('message.Warning')}}", error.responseJSON.message);
 
                             }
                         });
                     } else {
                         swal({
                             buttons: "@lang('layout.Confirm')",
                             title: "@lang('layout.FileIsSave')",
                         });
                         return false;
                     }
                 });
 
      } 

        //      function deleteItemAjax(element, datatableId = null) {
        //     var e = $(element);
        //     var form = e.parent('form').get(0);
        //     var url = $(form).get(0).action;
        //     var table = $(datatableId).DataTable();
        //     Swal.fire({
        //         title: "@lang('layout.AreYouSure?')",
        //         // text: "You wont be able to revert this!",
        //         icon: "warning",
        //         showCancelButton: true,
        //         confirmButtonText: "@lang('layout.Delete')",
        //         cancelButtonText: "@lang('layout.Cancel')",
        //         reverseButtons: true
        //     }).then(function(result) {
        //         if (result.value) {
        //             $.ajax({
        //                 type: 'DELETE',
        //                 url: url,
        //                 headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
        //                 success: function (res) {
        //                     Swal.fire(
        //                         "@lang('layout.Deleted')",
        //                         res.message,
        //                         "success"
        //                     )
        //                     // toastr.success("Are you the six fingered man?");
        //                     table.ajax.reload();
        //                 },
        //                 error: function (error) {
        //                     Swal.fire(
        //                         "@lang('message.Warning')",
        //                         error.responseJSON.message,
        //                         "error"
        //                     )
        //                 }
        //             });
        //         } else if (result.dismiss === "cancel") {
        //             Swal.fire(
        //                 "@lang('layout.Confirm')",
        //                 "@lang('layout.FileIsSave')",
        //                 "error"
        //             )
        //         }
        //     });
        // }  
        // chat part start 
        var KTAppChat = function () {
            var e = function (e) {
                    var t = e.querySelector('[data-kt-element="messages"]'),
                        n = e.querySelector('[data-kt-element="input"]');
                    if (0 !== n.value.length) {
                        send_message (n,t);
                        // var o, a = t.querySelector('[data-kt-element="template-out"]'),
                        //     l = t.querySelector('[data-kt-element="template-in"]');
                        // (o = a.cloneNode(!0)).classList.remove("d-none"), o.querySelector('[data-kt-element="message-text"]').innerText = n.value, n.value = "", t.appendChild(o), t.scrollTop = t.scrollHeight, setTimeout((function () {
                        //     (o = l.cloneNode(!0)).classList.remove("d-none"), o.querySelector('[data-kt-element="message-text"]').innerText = "@lang('message.ThankYouForYourMessageSystemUserAnswerSoon')", t.appendChild(o), t.scrollTop = t.scrollHeight
                        // }), 2e3)
                    }
                };
            return {
                init: function (t) {
                    !
                    function (t) {
                        t && (KTUtil.on(t, '[data-kt-element="input"]', "keydown", (function (n) {
                            if (13 == n.keyCode) return e(t), n.preventDefault(), !1
                        })), KTUtil.on(t, '[data-kt-element="send"]', "click", (function (n) {
                            e(t)
                        })))
                    }(t)
                }
            }
        }();
        KTUtil.onDOMContentLoaded((function () {
            KTAppChat.init(document.querySelector("#kt_drawer_chat_messenger"))
        }));

        function send_message (n,t){
            // console.log(12,id);
            if (n.value != null) {
                $.ajax({
                    type: 'GET',
                    url: "{{url('sendMessage')}}/",
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    data:{message:n.value},
                    success: function (result) {
                        messageLisVue.getMessageList(result.session_id);
                        n.value = "";
                        // toastr.success('', result.message);
                        // orderLisVue.getOrderList(user_id, session_id);
                        // table.ajax.reload();
                        // console.log(999,result.count);
                        // location.reload();
                        // return true;
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // return false;
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            }
        } 
        function getMessageAllList() {
            messageLisVue.getMessageList(session_id);
            v_alert.message_id = messageLisVue.message_id;
        }
        function getMessagePerTime() {
            setTimeout((function () {
                if (v_alert.message_id == 0) {
                    v_alert.message_id = messageLisVue.message_id;
                }
                getLastMessage();
                // console.log(120, v_alert.message_id);
            }), 4e4)
        }
        function getLastMessage() {
            $.ajax({
                type: 'GET',
                url: "{{route('onlineMessage.last')}}",
                data:{id:v_alert.message_id, session_id:session_id},
                success: function (result) {
                    if (result.count > 0) {
                        v_alert.last_message_id = result.id;
                    }
                    v_alert.alert = result.count;
                    // console.log(999,result.count);
                    // location.reload();
                },
                error: function (error) {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                }
            });
            getMessagePerTime();
        }

        $(document).ready(function () {
            getMessagePerTime();
        });


        // new vue for modal

        var v_alert = new Vue({
            el: '#alert_count',
            data: {
                alert: '',
                message_id: 0,
                last_message_id: session_id
            },
            methods: {
            }
        });
         // get message list
         var messageLisVue = new Vue({
            el: '#message_list_vue',
            data: {
                items: [],
                user_id: user_id,
                session_id: session_id,
                uploads: uploadUser,
                blank: blank,
                message_id: 0,
                user: "@lang('layout.You')",
                admin: "@lang('layout.UserSystem')",
            },
            computed: {
                // calculate total
                // total: function () {
                //     var sum = 0;
                //     for (var i = 0; i < this.items.length; i++) {
                //         if (this.items[i].quantity > 0 && this.items[i].price > 0) {
                //             this.currency = this.items[i].currency;
                //             sum += this.items[i].quantity * this.items[i].price;
                //         }
                //     }
                //     return myRound(sum);
                // },
                

            },
            mounted: function () {
                this.getMessageList(this.session_id);
            },
            methods:
                {
                    getMessageList(session_id) {
                        // console.log(123, session_id);
                        if (session_id != null) {
                            axios.get("{{route('online.message.list')}}", {
                                params: {
                                    session_id: session_id
                                }
                            })
                            .then(function (response) {
                                if (response.data) {
                                    if (response.data.message_id > 0) {
                                        messageLisVue.message_id = response.data.message_id;
                                    }
                                    if (response.data.result.length > 0) {
                                        messageLisVue.items = [];
                                        messageLisVue.items = response.data.result;
                                        setTimeout((function () {
                                            KTUtil.onDOMContentLoaded((function () {
                                                var t = document.querySelector("#kt_drawer_chat_messenger");
                                                var e = t.querySelector('[data-kt-element="messages"]');
                                                // console.log(111,e,e.scrollHeight);
                                                e.scrollTop = e.scrollHeight
                                            }));
                                            messageLisVue.getMessagePerTime(session_id);
                                        }), 400)
                                        // console.log(222, messageLisVue.items);
                                    }else{
                                        messageLisVue.items = [];
                                    }
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                    getMessagePerTime(session_id) {
                        setTimeout((function () {
                            messageLisVue.getMessageList(session_id);
                            // console.log(0);
                        }), 4e4)
                    },
                }

        });

        // const ENTER_KEY = "Enter";
        // document.addEventListener("DOMContentLoaded", function () {
        //   const messageInput = document.getElementById('message-input');
        //   const sendButton = document.getElementById('send-button');
        //   const chatMessages = document.getElementById('chat-messages');

        //   sendButton.addEventListener("click", ()=> onButtonClick(messageInput, chatMessages));
        //   messageInput.addEventListener('keyup', (event) => event.key === ENTER_KEY ? sendButton.click() : event.preventDefault());
        // });
        // const onButtonClick = (messageInput, chatMessages) => {
        //   const messageText = messageInput.value;

        //   if(messageText.trim() === ""){
        //     return false;
        //   }
        //   let messages = document.querySelectorAll('.message');
        //   console.log(messages[messages.length - 1].classList.contains('message-personal'));

        //   const messageDiv = document.createElement("div");
        //   const bubbleDiv = document.createElement("div");
        //   const bubbleTextDiv = document.createElement("div");

        //   messageDiv.classList.add("message", "message-personal");
        //   bubbleDiv.classList.add("bubble", "bubble-personal");
        //   bubbleTextDiv.classList.add("bubble-text");

        //   bubbleTextDiv.innerText = messageText;
        //   bubbleDiv.appendChild(bubbleTextDiv);
        //   messageDiv.appendChild(bubbleDiv);

        //   chatMessages.appendChild(messageDiv);
        //   messageInput.value = "";
        //   chatMessages.scrollTop = chatMessages.scrollHeight;
        // };
        // message list
        // chat part end 
  // let currentSlide = 0;
  // function moveSlide1(direction1){
  //   const subSlide = document.querySelectorAll('.subSlide');
  //   const totalSlides = subSlide.length;
  //   subSlide[currentSlide].classList.remove('active');

  //   currentSlide = (currentSlide + direction1 + totalSlides) % totalSlides;

  //   subSlide[currentSlide].classList.add('active');

  //   const sliderContainer = document.querySelector('.mainSlider-container');
  //   sliderContainer.style.transform = `translateX(-${currentSlide * 100}%)`;
  // }
  // document.addEventListener('DOMContentLoaded', () =>{
  //   const subSlide = document.querySelectorAll('.subSlide');
  //   subSlide.forEach((subSlide, index) => {
  //     if(index === 0){
  //       subSlide.classList.add('active');
  //     }
  //   });
  // });
  window.onscroll = function(){
    const scrollTopBtn = document.getElementById('scrollTopBtn');
    if(document.body.scrollTop > 50 || document.documentElement.scrollTop > 50){
      scrollTopBtn.style.display = "block";
    }
    else
    {
      scrollTopBtn.style.display = "none";
    }
  };
  </script>
   {{-- @if(googleTranslate()) --}}
   <script type="text/javascript">
       function googleTranslateElementInit() {
       var tra = new google.translate.TranslateElement({pageLanguage: '{{App::getLocale()}}'}, 'google_translate_element');
       } 
   </script>
   <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
   {{-- @endif --}}
  @stack('scripts')
</body>
</html>