<!-- Site menu offcanvas -->
<nav class="offcanvas offcanvas-start" id="navbarNav" tabindex="-1" aria-labelledby="navbarNavLabel">
	<div class="offcanvas-header py-3">
		<h5 class="offcanvas-title" id="navbarNavLabel">{{onlineSystemConfig()['name']}}</h5>
		<button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
	</div>
	<div class="offcanvas-body pt-0 pb-3">
		<!-- Navbar nav -->
		<div class="accordion" id="navigation">
		<!-- Rest of the menu -->
		<div class="accordion-item border-0">
			<div class="accordion-header" id="headingHome">
				<a type="button" href="{{route('/')}}" class="accordion-button animate-underline collapsed py-2 text-decoration-none"  data-bs-target="#home" aria-expanded="false" aria-controls="home">
					<span class="d-block animate-target py-1">@lang('menu.Home')</span>
				</a>
			</div>
		</div>
		<div class=" border-0">
			<div>
				<a type="button" href="#ourProduct" class="accordion-button animate-underline collapsed py-2 text-decoration-none" aria-expanded="false">
					<span class="d-block animate-target py-1">@lang('menu.OurProduct')</span>
				</a>
			</div>
		</div>
		<div class="accordion-item border-0">
			<div class="accordion-header" id="headingShop">
				<a type="button" href="#newProduct" class="accordion-button animate-underline collapsed py-2 text-decoration-none" aria-expanded="false">
					<span class="d-block animate-target py-1">@lang('menu.NewProduct')</span>
				</a>
			</div>
		</div>
		<div class="accordion-item border-0">
			<div class="accordion-header" id="headingShop">
				<a type="button" href="#recomendedProduct" class="accordion-button animate-underline collapsed py-2 text-decoration-none" aria-expanded="false">
					<span class="d-block animate-target py-1">@lang('menu.RecommendedProduct')</span>
				</a>
			</div>
		</div>
		<div class="accordion-item border-0">
			<div class="accordion-header" id="headingPages">
				<a type="button" href="#futureProduct" class="accordion-button animate-underline collapsed py-2 text-decoration-none" aria-expanded="false">
					<span class="d-block animate-target py-1">@lang('menu.IncommmingProduct')</span>
				</a>
			</div>
		</div>
		</div>
		<div class="h6 fw-medium py-1 mb-0">
			<a class="d-block animate-underline py-1 fw-bold" href="{{route('online.about')}}">
				<span class="d-inline-block animate-target py-1">@lang('menu.AboutUs')</span>
			</a>
		</div>
	</div>
	<!-- Account button visible on screens < 768px wide (md breakpoint) -->
	@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1)
	<div class="offcanvas-header flex-column align-items-start d-md-none">
		@if(!session()->has('online_user'))
			<a class="btn btn-lg btn-outline-secondary w-100 rounded-pill" href="{{route('online.login')}}">
				<i class="ci-user fs-lg ms-n1 me-2"></i>
				@lang('layout.Account')
			</a>
		@endif
	</div>
	@endif
</nav>
{{-- end of site menu offcanvas  --}}
<!-- Navigation bar (Page header) -->
<header class="navbar navbar-expand navbar-sticky sticky-top d-block bg-body z-fixed py-1 py-lg-0 py-xl-1 px-0" data-sticky-element="">
<div class="container justify-content-start py-0 py-lg-1">
	<!-- Offcanvas menu toggler (Hamburger) -->
	<button type="button" class="navbar-toggler d-block flex-shrink-0 me-3 me-sm-4" data-bs-toggle="offcanvas" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-label="Toggle navigation">
	<span class="navbar-toggler-icon"></span>
	</button>
	<!-- Navbar brand (Logo) -->
	<a class="navbar-brand fs-2 p-0 pe-lg-2 pe-xxl-0 me-0 me-sm-3 me-md-4 me-xxl-5" href="{{route('/')}}" style="width: 20%;">
		@if(session()->get('online_system_config'))
			<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo}}" style="display: none; width: 50%;border-radius: 50%;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" />
			<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" />
			<img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" />
		@else
			<img alt="Logo" src="{{url('/online/assets/logo/logoA1.png')}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" />
			<img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" />
			<img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" />
		@endif
	</a>
	<!--begin::Search-->
	<div id="search_vue" class="position-relative w-100 d-none d-md-block me-3 me-xl-4" v-cloak>
		<form data-kt-search-element="form" class="w-100 position-relative" autocomplete="off" id="search-form">
			<input type="text" class="form-control form-control-lg rounded-pill" name="search" v-model="search_input" @input="getSearch()" placeholder="@lang('layout.Search')..." aria-label="Search" />
			<input type="hidden" data-kt-search-element="input" />
			<button type="button" class="btn btn-icon btn-ghost fs-lg btn-secondary text-bo border-0 position-absolute top-0 end-0 rounded-circle mt-1 me-1" aria-label="Search button">
				<i class="ci-search"></i>
			</button>
			<!--end::Input-->
		</form>
		<!--end::Form-->
		<!--begin::Items-->
		<div v-show="search_input" style="position: absolute; top: 100%;width: 100%" class="mt-2" id="result-div">
			<!--begin::Item-->
			<span  v-for="(row,index) in items" v-cloak>
			<a :href="'{{url('item_details')}}/' + row.id" v-cloak class="d-flex justify-content-between text-dark text-hover-primary align-items-center" style="background-color: var(--cz-body-bg);border-bottom: 1px solid;border-top: none; border-right: 1px solid;border-left: 1px solid;">
				<!--begin::Symbol-->
				<div class="symbol symbol-40px me-4" style="width: 18%;" v-if='row.image'>
					<img :src="uploads+'/'+row.image" alt="" style="width: 50%;height: 20%; background-color: white;" class="m-1 rounded-pill" />
				</div>
				<div class="symbol symbol-40px me-4" style="width: 18%;" v-if='!row.image'>
					<img :src="uploads+'/'+'product.png'" alt="" style="width: 50%;height: 20%; background-color: white;" class="m-1 rounded-pill" />
				</div>
				<!--end::Symbol-->
				<!--begin::Title-->
				<div class="d-flex flex-column me-4 fw-bold">
					<span class="fs-6 fw-bold" style="color: var(--cz-body-color);">@{{(!row)?null:row.name}}</span>
				</div>
				<!--end::Title-->
			</a>
			</span>
			<!--end::Item-->
		</div>
		<!--end::Items-->
		<!--begin::Empty-->
		<div data-kt-search-element="empty" class="text-center d-none">
			<!--begin::Message-->
			<div class="pb-15 fw-bold">
				<h3 class="text-gray-600 fs-5 mb-2">No result found</h3>
				<div class="text-muted fs-7">Please try again with a different query</div>
			</div>
			<!--end::Message-->
		</div>
		<!--end::Empty-->
		<!--begin::Preferences-->
		<form action="{{route('online.ItemDetailsAll')}}" method="GET" data-kt-search-element="advanced-options-form" class="pt-1 d-none">
			<!--begin::Heading-->
			<h3 class="fw-bold text-dark mb-7">@lang('layout.AdvancedSearch')</h3>
			<!--end::Heading-->
			<!--begin::Input group-->
			<div class="mb-5">
				<input type="text" class="form-control form-control-sm form-control-solid" name="search" placeholder="@lang('layout.Search')..." />
			</div>
			<!--end::Input group-->
			<!--begin::Actions-->
			<div class="d-flex justify-content-end">
				<button type="reset" class="btn btn-sm btn-white fw-bolder btn-active-light-primary me-2" data-kt-search-element="advanced-options-form-cancel">@lang('layout.Cancel')</button>
				<button type="submit" class="btn btn-sm fw-bolder btn-primary" data-kt-search-element="advanced-options-form-search">@lang('layout.Search')</button>
			</div>
			<!--end::Actions-->
		</form>
	</div>
	{{-- end::Search  --}}
	<!-- Button group -->
	<div class="d-flex align-items-center gap-md-1 gap-lg-2 ms-auto">
	<!-- Theme switcher (light/dark/auto) -->
	<div class="dropdown">
		<button type="button" class="theme-switcher btn btn-icon btn-outline-secondary fs-lg border-0 rounded-circle animate-scale" data-bs-toggle="dropdown" aria-expanded="false" aria-label="Toggle theme (light)">
		<span class="theme-icon-active d-flex animate-target">
			<i class="ci-sun"></i>
		</span>
		</button>
		<ul class="dropdown-menu" style="--cz-dropdown-min-width: 9rem">
		<li>
			<button type="button" class="dropdown-item active" data-bs-theme-value="light" aria-pressed="true">
			<span class="theme-icon d-flex fs-base me-2">
				<i class="ci-sun"></i>
			</span>
			<span class="theme-label">@lang('layout.Light')</span>
			<i class="item-active-indicator ci-check ms-auto"></i>
			</button>
		</li>
		<li>
			<button type="button" class="dropdown-item" data-bs-theme-value="dark" aria-pressed="false">
			<span class="theme-icon d-flex fs-base me-2">
				<i class="ci-moon"></i>
			</span>
			<span class="theme-label">@lang('layout.Dark')</span>
			<i class="item-active-indicator ci-check ms-auto"></i>
			</button>
		</li>
		<li>
			<button type="button" class="dropdown-item" data-bs-theme-value="auto" aria-pressed="false">
			<span class="theme-icon d-flex fs-base me-2">
				<i class="ci-auto"></i>
			</span>
			<span class="theme-label">@lang('layout.Auto')</span>
			<i class="item-active-indicator ci-check ms-auto"></i>
			</button>
		</li>
		</ul>
	</div>
	<!-- Theme direction (Farsi/English) -->
	<div class="dropdown">
		<button type="button" title="@lang('layout.PageDirection')" class="theme-switcher btn btn-icon btn-outline-secondary fs-lg border-0 rounded-circle animate-scale" data-bs-toggle="dropdown">
			@if(App::isLocale('en'))
			<span class=" d-flex animate-target">
				<i class="ci-flag"></i>
			</span>
			@else
			<span class=" d-flex animate-target">
				<i class="ci-flag"></i>
			</span>
			@endif
		</button>
		<ul class="dropdown-menu" style="--cz-dropdown-min-width: 9rem">
			<li>
				<a href="#" onclick="changeLang('fa')" class="dropdown-item {{(App::isLocale('fa'))?'active':''}}" >
					<span class="theme-icon d-flex fs-base me-2">
						<i class="ci-arrow-left-circle"></i>
					</span>
					<span class="theme-label">@lang('layout.RTL')</span>
					<i class="item-active-indicator ci-check ms-auto"></i>
				</a>
			</li>
			<li>
				<a href="#" onclick="changeLang('en')" class="dropdown-item {{(App::isLocale('en'))?'active':''}}" aria-pressed="false">
					<span class="theme-icon d-flex fs-base me-2">
						<i class="ci-arrow-right-circle"></i>
					</span>
					<span class="theme-label">@lang('layout.LTR')</span>
					<i class="item-active-indicator ci-check ms-auto"></i>
				</a>
			</li>	
		</ul>
	</div>
	<!-- Theme languages (Farsi/English) -->
	<div class="dropdown">
		<button type="button" title="@lang('layout.SelectLanguage')" class="theme-switcher btn btn-icon btn-outline-secondary fs-lg border-0 rounded-circle animate-scale" data-bs-toggle="dropdown">
			<span class=" d-flex animate-target">
				<i class="fa fa-language"></i>
			</span>
		</button>
		<ul class="dropdown-menu" style="--cz-dropdown-min-width: 9rem">
			<li id="google_translate_element">
				
			</li>	
		</ul>
	</div>
	<!-- Search toggle button visible on screens < 768px wide (md breakpoint) -->
	<button type="button" class="btn btn-icon fs-xl btn-outline-secondary border-0 rounded-circle animate-shake d-md-none" data-bs-toggle="collapse" data-bs-target="#searchBar" aria-controls="searchBar" aria-label="Toggle search bar">
		<i class="ci-search animate-target"></i>
	</button>
	<!-- Account button visible on screens > 768px wide (md breakpoint) -->
	{{-- @dd(session()->get('online_system_config')) --}}
	@if(!session()->has('online_user') && session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1)
	<a class="btn btn-icon fs-lg btn-outline-secondary border-0 rounded-circle animate-shake d-none d-md-inline-flex" href="{{route('online.login')}}">
		<i class="ci-user animate-target"></i>
		<span class="visually-hidden">@lang('layout.Account')</span>
	</a>
	@endif
	@if(session()->has('online_user') && session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
	<a type="button" class="btn btn-icon fs-xl btn-outline-secondary position-relative border-0 rounded-circle animate-scale" data-bs-toggle="offcanvas" data-bs-target="#userLogedin" aria-controls="userLogedin" aria-label="Account Login">
		<i class="ci-user animate-target"></i>
		<span class="visually-hidden">@lang('layout.Account')</span>
	</a>
	@endif
	@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
	<div class="d-flex align-items-center ms-1 ms-lg-3">
		<!--begin::Menu wrapper-->
		<div class="btn btn-icon btn-active-light-primary position-relative w-30px h-30px w-md-40px h-md-40px animate-scale" data-bs-toggle="offcanvas" data-bs-target="#chatpart" onclick="getMessageAllList()" id="kt_drawer_chat_toggle">
			<a type="button" class="btn btn-icon fs-xl btn-outline-secondary position-relative border-0 rounded-circle animate-scale">
				<i class="ci-chat animate-target"></i>
			</a>
			<!--end::Svg Icon-->
			<i id="alert_count">
			<span v-if="alert > 0" class="bullet bullet-dot bg-success h-6px w-6px position-absolute translate-middle top-0 start-50 animation-blink"></span>
			</i>
		</div>
		<!--end::Menu wrapper-->
	</div>
	@endif
	@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
	<div id="wish_list_count_vue" v-cloak>
		<button type="button" class="btn btn-icon fs-xl btn-outline-secondary position-relative border-0 rounded-circle animate-scale" data-bs-toggle="offcanvas" data-bs-target="#WishList" aria-controls="WishList" aria-label="Wish List">
			<span class="position-absolute top-0 start-100 badge fs-xs text-bg-primary rounded-pill ms-n3 z-2" style="--cz-badge-padding-y: .25em; --cz-badge-padding-x: .42em" v-if="count_order_items1>0">
			@{{count_order_items1}}
			</span>
			<i class="ci-heart animate-target"></i>
		</button>
	</div>
	@endif
	@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
	<div id="order_list_count_vue" v-cloak>
		<button type="button" class="btn btn-icon fs-xl btn-outline-secondary position-relative border-0 rounded-circle animate-scale" data-bs-toggle="offcanvas" data-bs-target="#shoppingCart" aria-controls="shoppingCart" aria-label="Shopping cart">
			<span class="position-absolute top-0 start-100 badge fs-xs text-bg-primary rounded-pill ms-n3 z-2" style="--cz-badge-padding-y: .25em; --cz-badge-padding-x: .42em" v-if="count_order_items>0">@{{count_order_items}}</span>
			<i class="ci-shopping-cart animate-target"></i>
		</button>
	</div>
	@endif
	</div>
</div>
<!-- Search collapse available on screens < 768px wide (md breakpoint) -->
<div class="collapse d-md-none" id="searchBar">
	<div class="container pt-2 pb-3">
	<div class="position-relative">
		<i class="ci-search position-absolute top-50 translate-middle-y d-flex fs-lg ms-3"></i>
		<input type="search" class="form-control form-icon-start rounded-pill" placeholder="Search for products" data-autofocus="collapse">
	</div>
	</div>
</div>
</header>
{{-- end of navigation bar (page header) --}}