@extends('online.masters.app')
@section('style')
 	@if(App::isLocale('en'))
	<link href="{{url('/online/assets-v7/css/pages/wizard/wizard-4.css')}}" rel="stylesheet" type="text/css" />
    @else
	<link href="{{url('/online/assets-v7/css/pages/wizard/wizard-4.rtl.css')}}" rel="stylesheet" type="text/css" />
    @endif
@endsection
@section('content')
    <main class="content-wrapper">
		<nav class="container pt-1 pt-md-0 my-3 my-md-4" aria-label="breadcrumb">
		  <ol class="breadcrumb mb-0">
		  </ol>
		</nav>
		<section class="container mb-3" id="printableArea">
			<div class="border rounded">
				<div class="d-flex border-bottom">
					<div class="invoice-content px-2 mb-3" style="width: 80%;">
						<h5 class="almost-gray text-center mt-2"><span>{{$online_system_config->company_name}}</span></h5>
						<div class="d-flex" style=" padding: 0px !important; margin: 0px !important;">
							<div class="col-3" style="padding: 0px !important; margin: 0px !important;">
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">@lang('layout.Customer')</span> </p>
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">@lang('layout.OrderNumber')</span></p>
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">@lang('layout.Phone')</span></p>
							</div>
							<div class="col-3">
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">{{$online_order->fname}}</span></p>
								<p class="gray-ish text-danger border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">{{$online_order->number}}</span></p>
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">{{$online_system_config->phone}}</span></p>
							</div>
							<div class="col-3 text-right total-field">
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">@lang('layout.Email')</span></p>
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">@lang('layout.Date')</span></p>
								<p class="almost-gray border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">@lang('layout.DeliveryDate')</span></p>
							</div>
							<div class="col-3 text-right total-field">
								<p class="gray-ish border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">{{$online_order->email}}</span></p>
								<p class="almost-gray border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">{{$online_order->date}}</span></p>
								<p class="almost-gray border" style="padding: 0px !important; margin: 0px !important;"><span class="ms-2">{{$online_order->delivery_date}}</span></p>
							</div>
						</div>
					</div>
					<div class=" invoice-header px-3 d-flex justify-content-center align-items-center" style="width: 20%;">
						<div class="col-12 text-center">
							<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.$online_system_config->logo}}" style="width: 80%" loading="lazy" alt="" />
						</div>
					</div>
				</div>
				<div class="mt-2" style="padding: 0px !important;">
					<div class="col-11 d-flex mx-auto invoice-table">
						<table class="table table-hover" style="padding: 0px !important; margin: 0px !important;">
							<thead class="thead splitForPrint" style="padding: 0px !important; margin: 0px !important;">
								<tr style="padding: 0px !important; margin: 0px !important;">
									<th scope="col gray-ish" style="padding: 0px !important; margin: 0px !important;">#</th>
									<th scope="col gray-ish" style="padding: 0px !important; margin: 0px !important;">@lang('layout.Items')</th>
									<th scope="col gray-ish" style="padding: 0px !important; margin: 0px !important;">@lang('layout.Quantity')</th>
									<th scope="col gray-ish" style="padding: 0px !important; margin: 0px !important;">@lang('layout.UnitPrice')</th>
									<th scope="col gray-ish" style="padding: 0px !important; margin: 0px !important;">@lang('layout.Amount')</th>
								</tr>
							</thead>
							<tbody style="padding: 0px !important; margin: 0px !important;">
								<?php 
									$total_amount = 0;
									$number_count = 0;
								?>
								@if($online_order_list)
								@foreach($online_order_list AS $record)
								<?php $total_amount += ($record->cost * $record->quantity); ?>
								<tr style="padding: 0px !important; margin: 0px !important;">
									<th scope="row" style="padding: 0px !important; margin: 0px !important;">{{++$number_count}}</th>
									<td style="padding: 0px !important; margin: 0px !important;" class="">
										<div class="d-flex align-items-center">
										  <a class="position-relative flex-shrink-0">
											@if($record->image)
											<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" width="50" id="imageElement{{$record->id}}" style="cursor: zoom-in" loading="lazy" alt="Thumbnail" onclick="openFullscreen('imageElement{{$record->id}}')">
											@else
											<img src="{{asset('uploads/online_item/product.png')}}" width="50" id="imageElement{{$record->id}}" style="cursor: zoom-in" loading="lazy" alt="Thumbnail" onclick="openFullscreen('imageElement{{$record->id}}')">
											@endif
										  </a>
										  <div class="ps-2 ps-xl-3">
											<h5 class="lh-sm mb-2">
											  <a class="hover-effect-underline fs-sm fw-medium">{{$record->name}}</a>
											</h5>
										  </div>
										</div>
									</td>
									<td style="padding: 0px !important; margin: 0px !important;">{{$record->quantity}}</td>
									<td style="padding: 0px !important; margin: 0px !important;">{{round($record->cost,2)}} {{$record->currency}}</td>
									<td style="padding: 0px !important; margin: 0px !important;">{{round(($record->cost * $record->quantity),2)}} {{$record->currency}}</td>
								</tr>
								@endforeach
								@endif
							</tbody>
						</table>
					</div>
				</div>
				<div>
					<div class="col-12 mb-3 pr-4 sub-table mt-3">
						<table class="table" style="border: none; outline: none;">
							<tbody>
								<tr class="d-flex justify-content-between">
									<th scope="row gray-ish" class="ms-5">@lang('layout.TotalAmount')</th>
									<td class="text-right" style="margin-left: 16%;font-weight: bold;">{{ round($total_amount,2) }} {{$online_order->currency}}</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</section>
		<button class="btn btn-primary btn-sm d-flex mx-auto mb-3" style="border-radius: 7px;" id="printButton" onclick="printDiv()">
			@lang('layout.Print') @lang('layout.OrderDetail')
			<i class="ci-printer fs-lg ms-1 me-n1"></i>
		</button>
	  </main>
	  <script>
		function printDiv(divId){
			document.getElementById('printButton').style.display = 'none';
			var printContents = document.getElementById('printableArea').innerHTML;
			var originalContents = document.body.innerHTML;
			document.body.innerHTML = printContents;
			window.print();
			document.body.innerHTML = originalContents;
			location.reload();
		}
		function openFullscreen(imageId){
			var imageElement = document.getElementById(imageId);
			if(imageElement.requestFullscreen){
				imageElement.requestFullscreen();
			}
			else if(imageElement.mozRequestFullScreen){
				imageElement.mozRequestFullScreen();
			}
			else if(imageElement.webkitRequestFullscreen){
				imageElement.webkitRequestFullscreen();
			}
			else if(imageElement.msRequestFullscreen){
				imageElement.msRequestFullscreen();
			}
		}
	  </script>
@endsection
@push('scripts')
@endpush