@extends('online.masters.app')
@section('style')
@endsection
@section('content')
	<?php
		if (isset($_GET['search'])) {
			Session()->put('on_search', $_GET['search']);
		}
		if (isset($_GET['color'])) {
			Session()->put('on_color', $_GET['color']);
		}
		if (isset($_GET['brand'])) {
			Session()->put('on_brand', $_GET['brand']);
		}
		if (isset($_GET['category'])) {
			Session()->put('on_category', $_GET['category']);
		}
		if (isset($_GET['selectCategory'])) {
			Session()->put('on_selectCategory', $_GET['selectCategory']);
		}
		if (isset($_GET['selectBrand'])) {
			Session()->put('on_selectBrand', $_GET['selectBrand']);
		}
	?>
    <!-- Page content -->
    <main class="content-wrapper">
		<!-- Breadcrumb -->
		<nav class="container position-relative z-2 pt-lg-2 mt-3 mt-lg-4 mb-5 mt-5" aria-label="breadcrumb">
			<h3 class="font-weight-bold my-1 text-center">@lang('layout.Products')</h3>
		</nav>
		<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5">
			<div class="row">
			  <!-- Product grid -->
			  <div class="col-lg-9">
				<!-- Grid -->
				<div class="row row-cols-2 row-cols-sm-3 row-cols-md-3 row-cols-lg-3 row-cols-xl-3 g-4">
					@if($allProduct)
					@foreach($allProduct AS $record)
					<!-- Item -->
					<div class="col">
						<div class="card product-card h-100 bg-transparent" style="box-shadow: 0px 0px 5px rgba(224, 224, 224, 0.917);">
						  <div class="position-relative z-2">
							<a class="d-block p-2 p-lg-3 mb-2" href="{{route('online.ItemDetails',$record->id)}}">
							  <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)">
								@if($record->image)
								<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" loading="lazy" alt="Image">
								@else
								<img src="{{asset('uploads/online_item/product.png')}}" loading="lazy" alt="Image">
								@endif
							  </div>
							</a>
							<div class="position-absolute w-100 start-0 bottom-0">
								<div class="d-flex justify-content-end px-2 px-lg-3 pb-2 pb-lg-3">
								  <div class="count-input count-input-collapsible collapsed justify-content-between w-100 bg-transparent border-0 rounded-2">
									<button type="button" class="btn btn-icon btn-sm btn-primary" data-decrement="" aria-label="Decrement quantity">
									  <i class="ci-minus fs-sm"></i>
									</button>
									<input type="number" class="form-control form-control-sm bg-primary text-white w-100" value="0" min="0" readonly="">
									<a type="button" href="{{route('online.ItemDetails',$record->id)}}" class="product-card-button btn btn-icon btn-sm btn-secondary ms-auto" title="@lang('layout.QuickView')">
									  <i class="ci-eye fs-sm"></i>
									</a>
									@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
									<a type="button" onclick="putPurchase({{$record->id}})" class="product-card-button btn btn-icon btn-sm btn-secondary ms-auto" data-increment="" aria-label="Increment quantity" title="@lang('layout.Purchase')">
									  <span data-count-input-value=""></span>
									  <i class="ci-plus fs-sm"></i>
									</a>
									@endif
								  </div>
								</div>
							</div>
						  </div>
						  <div class="card-body pt-0 px-1 px-md-2 px-lg-3 pb-2">
							<h3 class="fs-sm lh-base mb-0 text-center">
								<a class="hover-effect-underline fw-bold" href="{{route('online.ItemDetails',$record->id)}}">{{$record->name}}</a>
							</h3>
						  </div>
						  <div class="fs-xs text-body-secondary px-1 px-md-2 px-lg-3 pb-2 pb-md-3 text-center">
								<span class="font-weight-bold">
									<?php
									$des = wordwrap(substr($record->description, 0, 120), 60, "<br/>\n", false);
									echo $des;
									?>
								</span>
							</div>
						</div>
					  </div>
					@endforeach
					@endif
				</div>
				<!-- Pagination -->
				@if ($allProduct->hasPages())
				<nav class="border-top mt-4 pt-3" aria-label="Catalog pagination">
				  <ul class="pagination pagination-lg pt-2 pt-md-3">
					<li class="page-item me-auto">
						@if (!$allProduct->onFirstPage())
						<a href="{{ $allProduct->url($allProduct->onFirstPage()) }}" class="page-link d-flex align-items-center h-100 fs-lg px-2" aria-label="Previous page">
							<i class="ci-chevron-left mx-1"></i>
						</a>
						@endif
						@if ($allProduct->onFirstPage())
						<a href="#" class="disabled page-link d-flex align-items-center h-100 fs-lg px-2">
						</a>
						@else
						<a href="{{ $allProduct->previousPageUrl() }}" class="page-link d-flex align-items-center h-100 fs-lg px-2">
						</a>
						@endif
					</li>
					@for($i= 1; $i <= $allProduct->lastPage(); $i++)
					<li class="page-item active" aria-current="page">
						@if ($i == $allProduct->currentPage())
						<a href="{{ $allProduct->url($i) }}" class="page-link btn btn-icon btn-sm border-0 btn-hover-primary active mr-2 my-1">{{ $i }}</a>
						@else
						<a href="{{ $allProduct->url($i) }}" class=" btn btn-icon btn-sm border-0 btn-hover-primary mr-2 my-1">{{ $i }}</a>
						@endif
					</li>
					@endfor
					<li class="page-item ms-auto d-flex">
					 	@if ($allProduct->hasMorePages())
							<a href="{{ $allProduct->nextPageUrl() }}" class="page-link d-flex align-items-center h-100 fs-lg" aria-label="Next page">
							</a>
						@else
							<a href="#" class=" disabled page-link d-flex align-items-center h-100 fs-lg">
							</a>
						@endif
						@if($allProduct->lastPage())
							<a href="{{ $allProduct->url($allProduct->lastPage()) }}" class="page-link d-flex align-items-center h-100 fs-lg">
								<i class="ci-chevron-right"></i>
							</a>
						@endif
					</li>
				  </ul>
				</nav>
				@endif
			  </div>
			  <!-- Filter sidebar that turns into offcanvas on screens < 992px wide (lg breakpoint) -->
			  <aside class="col-lg-3" style="padding: 0px !important; margin: 0px !important;">
				<div class="offcanvas-lg offcanvas-start">
				  <div class="offcanvas-body flex-column pt-2 py-lg-0">
					<div>
						<!-- products Category and Brand -->
						<div class="d-flex border rounded-5">
							<div class="w-100">
								<div class="card product-card h-100 bg-transparent border-0 shadow-none">
									{{Form::open(['route' => 'online.ItemDetailsAll','method' => 'GET'])}}
									<h2 class="h5 pt-2 text-center mt-3">@lang('layout.Categories')</h2>
									<div class="form-group" style="box-shadow: 0px 0px 3px white;padding: 8px;">
										@if($inventoryCategory)
										@foreach($inventoryCategory AS $key => $record3)
										<label class="checkbox checkbox-lg mb-7 d-flex justify-content-between mb-2" style="width: 100%;">
											<div class="d-flex">
												<input type="checkbox" name="selectCategory[]" value="{{$record3->id}}" class="me-2" />
												<div class="font-size-lg text-dark-75 font-weight-bold">{{$record3->name}}</div>
											</div>
											<div class="font-weight-bold bg-danger rounded-pill text-white" style="padding: 0px 7px;">{{$record3->total}}</div>
										</label>
										@endforeach
										@endif
									</div>
									<h2 class="h5 pt-2 text-center">@lang('layout.Brand')</h2>
									<div class="form-group" style="box-shadow: 0px 0px 3px white;padding: 8px;">
										@if($inventoryBrand)
										@foreach($inventoryBrand AS $key => $recordB)
										<label class="checkbox checkbox-lg mb-7 d-flex justify-content-between mb-2" style="width: 100%;">
											<div class="d-flex">
												<input type="checkbox" name="selectBrand[]" value="{{$recordB->id}}" class="me-2"/>
												<div class="font-size-lg  font-weight-bold">{{$recordB->name}}</div>
											</div>
											<div class="font-weight-bold bg-danger rounded-pill text-white" style="padding: 0px 7px;">{{$recordB->total}}</div>
										</label>
										@endforeach
										@endif
									</div>
									<h2 class="h5 pt-2 text-center">@lang('layout.Color')</h2>
									<div class="form-group d-flex" style="box-shadow: 0px 0px 3px white;padding: 8px;">
										@if($color)
										@foreach($color AS $record4)
										<label class="checkbox checkbox-lg mb-7 mb-2" style="width: 50%;">
											<div class="d-flex">
												<input type="radio" name="color" value="{{$record4->color}}" class="me-2"/>
												<span style="background-color: {{$record4->color}} !important; padding: 10px;border-radius: 50%;"></span>
											</div>
										</label>
										@endforeach
										@endif
									</div>
									<input type="hidden" name="search_form" value="on" />
									<div class="form-group m-2 d-flex justify-content-center gap-2">
										<button type="submit" class="btn btn-primary font-weight-bolder mr-2 px-8" style="border-radius: 7px;">@lang('layout.Search')</button>
										<button type="reset" class="btn btn-clear font-weight-bolder px-8 border" style="border-radius: 7px">@lang('layout.Reset')</button>
									</div>
									{!! Form::close() !!}
								</div>
							</div>
						</div>
					</div>
					<!-- Banner -->
					<div class="rounded-5 overflow-hidden mt-2" style="background-color: #a6cddc" data-bs-theme="light">
						<div class="pt-3 px-3 mt-3 mx-3">
							<h4 class="mb-2 mb-xl-3 text-center">@lang('layout.BestProducts')</h4>
							<div class="nav">
							<a class="nav-link animate-underline stretched-link px-0" >
								<i class="fs-base mt-3 ms-1"></i>
							</a>
							</div>
						</div>
						<div class="ratio mt-n2" style="--cz-aspect-ratio: calc(240 / 282 * 100%)">
							<div class="swiper position-absolute top-0 start-0 w-100 h-100" data-swiper="{ &quot;effect&quot;: &quot;fade&quot;, &quot;loop&quot;: true, &quot;speed&quot;: 400, &quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;autoplay&quot;: { &quot;delay&quot;: 5500, &quot;disableOnInteraction&quot;: false } }" data-bs-theme="dark">
								<div class="swiper-wrapper">
									<!-- Slide1 -->
									@if($allProduct)
										@foreach($allProduct AS $record)
										<div class="swiper-slide">
											@if($record->image)
											<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" loading="lazy" alt="Banner">
											@else
											<img src="{{asset('uploads/online_item/product.png')}}" loading="lazy" alt="Banner">
											@endif
										</div>
										@endforeach
									@endif
								</div>
								<!-- Slider pagination (Bullets) -->
							</div>
							<div class="d-md-none" style="height: 380px"></div>
							<div class="d-none d-md-block d-lg-none" style="height: 420px"></div>
							<div class="d-none d-lg-block d-xl-none" style="height: 500px"></div>
							<div class="d-none d-xl-block d-xxl-none" style="height: 560px"></div>
							<div class="d-none d-xxl-block" style="height: 624px"></div>
						</div> 
					</div>
				  </div>
				</div>
			  </aside>
			</div>
		  </section>
	</main>
@endsection
@push('scripts')
<!--begin::Page Scripts(used by this page)-->
<script src="{{url('/online/assets-v7/js/pages/widgets.js')}}"></script>
<script src="{{url('/online/assets-v7/js/pages/custom/profile/profile.js')}}"></script>
<!--end::Page Scripts-->
<?php
    $company_number =  null;
    $site_link =  null;
    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>
<script type="text/javascript">
	var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";
	function getAdvertisment(com_num, type, loc) {
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
				data:{session_id:session_id,url:url},
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'left') {
                                left_adver_lg.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_lg.link = result.link;
                                left_adver_lg.title = result.title;
                                left_adver_sm.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_sm.link = result.link;
                                left_adver_sm.title = result.title;
                            }
                        }
                    }
                    // console.log(130,result);
                },
                error: function(error) {
                    console.log(140,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);
                }
            });
        }
    }
    // $(document).ready(function () {
    //     getAdvertisment(1, 'top');
    // });
	var uploads_adve = '{{$site_link}}';
    var top_adver = new Vue({
        el: '#top_adver',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 3, 'top'); 
            }
        },
        methods: {
        }
    });    
    var left_adver_lg = new Vue({
        el: '#left_adver_lg',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 3, 'left'); 
            }
        },
        methods: {
        }
    });
    var left_adver_sm = new Vue({
        el: '#left_adver_sm',
        data: {
            title: '',
            link: '',
            image: '',
            com_num: '{{$company_number}}',
            uploads_adve: '{{$site_link}}'
        },
        mounted: function () {
            if (this.com_num) {
                getAdvertisment(this.com_num, 3, 'left'); 
            }
        },
        methods: {
        }
    });
	function putPurchase (id){
		if (id != null) {
			$.ajax({
				type: 'POST',
				url: "{{url('onlinePutPurchase')}}/" + id,
				headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
				success: function (result) {
					toastr.success('', result.message);
					orderLisVue.getOrderList(user_id, session_id);
					// table.ajax.reload();
					console.log(13,result);
					// location.reload();
				},
				error: function (error) {
					var message = "{{__('message.Warning')}}";
					toastr.warning('', message);
					// swal("{{__('message.Warning')}}", error.responseJSON.message);
				}
			});
		}
    } 
</script>
@endpush