@extends('online.masters.app')
@section('style')
@endsection
@section('content')
	<!-- Page content -->
	<main class="content-wrapper">
		<!-- Breadcrumb -->
		<nav class="container position-relative z-2 mb-5 mt-5 text-center" aria-label="breadcrumb">
			<h2 class="font-weight-bold my-1 mr-5">{{$item->name}}</h2>
		</nav>
		<!-- Product gallery + Product details -->
		<section class="container mb-2 mb-sm-3 mb-lg-4 mb-xl-5">
			<div class="row align-items-start" id="image_v" v-cloak>
				<!-- Product gallery -->
				<div class="col-md-8 col-lg-8 sticky-md-top z-1 mb-md-0" style="margin-top: -120px">
					<div class="d-flex" style="padding-top: 120px">
						<!-- Thumbnails -->
						<div class="swiper swiper-load swiper-thumbs d-none d-lg-block w-100 me-xl-3" id="thumbs" data-swiper="{&quot;direction&quot;: &quot;vertical&quot;,&quot;spaceBetween&quot;: 12,&quot;slidesPerView&quot;: 4,&quot;watchSlidesProgress&quot;: true }" style="max-width: 96px; height: 420px;">
							<div class="swiper-wrapper flex-column">
								<div class="swiper-slide swiper-thumb border rounded-5 mb-1 active">
									<div class="ratio ratio-1x1" style="max-width: 94px" v-if='item_image_base'>
										<img :src="uploads+'/'+item_image_base" @click="changeImg(item_image_base)" class="swiper-thumb-img" loading="lazy" alt="Thumbnail" v-cloak>
									</div>
									<div class="ratio ratio-1x1" style="max-width: 94px" v-if='!item_image_base'>
										<img :src="uploads+'/'+'product.png'" @click="changeImg(item_image_base)" class="swiper-thumb-img" loading="lazy" alt="Thumbnail" v-cloak>
									</div>
								</div>
								{{-- @dd($image); --}}
								@if($image)
								@foreach($image AS $record1)
								<div class="swiper-slide swiper-thumb border rounded-5 mb-1 active">
									<div class="ratio ratio-1x1" style="max-width: 94px">
										<div title="{{substr($record1->description,0,120)}}">
											<img alt="Pic" loading="lazy" v-cloak class="swiper-thumb-img" @click="changeImg('{{$record1->source}}')" src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record1->source}}" />
										</div>
									</div>
								</div>
								@endforeach
								@endif
							</div>
						</div>
						<div class="swiper w-100" data-swiper="{&quot;loop&quot;: false,&quot;thumbs&quot;: { &quot;swiper&quot;: &quot;#thumbs&quot;},&quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true} }">
							<div class="swiper-wrapper">
							<div class="swiper-slide border rounded-5">
								<a class="ratio ratio-1x1 d-block cursor-zoom-in" href="#addPaymentModal" data-bs-toggle="modal" data-glightbox="" data-gallery="product-gallery" v-if='item_image'>
									<img :src="uploads+'/'+item_image" alt="Preview" loading="lazy">
								</a>
								<a class="ratio ratio-1x1 d-block cursor-zoom-in" href="#addPaymentModal" data-bs-toggle="modal" data-glightbox="" data-gallery="product-gallery" v-if='!item_image'>
									<img :src="uploads+'/'+'product.png'" alt="Preview" loading="lazy">
								</a>
							</div>
							</div>
							<!-- Slider pagination (Bullets) visible on screens > 991px wide (lg breakpoint) -->
							<div class="swiper-pagination mb-n3 d-lg-none"></div>
						</div>
					</div>
				</div>
				<!-- Add payment method modal -->
				<div class="modal fade" id="addPaymentModal">
					<div class="modal-dialog modal-dialog-centered modal-xl">
						<div class="modal-content">
							<div class="modal-header" style="border-bottom: none;">
								<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
							</div>
							<div class="modal-body text-center" v-if='item_image'>
								<img :src="uploads+'/'+item_image" style="width: 70%;" alt="Preview" class="img-responsive" loading="lazy">
							</div>
							<div class="modal-body text-center" v-if='!item_image'>
								<img :src="uploads+'/'+'product.png'" style="width: 70%;" alt="Preview" class="img-responsive" loading="lazy">
							</div>
						</div>
					</div>
				</div>
				<!-- Product details -->
				<div class="col-md-4 col-lg-4 position-relative">
					<div class="border rounded-5 mb-2">
						<table class="table" style="border: 1px solid transparent;">
							<tr>
								<td colspan="3" class="fw-bold text-center fs-5">{{$item->name}}</td>
							</tr>
							<tr>
								<td colspan="3" class="text-center">{{$item->description}}</td>
							</tr>
							<tr>
								<td style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
									<span class="fw-bold mb-1">@lang('layout.Price')</span>
									<span>{{$item->price}} {{$item->currency}}</span>
								</td>
								<td>
									<div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
										<span class="fw-bold mb-1">@lang('layout.Brand')</span>
										<span>{{$item->brand_name}}</span> 
									</div>
								</td>
								<td>
									<div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
										<span class="fw-bold mb-1">@lang('layout.Category')</span>
										<span>{{$item->category_name}}</span>	
									</div>	 
								</td>
							</tr>
							<tr>
								<td>
									@if(session()->get('online_system_config'))
									@if(session()->get('online_system_config')->show_onhand === 0)
										<div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
											<span class="fw-bold mb-1">@lang('layout.InStock')</span>
											<span>{{round($item->onhand,2)}}</span>
										</div>
									@endif
									@endif
								</td>
								<td>
									<div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
										<span class="fw-bold mb-1">@lang('layout.Date')</span>
										<span>{{$item->collection}}</span>
									</div>
								</td>
								<td>
									<div style="display: flex; flex-direction: column; justify-content: center; align-items: center;">
										<span class="fw-bold mb-1">@lang('layout.Color')</span>
										<span class="text-dark flex-root font-weight-bold">
											<span style="background-color:{{$item->color}}; width:10px; height:6px;border-radius: 5px;box-shadow: 0px 0px 7px gray;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
										</span>
									</div>
								</td>
							</tr>
							<tr>
								<td colspan="3">
									@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
										<a type="button" class="btn btn-lg btn-primary w-100 text-white" onclick="putPurchase({{$item->id}})" style="border-radius: 7px;">@lang('layout.Purchase')</a>
									@endif
								</td>
							</tr>
						</table>
					</div>
					<div>
						<!-- products Category and Brand -->
						<div class="d-flex border rounded-5 px-2">
							<div class="w-100">
								<div class="card product-card h-100 bg-transparent border-0 shadow-none">
									{{Form::open(['route' => 'online.ItemDetailsAll','method' => 'GET'])}}
									<h2 class="h5 pt-2 text-center">@lang('layout.Categories')</h2>
									<div class="form-group" style="box-shadow: 0px 0px 3px white;padding: 8px;">
										@if($inventoryCategory)
										@foreach($inventoryCategory AS $key => $record3)
										<label class="checkbox checkbox-lg mb-7 d-flex justify-content-between mb-2" style="width: 100%;">
											<div class="d-flex">
												<input type="checkbox" name="selectCategory[]" value="{{$record3->id}}" class="me-2" />
												<div class="font-size-lg text-dark-75 font-weight-bold">{{$record3->name}}</div>
											</div>
											<div class="font-weight-bold bg-danger rounded-pill text-white" style="padding: 0px 7px;">{{$record3->total}}</div>
										</label>
										@endforeach
										@endif
									</div>
									<h2 class="h5 pt-2 text-center">@lang('layout.Brand')</h2>
									<div class="form-group" style="box-shadow: 0px 0px 3px white;padding: 8px;">
										@if($inventoryBrand)
										@foreach($inventoryBrand AS $key => $recordB)
										<label class="checkbox checkbox-lg mb-7 d-flex justify-content-between mb-2" style="width: 100%;">
											<div class="d-flex">
												<input type="checkbox" name="selectBrand[]" value="{{$recordB->id}}" class="me-2"/>
												<div class="font-size-lg  font-weight-bold">{{$recordB->name}}</div>
											</div>
											<div class="font-weight-bold bg-danger rounded-pill text-white" style="padding: 0px 7px;">{{$recordB->total}}</div>
										</label>
										@endforeach
										@endif
									</div>
									<h2 class="h5 pt-2 text-center">@lang('layout.Color')</h2>
									<div class="form-group d-flex" style="box-shadow: 0px 0px 3px white;padding: 8px;">
										@if($color)
										@foreach($color AS $record4)
										<label class="checkbox checkbox-lg mb-7 mb-2" style="width: 50%;">
											<div class="d-flex">
												<input type="radio" name="color" value="{{$record4->color}}" class="me-2"/>
												<span style="background-color: {{$record4->color}} !important; padding: 10px;border-radius: 50%;"></span>
											</div>
										</label>
										@endforeach
										@endif
									</div>
									<input type="hidden" name="search_form" value="on" />
									<div class="form-group m-2 d-flex justify-content-center gap-2">
										<button type="submit" class="btn btn-primary font-weight-bolder mr-2 px-8" style="border-radius: 7px;">@lang('layout.Search')</button>
										<button type="reset" class="btn btn-clear font-weight-bolder px-8 border" style="border-radius: 7px">@lang('layout.Reset')</button>
									</div>
									{!! Form::close() !!}
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- Related Products -->
		<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5">
			<div class="d-flex align-items-center justify-content-between border-bottom pb-3 pb-md-4 mb-3 mb-md-4">
				<h2 class="h3 mb-0">@lang('layout.RelatedProducts')</h2>
				<!-- Slider prev/next buttons -->
				<div class="d-flex gap-2 ms-3">
				<button type="button" class="btn btn-icon btn-outline-secondary animate-slide-start rounded-circle me-1" id="prevBtn" aria-label="Prev">
					<i class="ci-chevron-left fs-lg animate-target"></i>
				</button>
				<button type="button" class="btn btn-icon btn-outline-secondary animate-slide-end rounded-circle" id="nextBtn" aria-label="Next">
					<i class="ci-chevron-right fs-lg animate-target"></i>
				</button>
				</div>
			</div>
			<!-- Slider -->
			<div class="swiper" data-swiper="{&quot;slidesPerView&quot;: 2,&quot;spaceBetween&quot;: 24,&quot;loop&quot;: true,&quot;navigation&quot;: { &quot;prevEl&quot;: &quot;#prevBtn&quot;, &quot;nextEl&quot;: &quot;#nextBtn&quot;},&quot;breakpoints&quot;: {  &quot;500&quot;: {&quot;slidesPerView&quot;: 3 },  &quot;768&quot;: {&quot;slidesPerView&quot;: 4 },  &quot;1100&quot;: {&quot;slidesPerView&quot;: 5  }} }">
				<div class="swiper-wrapper">
					<!-- Product -->
					@if($allProduct)
					@foreach($allProduct AS $record)
					<div class="swiper-slide h-auto">
						<div class="card product-card h-100 bg-transparent" style="box-shadow: 0px 0px 5px rgba(224, 224, 224, 0.917);">
							<div class="position-relative z-2">
								<a class="d-block p-2 p-lg-3 mb-3" href="{{route('online.ItemDetails',$record->id)}}">
									<div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)">
										@if($record->image)
										<img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->image}}" alt="Image" loading="lazy">
										@else
										<img src="{{asset('uploads/online_item/product.png')}}" alt="Image" loading="lazy">
										@endif
									</div>
								</a>
								<div class="position-absolute w-100 start-0 bottom-0">
									<div class="d-flex justify-content-end px-2 px-lg-3 pb-2 pb-lg-3">
										<div class="count-input count-input-collapsible collapsed justify-content-between w-100 bg-transparent border-0 rounded-2">
										<button type="button" class="btn btn-icon btn-sm btn-primary" data-decrement="" aria-label="Decrement quantity">
											<i class="ci-minus fs-sm"></i>
										</button>
										<input type="number" class="form-control form-control-sm bg-primary text-white w-100" value="0" min="0" readonly="">
										<a type="button" href="{{route('online.ItemDetails',$record->id)}}" class="product-card-button btn btn-icon btn-sm btn-secondary ms-auto" title="@lang('layout.QuickView')">
											<i class="ci-eye fs-sm"></i>
										</a>
										@if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
										<a type="button" onclick="putPurchase({{$record->id}})" class="product-card-button btn btn-icon btn-sm btn-secondary ms-auto" data-increment="" aria-label="Increment quantity" title="@lang('layout.Purchase')">
											<span data-count-input-value=""></span>
											<i class="ci-plus fs-sm"></i>
										</a>
										@endif
										</div>
									</div>
								</div>
							</div>
							<div style="padding: 0px !important; margin: 0px !important;">
								<h3 class="fs-sm lh-base mb-0 text-center mb-2">
									<a class="hover-effect-underline fw-bold" href="{{route('online.ItemDetails',$record->id)}}">{{$record->name}}</a>
								</h3>
							</div>
							<div class="text-center" style="margin: 0px !important; padding: 0px !important;">
								<span class="font-size-lg">
									<?php
									$des = wordwrap(substr($record->description, 0, 120), 60, "<br/>\n", false);
									echo $des;
									?>
								</span>
							</div>
						</div>
					</div>
					@endforeach
					@endif
				</div>
			</div>
			<div class="d-flex justify-content-center mt-5">
				<a href="{{route('online.ItemDetailsAll',$item->category_id)}}" class="btn btn-light-primary font-weight-bolder fs-6 border">@lang('layout.ViewAll')</a>
			</div>
		</section>
		<!-- testimonels Part start -->
		<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5" id="comment_part">
			{{-- <div> --}}
			<h2 class="h3 text-center pb-1 pb-sm-2 pb-md-3 pb-lg-0 mb-4 mb-lg-5" id="comments">@lang('layout.Comments')</h2>
			<div class="swiper pb-lg-2" data-swiper="{ &quot;slidesPerView&quot;: 1, &quot;spaceBetween&quot;: 24, &quot;pagination&quot;:{ &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;breakpoints&quot;: { &quot;500&quot;: { &quot;slidesPerView&quot;: 2 }, &quot;768&quot;: { &quot;slidesPerView&quot;: 3 }, &quot;992&quot;: { &quot;slidesPerView&quot;: 4 }}}">
				<div class="swiper-wrapper">
					<!-- Category -->
					<div class="swiper-slide text-center border rounded" v-for="(item,index) in coment" style="padding: 0px 10px;height: 25vh;overflow-y: auto;">
						<div class="position-relative d-inline-block text-dark-emphasis bg-warning-subtle p-1 mt-2" style="width: 4rem;height: 4rem;border-radius: 50%">
							<img src="{{url('online/assets/blank.png')}}" class="" style="border-radius: 50%; width: 100%" alt="" loading="lazy" />
						</div>
						<h3 class="h5 mb-2">
							<a class="animate-underline stretched-link" href="#" v-cloak>
								<span class="animate-target">@{{item.user_name}}</span>
							</a>
						</h3>
						<p class="fs-sm mb-0" style="text-align: justify; text-align-last: center;" v-cloak>@{{item.description}}</p>
					</div>
					<!-- Slider pagination (Bullets) -->
				</div>
				<div class="swiper-pagination position-static mt-3 mt-sm-4"></div>
			</div>
		</section>
		<!-- testimonels Part end -->
  	</main>
	@section('form_sub')
		<div class="border-bottom py-5" id="contact_form" v-cloak>
			<div class="container py-sm-1 py-md-2 py-lg-3" style="border: 1px solid rgb(76, 76, 76);border-radius: 10px;">
			<div>
				<h3 class="pb-1 mb-2 text-center mt-2" style="margin: auto auto">@lang('layout.ContactUs')</h3>
				<div class="text-center w-100">
					<span v-if="success_msg">
						<div class="alert alert-success alert-dismissible" style="display: flex; justify-content: space-between;" id="myAlert">
							<p><strong>@{{success_msg}}</strong></p>
							<a class="close" data-dismiss="alert" aria-label="close" style="cursor: pointer;">&times;</a>
						</div>
					</span>
					<span v-if="warning_msg">
						<div class="alert alert-danger alert-dismissible" style="display: flex; justify-content: space-between;" id="myAlert">
							<p><strong>@{{warning_msg}}</strong></p>
							<a class="close" data-dismiss="alert" aria-label="close" style="cursor: pointer;">&times;</a>
						</div>
					</span>
				</div>
				{{Form::open(['route' => 'comment.store','method' => 'POST','class' => 'position-relative d-flex flex-column flex-sm-row gap-2 pt-3','id'=>'comment-form','id'=>'comment-form'])}}
				{{ csrf_field() }}
				<input type="hidden" value="{{$item->id}}" name="item_id">
				<input type="hidden" value="item" name="category">
				<div class="col-lg-12 col-md-12 col-sm-12">
					<div class="row">
					<div class="col-lg-6 col-md-6 col-sm-12">
						<div class="form-group">
						<label for="name" class="form-label">@lang('layout.Name')</label>
						<input type="text"class="form-control form-control-lg rounded text-start" name="name" required="" v-validate="'required'">
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-12">
						<div class="form-group">
						<label for="name" class="form-label">@lang('layout.Email')</label>
						<input type="email" class="form-control form-control-lg rounded text-start" name="email" required="" v-validate="'required'">
						</div>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12">
						<div class="form-group">
						<label for="name" class="form-label">@lang('layout.Message')</label>
						<textarea class="form-control form-control-lg rounded text-start" rows="2" name="message" required="" v-validate="'required'"></textarea>
						</div>
					</div>
					<button type="button" class="btn btn-primary mt-3 mb-3" style="width: fit-content;margin: auto auto; border-radius: 7px;"  @click="saveAndNew($event)">@lang('layout.SendMessage')</button>
					</div>
				</div>
				{!! Form::close() !!}
			</div>
			</div>
		</div>
	@endsection
	<div id="contact_form1">
	</div>
	<!-- testimonels Part end -->
@endsection
@push('scripts')
<?php
    $company_number =  null;
    $site_link =  null;
    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>
<script type="text/javascript">
	var session_id = "{{session()->get('online_session')}}";
    var url = "{{\URL::to('/')}}";
	@if(session()->has('online_user'))
      var user_id = {{session()->get('online_user')['id']}};
    @endif
	var item_id = {{$item->id}};
	var item_image = "{{$item->image}}";
	var item_image_base = "{{$item->image}}";
	var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";
	function getAdvertisment(com_num, type, loc) {
        // console.log(12,uploads_adve);
        if (com_num != null && type != null && loc != null) {
            $.ajax({
                type: 'GET',
                url: uploads_adve + "/get_advertisment/" + com_num + "/" + type + "/" + loc,
				data:{session_id:session_id,url:url},
                success: function(result) {
                    if (result) {
                        if (result.image != null) {
                            if (result.location == 'top') {
                                top_adver.image = uploads_adve+'/uploads/'+result.image;
                                top_adver.link = result.link;
                                top_adver.title = result.title;
                            }
                            if (result.location == 'left') {
								left_adver_lg.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_lg.link = result.link;
                                left_adver_lg.title = result.title;

                                left_adver_sm.image = uploads_adve+'/uploads/'+result.image;
                                left_adver_sm.link = result.link;
                                left_adver_sm.title = result.title;
                            }
                        }
                    }
                    // console.log(130,result);
                },
                error: function(error) {
                    console.log(140,error);
                    // swal("{{__('message.Warning')}}", error.responseJSON.message);
                }
            });
        }
    }
	function putPurchase (id){
		// console.log(12,id);
		if (id != null) {
			$.ajax({
				type: 'POST',
				url: "{{url('onlinePutPurchase')}}/" + id,
				headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
				success: function (result) {
					toastr.success('', result.message);
					orderLisVue.getOrderList(user_id, session_id);
					// table.ajax.reload();
					console.log(13,result);
					// location.reload();
				},
				error: function (error) {
					var message = "{{__('message.Warning')}}";
					toastr.warning('', message);
					// console.log(14,error);
					// swal("{{__('message.Warning')}}", error.responseJSON.message);
				}
			});
		}
    } 
	var v = new Vue({
		el: '#contact_form',
		data: {
			part: '',
			coment: [],
			success_msg:null,
			error_msg:null,
			warning_msg:null
		},
		computed: {
			setRates() {}
		},
		mounted: function() {
			this.getComent();
		},
		methods: {
			getComent() {
				// console.log(222222221);
				axios.get("{{route('comment.home')}}", {
						params: {
							category: 'item',
							item_id: item_id
						}
					})
					.then(function(response) {
						if (response.data.length > 0) {
							v.coment = [];
							v.coment = response.data;
						}
						// console.log(222, response.data);
					})
					.catch(function(error) {
						console.log(error);
					});
			},
			saveAndNew() {
				v.success_msg = null
				v.error_msg = null
				v.warning_msg = null
				// this.$validator.validate()
					// .then(valid => {
					// 	if (valid) {
							var url = "{{route('comment.store')}}";
							form_id = 'comment-form';
							var data = $('#' + form_id).serialize();
							// toggleBlock(true);
							axios.post(url, data)
								.then(function(response) {
									// toggleBlock(0);
									console.log('sss11', response.data);
									if (response.data.result == 1) {
										$('#' + form_id).trigger('reset');
										//$('#success-sound')[0].play();
										v.success_msg = response.data.message
										// toastr.success('', response.data.message);
									} else {
										var message = "{{__('message.Warning')}}";
										v.error_msg = message
										//$('#error-sound')[0].play();
										// toastr.warning('', message);
									}
								})
								.catch(function(error) {
									// toggleBlock(0);
									console.log(error);
									var message = "{{__('message.Warning')}}";
									//$('#error-sound')[0].play();
									// toastr.warning('', message);
									v.warning_msg = message
								});
					// 	}
					// })
			},
		},
		created: function() {
		}
	});
	var vim = new Vue({
		el: '#image_v',
		data: {
			item_image: item_image,
			item_image_base: item_image_base,
			uploads: uploads
		},
		methods: {
			changeImg(image) {
				vim.item_image = image;
			},
		},
	});	
	var vc = new Vue({
		el: '#comment_part',
		data: {
			coment: []
		},
		mounted: function() {
			this.getComent();
		},
		methods: {
			getComent() {
				axios.get("{{route('comment.home')}}", {
						params: {
							category: 'item',
							item_id: item_id
						}
					})
					.then(function(response) {
						if (response.data.length > 0) {
							vc.coment = [];
							vc.coment = response.data;
						}
						console.log(222, response.data);
					})
					.catch(function(error) {
						console.log(error);
					});
			}
		}
	});
</script>
@endpush