@extends('online.masters.app')
{{-- @section('style')
@endsection --}}
<style>
	.customSelect{
		background-color: white !important;
	}
</style>
@section('content')
<!-- Page content -->
<main class="content-wrapper">
	<section class="container mb-2 mb-sm-3 mb-lg-4 mb-xl-5">
	  	<div class="row align-items-start" id="app" v-cloak>
			<div class="card-header py-3">
				<div class="card-title align-items-start flex-column text-center">
					<h3 class="card-label font-weight-bolder text-muted">@lang('layout.EditOrders')</h3>
					<span class="font-weight-bold font-size-md mt-1">@lang('layout.Update') @lang('layout.Order') - {{$online_order->number}} : {{$online_order->fname}} </span>
				</div>
			</div>
			{!! Form::model($online_order, ['method' => 'PATCH','route' => ['online.ItemOrder.update',$online_order->id],'class'=>'form','id'=>'personal-form','files'=> true]) !!}
			{{ csrf_field() }}
				<div class="tab-content bg-body rounded-5 py-3 py-sm-4 px-4 px-sm-5 border">
					<div class="tab-pane fade show active border-bottom pb-4" id="customers" role="tabpanel" aria-labelledby="customers-tab">
						<div class="row g-4">
							<div class="col-md-6 position-relative" style="padding: 0px !important; margin: 0px !important;">
								<label for="fn" class="form-label">@lang('layout.Date')</label>
								<input type="text" class="form-control form-control-lg date" id="fn" required="" name="date" value="{{$online_order->date}}" autocomplete="off">
							</div>
							<div class="col-md-6 position-relative" style="padding: 0px !important; margin: 0px !important;">
								<label for="ln" class="form-label">@lang('layout.DeliveryDate')</label>
								<input type="text" class="form-control form-control-lg date ms-2" id="ln" required="" name="delivery_date" value="{{$online_order->delivery_date}}" autocomplete="off">
							</div>
							<div class="col-6 position-relative" style="padding: 0px !important; margin: 0px !important;">
								<label for="message" class="form-label">@lang('layout.Description')</label>
								<textarea class="form-control form-control-lg" id="message" rows="1" required="" name="description">{{$online_order->description}}</textarea>
							</div>
							<div class="col-6 text-center d-flex justify-content-center align-items-center" style="padding: 0px !important; margin: 0px !important;">
								<center>
									@lang('layout.Total') : @{{total}} {{$online_order->currency}}
								</center>
							</div>
						</div>
					</div>
					<!-- Items list -->
					<div class="col-lg-12" v-if="orders.length>0">
						<!-- Table of items -->
						<table class="table position-relative z-2 mb-4">
							<thead>
								<tr style="padding: 0px !important; margin: 0px !important;">
									<th class="ps-0 text-center" style="padding: 0px !important; margin: 0px !important;"><span class="text-body"> # </span></th>
									<th class="text-body text-center" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Photo')</span></th>
									<th class="text-body text-center" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Category')</span></th>
									<th class="text-body text-center" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.ItemName')</span></th>
									<th class="text-body text-center" style="width: 15%;padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Quantity')</span></th>
									<th class="text-body text-center" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Price')</span></th>
									<th class="text-body text-center" style="padding: 0px !important; margin: 0px !important;"><span class="text-body">@lang('layout.Total')</span></th>
									<th class="py-0 px-0" style="padding: 0px !important; margin: 0px !important;">
										<div class="nav justify-content-end">
											<button type="button" class="nav-link d-inline-block text-decoration-underline text-nowrap py-3 px-0">@lang('layout.Action')</button>
										</div>
									</th>
								</tr>
							</thead>
							<tbody class="align-middle">
								<!-- Item -->
								<tr v-for="(item,index) in orders">
									<td class="h6 py-0 d-none d-xl-table-cell text-center" style="padding: 0px !important; margin: 0px !important;">@{{index+1}}</td>
									<td class="py-0 ps-0" style="padding: 0px !important; margin: 0px !important;">
										<div class="d-flex align-items-center justify-content-center">
											<a class="flex-shrink-0" v-if="item.item!=null">
												<span v-if='item.item.image'>
													<img :src="uploads+'/'+item.item.image" width="50" :id="'imageElement'+item.item.id" @click="openFullscreen('imageElement'+item.item.id)" alt="product" loading="lazy" style="cursor: zoom-in;">
												</span>
												<span v-if='!item.item.image'>
													<img :src="uploads+'/'+'product.png'" width="50" :id="'imageElement'+item.item.id" @click="openFullscreen('imageElement'+item.item.id)" alt="product" loading="lazy" style="cursor: zoom-in;">
												</span>
											</a>
										</div>
									</td>
									<td class="h6 d-none d-xl-table-cell text-center" style="padding: 0px !important; margin: 0px !important;">
										<v-select label="name" class="customSelect" style="border: var(--cz-border-width) solid var(--cz-border-color);border-radius: var(--cz-border-radius);" v-model="item.item_category" :options="inventory_category" @Click.native="addNew('order',index)" @input="itemCategoryChange(index)"></v-select>
										<input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
									</td>
									<td class="py-3 d-none d-md-table-cell text-center" style="padding: 0px !important; margin: 0px !important;">
										<div>
											<v-select label="name" class="customSelect" style="border: var(--cz-border-width) solid var(--cz-border-color);border-radius: var(--cz-border-radius);" v-model="item.item" :options="temp_items" @Click.native="addNew('order',index)" @search="onItemSearch"></v-select>
											<input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">
										</div>
									</td>
									<td class="h6 py-3 d-none d-md-table-cell text-center" style="padding: 0px !important; margin: 0px !important;">
										<div>
											<input type="number" name="quantity[]" style="color: black !important;" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number customSelect"  placeholder="@lang('layout.Quantity')">
										</div>
									</td>
									<td class="h6 py-0 d-none d-xl-table-cell text-center" style="padding: 0px !important; margin: 0px !important">
										@{{((item.item==null)?null:(item.item.price))}} @{{(item.item==null)?null:item.item.currency}}
										<input type="hidden" name="price[]" v-model.number="(item.item==null)?null:item.item.price" >
									</td>
									<td class="h6 py-0 d-none d-xl-table-cell text-center" style="padding: 0px !important; margin: 0px !important;">
										@{{((item.item==null)?null:(item.item.price * item.item.quantity))}} @{{(item.item==null)?null:item.item.currency}}
									</td>
									<td class="text-end py-3 px-0" style="padding: 0px !important; margin: 0px !important;">
										<button type="button" class="btn-close fs-sm" v-if="orders.length>1" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-sm" data-bs-title="Remove" aria-label="Remove from cart" v-on:click="deleteItem('order',index)"></button>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="card-header text-center">
						<div class="card-toolbar">
							<button type="button" class="btn btn-sm btn-outline-info" @Click="addNew('order',1000)" ><i class="p-0 ci-plus"></i></button>
							<button type="submit" class="btn btn-sm btn-outline-success">@lang('layout.Update')</button>
							<a href="{{route('online.users.show',$online_order->id)}}" class="btn btn-sm btn-outline-secondary">@lang('layout.Cancel')</a>
						</div>
					</div>
				</div>
			{!! Form::close() !!}
	 	</div>
	</section>
  </main>
<!-- testimonels Part end -->
@endsection
@push('scripts')
<script type="text/javascript">
var uploads = "{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}";
var selected_item = {!! json_encode($online_order_list) !!};
var inventoryCategory = {!! $inventoryCategory !!};
	var v = new Vue({
        el: '#app',
        data: {
            index: 0,
            disabled: false,
			temp_items:[],
            selected_item: selected_item,
            inventory_category: inventoryCategory,
			orders:[],
			uploads:uploads,
        },
		computed: {
			// calculate total
			total: function () {
				var sum = 0;
				for (var i = 0; i < this.orders.length; i++) {
					if (this.orders[i].item && this.orders[i].item != null) {
						if (this.orders[i].item.quantity > 0 && this.orders[i].item.price > 0) {
							this.currency = this.orders[i].item.currency;
							sum += this.orders[i].item.quantity * this.orders[i].item.price;
						}
					}
				}
				return myRound(sum);
				// return (sum);
			},
		},
		mounted:function(){
          // initialize the selected item
			for(var i=0;i<this.selected_item.length;i++)
			{
			// console.log('ssssssss',this.selected_item[i]);
			this.orders.push({item:this.selected_item[i],item_category:null});
			}
			for(var m=4;m>this.selected_item.length;m--)
			{
				this.orders.push({item:null,item_category:null});
			}
        },
        methods: {
			handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        document.getElementById("personal-form").submit()
                    }
                });
            },
			onItemSearch(search){
				let inventory_category_id = (v.orders[this.index]['item_category'] !=undefined)?v.orders[this.index]['item_category'].id:'';
				// console.log(123,search)
				axios.get("{{route('search.item')}}",{
					params:{
						inventory_category_id: inventory_category_id,
						search: search
					}
				})
				.then(function (response)
				{
					v.temp_items=[];
					if(response.data.result.length>0)
					{
						v.temp_items = response.data.result;
					}
				})
				.catch(function (error)
				{
					console.log(error);
				});
			},
			itemCategoryChange(index){
				if(this.orders[index]['item_category'] !=null)
				{
				let inventory_category_id = (v.orders[index]['item_category'] !=undefined)?v.orders[index]['item_category'].id:'';
				
				axios.get("{{route('search.item')}}",{
					params:{
					inventory_category_id: inventory_category_id
					}
				})
				.then(function(response){
					v.temp_items = [];
					if(response.data.result.length >0)
					{
						v.temp_items = response.data.result;
					}
				})
				.catch(function(error){
					console.log(error);
				});
				}
			},
			// generic function for adding item to list
			addNew(type=null,index)
			{
				this.index = index;
				if(type !=null)
				{
					if(type=='order')
					{
						if(this.orders[index+1]==undefined)
						{
						this.temp_items=[];
						this.orders.push({item:null});
						}
					}	
				}	
			},
			// in here you can check and decide to allow duplicate bank for payment or not
			// delete item from list
			deleteItem(type=null,index)
			{
				if(type !=null)
				{
					// console.log(type);
					if(type=='order')
					{
						this.orders.splice(index, 1);
					}	
				}	
			},	
			openFullscreen(imageId){
				const imageElement = document.getElementById(imageId);
				if(imageElement.requestFullscreen){
					imageElement.requestFullscreen();
				}
				else if(imageElement.mozRequestFullScreen){
					imageElement.mozRequestFullScreen();
				}
				else if(imageElement.webkitRequestFullscreen){
					imageElement.webkitRequestFullscreen();
				}
				else if(imageElement.msRequestFullscreen){
					imageElement.msRequestFullscreen();
				}
			}
        },
    });
	Vue.component('v-select', VueSelect.VueSelect);
</script>
@endpush