@extends('online.masters.app')
@section('style')
@endsection
@section('content')
<!-- Hero slider -->
<section class="position-relative">
    <div class="swiper position-absolute top-0 start-0 w-100 h-100" data-swiper="{ &quot;effect&quot;: &quot;fade&quot;, &quot;loop&quot;: true, &quot;speed&quot;: 400, &quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;autoplay&quot;: { &quot;delay&quot;: 5500, &quot;disableOnInteraction&quot;: false } }" data-bs-theme="dark">
        <div class="swiper-wrapper">
            <!-- Slide1 -->
            @if($slider)
                @foreach($slider AS $record)
                <div class="swiper-slide" style="background-color: #6dafca">
                    <div class="position-absolute d-flex align-items-center w-100 h-100 z-2">
                    <div class="container mt-lg-n4">
                        <div class="row">
                        <div class="col-9 col-sm-8 col-md-7 col-lg-6">
                            {{-- <p class="fs-sm text-white mb-lg-4">🔥 Free shipping - order over <strong>50$</strong></p> --}}
                            <h3 class="display-5 pb-2 pb-md-3 pb-lg-4" style="text-shadow: 10px 10px 10px black;">{{substr($record->description,0,120)}}</h3>
                            @if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
                            <a class="btn btn-lg btn-outline-light" style="border-radius: 7px;box-shadow: 0px 0px 5px black;text-shadow: 0px 0px 10px black;" href="{{route('online.ItemDetails',$record->online_item_id)}}">@lang('layout.ShopNow')</a>
                            @endif
                        </div>
                        </div>
                    </div>
                    </div>
                    <img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record->source}}" loading="lazy" class="position-absolute top-0 start-0 w-100 h-100 object-fit-cover rtl-flip" style="background-size: cover;background-position: center center;" alt="Image">
                </div>
                @endforeach
            @endif
        </div>
        <!-- Slider pagination (Bullets) -->
        <div class="swiper-pagination pb-sm-2"></div>
    </div>
    <div class="d-md-none" style="height: 380px"></div>
    <div class="d-none d-md-block d-lg-none" style="height: 420px"></div>
    <div class="d-none d-lg-block d-xl-none" style="height: 500px"></div>
    <div class="d-none d-xl-block d-xxl-none" style="height: 560px"></div>
    <div class="d-none d-xxl-block" style="height: 624px"></div>
</section>
<!-- Categories + Popular products -->
<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5 mt-5" id="ourProduct">
    <div class="row" id="filterCat" v-cloak>
        <!-- Categories list side-->
        <div class="col-lg-3 pb-2 pb-sm-3 pb-md-4 mb-5 mb-lg-0">
            <h2 class="h3 border-bottom pb-3 pb-md-4 mb-4">@lang('layout.Categories')</h2>
            <div class="row nav g-3 g-sm-4">
                {{-- @dd(onlineSystemConfig()['back_site_link']); --}}
                @if($inventoryCategory)
                {{-- @dd($inventoryCategory) --}}
                <?php $cat_co = 0; ?>
                @foreach($inventoryCategory AS $recordc)
                <div class="col-sm-6 col-md-4 col-lg-12 d-flex" @click="getCate({{$recordc->id}})">
                    <div class="position-relative d-flex min-w-0 align-items-center">
                        <div class="d-flex flex-shrink-0 align-items-center justify-content-center bg-body-tertiary rounded-circle" style="width: 56px; height: 56px">
                            @if($recordc->categoryImage)
                            <img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_category_image/' . $recordc->categoryImage}}" loading="lazy" width="40" alt="Image">
                            @else
                            <img src="{{asset('uploads/online_item/category.png')}}" style="border-radius: 50%;" alt="">
                            @endif
                        </div>
                        <div class="min-w-0 ps-3">
                            <a class="nav-link animate-underline stretched-link fs-base fw-semibold p-0 mb-1 <?php if ($cat_co == 0) { echo 'active';} ?>" href="#" data-bs-toggle="tab" data-bs-target="#kt-List-{{$cat_co}}">
                                <span class="animate-target text-truncate">{{$recordc->name}}</span>
                            </a>
                            <div class="fs-xs fw-normal text-body-secondary">{{count($recordc->item)}} @lang('layout.Product')</div>
                        </div>
                    </div>
                </div>
                <?php $cat_co++; ?>
                @endforeach
                @endif
            </div>
        </div>
        <div class="col-lg-9">
            <div class="d-flex align-items-center justify-content-between border-bottom pb-3 pb-md-4 mb-3 mb-lg-4">
                <h2 class="h3 mb-0" style="margin: auto auto;">@lang('menu.OurProduct')</h2>
                <div class="nav ms-3">
                    <a class="nav-link animate-underline px-0 py-2" href="{{route('online.ItemDetailsAll')}}">
                        <span class="animate-target fs-6">@lang('layout.ViewAll')</span>
                        <i class="ci-chevron-right fs-base ms-1"></i>
                    </a>
                </div>
            </div>
            <!-- Products grid -->
            <div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 row-cols-lg-3 row-cols-xl-4 g-4" >
                <div class="col" v-if="cate.length > 0" v-for="(item,index) in cate" v-cloak>
                    <div class="card product-card h-100 bg-transparent" style="box-shadow: 0px 0px 5px rgba(224, 224, 224, 0.917);">
                        <div class="position-relative z-2">
                            @if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
                            <button type="button" class="btn btn-icon btn-sm btn-secondary animate-pulse fs-sm bg-body border-0 position-absolute top-0 end-0 z-2 mt-1 mt-sm-2 me-1 me-sm-2" aria-label="Add to Wishlist"  @click="putWishList(item.item_id)" title="@lang('layout.AddToWishList')">
                                <i v-if="item.wished_item" class="ci-heart-filled text-danger animate-target"></i>
                                <i v-if="!item.wished_item" class="ci-heart animate-target"></i>
                            </button>
                            @endif
                            <a class="d-block p-2 p-lg-3" :href="online_item_route+'/'+item.id">
                                <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)" v-if="item.image">
                                    <img :src="'{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}'+item.image" loading="lazy" alt="Image">
                                </div>
                                <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)" v-if="!item.image">
                                    <img :src="'{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}'+'product.png'" loading="lazy" alt="Image">
                                </div>
                            </a>
                        </div>
                        <div class="card-body pt-0 px-1 px-md-2 px-lg-3 pb-2">
                            <h3 class="fs-sm lh-base mb-0 text-center">
                                <a class="hover-effect-underline fw-normal" :href="online_item_route+'/'+item.id">@{{item.name}}</a>
                            </h3>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
</section>
<!-- New Product start -->
<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5" id="newProduct">
    <div class="d-flex align-items-center justify-content-between border-bottom pb-3 pb-md-4 mb-3 mb-md-4">
        <h2 class="h3 mb-0 text-center">@lang('menu.NewProduct')</h2>
        <div class="nav ms-3">
            <a class="nav-link animate-underline px-0 py-2" href="{{route('online.ItemDetailsAll')}}">
                <span class="animate-target fs-6">@lang('layout.ViewAll')</span>
                <i class="ci-chevron-right fs-base ms-1"></i>
            </a>
        </div>
    </div>
    <!-- Slider -->
    <div id="newProduncts" v-cloak>
        <div class="row row-cols-2 row-cols-sm-3 row-cols-md-5 row-cols-lg-3 row-cols-xl-5 g-4" v-cloak>
            <!-- Item -->
            {{-- @if($NewProduct) --}}
            <div class="col" v-for="(item2,index) in newProduct" v-cloak>
                <div class="card product-card h-100 bg-transparent" style="box-shadow: 0px 0px 5px rgba(224, 224, 224, 0.917);">
                    <div class="position-relative z-2">
                        @if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
                        <button type="button" class="btn btn-icon btn-sm btn-secondary animate-pulse fs-sm bg-body border-0 position-absolute top-0 end-0 z-2 mt-1 mt-sm-2 me-1 me-sm-2" aria-label="Add to Wishlist"  @click="putWishList(item2.item_id)" title="@lang('layout.AddToWishList')">
                            <i v-if="item2.wished_item" class="ci-heart-filled text-danger animate-target"></i>
                            <i v-if="!item2.wished_item" class="ci-heart animate-target"></i>
                        </button>
                        @endif
                        <a class="d-block p-2 p-lg-3" :href="online_item_route+'/'+item2.id">
                            <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)" v-if="item2.image">
                                <img :src="'{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}'+item2.image" alt="Image">
                            </div>
                            <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)" v-if="!item2.image">
                                <img :src="'{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}'+'product.png'" loading="lazy" alt="Image">
                            </div>
                        </a>
                        <div class="position-absolute w-100 start-0 bottom-0">
                            <div class="d-flex justify-content-end px-2 px-lg-3 pb-2 pb-lg-3">
                                <div class="count-input count-input-collapsible collapsed justify-content-between w-100 bg-transparent border-0 rounded-2">
                                    @if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
                                    <button type="button" class="btn btn-icon btn-sm btn-primary" data-decrement="" aria-label="Decrement quantity">
                                        <i class="ci-minus fs-sm"></i>
                                    </button>
                                    <input type="number" class="form-control form-control-sm bg-primary text-white w-100" value="0" min="0" readonly="">
                                    <button type="button" class="product-card-button btn btn-icon btn-sm btn-secondary ms-auto" @click="putPurchase(item2.id)" title="@lang('layout.AddToCart')" data-increment="" aria-label="Increment quantity">
                                    <span data-count-input-value=""></span>
                                    <i class="ci-plus fs-sm"></i>
                                    </button>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0 px-1 px-md-2 px-lg-3 pb-2">
                    <h6 class="fs-md lh-base mb-0 text-center">
                        <a class="hover-effect-underline fw-normal" :href="online_item_route+'/'+item2.id">@{{item2.name}}</a>
                    </h6>
                    </div>
                    <div class="fs-xs text-body-dark px-1 px-md-2 px-lg-3 pb-2 pb-md-3 text-center fw-bold">@{{item2.description}}</div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- New Product carousel end -->
<!-- Recommended products start-->
<section class="container pt-xl-2 pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5" id="recomendedProduct">
    <div class="row">
        <!--Side Banner -->
        <div class="col-sm-5 col-md-4 col-lg-3 mb-5 mb-sm-0">
            <div class="pe-lg-2 pe-xl-4">
                <div class="rounded-4 overflow-hidden" style="background-color: #a6cddc" data-bs-theme="light">
                    <div class="pt-3 px-3 mt-3 mx-3">
                        <h4 class="mb-2 mb-xl-3 text-center">@lang('menu.RecommendedProduct')</h4>
                        <div class="nav">
                        <a class="nav-link animate-underline stretched-link px-0" >
                            <i class="fs-base mt-3 ms-1"></i>
                        </a>
                        </div>
                    </div>
                    <div class="ratio mt-n2" style="--cz-aspect-ratio: calc(240 / 282 * 100%)">
                        <div class="swiper position-absolute top-0 start-0 w-100 h-100" data-swiper="{ &quot;effect&quot;: &quot;fade&quot;, &quot;loop&quot;: true, &quot;speed&quot;: 400, &quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;autoplay&quot;: { &quot;delay&quot;: 5500, &quot;disableOnInteraction&quot;: false } }" data-bs-theme="dark">
                            <div class="swiper-wrapper">
                                <!-- Slide1 -->
                                @if($RecommendedProduct)
                                    @foreach($RecommendedProduct AS $record2)
                                    <div class="swiper-slide">
                                        <img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $record2->image}}" loading="lazy" alt="Banner">
                                    </div>
                                    @endforeach
                                @endif
                            </div>
                            <!-- Slider pagination (Bullets) -->
                            <div class="swiper-pagination pb-sm-2"></div>
                        </div>
                        <div class="d-md-none" style="height: 380px"></div>
                        <div class="d-none d-md-block d-lg-none" style="height: 420px"></div>
                        <div class="d-none d-lg-block d-xl-none" style="height: 500px"></div>
                        <div class="d-none d-xl-block d-xxl-none" style="height: 560px"></div>
                        <div class="d-none d-xxl-block" style="height: 624px"></div>
                    </div>     
                </div>
            </div>
        </div>
        <!-- Special products carousel -->
        <div class="col-sm-7 col-md-8 col-lg-9" id="recommendedProduct">
            <div class="d-flex align-items-center justify-content-between border-bottom pb-3 pb-md-4 mb-3 mb-lg-4">
                <h2 class="h3 mb-0">@lang('menu.RecommendedProduct')</h2>
                <div class="nav ms-3">
                </div>
            </div>
            <div class="swiper" data-swiper="{ &quot;slidesPerView&quot;: 2, &quot;spaceBetween&quot;: 24, &quot;pagination&quot;: { &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;breakpoints&quot;: { &quot;840&quot;: { &quot;slidesPerView&quot;: 3 }, &quot;992&quot;: { &quot;slidesPerView&quot;: 4 }}}">
                <div class="swiper-wrapper">
                    <!-- Product -->
                    <div class="swiper-slide h-auto" v-for="(item1,index) in recommended">
                        <div class="card product-card h-100 bg-transparent" style="box-shadow: 0px 0px 5px rgba(224, 224, 224, 0.917);" v-cloak>
                            <div class="position-relative z-2">
                                @if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
                                <button type="button" class="btn btn-icon btn-sm btn-secondary animate-pulse fs-sm bg-body border-0 position-absolute top-0 end-0 z-2 mt-1 mt-sm-2 me-1 me-sm-2" aria-label="Add to Wishlist"  @click="putWishList(item1.item_id)" title="@lang('layout.AddToWishList')">
                                    <i v-if="item1.wished_item" class="ci-heart-filled text-danger animate-target"></i>
                                    <i v-if="!item1.wished_item" class="ci-heart animate-target"></i>
                                </button>
                                @endif
                                <a class="d-block p-2 p-lg-3" :href="online_item_route+'/'+item1.id">
                                    <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)" v-if='item1.image'>
                                        <img :src="'{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}'+item1.image" loading="lazy" alt="Image">
                                    </div>
                                    <div class="ratio" style="--cz-aspect-ratio: calc(160 / 191 * 100%)" v-if='!item1.image'>
                                        <img :src="'{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/'}}'+'product.png'" loading="lazy" alt="Image">
                                    </div>
                                </a>
                                <div class="position-absolute w-100 start-0 bottom-0">
                                    <div class="d-flex justify-content-end px-2 px-lg-3 pb-2 pb-lg-3">
                                        <div class="count-input count-input-collapsible collapsed justify-content-between w-100 bg-transparent border-0 rounded-2">
                                            @if(session()->get('online_system_config') &&  session()->get('online_system_config')->simple_website !=1 )
                                            <button type="button" class="btn btn-icon btn-sm btn-primary" data-decrement="" aria-label="Decrement quantity">
                                                <i class="ci-minus fs-sm"></i>
                                            </button>
                                            <input type="number" class="form-control form-control-sm bg-primary text-white w-100" value="0" min="0" readonly="">
                                            <button type="button" class="product-card-button btn btn-icon btn-sm btn-secondary ms-auto" @click="putPurchase(item1.id)" data-increment="" aria-label="Increment quantity">
                                                <span data-count-input-value=""></span>
                                                <i class="ci-plus fs-sm"></i>
                                            </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body pt-0 px-1 px-md-2 px-lg-3 pb-2">
                                <h5 class="fs-md lh-base mb-0 text-center">
                                    <a class="hover-effect-underline fw-normal" :href="online_item_route+'/'+item1.id">@{{item1.name}}</a>
                                </h5>
                            </div>
                            <div class="fs-xs text-body-dark px-1 px-md-2 px-lg-3 pb-2 pb-md-3 text-center fw-bold">@{{item1.description}}</div>
                        </div>
                    </div>
                </div>
                <!-- Slider pagination (Bullets) -->
                <div class="swiper-pagination position-static mt-3 mt-sm-4"></div>
            </div>
        </div>
    </div>
</section>
<!-- Recommended products end-->
{{-- future products start  --}}
<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4" id="futureProduct" v-cloak>
    {{-- <div class="row"> --}}
    <!-- Recipes list -->
    <div class="col-lg-12 mb-4 mb-lg-0">
        <div class="row">
            <div class="d-flex align-items-center justify-content-between border-bottom pb-3 pb-md-4 mb-3 mb-md-4">
                <h2 class="h3 mb-4">@lang('menu.IncommmingProduct')</h2>
                <!-- Slider prev/next buttons -->
                <div class="d-flex gap-2 ms-3">
                  <button type="button" class="btn btn-icon btn-outline-secondary animate-slide-start rounded-circle me-1" id="prevBtn" aria-label="Prev">
                    <i class="ci-chevron-left fs-lg animate-target"></i>
                  </button>
                  <button type="button" class="btn btn-icon btn-outline-secondary animate-slide-end rounded-circle" id="nextBtn" aria-label="Next">
                    <i class="ci-chevron-right fs-lg animate-target"></i>
                  </button>
                </div>
            </div>
      
            <!-- Slider -->
            <div class="swiper" data-swiper="{ &quot;slidesPerView&quot;: 2, &quot;spaceBetween&quot;: 24, &quot;loop&quot;: true, &quot;navigation&quot;: { &quot;prevEl&quot;: &quot;#prevBtn&quot;, &quot;nextEl&quot;: &quot;#nextBtn&quot; }, &quot;breakpoints&quot;: {&quot;500&quot;: { &quot;slidesPerView&quot;: 3}, &quot;768&quot;: { &quot;slidesPerView&quot;: 4 }, &quot;1100&quot;: { &quot;slidesPerView&quot;: 3} } }">
            <div class="swiper-wrapper">
                <!-- Product -->
                @if($IncommmingProduct)
                @foreach($IncommmingProduct AS $recordI)
                <div class="swiper-slide h-auto col-lg-4">
                    <div class="position-relative d-flex align-items-start align-items-sm-center mb-4 p-2 rounded" style="border: 1px solid rgba(186, 186, 186, 0.366);">
                        <div class="ratio" style="--cz-aspect-ratio: calc(140 / 196 * 100%); max-width: 196px">
                            <img src="{{onlineSystemConfig()['back_site_link'].'/uploads/online_item/' . $recordI->image}}" loading="lazy" class="rounded" alt="Image">
                        </div>
                        <div class="ps-3 ps-xl-4">
                            <h3 class="fs-base fw-bold lh-base mb-2 mb-xl-3 text-center ">
                                <a class="hover-effect-underline stretched-link" href="{{route('online.ItemDetails',$recordI->id)}}">{{$recordI->name}}</a>
                            </h3>
                            <div class="fs-xs text-body-dark px-1 px-md-2 px-lg-3 pb-2 pb-md-3 text-center fw-bold fs-5">{{substr($recordI->description,0,120)}}</div>
                        </div>
                    </div>
                </div>
                @endforeach
                @endif
            </div>
            </div>
        </div>
        <div class="nav mt-n2 mt-lg-n1 mt-xxl-0">
            {{-- <a class="nav-link animate-underline px-0 py-2" href="{{route('online.ItemDetails',$recordI->id)}}">
            <span class="animate-target text-nowrap">View all</span>
            <i class="ci-chevron-right fs-base ms-1"></i>
            </a> --}}
        </div>
    </div>
</section>
{{-- future products end  --}}
<!-- Recipes -->
<!-- testimonels Part start -->
<section class="container pb-5 mb-2 mb-sm-3 mb-lg-4 mb-xl-5">
    <div >
        <h2 class="h3 text-center pb-1 pb-sm-2 pb-md-3 pb-lg-0 mb-4 mb-lg-5" id="comments">@lang('layout.Comments')</h2>
        <div class="swiper pb-lg-2" data-swiper="{ &quot;slidesPerView&quot;: 1, &quot;spaceBetween&quot;: 24, &quot;pagination&quot;:{ &quot;el&quot;: &quot;.swiper-pagination&quot;, &quot;clickable&quot;: true }, &quot;breakpoints&quot;: { &quot;500&quot;: { &quot;slidesPerView&quot;: 2 }, &quot;768&quot;: { &quot;slidesPerView&quot;: 3 }, &quot;992&quot;: { &quot;slidesPerView&quot;: 4 }}}">
        <div class="swiper-wrapper">
            <!-- Category -->
            @foreach($online_comment as $coment)
            {{-- <div class="swiper-slide text-center" v-for="(item,index) in coment"> --}}
            <div class="swiper-slide text-center rounded border" style="padding: 0px 10px;height: 25vh;">
                <div class="position-relative d-inline-block text-dark-emphasis bg-warning-subtle p-1 mt-2" style="width: 4rem;height: 4rem;border-radius: 50%">
                    <img src="{{url('online/assets/blank.png')}}" class="" loading="lazy" style="border-radius: 50%; width: 100%" alt="" />
                </div>
                <h6 class="h6 mb-2" style="font-size: 16px;">
                    <a class="">
                        {{-- <span class="animate-target">{{$coment->user_name}}</span> --}}
                        <span class="animate-target text-center">{{Str::limit($coment->user_name, 30, '...');}}</span>
                    </a>
                </h6>
                {{-- <p class="fs-sm mb-0">{{$coment->description}}</p> --}}
                <p class="fs-sm mb-0">{{Str::limit($coment->description, 230, '...');}} &nbsp; @if($coment->description == Str::limit($coment->description, 230, '...'))  @else <a href="#addPaymentModal1" data-bs-toggle="modal" class="text-muted" onclick="showModal('{{$coment->user_name}}', '{{$coment->description}}')" id="show-more-btn" style="cursor: pointer;"><i class="ci-info text-muted"></i></a> @endif</p>
            </div>
            @endforeach
        </div>
        <!-- Slider pagination (Bullets) -->
        <div class="swiper-pagination position-static mt-3 mt-sm-4"></div>
        </div>
    </div>
</section>
<!-- modal start -->
<div class="modal fade" id="addPaymentModal1" tabindex="-1" aria-labelledby="addPaymentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
      <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="modal-title"></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" ></button>
        </div>
        <div class="modal-body">
        <p id="descriptionPart" style="text-align: justify;text-align-last: center;"></p>
        </div>
      </div>
    </div>
</div>
{{-- modal end  --}}
<!-- testimonels Part end -->
@section('form_sub')
<div class="border-bottom py-5">
    <div class="container py-sm-1 py-md-2 py-lg-3" style="border: 1px solid rgb(76, 76, 76);border-radius: 10px;">
      <div>
        <h3 class="pb-1 mb-2 text-center mt-2" style="margin: auto auto">@lang('layout.ContactUs')</h3>
        {{Form::open(['route' => 'comment.store','method' => 'POST','class' => 'needs-validation position-relative d-flex flex-column flex-sm-row gap-2 pt-3','id'=>'comment-form'])}}
        {{ csrf_field() }}
        <input type="hidden" value="home" name="category">
        <div class="col-lg-12 col-md-12 col-sm-12">
            <div class="row">
              <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="form-group">
                  <label for="name" class="form-label">@lang('layout.Name')</label>
                  <input type="text"class="form-control form-control-lg rounded text-start" name="name" v-validate="'required'" data-vv-as="@lang('layout.Name')" required="">
                </div>
              </div>
              <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="form-group">
                  <label for="name" class="form-label">@lang('layout.Email')</label>
                  <input type="email" class="form-control form-control-lg rounded text-start" name="email" v-validate="'required'" data-vv-as="@lang('layout.Email')" required="">
                </div>
              </div>
              <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="form-group">
                  <label for="name" class="form-label">@lang('layout.Message')</label>
                  <textarea class="form-control form-control-lg rounded text-start" rows="2" name="message" v-validate="'required'" data-vv-as="@lang('layout.Message')" required=""></textarea>
                </div>
              </div>
              <button type="submit" class="btn btn-primary mt-3 mb-3" style="width: fit-content; margin: auto auto; border-radius: 7px;" @click="saveAndNew($event)">@lang('layout.SendMessage')</button>
            </div>
        </div>
        {!! Form::close() !!}
      </div>
    </div>
</div>
@endsection
<div id="contact_form1">
</div>
@endsection
@push('scripts')
<?php
    $company_number =  null;
    $site_link =  null;
    if( onlineSystemConfig()['advertisment'] == 1)
    {
        $company_number =  onlineSystemConfig()['company_number'];
        $site_link =  onlineSystemConfig()['site_link'];
    }
?>
<script type="text/javascript">

    // const theme = document.documentElement.getAttribute('data-bs-theme');
    // console.log('Current Mode', theme)


    // if(theme === 'dark'){
    //     console.log('Dark Mode')
    // }else{
    //     console.log('Light Mode')
    // }


	function showModal(user_name, description){
		document.getElementById('modal-title').innerText = user_name;
		document.getElementById('descriptionPart').innerText = description;
	}
    var user_id = null;
    var session_id = null;
    @if(session()->has('online_user'))
        user_id = {{session()->get('online_user')['id']}};
    @endif
    @if(session()->has('online_session'))
        session_id = {{session()->get('online_session')}};
    @endif

    var vu = new Vue({
        el: '#filterCat',
        data: {
            part: '',
            cate: [],
            online_item_route:"{{route('online.ItemDetails')}}",
            user_id: user_id,
            session_id: session_id,
            // ,$recordt->item[0]->id
        },
        computed: {
            setRates(){}
        },
		mounted: function() {
            // setInterval(() => {
                this.getCate();
            // }, 1000);

			// this.getCate();
        },
        methods:{
            getCate(category_id = null){
				var v = this;
                axios.get("{{route('onlineHome.category')}}",{
                    params: {
                        category_id: category_id
                    }
                })
                .then(function(response) {
                    v.cate = [];	
                    if (response.data.length > 0) {
                        v.cate = response.data;
                    }
                    console.log(222, v.cate,v.route);
                })
                .catch(function(error) {
                    console.log(error);
                });
            },
            putWishList(id){  
                if (id != null) {
                    $.ajax({
                    type: 'POST',
                    url: "{{url('onlinePutWishList')}}/" + id,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        toastr.success('', result.message);
                        wishLisVue.getWishList(user_id, session_id);
                        vu.getCate();
                        // table.ajax.reload();
                        console.log(13,result);
                        // location.reload();
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);
                    }
                    });
                }
            }
        }
    });

    var vuRecommendedProduct = new Vue({
        el: '#recommendedProduct',
        data: {
            part: '',
            recommended: [],
            online_item_route:"{{route('online.ItemDetails')}}",
            user_id: user_id,
            session_id: session_id,
        },
        computed: {
            setRates(){}
        },
		mounted: function() {
                this.getRecommended();
        },
        methods:{
            getRecommended(){
				var vuRecommendedProduct = this;
                axios.get("{{route('online.recommended')}}")
                .then(function(response) {
                    // console.log("AAAAA",response)
                    vuRecommendedProduct.recommended = [];	
                    if (response.data.length > 0) {
                        vuRecommendedProduct.recommended = response.data;
                    }
                    // console.log(222, vuRecommendedProduct.recommended,vuRecommendedProduct.route);
                })
                .catch(function(error) {
                    console.log(error);
                });
            },
            putWishList(id){  
                if (id != null) {
                    $.ajax({
                    type: 'POST',
                    url: "{{url('onlinePutWishList')}}/" + id,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        toastr.success('', result.message);
                        wishLisVue.getWishList(user_id, session_id);
                        vuRecommendedProduct.getRecommended();
                        // table.ajax.reload();
                        console.log(13,result);
                        // location.reload();
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);
                    }
                    });
                }
            },
            putPurchase(id){
                if (id != null) {
                    $.ajax({
                    type: 'POST',
                    url: "{{url('onlinePutPurchase')}}/" + id,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        toastr.success('', result.message);
                        // wishLisVue.getWishList(user_id, session_id);
                        orderLisVue.getOrderList(user_id, session_id);
                        // table.ajax.reload();
                        console.log(13,result);
                        // location.reload();
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);
                    }
                    });
                }
            }
        }
    });

    var vuNewProduct = new Vue({
        el: '#newProduncts',
        data: {
            part: '',
            newProduct: [],
            online_item_route:"{{route('online.ItemDetails')}}",
            user_id: user_id,
            session_id: session_id,
        },
        computed: {
            setRates(){}
        },
		mounted: function() {
                this.getNewProduct();
        },
        methods:{
            getNewProduct(){
				var vuNewProduct = this;
                axios.get("{{route('online.newProduct')}}")
                .then(function(response) {
                    // console.log("AAAAA",response)
                    vuNewProduct.newProduct = [];	
                    if (response.data.length > 0) {
                        vuNewProduct.newProduct = response.data;
                    }
                    // console.log("AAA", vuNewProduct.newProduct);
                })
                .catch(function(error) {
                    console.log(error);
                });
            },
            putWishList(id){  
                if (id != null) {
                    $.ajax({
                    type: 'POST',
                    url: "{{url('onlinePutWishList')}}/" + id,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        toastr.success('', result.message);
                        wishLisVue.getWishList(user_id, session_id);
                        vuNewProduct.getNewProduct();
                        // table.ajax.reload();
                        console.log(13,result);
                        // location.reload();
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);
                    }
                    });
                }
            },
            putPurchase(id){
                if (id != null) {
                    $.ajax({
                    type: 'POST',
                    url: "{{url('onlinePutPurchase')}}/" + id,
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    success: function (result) {
                        toastr.success('', result.message);
                        orderLisVue.getOrderList(user_id, session_id);
                        // table.ajax.reload();
                        console.log(13,result);
                        // location.reload();
                    },
                    error: function (error) {
                        var message = "{{__('message.Warning')}}";
                        toastr.warning('', message);
                        // console.log(14,error);
                        // swal("{{__('message.Warning')}}", error.responseJSON.message);
                    }
                    });
                }
            }
        }
    });

    var v = new Vue({
        el: '#contact_form1',
        data: {
            part: '',
            coment: [],
        },
        computed: {
            setRates() {}
        },
        mounted: function() {
            this.getComent();
            // console.log(145);
        },
        methods: {
            getComent() {
                axios.get("{{route('comment.home')}}", {
                    params: {
                        category: 'home'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        v.coment = [];
                        v.coment = response.data;
                    }
                    // console.log(222, response.data);
                })
                .catch(function(error) {
                    console.log(error);
                });
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            console.log('sss11', valid);
                            var url = "{{route('comment.store')}}";
                            form_id = 'comment-form';
                            var data = $('#' + form_id).serialize();
                            // toggleBlock(true);
                            axios.post(url, data)
                            .then(function(response) {
                                // toggleBlock(0);
                                console.log('sss11', response.data);
                                if (response.data.result == 1) {
                                    $('#' + form_id).trigger('reset');
                                    //$('#success-sound')[0].play();
                                    toastr.success('', response.data.message);
                                } else {
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                }
                            })
                            .catch(function(error) {
                                // toggleBlock(0);
                                console.log(error);
                                var message = "{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                            });
                        }
                    })
                },
            }, 
    });
</script>
@endpush