<!DOCTYPE html><html lang="en" data-bs-theme="light" data-pwa="true">
  <head>
    <meta charset="utf-8">
    <!-- Viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover">
    <!-- SEO Meta Tags -->
    <title>{{onlineSystemConfig()['name']}}</title>
    <meta name="description" content="Cartzilla - Multipurpose Bootstrap E-Commerce HTML Template">
    <meta name="keywords" content="online shop, e-commerce, online store, market, multipurpose, product landing, cart, checkout, ui kit, light and dark mode, bootstrap, html5, css3, javascript, gallery, slider, mobile, pwa">
    <meta name="author" content="Createx Studio">
    <!-- Webmanifest + Favicon / App icons -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <link rel="manifest" href="manifest.json">
    @if(session()->get('online_system_config'))
    <link rel="shortcut icon" href="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" />
    @else
    <link rel="shortcut icon" href="{{url('/online/assets/logo/logo1.png')}}" />
    @endif
    <!-- Theme switcher (color modes) -->
    <script src="{{asset('online/onlineAssets/js/theme-switcher.js')}}"></script>
    <!-- Preloaded local web font (Inter) -->
    <link rel="preload" href="{{asset('online/onlineAssets/fonts/inter-variable-latin.woff2')}}" as="font" type="font/woff2" crossorigin="">
    <!-- Font icons -->
    <link rel="preload" href="{{asset('online/onlineAssets/icons/cartzilla-icons.woff2')}}" as="font" type="font/woff2" crossorigin="">
    <link rel="stylesheet" href="{{asset('online/onlineAssets/icons/cartzilla-icons.min.css')}}">
    <!-- Bootstrap + Theme styles -->
    <link rel="preload" href="{{asset('online/onlineAssets/css/theme.min.css')}}" as="style">
    <link rel="preload" href="{{asset('online/onlineAssets/css/theme.rtl.min.css')}}" as="style">
    <link rel="stylesheet" href="{{asset('online/onlineAssets/css/theme.min.css')}}" id="theme-styles">
    <!-- Customizer -->
    <script src="{{asset('online/onlineAssets/js/customizer.min.js')}}"></script>
  </head>
  <!-- Body -->
  <body>
    <!-- Customizer offcanvas -->
    <div class="offcanvas offcanvas-end" id="customizer" tabindex="-1">
      <div class="offcanvas-header border-bottom">
        <h4 class="h5 offcanvas-title">@lang('layout.CustomizeTheme')</h4>
        <button class="btn-close" type="button" data-bs-dismiss="offcanvas" aria-label="Close"></button>
      </div>
      <div class="offcanvas-body">
        <!-- Customizer settings -->
        <div class="customizer-collapse collapse show" id="customizerSettings">
          <!-- Colors -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center mb-3">
              <i class="ci-paint text-body-tertiary fs-5 me-2"></i>
              <h5 class="fs-lg mb-0">@lang('layout.Colors')</h5>
            </div>
            <div class="row row-cols-2 g-3" id="theme-colors">
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Primary</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-primary" data-color-labels="[&quot;theme-primary&quot;, &quot;primary&quot;, &quot;primary-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#f55266">
                  <label for="primary" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #f55266"></label>
                  <input type="color" class="visually-hidden" id="primary" value="#f55266">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Success</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-success" data-color-labels="[&quot;theme-success&quot;, &quot;success&quot;, &quot;success-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#33b36b">
                  <label for="success" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #33b36b"></label>
                  <input type="color" class="visually-hidden" id="success" value="#33b36b">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Warning</h6>
                <div class="color-swatch d-flex border rounded gap-3 p-2" id="theme-warning" data-color-labels="[&quot;theme-warning&quot;, &quot;warning&quot;, &quot;warning-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#fc9231">
                  <label for="warning" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #fc9231"></label>
                  <input type="color" class="visually-hidden" id="warning" value="#fc9231">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Danger</h6>
                <div class="color-swatch d-flex border rounded gap-2 p-2" id="theme-danger" data-color-labels="[&quot;theme-danger&quot;, &quot;danger&quot;, &quot;danger-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#f03d3d">
                  <label for="danger" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #f03d3d"></label>
                  <input type="color" class="visually-hidden" id="danger" value="#f03d3d">
                </div>
              </div>
              <div class="col">
                <h6 class="fs-sm mb-2 text-center">Info</h6>
                <div class="color-swatch d-flex border rounded gap-2 p-2" id="theme-info" data-color-labels="[&quot;theme-info&quot;, &quot;info&quot;, &quot;info-rgb&quot;]">
                  <input type="text" class="form-control bg-transparent border-0 rounded-0 p-1" value="#2f6ed5">
                  <label for="info" class="ratio ratio-1x1 flex-shrink-0 w-100 cursor-pointer rounded-circle" style="max-width: 38px; background-color: #2f6ed5"></label>
                  <input type="color" class="visually-hidden" id="info" value="#2f6ed5">
                </div>
              </div>
            </div>
          </div>
          <!-- Direction -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
              <i class="ci-sort text-body-tertiary fs-lg me-2" style="transform: rotate(90deg)"></i>
              <h5 class="fs-lg mb-0">@lang('layout.PageDirection')</h5>
            </div>
            <div class="d-flex align-items-center justify-content-between border rounded p-3">
              <div class="me-3">
                <h6 class="mb-1">@lang('layout.RTL') || @lang('layout.LTR')</h6>
                <p class="fs-sm mb-0">@lang('layout.ChangeTextDirection')</p>
              </div>
              <div class="form-check form-switch m-0">
                <input type="checkbox" class="form-check-input" role="switch" id="rtl-switch">
              </div>
            </div>
            {{-- <div class="alert alert-info p-2 mt-2 mb-0">
              <div class="d-flex text-body-emphasis fs-xs py-1 pe-1">
                <i class="ci-info text-info fs-lg mb-2 mb-sm-0" style="margin-top: .125rem"></i>
                <div class="ps-2">To switch the text direction of your webpage from LTR to RTL, please consult the detailed instructions provided in the relevant section of our documentation.</div>
              </div>
            </div> --}}
          </div>
          <!-- Border width -->
          <div class="pb-4 mb-2">
            <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
              <i class="ci-menu text-body-tertiary fs-lg me-2"></i>
              <h5 class="fs-lg mb-0">@lang('layout.BorderWidth') , {px}</h5>
            </div>
            <div class="slider-input d-flex align-items-center gap-3 border rounded p-3" id="border-input">
              <input type="range" class="form-range" min="0" max="10" step="1" value="1">
              <input type="number" class="form-control" id="border-width" min="0" max="10" value="1" style="max-width: 5.5rem">
            </div>
          </div>
          <!-- Rounding -->
          <div class="d-flex align-items-center pb-1 mb-2 justify-content-center">
            <i class="ci-maximize text-body-tertiary fs-lg me-2"></i>
            <h5 class="fs-lg mb-0">@lang('layout.RoundingCards'), {rem}</h5>
          </div>
          <div class="slider-input d-flex align-items-center gap-3 border rounded p-3">
            <input type="range" class="form-range" min="0" max="5" step=".05" value="0.5">
            <input type="number" class="form-control" id="border-radius" min="0" max="5" step=".05" value="0.5" style="max-width: 5.5rem">
          </div>
        </div>
        <!-- Customizer code -->
        <div class="customizer-collapse collapse" id="customizerCode">
          <div class="nav mb-3">
            <a class="nav-link animate-underline fs-base p-0" href="{{route('/')}}" data-bs-toggle="collapse" aria-expanded="true" aria-controls="customizerSettings customizerCode">
              <i class="ci-chevron-left fs-lg ms-n1 me-1"></i>
              <span class="animate-target">@lang('layout.BackToSettings')</span>
            </a>
          </div>
          <div class="position-relative bg-body-tertiary rounded overflow-hidden pt-3">
            <div class="position-absolute top-0 start-0 w-100 p-3">
              <button type="button" class="btn btn-sm btn-outline-dark w-100" data-copy-text-from="#generated-styles" data-done-label="Code copied">
                <i class="ci-copy fs-sm me-1"></i>
                @lang('layout.CopyCode')
              </button>
            </div>
            <pre class="text-wrap bg-transparent border-0 fs-xs text-body-emphasis p-4 pt-5" id="generated-styles"></pre>
          </div>
        </div>
      </div>
      <!-- Offcanvas footer (Action buttons) -->
      <div class="offcanvas-header border-top gap-3 d-none" id="customizer-btns">
        <button type="button" class="btn btn-lg btn-secondary w-100 fs-sm" id="customizer-reset">
          <i class="ci-trash fs-lg me-2 ms-n1"></i>
          @lang('layout.Reset')
        </button>
        <button class="btn btn-lg btn-primary hiding-collapse-toggle w-100 fs-sm collapsed" type="button" data-bs-toggle="collapse" data-bs-target=".customizer-collapse" aria-expanded="false" aria-controls="customizerSettings customizerCode">
          <i class="ci-code fs-lg me-2 ms-n1"></i>
          @lang('layout.ShowCode')
        </button>
      </div>
    </div>
    <!-- Page content -->
    <main class="content-wrapper w-100 px-3 ps-lg-5 pe-lg-4 mx-auto" style="max-width: 1920px">
      <div class="d-lg-flex">
        <!-- Login form + Footer -->
        <div class="d-flex flex-column min-vh-100 w-100 py-4 mx-auto me-lg-5" style="max-width: 416px">
          <header class="navbar px-0 pb-4 mt-n2 mt-sm-0 mb-2 mb-md-3 mb-lg-4">
            <a href="{{route('/')}}" class="navbar-brand pt-0 text-center" style="width: 50%;margin: auto auto">
                @if(session()->get('online_system_config'))
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" loading="lazy"/>
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" loading="lazy"/>
                    <img alt="Logo" src="{{onlineSystemConfig()['back_site_link'].'/uploads/logo/'.session()->get('online_system_config')->logo2}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" loading="lazy"/>
                @else
                    <img alt="Logo" src="{{url('/online/assets/logo/logoA1.png')}}" style="display: none;" class="logo-default h-25px h-lg-30px d-sm-none d-md-block d-lg-block" loading="lazy"/>
                    <img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-default h-20px h-lg-25px d-md-none d-lg-none" loading="lazy"/>
                    <img alt="Logo" src="{{url('/online/assets/logo/logo1.png')}}" class="logo-sticky h-20px h-lg-25px d-md-none d-lg-none" loading="lazy"/>
                @endif
            </a>
          </header>
            @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert" id="myAlert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                {{ session('success') }}
            </div>
            @endif
            @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert" id="myAlert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                {{ session('error') }}
            </div>
            @endif
          <h1 class="h2 mt-auto text-center">@lang('layout.ResetPassword')</h1>
          {{-- <p class="pb-2 pb-md-3">Enter the email address you used when you joined and we’ll send you instructions to reset your password</p> --}}
          <!-- Form -->
          <form class="needs-validation pb-4 mb-3 mb-lg-4" novalidate="" id="kt_sign_in_form" method="POST" action="{{ route('online.reset.pass') }}">
            {{ csrf_field() }}
            <div class="position-relative mb-4">
              {{-- <i class="ci-mail position-absolute top-50 mt-3 start-0 translate-middle-y fs-lg ms-3"></i> --}}
              <label for="email" class="form-label">@lang('layout.Email')</label>
              <input type="email" class="form-control form-control-lg form-icon-start" id="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="off" required="">
              <div class="invalid-tooltip bg-transparent py-0">@lang('layout.EnterAValidEmailAddress')!</div>
            </div>
            {{-- <button type="submit" class="btn btn-lg btn-primary w-100">Reset password</button> --}}
            <div class="d-flex flex-wrap justify-content-center pb-lg-0">
                <input class="btn btn-lg btn-primary fw-bolder me-4" type="submit" value="@lang('layout.Send')" />
                <a href="{{route('online.login')}}" class="btn btn-lg border btn-light-primary fw-bolder">@lang('layout.Cancel')</a>
            </div>
          </form>
          <!-- Footer -->
          <footer class="mt-auto">
            {{-- <div class="nav mb-4">
              <a class="nav-link text-decoration-underline p-0" href="help-topics-v1.html">Need help?</a>
            </div> --}}
            <p class="fs-xs mb-0 text-center">
              © <span id="currentDate"></span> @lang('layout.AllRightsReserved') <i class="ci-heart-filled text-danger align-middle"></i> <span class="animate-underline"><a class="animate-target text-muted text-decoration-none" href="#" target="_self" rel="noreferrer">CHACO</a></span>
            </p>
          </footer>
        </div>
        <!-- Cover image visible on screens > 992px wide -->
        <div class="d-none d-lg-block w-100 py-4 ms-auto" style="max-width: 1034px">
          <div class="d-flex flex-column justify-content-end h-100 rounded-5 overflow-hidden">
            <span class="position-absolute top-0 start-0 w-100 h-100 d-none-dark" style="background: linear-gradient(-90deg, #accbee 0%, #e7f0fd 100%)"></span>
            <span class="position-absolute top-0 start-0 w-100 h-100 d-none d-block-dark" style="background: linear-gradient(-90deg, #1b273a 0%, #1f2632 100%)"></span>
            <div class="ratio position-relative z-2" style="--cz-aspect-ratio: calc(500 / 400 * 50%); height: 95vh">
                <img src="{{asset('online/onlineAssets/img/SignUp.jpg')}}">
            </div>
          </div>
        </div>
      </div>
    </main>
    <!-- Customizer toggle -->
    <div class="floating-buttons position-fixed top-50 end-0 z-sticky me-3 me-xl-4 pb-4">
      <a class="btn btn-sm btn-outline-secondary text-uppercase bg-body rounded-pill shadow animate-rotate ms-2 me-n5" href="#customizer" style="font-size: .625rem; letter-spacing: .05rem;" data-bs-toggle="offcanvas" role="button" aria-controls="customizer">
       @lang('layout.Customize')<i class="ci-settings fs-base ms-1 me-n2 animate-target"></i>
      </a>
    </div>
    <!-- Bootstrap + Theme scripts -->
    <script src="{{asset('online/onlineAssets/js/theme.min.js')}}"></script>
    <script>
        setTimeout(function() {
            var alert = document.getElementById('myAlert');
            if(alert){
                var bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            }
        }, 9000);
    </script>
</body>
</html>