<!DOCTYPE html>

<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <title> CAS | User Login 4</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="{{url('/assets/app/css/app.css')}}" rel="stylesheet" type="text/css" />
    <link href="{{url('/assets/app/pages/login.css')}}" rel="stylesheet" type="text/css" />


    <link rel="shortcut icon" href="favicon.ico" /> </head>
 
<!-- END HEAD -->

<body class=" login" style="background-image: url('logo/16.jpg');">
<!-- BEGIN LOGO -->
<div class="logo">
    {{--<a href="index.html">--}}
        {{--<img src="{{url('/logo.png')}}" alt="" /> </a>--}}
</div>
<!-- END LOGO -->
<!-- BEGIN LOGIN -->
<div class="content">
    <!-- BEGIN LOGIN FORM -->
    <form class="login-form"  role="form" method="POST" action="{{ url('/login') }}" >
        {{ csrf_field() }}
        <h3 class="form-title">@lang('layout.LoginToYourAccount')</h3>
        <div class="alert alert-danger display-hide">
            <button class="close" data-close="alert"></button>
            <span> @lang('layout.EnterAnyUsernameAndPassword'). </span>
        </div>
        <div class="form-group">
            <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
            <label class="control-label visible-ie8 visible-ie9">@lang('layout.Username')</label>
            <div class="input-icon">
                <i class="fa fa-user"></i>

                <input id="email" type="email" class="form-control placeholder-no-fix"  placeholder="Username" name="email" value="{{ old('email') }}" required autofocus>

                @if ($errors->has('email'))
                    <span class="help-block">
                    <strong>{{ $errors->first('email') }}</strong>
                </span>
                @endif
            </div>
        </div>
        <div class="form-group">
            <label class="control-label visible-ie8 visible-ie9">@lang('layout.Password')</label>
            <div class="input-icon">
                <i class="fa fa-lock"></i>
                <input id="password" type="password" autocomplete="off" placeholder="Password" class="form-control placeholder-no-fix" name="password" required>

                @if ($errors->has('password'))
                    <span class="help-block">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                @endif
            </div>
        </div>
        <div class="form-actions">
            <label class="rememberme mt-checkbox mt-checkbox-outline">
                <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : ''}}>@lang('layout.RememberMe')
                <span></span>
            </label>
            <div> 
                <center>
                    <button type="submit" class="btn green"> @lang('layout.LoginToYourAccount')</button>
                </center>
            </div>
        </div>
        <div class="login-options">
            <h4>@lang('layout.OrLoginWith')</h4>
            <ul class="social-icons">
                <li>
                    <a class="facebook" data-original-title="facebook" href="javascript:;"> </a>
                </li>
                <li>
                    <a class="twitter" data-original-title="Twitter" href="javascript:;"> </a>
                </li>
                <li>
                    <a class="googleplus" data-original-title="Goole Plus" href="javascript:;"> </a>
                </li>
                <li>
                    <a class="linkedin" data-original-title="Linkedin" href="javascript:;"> </a>
                </li>
            </ul>
        </div>
        <div class="forget-password">
            <h4>@lang('layout.ForgotYourPassword')?</h4>
            <p> @lang('layout.NoWorriesClick')
                <a href="{{ url('/password/reset') }}" id="forget-password"> @lang('layout.Here') </a>@lang('layout.ToResetYourPassword'). </p>
        </div>

    </form>
    <!-- END LOGIN FORM -->


</div>
<!-- END LOGIN -->
<!-- BEGIN COPYRIGHT -->
<div class="copyright"> 2018 &copy; C.A.S System (Chartered Accountant Standard System) - by CH.A CO. </div>
<!-- END COPYRIGHT -->
<!--[if lt IE 9]-->
<script src="{{url('/assets/app/js/pages/login.js')}}" type="text/javascript"></script>

</body>

</html>